/**
 * MessageChunk.java
 * Created on 2003/06/12 22:39:17
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.logic;

import java.util.Date;

import net.prixdami.alexis.util.Utils;

/**
 * uploaderAPsfŎgĂP̃f[^ێNX
 * @author es
 * @deprecated 蔲߂Ȃ̂ō蒼
 */
public class MessageChunk implements Message {
    /**@todo 蔲߂ */
    public String writeDate = "";
    public String dataFileName = "";
    public String dataFileOriginalName = "";
    public String dataFileSuffix = "";
    public String dataType = "";
    public String thumbFileName = "";
    public String message = "";
    public String writterName = "";
    public String writterMail = "";
    public String writterIP = "";
    public String writterID = "";
    public String title = "";

    public MessageChunk() {
    }

    public String ip2ID() {
        return Utils.getID(writterIP + (new Date().getTime() / 86400000L));
    }

    /**@todo 蔲߂ */
    public MessageChunk(String arg) {
        String[] data = Utils.split(arg, ",");
        writeDate = data[0].replace('"', ' ').trim();
        dataFileName = data[1].replace('"', ' ').trim();
        dataFileOriginalName = data[2].replace('"', ' ').trim();
        dataFileSuffix = data[3].replace('"', ' ').trim();
        dataType = data[4].replace('"', ' ').trim();
        thumbFileName = data[5].replace('"', ' ').trim();
        message = data[6].replace('"', ' ').trim();
        writterName = data[7].replace('"', ' ').trim();
        writterMail = data[8].replace('"', ' ').trim();
        writterIP = data[9].replace('"', ' ').trim();
        writterID = data[10].replace('"', ' ').trim();
        title = data[11].replace('"', ' ').trim();
    }

    /**@todo 蔲߂ */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.quote(writeDate) + ",");
        sb.append(Utils.quote(dataFileName) + ",");
        sb.append(Utils.quote(dataFileOriginalName) + ",");
        sb.append(Utils.quote(dataFileSuffix) + ",");
        sb.append(Utils.quote(dataType) + ",");
        sb.append(Utils.quote(thumbFileName) + ",");
        sb.append(Utils.quote(message) + ",");
        sb.append(Utils.quote(writterName) + ",");
        sb.append(Utils.quote(writterMail) + ",");
        sb.append(Utils.quote(writterIP) + ",");
        sb.append(Utils.quote(writterID) + ",");
        sb.append(Utils.quote(title));
        return sb.toString();
    }

    /**
     * @param rawLine
     * @return
     */
    public static Message createMessage(String rawLine) {
        return new MessageChunk(rawLine);
    }

    /**
     * @return
     */
    public String getDataFileName() {
        return dataFileName;
    }

    /**
     * @return
     */
    public String getDataFileOriginalName() {
        return dataFileOriginalName;
    }

    /**
     * @return
     */
    public String getDataFileSuffix() {
        return dataFileSuffix;
    }

    /**
     * @return
     */
    public String getDataType() {
        return dataType;
    }

    /**
     * @return
     */
    public String getMessage() {
        return message;
    }

    /**
     * @return
     */
    public String getThumbFileName() {
        return thumbFileName;
    }

    /**
     * @return
     */
    public String getTitle() {
        return title;
    }

    /**
     * @return
     */
    public String getWriteDate() {
        return writeDate;
    }

    /**
     * @return
     */
    public String getWritterID() {
        return writterID;
    }

    /**
     * @return
     */
    public String getWritterIP() {
        return writterIP;
    }

    /**
     * @return
     */
    public String getWritterMail() {
        return writterMail;
    }

    /**
     * @return
     */
    public String getWritterName() {
        return writterName;
    }

	public String getDateString() {
		return Utils.getDate(new Date(Long.valueOf(writeDate).longValue()));
	}
}
