/**
 * MultipartController.java
 * Created on 2003/06/05
 * Copyright (c) by es , All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.prixdami.alexis.logic.*;
import net.prixdami.alexis.logic.Logic;
import net.prixdami.alexis.logic.LogicParameter;
import net.prixdami.alexis.model.ResultModel;
import net.prixdami.alexis.multipart.MultipartParser;

/**
 * }`p[gtH[pRg[.
 * 
 * }`p[g(=t@CYt)ΉȎȊONormalControllerƈꏏ
 * 
 * KΏۂHTMLtH[actionHttpSessionł̓eID𖄂ߍނ<br>
 * <p>̗<br>
 * input name="action" value="(ActionCode)"<br>
 * input name="(ActionCode)" value="(eID)"<br>
 * session.setAttribute("(ActionCode)", "(eID)");
 *
 * @author es
 * @version 1.0
 */
public class MultipartController extends GenericController {

	//@TODO o[WÂA
	//NormalController̕ύXɒǏ]؂ĂȂ

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, java.io.IOException {
        res.sendRedirect(this.action(req, res));
    }

    protected String action(HttpServletRequest req, HttpServletResponse res)
        throws javax.servlet.ServletException, java.io.IOException {
        HttpSession session = req.getSession();
        int resultCode = ResultModel.FATAL;

        String action = req.getParameter(super.ACTION);
        if (action == null || action.equals("")) {
            session.setAttribute(super.RESULT, new Exception());
            return super.systemFatalTo;
        }

        ActionModel am = super.getAction(action);
        try {
            Logic al = super.getLogic(am);
            MultipartParser paser = MultipartParser.getInstance();
            ResultModel result = al.invoke(new LogicParameter(paser.parse(req, -1)));
            session.setAttribute(RESULT, result.getResult());
            resultCode = result.getResultCode();
        } catch (Exception ex) {
            session.setAttribute(super.RESULT, ex);
            return super.systemFatalTo;
        }

        return super.getReturnPath(resultCode, am, req.getRequestURI());
    }

}
