/**
 * ReplyAgent.java
 * Created on 2003/10/05
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Must not change/append/modify this list of conditions and the 
 *    following disclaimer, if you altered this source code.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package lapis.logic;

import java.io.IOException;
import java.util.Date;
import java.util.Properties;

import net.prixdami.alexis.logic.Logic;
import net.prixdami.alexis.logic.LogicParameter;
import net.prixdami.alexis.logic.MessageChunk;
import net.prixdami.alexis.dataaccess.DataAccessManager;
import net.prixdami.alexis.exception.InvalidParameterException;
import net.prixdami.alexis.exception.Recoverable;
import net.prixdami.alexis.model.GenericResult;
import net.prixdami.alexis.model.ResultModel;

/**
 * sfpLogic
 * @author es
 */
public class ReplyAgent extends Logic {

    //p[^
    private Properties props;

	private static final String TARGET = "reply";

    public static final String PARAM_NAME = "name";
    public static final String PARAM_COMMENT = "content";

    public static final String PARAM_IP = LogicParameter.PARAM_IP;
	public static final String PARAM_HOST = LogicParameter.PARAM_HOST;
	public static final String PARAM_REF = LogicParameter.PARAM_REF;

	public static final String PREF_REF = LogicParameter.PARAM_REF;
	public static final String PREF_MAXCOMMENT = "max_comment";
	public static final String PREF_MAXNAME = "max_name";

	private DataAccessManager dam;

    /* ( Javadoc)
     * @see net.prixdami.alexis.logic.Logic#invoke(net.prixdami.alexis.logic.LogicParameter)
     */
    public ResultModel invoke(LogicParameter params) {
		GenericResult r = new GenericResult(null, ResultModel.SATISFY);
		try {
			check(params);
			MessageChunk mc = new MessageChunk();		
			mc.writeDate = String.valueOf(new Date().getTime());
			mc.writterIP = params.get(PARAM_IP);
			mc.writterID = mc.ip2ID();
			mc.writterName = params.get(PARAM_NAME);
			mc.message = params.get(PARAM_COMMENT);
	        dam.store(TARGET, mc);
		} catch (Recoverable e) {
			r.setResultCode(ResultModel.NOTICE);
			r.setResult(e);
        } catch (Exception e) {
			r.setResultCode(ResultModel.FATAL);
			r.setResult(e);
        }
		return r;
    }

    /* ( Javadoc)
     * @see net.prixdami.alexis.logic.Logic#init(java.util.Properties)
     */
    public void init(Properties prop) {
        props = prop;
		dam = DataAccessManager.getInstace();
    }

	private void check(LogicParameter param) throws Recoverable {
		if (!param.get(PARAM_REF).endsWith(props.getProperty(PARAM_REF))) {
			throw new InvalidParameterException("ďosł");
		}

		String name = param.get(PARAM_NAME, true);
		String comm = param.get(PARAM_COMMENT, true);

		if(name.equals("") || comm.equals("")){
			throw new InvalidParameterException("͍ڂɕs܂");
		}

		if(name.getBytes().length >= Integer.parseInt(props.getProperty(PREF_MAXNAME, "256"))) {
			throw new InvalidParameterException("͍ڂ܂");
		}

		if(comm.getBytes().length >= Integer.parseInt(props.getProperty(PREF_MAXCOMMENT, "512"))) {
			throw new InvalidParameterException("͍ڂ܂");
		}
	}

}
