/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.stream;

import com.jmex.audio.AudioTrack;
import com.jmex.audio.filter.Filter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class AudioInputStream
extends FilterInputStream {
    protected ArrayList<Filter> filters;
    private URL resource;
    private float length;

    public AudioInputStream(URL uRL, float f) throws IOException {
        super(uRL.openStream());
        this.resource = uRL;
        this.length = f;
        this.filters = new ArrayList();
    }

    public abstract int read(ByteBuffer var1, int var2, int var3) throws IOException;

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public abstract int getChannelCount();

    public abstract int getBitRate();

    public abstract int getDepth();

    public URL getResource() {
        return this.resource;
    }

    public abstract AudioInputStream makeNew() throws IOException;

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public static AudioTrack.Format sniffFormat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[128];
        int n = inputStream.read(byArray);
        if (n >= 4 && byArray[0] == 79 && byArray[1] == 103 && byArray[2] == 103 && byArray[3] == 83) {
            return AudioTrack.Format.OGG;
        }
        if (n >= 12 && byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70 && byArray[8] == 87 && byArray[9] == 65 && byArray[10] == 86 && byArray[11] == 69) {
            return AudioTrack.Format.WAV;
        }
        return null;
    }
}

