/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.openal;

import com.jme.util.resource.ResourceLocatorTool;
import com.jmex.audio.AudioSystem;
import com.jmex.audio.openal.OpenALAudioBuffer;
import com.jmex.audio.openal.OpenALAudioTrack;
import com.jmex.audio.openal.OpenALEar;
import com.jmex.audio.openal.OpenALSource;
import com.jmex.audio.util.AudioLoader;
import java.io.IOException;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;

public class OpenALSystem
extends AudioSystem {
    private static final Logger logger = Logger.getLogger(OpenALSystem.class.getName());
    private static final long MAX_MEMORY = 0x1000000L;
    private OpenALEar ear;
    private LinkedList<OpenALSource> sourcePool = new LinkedList();
    private static int MAX_SOURCES = 64;
    private Map<String, OpenALAudioBuffer> memoryPool = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true));
    private long held = 0L;
    private long lastTime = System.currentTimeMillis();

    public OpenALSystem() {
        this.ear = new OpenALEar();
        try {
            AL.create();
            AL10.alDistanceModel((int)53249);
            this.setupSourcePool();
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "OpenALSystem()", "Exception", exception);
        }
    }

    private void setupSourcePool() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        try {
            for (int i = 0; i < MAX_SOURCES; ++i) {
                intBuffer.clear();
                AL10.alGenSources((IntBuffer)intBuffer);
                OpenALSource openALSource = new OpenALSource(intBuffer.get(0));
                this.sourcePool.add(openALSource);
            }
        }
        catch (OpenALException openALException) {
            MAX_SOURCES = this.sourcePool.size();
        }
        logger.info("max source channels: " + MAX_SOURCES);
    }

    public OpenALEar getEar() {
        return this.ear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        OpenALSystem openALSystem = this;
        synchronized (openALSystem) {
            if (!AL.isCreated()) {
                return;
            }
            long l = System.currentTimeMillis();
            float f = (float)(l - this.lastTime) / 1000.0f;
            this.lastTime = l;
            try {
                for (int i = 0; i < MAX_SOURCES; ++i) {
                    OpenALSource openALSource = this.sourcePool.get(i);
                    openALSource.setState(AL10.alGetSourcei((int)openALSource.getId(), (int)4112));
                    if (openALSource.getState() != 4114) continue;
                    openALSource.getTrack().update(f);
                }
                this.ear.update(f);
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "update()", "Exception", exception);
            }
            try {
                this.getMusicQueue().update(f);
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "update()", "Exception", exception);
                try {
                    this.getMusicQueue().clearTracks();
                }
                catch (Exception exception2) {
                    logger.logp(Level.SEVERE, this.getClass().toString(), "update()", "Exception", exception2);
                }
            }
            try {
                this.getEnvironmentalPool().update(f);
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "update()", "Exception", exception);
                try {
                    this.getEnvironmentalPool().clearTracks();
                }
                catch (Exception exception3) {
                    logger.logp(Level.SEVERE, this.getClass().toString(), "update()", "Exception", exception3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenALSource getNextFreeSource() {
        OpenALSystem openALSystem = this;
        synchronized (openALSystem) {
            for (int i = 0; i < MAX_SOURCES; ++i) {
                OpenALSource openALSource = this.sourcePool.get(i);
                if (!this.isAvailableState(openALSource.getState())) continue;
                this.sourcePool.remove(i);
                this.sourcePool.add(openALSource);
                return openALSource;
            }
        }
        return null;
    }

    private boolean isAvailableState(int n) {
        return n != 4114 && n != 4115 && n != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenALAudioTrack createAudioTrack(URL uRL, boolean bl) {
        OpenALSystem openALSystem = this;
        synchronized (openALSystem) {
            if (uRL == null) {
                logger.warning("Tried to load null audio file.");
                return null;
            }
            String string = uRL.toString();
            if (!bl) {
                OpenALAudioBuffer openALAudioBuffer = this.memoryPool.get(string);
                if (openALAudioBuffer == null) {
                    openALAudioBuffer = OpenALAudioBuffer.generateBuffer();
                    try {
                        AudioLoader.fillBuffer(openALAudioBuffer, uRL);
                    }
                    catch (IOException iOException) {
                        logger.logp(Level.SEVERE, this.getClass().toString(), "createAudioTrack(URL resource, boolean stream)", "Exception", iOException);
                        return null;
                    }
                    this.held += (long)openALAudioBuffer.getData().capacity();
                    this.memoryPool.put(string, openALAudioBuffer);
                    if (this.held > 0x1000000L) {
                        Object[] objectArray = this.memoryPool.keySet().toArray();
                        Object[] objectArray2 = this.memoryPool.values().toArray();
                        int n = objectArray.length - 1;
                        while (this.held > 0x1000000L && n >= 0) {
                            OpenALAudioBuffer openALAudioBuffer2 = (OpenALAudioBuffer)objectArray2[n];
                            this.held -= (long)openALAudioBuffer2.getData().capacity();
                            this.memoryPool.remove(objectArray[n]);
                        }
                    }
                }
                return new OpenALAudioTrack(uRL, openALAudioBuffer);
            }
            return new OpenALAudioTrack(uRL, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenALAudioTrack createAudioTrack(String string, boolean bl) {
        OpenALSystem openALSystem = this;
        synchronized (openALSystem) {
            URL uRL = ResourceLocatorTool.locateResource((String)"audio", (String)string);
            if (uRL == null) {
                logger.warning("Could not locate audio file: " + string);
                return null;
            }
            String string2 = uRL.toString();
            if (!bl) {
                OpenALAudioBuffer openALAudioBuffer = this.memoryPool.get(string2);
                if (openALAudioBuffer == null) {
                    openALAudioBuffer = OpenALAudioBuffer.generateBuffer();
                    try {
                        AudioLoader.fillBuffer(openALAudioBuffer, uRL);
                    }
                    catch (IOException iOException) {
                        logger.logp(Level.SEVERE, this.getClass().toString(), "createAudioTrack(URL resource, boolean stream)", "Exception", iOException);
                        return null;
                    }
                    this.held += (long)openALAudioBuffer.getData().capacity();
                    this.memoryPool.put(string2, openALAudioBuffer);
                    if (this.held > 0x1000000L) {
                        Object[] objectArray = this.memoryPool.keySet().toArray();
                        Object[] objectArray2 = this.memoryPool.values().toArray();
                        int n = objectArray.length - 1;
                        while (this.held > 0x1000000L && n >= 0) {
                            OpenALAudioBuffer openALAudioBuffer2 = (OpenALAudioBuffer)objectArray2[n];
                            this.held -= (long)openALAudioBuffer2.getData().capacity();
                            this.memoryPool.remove(objectArray[n]);
                        }
                    }
                }
                return new OpenALAudioTrack(uRL, openALAudioBuffer);
            }
            return new OpenALAudioTrack(uRL, bl);
        }
    }

    public void setMasterGain(float f) {
        AL10.alListenerf((int)4106, (float)f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        super.cleanup();
        OpenALSystem openALSystem = this;
        synchronized (openALSystem) {
            if (this.getMusicQueue() != null) {
                this.getMusicQueue().clearTracks();
            }
            if (this.getEnvironmentalPool() != null) {
                this.getEnvironmentalPool().clearTracks();
            }
            AL.destroy();
        }
        this.sourcePool.clear();
        this.memoryPool.clear();
    }

    public void setDopplerFactor(float f) {
        AL10.alDopplerFactor((float)f);
    }

    public void setSpeedOfSound(float f) {
        AL10.alDopplerVelocity((float)f);
    }
}

