/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio;

import com.jmex.audio.AudioTrack;
import com.jmex.audio.event.TrackStateAdapter;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentalPool {
    private ArrayList<AudioTrack> tracks = new ArrayList();
    private ArrayList<ChangeListener> listListeners = new ArrayList();
    private float crossfadeoutTime = 3.5f;
    private float crossfadeinTime = 3.5f;

    public void addTrack(AudioTrack audioTrack) {
        audioTrack.setType(AudioTrack.TrackType.ENVIRONMENT);
        if (!this.tracks.contains(audioTrack)) {
            this.tracks.add(audioTrack);
            this.fireListChanged();
        }
    }

    public void removeTrack(AudioTrack audioTrack) {
        audioTrack.stop();
        audioTrack.getPlayer().cleanup();
        this.tracks.remove(audioTrack);
        this.fireListChanged();
    }

    private void fireListChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.listListeners.size(); ++i) {
            this.listListeners.get(i).stateChanged(changeEvent);
        }
    }

    public ArrayList<AudioTrack> getTrackList() {
        return this.tracks;
    }

    public void clearTracks() {
        this.stopAllTracks();
        this.tracks.clear();
        this.fireListChanged();
    }

    public void update(float f) {
        int n = this.tracks.size();
        while (--n >= 0) {
            AudioTrack audioTrack = this.tracks.get(n);
            if (audioTrack.isEnabled() && !audioTrack.isActive()) {
                audioTrack.stop();
                if (this.crossfadeinTime > 0.0f) {
                    audioTrack.fadeIn(this.crossfadeinTime, 1.0f);
                }
                audioTrack.play();
                continue;
            }
            if (audioTrack.isEnabled() || !audioTrack.isActive()) continue;
            if (this.crossfadeoutTime > 0.0f) {
                if (audioTrack.getVolume() != audioTrack.getTargetVolume()) continue;
                audioTrack.fadeOut(this.crossfadeoutTime);
                audioTrack.addTrackStateListener(new TrackStateAdapter(){

                    public void trackFinishedFade(AudioTrack audioTrack) {
                        audioTrack.removeTrackStateListener(this);
                        audioTrack.stop();
                        audioTrack.setVolume(1.0f);
                        audioTrack.setTargetVolume(1.0f);
                    }

                    public void trackStopped(AudioTrack audioTrack) {
                        audioTrack.removeTrackStateListener(this);
                        audioTrack.setVolume(1.0f);
                        audioTrack.setTargetVolume(1.0f);
                    }
                });
                continue;
            }
            audioTrack.stop();
        }
    }

    public void stopAllTracks() {
        for (AudioTrack audioTrack : this.tracks) {
            if (!audioTrack.isActive()) continue;
            audioTrack.stop();
        }
    }

    public void fadeOutAllTracks(float f) {
        for (AudioTrack audioTrack : this.tracks) {
            if (!audioTrack.isActive()) continue;
            audioTrack.fadeOut(f);
        }
    }

    public void addSongListChangeListener(ChangeListener changeListener) {
        this.listListeners.add(changeListener);
    }

    public void removeSongListChangeListener(ChangeListener changeListener) {
        this.listListeners.remove(changeListener);
    }

    public void clearSongListChangeListeners() {
        this.listListeners.clear();
    }

    public float getCrossfadeinTime() {
        return this.crossfadeinTime;
    }

    public void setCrossfadeinTime(float f) {
        this.crossfadeinTime = f;
    }

    public float getCrossfadeoutTime() {
        return this.crossfadeoutTime;
    }

    public void setCrossfadeoutTime(float f) {
        this.crossfadeoutTime = f;
    }

    public void fadeOutAndClear(float f) {
        this.listListeners.clear();
        this.fadeOutAllTracks(f);
        this.tracks.clear();
    }
}

