/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.resource;

import com.jme.util.resource.SimpleResourceLocator;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;

public class MultiFormatResourceLocator
extends SimpleResourceLocator {
    private String[] extensions;
    private boolean trySpecifiedFormatFirst = false;

    public MultiFormatResourceLocator(URI uRI) {
        this(uRI, ".dds", ".tga", ".png", ".jpg", ".gif");
    }

    public MultiFormatResourceLocator(URL uRL) throws URISyntaxException {
        this(uRL, ".dds", ".tga", ".png", ".jpg", ".gif");
    }

    public MultiFormatResourceLocator(URI uRI, String ... stringArray) {
        super(uRI);
        if (stringArray == null) {
            throw new NullPointerException("extensions can not be null.");
        }
        this.extensions = stringArray;
    }

    public MultiFormatResourceLocator(URL uRL, String ... stringArray) throws URISyntaxException {
        this(uRL.toURI(), stringArray);
    }

    public URL locateResource(String string) {
        Object object;
        if (this.trySpecifiedFormatFirst && (object = super.locateResource(string)) != null) {
            return object;
        }
        object = this.getBaseFileName(string);
        for (String string2 : this.extensions) {
            URL uRL = super.locateResource((String)object + string2);
            if (uRL == null) continue;
            return uRL;
        }
        if (!this.trySpecifiedFormatFirst) {
            return super.locateResource(string);
        }
        return null;
    }

    private String getBaseFileName(String string) {
        File file = new File(string);
        String string2 = file.getPath();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public boolean isTrySpecifiedFormatFirst() {
        return this.trySpecifiedFormatFirst;
    }

    public void setTrySpecifiedFormatFirst(boolean bl) {
        this.trySpecifiedFormatFirst = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof MultiFormatResourceLocator) {
            return this.baseDir.equals(((MultiFormatResourceLocator)object).baseDir) && Arrays.equals(this.extensions, ((MultiFormatResourceLocator)object).extensions);
        }
        return false;
    }
}

