/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export.binary;

import com.jme.util.export.ByteUtils;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryClassField;
import com.jme.util.export.binary.BinaryClassObject;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryInputCapsule
implements InputCapsule {
    private static final Logger logger = Logger.getLogger(BinaryInputCapsule.class.getName());
    protected BinaryImporter importer;
    protected BinaryClassObject cObj;
    protected HashMap<Byte, Object> fieldData;
    protected int index = 0;

    public BinaryInputCapsule(BinaryImporter binaryImporter, BinaryClassObject binaryClassObject) {
        this.importer = binaryImporter;
        this.cObj = binaryClassObject;
    }

    public void setContent(byte[] byArray, int n, int n2) {
        this.fieldData = new HashMap();
        this.index = n;
        block42: while (this.index < n2) {
            byte by = byArray[this.index];
            ++this.index;
            try {
                byte by2 = this.cObj.aliasFields.get((Object)Byte.valueOf((byte)by)).type;
                Object object = null;
                switch (by2) {
                    case 80: {
                        object = this.readBitSet(byArray);
                        break;
                    }
                    case 60: {
                        object = this.readBoolean(byArray);
                        break;
                    }
                    case 61: {
                        object = this.readBooleanArray(byArray);
                        break;
                    }
                    case 62: {
                        object = this.readBooleanArray2D(byArray);
                        break;
                    }
                    case 0: {
                        object = this.readByte(byArray);
                        break;
                    }
                    case 1: {
                        object = this.readByteArray(byArray);
                        break;
                    }
                    case 2: {
                        object = this.readByteArray2D(byArray);
                        break;
                    }
                    case 122: {
                        object = this.readByteBuffer(byArray);
                        break;
                    }
                    case 30: {
                        object = this.readDouble(byArray);
                        break;
                    }
                    case 31: {
                        object = this.readDoubleArray(byArray);
                        break;
                    }
                    case 32: {
                        object = this.readDoubleArray2D(byArray);
                        break;
                    }
                    case 20: {
                        object = Float.valueOf(this.readFloat(byArray));
                        break;
                    }
                    case 21: {
                        object = this.readFloatArray(byArray);
                        break;
                    }
                    case 22: {
                        object = this.readFloatArray2D(byArray);
                        break;
                    }
                    case 120: {
                        object = this.readFloatBuffer(byArray);
                        break;
                    }
                    case 110: {
                        object = this.readFloatBufferArrayList(byArray);
                        break;
                    }
                    case 10: {
                        object = this.readInt(byArray);
                        break;
                    }
                    case 11: {
                        object = this.readIntArray(byArray);
                        break;
                    }
                    case 12: {
                        object = this.readIntArray2D(byArray);
                        break;
                    }
                    case 121: {
                        object = this.readIntBuffer(byArray);
                        break;
                    }
                    case 40: {
                        object = this.readLong(byArray);
                        break;
                    }
                    case 41: {
                        object = this.readLongArray(byArray);
                        break;
                    }
                    case 42: {
                        object = this.readLongArray2D(byArray);
                        break;
                    }
                    case 90: {
                        object = this.readSavable(byArray);
                        break;
                    }
                    case 91: {
                        object = this.readSavableArray(byArray);
                        break;
                    }
                    case 92: {
                        object = this.readSavableArray2D(byArray);
                        break;
                    }
                    case 100: {
                        object = this.readSavableArray(byArray);
                        break;
                    }
                    case 101: {
                        object = this.readSavableArray2D(byArray);
                        break;
                    }
                    case 102: {
                        object = this.readSavableArray3D(byArray);
                        break;
                    }
                    case 105: {
                        object = this.readSavableMap(byArray);
                        break;
                    }
                    case 106: {
                        object = this.readStringSavableMap(byArray);
                        break;
                    }
                    case 50: {
                        object = this.readShort(byArray);
                        break;
                    }
                    case 51: {
                        object = this.readShortArray(byArray);
                        break;
                    }
                    case 52: {
                        object = this.readShortArray2D(byArray);
                        break;
                    }
                    case 123: {
                        object = this.readShortBuffer(byArray);
                        break;
                    }
                    case 70: {
                        object = this.readString(byArray);
                        break;
                    }
                    case 71: {
                        object = this.readStringArray(byArray);
                        break;
                    }
                    case 72: {
                        object = this.readStringArray2D(byArray);
                        break;
                    }
                    default: {
                        continue block42;
                    }
                }
                this.fieldData.put(by, object);
            }
            catch (IOException iOException) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "setContent(byte[] content)", "Exception", iOException);
            }
        }
    }

    @Override
    public BitSet readBitSet(String string, BitSet bitSet) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return bitSet;
        }
        return (BitSet)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public boolean readBoolean(String string, boolean bl) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return bl;
        }
        return (Boolean)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public boolean[] readBooleanArray(String string, boolean[] blArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return blArray;
        }
        return (boolean[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public boolean[][] readBooleanArray2D(String string, boolean[][] blArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return blArray;
        }
        return (boolean[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public byte readByte(String string, byte by) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return by;
        }
        return (Byte)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public byte[] readByteArray(String string, byte[] byArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return byArray;
        }
        return (byte[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public byte[][] readByteArray2D(String string, byte[][] byArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return byArray;
        }
        return (byte[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public ByteBuffer readByteBuffer(String string, ByteBuffer byteBuffer) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return byteBuffer;
        }
        return (ByteBuffer)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public double readDouble(String string, double d) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return d;
        }
        return (Double)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public double[] readDoubleArray(String string, double[] dArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return dArray;
        }
        return (double[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public double[][] readDoubleArray2D(String string, double[][] dArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return dArray;
        }
        return (double[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public float readFloat(String string, float f) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return f;
        }
        return ((Float)this.fieldData.get(binaryClassField.alias)).floatValue();
    }

    @Override
    public float[] readFloatArray(String string, float[] fArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return fArray;
        }
        return (float[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public float[][] readFloatArray2D(String string, float[][] fArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return fArray;
        }
        return (float[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public FloatBuffer readFloatBuffer(String string, FloatBuffer floatBuffer) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return floatBuffer;
        }
        return (FloatBuffer)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public ArrayList readFloatBufferArrayList(String string, ArrayList<FloatBuffer> arrayList) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return arrayList;
        }
        return (ArrayList)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public int readInt(String string, int n) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return n;
        }
        return (Integer)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public int[] readIntArray(String string, int[] nArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return nArray;
        }
        return (int[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public int[][] readIntArray2D(String string, int[][] nArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return nArray;
        }
        return (int[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public IntBuffer readIntBuffer(String string, IntBuffer intBuffer) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return intBuffer;
        }
        return (IntBuffer)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public long readLong(String string, long l) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return l;
        }
        return (Long)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public long[] readLongArray(String string, long[] lArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return lArray;
        }
        return (long[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public long[][] readLongArray2D(String string, long[][] lArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return lArray;
        }
        return (long[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public Savable readSavable(String string, Savable savable) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return savable;
        }
        Object object = this.fieldData.get(binaryClassField.alias);
        if (object == null) {
            return null;
        }
        if (object instanceof ID) {
            object = this.importer.readObject(((ID)object).id);
            this.fieldData.put(binaryClassField.alias, object);
            return (Savable)object;
        }
        return savable;
    }

    @Override
    public Savable[] readSavableArray(String string, Savable[] savableArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return savableArray;
        }
        Object[] objectArray = (Object[])this.fieldData.get(binaryClassField.alias);
        if (objectArray instanceof ID[]) {
            objectArray = this.resolveIDs(objectArray);
            this.fieldData.put(binaryClassField.alias, objectArray);
            return (Savable[])objectArray;
        }
        return savableArray;
    }

    private Savable[] resolveIDs(Object[] objectArray) {
        if (objectArray != null) {
            Savable[] savableArray = new Savable[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                ID iD = (ID)objectArray[i];
                savableArray[i] = iD != null ? this.importer.readObject(iD.id) : null;
            }
            return savableArray;
        }
        return null;
    }

    @Override
    public Savable[][] readSavableArray2D(String string, Savable[][] savableArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return savableArray;
        }
        Object[][] objectArray = (Object[][])this.fieldData.get(binaryClassField.alias);
        if (objectArray instanceof ID[][]) {
            Savable[][] savableArrayArray = new Savable[objectArray.length][];
            for (int i = 0; i < objectArray.length; ++i) {
                savableArrayArray[i] = objectArray[i] != null ? this.resolveIDs(objectArray[i]) : null;
            }
            objectArray = savableArrayArray;
            this.fieldData.put(binaryClassField.alias, objectArray);
        }
        return (Savable[][])objectArray;
    }

    public Savable[][][] readSavableArray3D(String string, Savable[][][] savableArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return savableArray;
        }
        Object[][][] objectArray = (Object[][][])this.fieldData.get(binaryClassField.alias);
        if (objectArray instanceof ID[][][]) {
            Savable[][][] savableArray2 = new Savable[objectArray.length][][];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) {
                    savableArray2[i] = new Savable[objectArray[i].length][];
                    for (int j = 0; j < objectArray[i].length; ++j) {
                        savableArray2[i][j] = this.resolveIDs(objectArray[i][j]);
                    }
                    continue;
                }
                savableArray2[i] = null;
            }
            this.fieldData.put(binaryClassField.alias, savableArray2);
            return savableArray2;
        }
        return savableArray;
    }

    private ArrayList<Savable> savableArrayListFromArray(Savable[] savableArray) {
        if (savableArray == null) {
            return null;
        }
        ArrayList<Savable> arrayList = new ArrayList<Savable>(savableArray.length);
        for (int i = 0; i < savableArray.length; ++i) {
            arrayList.add(savableArray[i]);
        }
        return arrayList;
    }

    private Map<Savable, Savable> savableMapFrom2DArray(Savable[][] savableArray) {
        if (savableArray == null) {
            return null;
        }
        HashMap<Savable, Savable> hashMap = new HashMap<Savable, Savable>(savableArray.length);
        for (int i = 0; i < savableArray.length; ++i) {
            hashMap.put(savableArray[i][0], savableArray[i][1]);
        }
        return hashMap;
    }

    private Map<String, Savable> stringSavableMapFromKV(String[] stringArray, Savable[] savableArray) {
        if (stringArray == null || savableArray == null) {
            return null;
        }
        HashMap<String, Savable> hashMap = new HashMap<String, Savable>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], savableArray[i]);
        }
        return hashMap;
    }

    @Override
    public ArrayList readSavableArrayList(String string, ArrayList arrayList) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return arrayList;
        }
        ArrayList<Savable> arrayList2 = this.fieldData.get(binaryClassField.alias);
        if (arrayList2 instanceof ID[]) {
            Savable[] savableArray = this.readSavableArray(string, null);
            arrayList2 = this.savableArrayListFromArray(savableArray);
            this.fieldData.put(binaryClassField.alias, arrayList2);
        }
        return arrayList2;
    }

    @Override
    public ArrayList[] readSavableArrayListArray(String string, ArrayList[] arrayListArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return arrayListArray;
        }
        ArrayList[] arrayListArray2 = this.fieldData.get(binaryClassField.alias);
        if (arrayListArray2 instanceof ID[][]) {
            Savable[][] savableArray = this.readSavableArray2D(string, null);
            if (savableArray != null) {
                ArrayList[] arrayListArray3 = new ArrayList[savableArray.length];
                for (int i = 0; i < savableArray.length; ++i) {
                    arrayListArray3[i] = this.savableArrayListFromArray(savableArray[i]);
                }
                arrayListArray2 = arrayListArray3;
            } else {
                arrayListArray2 = arrayListArray;
            }
            this.fieldData.put(binaryClassField.alias, arrayListArray2);
        }
        return arrayListArray2;
    }

    @Override
    public ArrayList[][] readSavableArrayListArray2D(String string, ArrayList[][] arrayListArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return arrayListArray;
        }
        ArrayList[][] arrayListArray2 = this.fieldData.get(binaryClassField.alias);
        if (arrayListArray2 instanceof ID[][][]) {
            Savable[][][] savableArray = this.readSavableArray3D(string, null);
            if (savableArray != null && savableArray.length > 0) {
                ArrayList[][] arrayListArrayArray = new ArrayList[savableArray.length][];
                for (int i = 0; i < savableArray.length; ++i) {
                    arrayListArrayArray[i] = new ArrayList[savableArray[i].length];
                    for (int j = 0; j < savableArray[i].length; ++j) {
                        arrayListArrayArray[i][j] = this.savableArrayListFromArray(savableArray[i][j]);
                    }
                }
                arrayListArray2 = arrayListArrayArray;
            } else {
                arrayListArray2 = arrayListArray;
            }
            this.fieldData.put(binaryClassField.alias, arrayListArray2);
        }
        return arrayListArray2;
    }

    @Override
    public Map<? extends Savable, ? extends Savable> readSavableMap(String string, Map<? extends Savable, ? extends Savable> map) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return map;
        }
        Map<Savable, Savable> map2 = this.fieldData.get(binaryClassField.alias);
        if (map2 instanceof ID[][]) {
            Savable[][] savableArray = this.readSavableArray2D(string, null);
            map2 = this.savableMapFrom2DArray(savableArray);
            this.fieldData.put(binaryClassField.alias, map2);
        }
        return map2;
    }

    @Override
    public Map<String, ? extends Savable> readStringSavableMap(String string, Map<String, ? extends Savable> map) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return map;
        }
        Map<String, Savable> map2 = this.fieldData.get(binaryClassField.alias);
        if (map2 instanceof StringIDMap) {
            StringIDMap stringIDMap = (StringIDMap)((Object)map2);
            Savable[] savableArray = this.resolveIDs(stringIDMap.values);
            map2 = this.stringSavableMapFromKV(stringIDMap.keys, savableArray);
            this.fieldData.put(binaryClassField.alias, map2);
        }
        return map2;
    }

    @Override
    public short readShort(String string, short s) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return s;
        }
        return (Short)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public short[] readShortArray(String string, short[] sArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return sArray;
        }
        return (short[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public short[][] readShortArray2D(String string, short[][] sArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return sArray;
        }
        return (short[][])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public ShortBuffer readShortBuffer(String string, ShortBuffer shortBuffer) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return shortBuffer;
        }
        return (ShortBuffer)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public String readString(String string, String string2) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return string2;
        }
        return (String)this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public String[] readStringArray(String string, String[] stringArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return stringArray;
        }
        return (String[])this.fieldData.get(binaryClassField.alias);
    }

    @Override
    public String[][] readStringArray2D(String string, String[][] stringArray) throws IOException {
        BinaryClassField binaryClassField = this.cObj.nameFields.get(string);
        if (binaryClassField == null || !this.fieldData.containsKey(binaryClassField.alias)) {
            return stringArray;
        }
        return (String[][])this.fieldData.get(binaryClassField.alias);
    }

    protected byte readByte(byte[] byArray) throws IOException {
        byte by = byArray[this.index];
        ++this.index;
        return by;
    }

    protected byte[] readByteArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = this.readByte(byArray);
        }
        return byArray2;
    }

    protected byte[][] readByteArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byArrayArray[i] = this.readByteArray(byArray);
        }
        return byArrayArray;
    }

    protected int readInt(byte[] byArray) throws IOException {
        byte[] byArray2 = BinaryInputCapsule.inflateFrom(byArray, this.index);
        this.index += 1 + byArray2.length;
        int n = ByteUtils.convertIntFromBytes(byArray2 = ByteUtils.rightAlignBytes(byArray2, 4));
        if (n == -1 || n == -2) {
            this.index -= 4;
        }
        return n;
    }

    protected int[] readIntArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readInt(byArray);
        }
        return nArray;
    }

    protected int[][] readIntArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = this.readIntArray(byArray);
        }
        return nArrayArray;
    }

    protected float readFloat(byte[] byArray) throws IOException {
        float f = ByteUtils.convertFloatFromBytes(byArray, this.index);
        this.index += 4;
        return f;
    }

    protected float[] readFloatArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.readFloat(byArray);
        }
        return fArray;
    }

    protected float[][] readFloatArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = this.readFloatArray(byArray);
        }
        return fArrayArray;
    }

    protected double readDouble(byte[] byArray) throws IOException {
        double d = ByteUtils.convertDoubleFromBytes(byArray, this.index);
        this.index += 8;
        return d;
    }

    protected double[] readDoubleArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.readDouble(byArray);
        }
        return dArray;
    }

    protected double[][] readDoubleArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = this.readDoubleArray(byArray);
        }
        return dArrayArray;
    }

    protected long readLong(byte[] byArray) throws IOException {
        byte[] byArray2 = BinaryInputCapsule.inflateFrom(byArray, this.index);
        this.index += 1 + byArray2.length;
        byArray2 = ByteUtils.rightAlignBytes(byArray2, 8);
        long l = ByteUtils.convertLongFromBytes(byArray2);
        return l;
    }

    protected long[] readLongArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.readLong(byArray);
        }
        return lArray;
    }

    protected long[][] readLongArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        long[][] lArrayArray = new long[n][];
        for (int i = 0; i < n; ++i) {
            lArrayArray[i] = this.readLongArray(byArray);
        }
        return lArrayArray;
    }

    protected short readShort(byte[] byArray) throws IOException {
        short s = ByteUtils.convertShortFromBytes(byArray, this.index);
        this.index += 2;
        return s;
    }

    protected short[] readShortArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.readShort(byArray);
        }
        return sArray;
    }

    protected short[][] readShortArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        short[][] sArrayArray = new short[n][];
        for (int i = 0; i < n; ++i) {
            sArrayArray[i] = this.readShortArray(byArray);
        }
        return sArrayArray;
    }

    protected boolean readBoolean(byte[] byArray) throws IOException {
        boolean bl = ByteUtils.convertBooleanFromBytes(byArray, this.index);
        ++this.index;
        return bl;
    }

    protected boolean[] readBooleanArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = this.readBoolean(byArray);
        }
        return blArray;
    }

    protected boolean[][] readBooleanArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            blArrayArray[i] = this.readBooleanArray(byArray);
        }
        return blArrayArray;
    }

    protected String readString(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[this.index++];
        }
        return new String(byArray2);
    }

    protected String[] readStringArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readString(byArray);
        }
        return stringArray;
    }

    protected String[][] readStringArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readStringArray(byArray);
        }
        return stringArray;
    }

    protected BitSet readBitSet(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            bitSet.set(i, this.readBoolean(byArray));
        }
        return bitSet;
    }

    protected static byte[] inflateFrom(byte[] byArray, int n) {
        byte by = byArray[n];
        if (by == -1) {
            return ByteUtils.convertToBytes(-1);
        }
        if (by == -2) {
            return ByteUtils.convertToBytes(-2);
        }
        if (by == 0) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[by];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[i + 1 + n];
        }
        return byArray2;
    }

    protected ID readSavable(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        return new ID(n);
    }

    protected ID[] readSavableArray(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ID[] iDArray = new ID[n];
        for (int i = 0; i < n; ++i) {
            iDArray[i] = this.readSavable(byArray);
        }
        return iDArray;
    }

    protected ID[][] readSavableArray2D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ID[][] iDArray = new ID[n][];
        for (int i = 0; i < n; ++i) {
            iDArray[i] = this.readSavableArray(byArray);
        }
        return iDArray;
    }

    protected ID[][][] readSavableArray3D(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ID[][][] iDArray = new ID[n][][];
        for (int i = 0; i < n; ++i) {
            iDArray[i] = this.readSavableArray2D(byArray);
        }
        return iDArray;
    }

    protected ID[][] readSavableMap(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ID[][] iDArray = new ID[n][];
        for (int i = 0; i < n; ++i) {
            iDArray[i] = this.readSavableArray(byArray);
        }
        return iDArray;
    }

    protected StringIDMap readStringSavableMap(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        String[] stringArray = this.readStringArray(byArray);
        ID[] iDArray = this.readSavableArray(byArray);
        StringIDMap stringIDMap = new StringIDMap();
        stringIDMap.keys = stringArray;
        stringIDMap.values = iDArray;
        return stringIDMap;
    }

    protected ArrayList readFloatBufferArrayList(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ArrayList<FloatBuffer> arrayList = new ArrayList<FloatBuffer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.readFloatBuffer(byArray));
        }
        return arrayList;
    }

    protected FloatBuffer readFloatBuffer(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n);
        for (int i = 0; i < n; ++i) {
            floatBuffer.put(this.readFloat(byArray));
        }
        floatBuffer.rewind();
        return floatBuffer;
    }

    protected IntBuffer readIntBuffer(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        for (int i = 0; i < n; ++i) {
            intBuffer.put(this.readInt(byArray));
        }
        intBuffer.rewind();
        return intBuffer;
    }

    protected ByteBuffer readByteBuffer(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n);
        for (int i = 0; i < n; ++i) {
            byteBuffer.put(this.readByte(byArray));
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    protected ShortBuffer readShortBuffer(byte[] byArray) throws IOException {
        int n = this.readInt(byArray);
        if (n == -1) {
            return null;
        }
        ShortBuffer shortBuffer = BufferUtils.createShortBuffer(n);
        for (int i = 0; i < n; ++i) {
            shortBuffer.put(this.readShort(byArray));
        }
        shortBuffer.rewind();
        return shortBuffer;
    }

    private static class StringIDMap {
        public String[] keys;
        public ID[] values;

        private StringIDMap() {
        }
    }

    private static class ID {
        public int id;

        public ID(int n) {
            this.id = n;
        }
    }
}

