/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.StencilState;
import com.jme.scene.state.lwjgl.records.StencilStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLStencilState
extends StencilState {
    private static final long serialVersionUID = 2L;
    private static int[] stencilFunc = new int[]{512, 513, 515, 516, 518, 514, 517, 519};
    private static int[] stencilOp = new int[]{7680, 0, 7681, 7682, 7683, 5386};

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        StencilStateRecord stencilStateRecord = (StencilStateRecord)renderContext.getStateRecord(13);
        renderContext.currentStates[13] = this;
        this.setEnabled(this.isEnabled(), stencilStateRecord);
        if (this.isEnabled()) {
            this.applyMask(this.getStencilWriteMask(), stencilStateRecord);
            this.applyFunc(stencilFunc[this.getStencilFunc()], this.getStencilRef(), this.getStencilFuncMask(), stencilStateRecord);
            this.applyOp(stencilOp[this.getStencilOpFail()], stencilOp[this.getStencilOpZFail()], stencilOp[this.getStencilOpZPass()], stencilStateRecord);
        }
        if (!stencilStateRecord.isValid()) {
            stencilStateRecord.validate();
        }
    }

    private void setEnabled(boolean bl, StencilStateRecord stencilStateRecord) {
        if (stencilStateRecord.isValid()) {
            if (bl && !stencilStateRecord.enabled) {
                GL11.glEnable((int)2960);
            } else if (!bl && stencilStateRecord.enabled) {
                GL11.glDisable((int)2960);
            }
        } else if (bl) {
            GL11.glEnable((int)2960);
        } else {
            GL11.glDisable((int)2960);
        }
        stencilStateRecord.enabled = bl;
    }

    private void applyMask(int n, StencilStateRecord stencilStateRecord) {
        if (!stencilStateRecord.isValid() || n != stencilStateRecord.writeMask) {
            GL11.glStencilMask((int)n);
            stencilStateRecord.writeMask = n;
        }
    }

    private void applyFunc(int n, int n2, int n3, StencilStateRecord stencilStateRecord) {
        if (!stencilStateRecord.isValid() || n != stencilStateRecord.func || n2 != stencilStateRecord.ref || n3 != stencilStateRecord.funcMask) {
            GL11.glStencilFunc((int)n, (int)n2, (int)n3);
            stencilStateRecord.func = n;
            stencilStateRecord.ref = n2;
            stencilStateRecord.funcMask = n3;
        }
    }

    private void applyOp(int n, int n2, int n3, StencilStateRecord stencilStateRecord) {
        if (!stencilStateRecord.isValid() || n != stencilStateRecord.fail || n2 != stencilStateRecord.zfail || n3 != stencilStateRecord.zpass) {
            GL11.glStencilOp((int)n, (int)n2, (int)n3);
            stencilStateRecord.fail = n;
            stencilStateRecord.zfail = n2;
            stencilStateRecord.zpass = n3;
        }
    }

    public StencilStateRecord createStateRecord() {
        return new StencilStateRecord();
    }
}

