/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.lwjgl.records.ShaderObjectsStateRecord;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.scene.state.lwjgl.shader.LWJGLShaderUtil;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.shader.ShaderVariable;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class LWJGLShaderObjectsState
extends GLSLShaderObjectsState {
    private static final Logger logger = Logger.getLogger(LWJGLShaderObjectsState.class.getName());
    private static final long serialVersionUID = 1L;
    private int programID = -1;
    private int vertexShaderID = -1;
    private int fragmentShaderID = -1;
    private int maxVertexAttribs;

    public LWJGLShaderObjectsState() {
        if (this.isSupported()) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)16);
            GL11.glGetInteger((int)34921, (IntBuffer)intBuffer);
            this.maxVertexAttribs = intBuffer.get(0);
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("GL_MAX_VERTEX_ATTRIBS: " + this.maxVertexAttribs + "\n");
                GL11.glGetInteger((int)35658, (IntBuffer)intBuffer);
                stringBuffer.append("GL_MAX_VERTEX_UNIFORM_COMPONENTS: " + intBuffer.get(0) + "\n");
                GL11.glGetInteger((int)35657, (IntBuffer)intBuffer);
                stringBuffer.append("GL_MAX_FRAGMENT_UNIFORM_COMPONENTS: " + intBuffer.get(0) + "\n");
                GL11.glGetInteger((int)34929, (IntBuffer)intBuffer);
                stringBuffer.append("GL_MAX_TEXTURE_COORDS: " + intBuffer.get(0) + "\n");
                GL11.glGetInteger((int)34930, (IntBuffer)intBuffer);
                stringBuffer.append("GL_MAX_TEXTURE_IMAGE_UNITS: " + intBuffer.get(0) + "\n");
                GL11.glGetInteger((int)35661, (IntBuffer)intBuffer);
                stringBuffer.append("GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS: " + intBuffer.get(0) + "\n");
                GL11.glGetInteger((int)35659, (IntBuffer)intBuffer);
                stringBuffer.append("GL_MAX_VARYING_FLOATS: " + intBuffer.get(0) + "\n");
                stringBuffer.append(GL11.glGetString((int)35724));
                logger.fine(stringBuffer.toString());
            }
        }
    }

    public boolean isSupported() {
        return GLContext.getCapabilities().GL_ARB_shader_objects && GLContext.getCapabilities().GL_ARB_fragment_shader && GLContext.getCapabilities().GL_ARB_vertex_shader && GLContext.getCapabilities().GL_ARB_shading_language_100;
    }

    private ByteBuffer load(URL uRL) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte[bufferedInputStream.available()];
            dataInputStream.readFully(byArray);
            bufferedInputStream.close();
            dataInputStream.close();
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            return byteBuffer;
        }
        catch (Exception exception) {
            logger.severe("Could not load shader object: " + exception);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", exception);
            return null;
        }
    }

    private ByteBuffer load(String string) {
        try {
            byte[] byArray = string.getBytes();
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            return byteBuffer;
        }
        catch (Exception exception) {
            logger.severe("Could not load fragment program: " + exception);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", exception);
            return null;
        }
    }

    public void load(URL uRL, URL uRL2) {
        ByteBuffer byteBuffer = uRL != null ? this.load(uRL) : null;
        ByteBuffer byteBuffer2 = uRL2 != null ? this.load(uRL2) : null;
        this.load(byteBuffer, byteBuffer2);
    }

    public void load(String string, String string2) {
        ByteBuffer byteBuffer = string != null ? this.load(string) : null;
        ByteBuffer byteBuffer2 = string2 != null ? this.load(string2) : null;
        this.load(byteBuffer, byteBuffer2);
    }

    private void load(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        IntBuffer intBuffer;
        if (byteBuffer == null && byteBuffer2 == null) {
            logger.warning("Could not find shader resources!(both inputbuffers are null)");
            return;
        }
        if (this.programID == -1) {
            this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        }
        if (byteBuffer != null) {
            if (this.vertexShaderID != -1) {
                this.removeVertShader();
            }
            this.vertexShaderID = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
            ARBShaderObjects.glShaderSourceARB((int)this.vertexShaderID, (ByteBuffer)byteBuffer);
            intBuffer = BufferUtils.createIntBuffer((int)1);
            ARBShaderObjects.glCompileShaderARB((int)this.vertexShaderID);
            ARBShaderObjects.glGetObjectParameterARB((int)this.vertexShaderID, (int)35713, (IntBuffer)intBuffer);
            this.checkProgramError(intBuffer, this.vertexShaderID);
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.vertexShaderID);
        } else if (this.vertexShaderID != -1) {
            this.removeVertShader();
            this.vertexShaderID = -1;
        }
        if (byteBuffer2 != null) {
            if (this.fragmentShaderID != -1) {
                this.removeFragShader();
            }
            this.fragmentShaderID = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
            ARBShaderObjects.glShaderSourceARB((int)this.fragmentShaderID, (ByteBuffer)byteBuffer2);
            intBuffer = BufferUtils.createIntBuffer((int)1);
            ARBShaderObjects.glCompileShaderARB((int)this.fragmentShaderID);
            ARBShaderObjects.glGetObjectParameterARB((int)this.fragmentShaderID, (int)35713, (IntBuffer)intBuffer);
            this.checkProgramError(intBuffer, this.fragmentShaderID);
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.fragmentShaderID);
        } else if (this.fragmentShaderID != -1) {
            this.removeFragShader();
            this.fragmentShaderID = -1;
        }
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        this.setNeedsRefresh(true);
    }

    private void removeFragShader() {
        if (this.fragmentShaderID != -1) {
            ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.fragmentShaderID);
            ARBShaderObjects.glDeleteObjectARB((int)this.fragmentShaderID);
        }
    }

    private void removeVertShader() {
        if (this.vertexShaderID != -1) {
            ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.vertexShaderID);
            ARBShaderObjects.glDeleteObjectARB((int)this.vertexShaderID);
        }
    }

    private void checkProgramError(IntBuffer intBuffer, int n) {
        if (intBuffer.get(0) == 0) {
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer((int)1);
            ARBShaderObjects.glGetObjectParameterARB((int)n, (int)35716, (IntBuffer)intBuffer2);
            int n2 = intBuffer2.get();
            String string = null;
            if (n2 > 0) {
                ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)n2);
                intBuffer2.flip();
                ARBShaderObjects.glGetInfoLogARB((int)n, (IntBuffer)intBuffer2, (ByteBuffer)byteBuffer);
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                string = new String(byArray);
            }
            logger.severe(string);
            throw new JmeException("Error compiling GLSL shader: " + string);
        }
    }

    public void apply() {
        if (this.isSupported()) {
            RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
            ShaderObjectsStateRecord shaderObjectsStateRecord = (ShaderObjectsStateRecord)renderContext.getStateRecord(14);
            renderContext.currentStates[14] = this;
            if (this.shaderDataLogic != null) {
                this.shaderDataLogic.applyData(this, this.batch);
            }
            if (!shaderObjectsStateRecord.isValid() || shaderObjectsStateRecord.getReference() != this || this.needsRefresh()) {
                shaderObjectsStateRecord.setReference(this);
                if (this.isEnabled()) {
                    if (this.programID != -1) {
                        ShaderVariable shaderVariable;
                        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
                        int n = this.shaderAttributes.size();
                        while (--n >= 0) {
                            shaderVariable = (ShaderVariable)this.shaderAttributes.get(n);
                            if (shaderVariable.needsRefresh) {
                                LWJGLShaderUtil.updateAttributeLocation(shaderVariable, this.programID);
                                shaderVariable.needsRefresh = false;
                            }
                            LWJGLShaderUtil.updateShaderAttribute(shaderVariable);
                        }
                        n = this.shaderUniforms.size();
                        while (--n >= 0) {
                            shaderVariable = (ShaderVariable)this.shaderUniforms.get(n);
                            if (!shaderVariable.needsRefresh) continue;
                            LWJGLShaderUtil.updateUniformLocation(shaderVariable, this.programID);
                            LWJGLShaderUtil.updateShaderUniform(shaderVariable);
                            shaderVariable.needsRefresh = false;
                        }
                    }
                } else {
                    ARBShaderObjects.glUseProgramObjectARB((int)0);
                }
            }
            if (!shaderObjectsStateRecord.isValid()) {
                shaderObjectsStateRecord.validate();
            }
        }
    }

    public StateRecord createStateRecord() {
        return new ShaderObjectsStateRecord();
    }

    public void checkAttributeSizeLimits() {
        if (this.shaderAttributes.size() > this.maxVertexAttribs) {
            logger.severe("Too many shader attributes(standard+defined): " + this.shaderAttributes.size() + " maximum: " + this.maxVertexAttribs);
        } else if (this.shaderAttributes.size() + 16 > this.maxVertexAttribs) {
            logger.warning("User defined attributes might overwrite default OpenGL attributes");
        }
    }

    public void checkUniformSizeLimits() {
    }
}

