/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.light.Light;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public abstract class LightState
extends RenderState {
    public static boolean LIGHTS_ENABLED = true;
    public static final int MAX_LIGHTS_ALLOWED = 8;
    public static final int OFF = 0;
    public static final int COMBINE_FIRST = 1;
    public static final int COMBINE_CLOSEST = 2;
    public static final int COMBINE_RECENT_ENABLED = 3;
    public static final int INHERIT = 4;
    public static final int REPLACE = 5;
    public static final int MASK_AMBIENT = 1;
    public static final int MASK_DIFFUSE = 2;
    public static final int MASK_SPECULAR = 4;
    public static final int MASK_GLOBALAMBIENT = 8;
    private ArrayList<Light> lightList;
    protected int lightMask = 0;
    protected int backLightMask = 0;
    protected boolean twoSidedOn = true;
    protected float[] globalAmbient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected static FloatBuffer zeroBuffer;
    protected boolean localViewerOn;
    protected boolean separateSpecularOn;

    public LightState() {
        this.lightList = new ArrayList();
        if (zeroBuffer == null) {
            zeroBuffer = BufferUtils.createFloatBuffer(4);
            zeroBuffer.put(0.0f).put(0.0f).put(0.0f).put(1.0f);
            zeroBuffer.rewind();
        }
    }

    public int getType() {
        return 3;
    }

    public boolean attach(Light light) {
        if (this.lightList.size() < 8 && !this.lightList.contains(light)) {
            this.lightList.add(light);
            this.setNeedsRefresh(true);
            return true;
        }
        return false;
    }

    public void detach(Light light) {
        this.lightList.remove(light);
        this.setNeedsRefresh(true);
    }

    public void detachAll() {
        this.lightList.clear();
        this.setNeedsRefresh(true);
    }

    public Light get(int n) {
        return this.lightList.get(n);
    }

    public int getQuantity() {
        return this.lightList.size();
    }

    public void setTwoSidedLighting(boolean bl) {
        this.twoSidedOn = bl;
        this.setNeedsRefresh(true);
    }

    public boolean getTwoSidedLighting() {
        return this.twoSidedOn;
    }

    public void setLocalViewer(boolean bl) {
        this.localViewerOn = bl;
        this.setNeedsRefresh(true);
    }

    public boolean getLocalViewer() {
        return this.localViewerOn;
    }

    public void setSeparateSpecular(boolean bl) {
        this.separateSpecularOn = bl;
        this.setNeedsRefresh(true);
    }

    public boolean getSeparateSpecular() {
        return this.separateSpecularOn;
    }

    public void setGlobalAmbient(ColorRGBA colorRGBA) {
        this.globalAmbient[0] = colorRGBA.r;
        this.globalAmbient[1] = colorRGBA.g;
        this.globalAmbient[2] = colorRGBA.b;
        this.globalAmbient[3] = colorRGBA.a;
        this.setNeedsRefresh(true);
    }

    public ColorRGBA getGlobalAmbient() {
        return new ColorRGBA(this.globalAmbient[0], this.globalAmbient[1], this.globalAmbient[2], this.globalAmbient[3]);
    }

    public int getLightMask() {
        return this.lightMask;
    }

    public void setLightMask(int n) {
        this.lightMask = n;
        this.setNeedsRefresh(true);
    }

    public void pushLightMask() {
        this.backLightMask = this.lightMask;
    }

    public void popLightMask() {
        this.lightMask = this.backLightMask;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.lightList, "lightList", new ArrayList());
        outputCapsule.write(this.lightMask, "lightMask", 0);
        outputCapsule.write(this.backLightMask, "backLightMask", 0);
        outputCapsule.write(this.twoSidedOn, "twoSidedOn", false);
        outputCapsule.write(this.globalAmbient, "globalAmbient", new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        outputCapsule.write(this.localViewerOn, "localViewerOn", false);
        outputCapsule.write(this.separateSpecularOn, "separateSpecularOn", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.lightList = inputCapsule.readSavableArrayList("lightList", new ArrayList());
        this.lightMask = inputCapsule.readInt("lightMask", 0);
        this.backLightMask = inputCapsule.readInt("backLightMask", 0);
        this.twoSidedOn = inputCapsule.readBoolean("twoSidedOn", false);
        this.globalAmbient = inputCapsule.readFloatArray("globalAmbient", new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        this.localViewerOn = inputCapsule.readBoolean("localViewerOn", false);
        this.separateSpecularOn = inputCapsule.readBoolean("separateSpecularOn", false);
    }

    public Class getClassTag() {
        return LightState.class;
    }
}

