/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Line;
import com.jme.scene.TriMesh;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extrusion
extends TriMesh {
    private static final long serialVersionUID = 1L;

    public Extrusion() {
    }

    public Extrusion(String string) {
        super(string);
    }

    public Extrusion(Line line, List<Vector3f> list, Vector3f vector3f) {
        this.updateGeometry(line, list, vector3f);
    }

    public Extrusion(String string, Line line, List<Vector3f> list, Vector3f vector3f) {
        super(string);
        this.updateGeometry(line, list, vector3f);
    }

    public void updateGeometry(Line line, List<Vector3f> list, Vector3f vector3f) {
        this.updateGeometry(line, list, false, vector3f);
    }

    public void updateGeometry(Line line, List<Vector3f> list, boolean bl, Vector3f vector3f) {
        IntBuffer intBuffer;
        FloatBuffer floatBuffer;
        FloatBuffer floatBuffer2;
        FloatBuffer floatBuffer3 = line.getVertexBuffer(0);
        FloatBuffer floatBuffer4 = line.getNormalBuffer(0);
        int n = list.size() * floatBuffer3.limit();
        if (this.getVertexBuffer(0) != null && this.getVertexBuffer(0).limit() == n) {
            floatBuffer2 = this.getVertexBuffer(0);
            floatBuffer = this.getNormalBuffer(0);
            floatBuffer2.rewind();
            floatBuffer.rewind();
        } else {
            floatBuffer2 = BufferUtils.createFloatBuffer(n);
            floatBuffer = BufferUtils.createFloatBuffer(n);
        }
        int n2 = (list.size() - 1) * 2 * floatBuffer3.limit();
        if (this.getIndexBuffer(0) != null && this.getIndexBuffer(0).limit() == n2) {
            intBuffer = this.getIndexBuffer(0);
            intBuffer.rewind();
        } else {
            intBuffer = BufferUtils.createIntBuffer(n2);
        }
        int n3 = floatBuffer3.limit() / 3;
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Quaternion quaternion = new Quaternion();
        for (int i = 0; i < list.size(); ++i) {
            Vector3f vector3f4 = list.get(i);
            floatBuffer3.rewind();
            floatBuffer4.rewind();
            int n4 = 0;
            do {
                Vector3f vector3f5;
                Vector3f vector3f6 = i < list.size() - 1 ? list.get(i + 1) : (bl ? list.get(0) : null);
                Vector3f vector3f7 = vector3f5 = i > 0 ? list.get(i - 1) : null;
                if (vector3f6 != null) {
                    vector3f3.set(vector3f6).subtractLocal(vector3f4);
                } else {
                    vector3f3.set(vector3f4).subtractLocal(vector3f5);
                }
                quaternion.lookAt(vector3f3, vector3f);
                vector3f2.set(floatBuffer4.get(), floatBuffer4.get(), floatBuffer4.get());
                quaternion.multLocal(vector3f2);
                floatBuffer.put(vector3f2.x);
                floatBuffer.put(vector3f2.y);
                floatBuffer.put(vector3f2.z);
                vector3f2.set(floatBuffer3.get(), floatBuffer3.get(), floatBuffer3.get());
                quaternion.multLocal(vector3f2);
                vector3f2.addLocal(vector3f4);
                floatBuffer2.put(vector3f2.x);
                floatBuffer2.put(vector3f2.y);
                floatBuffer2.put(vector3f2.z);
                if (!(n4 & true)) {
                    if (i < list.size() - 1) {
                        intBuffer.put(i * n3 + n4);
                        intBuffer.put(i * n3 + n4 + 1);
                        intBuffer.put((i + 1) * n3 + n4);
                        intBuffer.put((i + 1) * n3 + n4 + 1);
                        intBuffer.put((i + 1) * n3 + n4);
                        intBuffer.put(i * n3 + n4 + 1);
                    } else if (bl) {
                        intBuffer.put(i * n3 + n4);
                        intBuffer.put(i * n3 + n4 + 1);
                        intBuffer.put(0 + n4);
                        intBuffer.put(0 + n4 + 1);
                        intBuffer.put(0 + n4);
                        intBuffer.put(i * n3 + n4 + 1);
                    }
                }
                ++n4;
            } while (floatBuffer3.hasRemaining());
        }
        this.setVertexBuffer(0, floatBuffer2);
        this.setNormalBuffer(0, floatBuffer);
        this.setIndexBuffer(0, intBuffer);
    }

    public void updateGeometry(Line line, List<Vector3f> list, int n, Vector3f vector3f) {
        this.updateGeometry(line, list, n, false, vector3f);
    }

    public void updateGeometry(Line line, List<Vector3f> list, int n, boolean bl, Vector3f vector3f) {
        Object object;
        int n2 = list.size();
        if (bl) {
            n2 += 3;
        }
        float[][] fArray = new float[3][n2];
        float[] fArray2 = new float[n2];
        ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>();
        for (int i = 0; i < n2; ++i) {
            object = !bl ? list.get(i) : (i == 0 ? list.get(list.size() - 1) : (i >= n2 - 2 ? list.get(i - n2 + 2) : list.get(i - 1)));
            fArray2[i] = i;
            fArray[0][i] = ((Vector3f)object).x;
            fArray[1][i] = ((Vector3f)object).y;
            fArray[2][i] = ((Vector3f)object).z;
        }
        if (n2 > 1) {
            int n3;
            int n4;
            float[][] fArray3 = new float[3][n2];
            object = new float[n2];
            for (int i = 1; i <= n2 - 1; ++i) {
                object[i] = fArray2[i] - fArray2[i - 1];
            }
            if (n2 > 2) {
                float[] fArray4 = new float[n2 - 1];
                float[] fArray5 = new float[n2 - 1];
                float[] fArray6 = new float[n2 - 1];
                for (n4 = 1; n4 <= n2 - 2; ++n4) {
                    fArray5[n4] = (float)((object[n4] + object[n4 + 1]) / 3.0f);
                    fArray6[n4] = (float)(object[n4 + 1] / 6.0f);
                    fArray4[n4] = (float)(object[n4] / 6.0f);
                    for (int i = 0; i < 3; ++i) {
                        fArray3[i][n4] = (fArray[i][n4 + 1] - fArray[i][n4]) / object[n4 + 1] - (fArray[i][n4] - fArray[i][n4 - 1]) / object[n4];
                    }
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    Extrusion.solveTridiag((float[])fArray4.clone(), (float[])fArray5.clone(), (float[])fArray6.clone(), fArray3[n4], n2 - 2);
                }
            }
            if (!bl) {
                arrayList.add(new Vector3f(fArray[0][0], fArray[1][0], fArray[2][0]));
            }
            float[] fArray7 = new float[3];
            int n5 = n3 = bl ? 2 : 1;
            while (n3 <= n2 - 2) {
                for (int i = 1; i <= n; ++i) {
                    for (n4 = 0; n4 < 3; ++n4) {
                        float f;
                        reference var16_23 = object[n3] * (float)i / (float)n;
                        reference var17_24 = object[n3] - var16_23;
                        fArray7[n4] = f = ((-fArray3[n4][n3 - 1] / 6.0f * (var17_24 + object[n3]) * var16_23 + fArray[n4][n3 - 1]) * var17_24 + (-fArray3[n4][n3] / 6.0f * (var16_23 + object[n3]) * var17_24 + fArray[n4][n3]) * var16_23) / object[n3];
                    }
                    arrayList.add(new Vector3f(fArray7[0], fArray7[1], fArray7[2]));
                }
                ++n3;
            }
        }
        this.updateGeometry(line, arrayList, bl, vector3f);
    }

    private static void solveTridiag(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        int n2;
        for (n2 = 2; n2 <= n; ++n2) {
            fArray[n2] = fArray[n2] / fArray2[n2 - 1];
            fArray2[n2] = fArray2[n2] - fArray[n2] * fArray3[n2 - 1];
            fArray4[n2] = fArray4[n2] - fArray[n2] * fArray4[n2 - 1];
        }
        fArray4[n] = fArray4[n] / fArray2[n];
        for (n2 = n - 1; n2 >= 1; --n2) {
            fArray4[n2] = (fArray4[n2] - fArray3[n2] * fArray4[n2 + 1]) / fArray2[n2];
        }
    }
}

