/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Quaternion;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Cylinder;
import com.jme.scene.shape.Pyramid;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class Arrow
extends TriMesh {
    private static final long serialVersionUID = 1L;
    protected float length = 1.0f;
    protected float width = 0.25f;
    protected static final Quaternion rotator = new Quaternion();

    public Arrow() {
    }

    public Arrow(String string) {
        super(string);
    }

    public Arrow(String string, float f, float f2) {
        super(string);
        this.length = f;
        this.width = f2;
        this.buildArrow();
    }

    protected void buildArrow() {
        this.clearBatches();
        Cylinder cylinder = new Cylinder("base", 4, 16, this.width * 0.75f, this.length);
        rotator.fromAngles(1.5707964f, 0.0f, 0.0f);
        cylinder.getBatch(0).rotatePoints(rotator);
        cylinder.getBatch(0).rotateNormals(rotator);
        this.addBatch(cylinder.getBatch(0));
        Pyramid pyramid = new Pyramid("tip", 2.0f * this.width, this.length / 2.0f);
        pyramid.getBatch(0).translatePoints(0.0f, this.length * 0.75f, 0.0f);
        this.addBatch(pyramid.getBatch(0));
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.length, "length", 1.0f);
        outputCapsule.write(this.width, "width", 0.25f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.length = inputCapsule.readFloat("length", 1.0f);
        this.width = inputCapsule.readFloat("width", 0.25f);
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }
}

