/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.geometryinstancing.instance;

import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.geometryinstancing.instance.GeometryInstance;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryBatchCreator {
    protected ArrayList<GeometryInstance> instances = new ArrayList(1);
    private int nVerts = 0;
    private int nIndices = 0;

    public void clearInstances() {
        this.instances.clear();
        this.nVerts = 0;
        this.nIndices = 0;
    }

    public void addInstance(GeometryInstance geometryInstance) {
        if (geometryInstance == null) {
            return;
        }
        this.instances.add(geometryInstance);
        this.nIndices += geometryInstance.getNumIndices();
        this.nVerts += geometryInstance.getNumVerts();
    }

    public void removeInstance(GeometryInstance geometryInstance) {
        if (this.instances.remove(geometryInstance)) {
            this.nIndices -= geometryInstance.getNumIndices();
            this.nVerts -= geometryInstance.getNumVerts();
        }
    }

    public int getNumVertices() {
        return this.nVerts;
    }

    public int getNumIndices() {
        return this.nIndices;
    }

    public ArrayList<GeometryInstance> getInstances() {
        return this.instances;
    }

    public void commit(TriangleBatch triangleBatch) {
        for (GeometryInstance geometryInstance : this.instances) {
            geometryInstance.commit(triangleBatch);
        }
    }
}

