/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.TriMesh;
import com.jme.scene.UserDataManager;
import com.jme.scene.VBOInfo;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.SharedBatch;
import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedMesh
extends TriMesh {
    private static final Logger logger = Logger.getLogger(SharedMesh.class.getName());
    private static final long serialVersionUID = 1L;
    private TriMesh target;

    public SharedMesh() {
    }

    @Override
    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
    }

    public SharedMesh(String string, TriMesh triMesh) {
        super(string);
        if ((triMesh.getType() & 8) != 0) {
            this.setTarget(((SharedMesh)triMesh).getTarget());
        } else {
            this.setTarget(triMesh);
        }
        this.localRotation.set(triMesh.getLocalRotation());
        this.localScale.set(triMesh.getLocalScale());
        this.localTranslation.set(triMesh.getLocalTranslation());
    }

    @Override
    public int getType() {
        return 14;
    }

    public void setTarget(TriMesh triMesh) {
        int n;
        this.target = triMesh;
        UserDataManager.getInstance().bind(this, triMesh);
        for (n = 0; n < 17; ++n) {
            RenderState renderState = this.target.getRenderState(n);
            if (renderState == null) continue;
            this.setRenderState(renderState);
        }
        this.batchList.clear();
        int n2 = triMesh.getBatchCount();
        for (n = 0; n < n2; ++n) {
            SharedBatch sharedBatch = new SharedBatch(triMesh.getBatch(n));
            sharedBatch.setParentGeom(this);
            this.batchList.add(sharedBatch);
        }
        this.setCullMode(triMesh.cullMode);
        this.setLightCombineMode(triMesh.lightCombineMode);
        this.setRenderQueueMode(triMesh.renderQueueMode);
        this.setTextureCombineMode(triMesh.textureCombineMode);
        this.setZOrder(triMesh.getZOrder());
    }

    public TriMesh getTarget() {
        return this.target;
    }

    @Override
    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        logger.info("SharedMesh will ignore reconstruct.");
    }

    @Override
    public void setVBOInfo(VBOInfo vBOInfo) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void setVBOInfo(int n, VBOInfo vBOInfo) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public VBOInfo getVBOInfo(int n) {
        return this.target.getBatch(n).getVBOInfo();
    }

    @Override
    public void setSolidColor(ColorRGBA colorRGBA) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void setRandomColors() {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public FloatBuffer getVertexBuffer(int n) {
        return this.target.getVertexBuffer(n);
    }

    @Override
    public void setVertexBuffer(int n, FloatBuffer floatBuffer) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public int getVertexCount() {
        return this.target.getVertexCount();
    }

    @Override
    public FloatBuffer getNormalBuffer(int n) {
        return this.target.getNormalBuffer(n);
    }

    @Override
    public void setNormalBuffer(int n, FloatBuffer floatBuffer) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public FloatBuffer getColorBuffer(int n) {
        return this.target.getColorBuffer(n);
    }

    @Override
    public void setColorBuffer(int n, FloatBuffer floatBuffer) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public IntBuffer getIndexBuffer(int n) {
        return this.target.getIndexBuffer(n);
    }

    @Override
    public void setIndexBuffer(int n, IntBuffer intBuffer) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void getTriangle(int n, int[] nArray) {
        this.target.getTriangle(n, nArray);
    }

    @Override
    public void getTriangle(int n, int n2, int[] nArray) {
        this.target.getTriangle(n, n2, nArray);
    }

    @Override
    public void getTriangle(int n, Vector3f[] vector3fArray) {
        this.target.getTriangle(n, vector3fArray);
    }

    @Override
    public int getTriangleCount() {
        return this.target.getTriangleCount();
    }

    @Override
    public void copyTextureCoords(int n, int n2, int n3) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public FloatBuffer[] getTextureBuffers(int n) {
        return this.target.getTextureBuffers(n);
    }

    @Override
    public FloatBuffer getTextureBuffer(int n, int n2) {
        return this.target.getTextureBuffer(n, n2);
    }

    @Override
    public Vector3f[] getMeshAsTrianglesVertices(int n, Vector3f[] vector3fArray) {
        return this.target.getMeshAsTrianglesVertices(n, vector3fArray);
    }

    @Override
    public void setTextureBuffer(int n, FloatBuffer floatBuffer) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void setTextureBuffer(int n, FloatBuffer floatBuffer, int n2) {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void clearBuffers() {
        logger.warning("SharedMesh does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void draw(Renderer renderer) {
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            SharedBatch sharedBatch = this.getBatch(i);
            if (sharedBatch == null || !sharedBatch.isEnabled()) continue;
            sharedBatch.onDraw(renderer);
        }
    }

    @Override
    public SharedBatch getBatch(int n) {
        return (SharedBatch)this.batchList.get(n);
    }

    @Override
    public boolean hasTriangleCollision(TriMesh triMesh) {
        this.target.setLocalTranslation(this.worldTranslation);
        this.target.setLocalRotation(this.worldRotation);
        this.target.setLocalScale(this.worldScale);
        this.target.updateWorldBound();
        return this.target.hasTriangleCollision(triMesh);
    }

    @Override
    public void findTriangleCollision(TriMesh triMesh, int n, int n2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        this.target.setLocalTranslation(this.worldTranslation);
        this.target.setLocalRotation(this.worldRotation);
        this.target.setLocalScale(this.worldScale);
        this.target.updateWorldBound();
        this.target.findTriangleCollision(triMesh, n, n2, arrayList, arrayList2);
    }

    @Override
    public void findTrianglePick(Ray ray, ArrayList<Integer> arrayList, int n) {
        this.target.setLocalTranslation(this.worldTranslation);
        this.target.setLocalRotation(this.worldRotation);
        this.target.setLocalScale(this.worldScale);
        this.target.updateWorldBound();
        this.target.findTrianglePick(ray, arrayList, n);
    }

    @Override
    public void swapBatches(int n, int n2) {
        GeomBatch geomBatch = (GeomBatch)this.target.batchList.get(n2);
        GeomBatch geomBatch2 = (GeomBatch)this.target.batchList.remove(n);
        this.target.batchList.add(n, geomBatch);
        this.target.batchList.remove(n2);
        this.target.batchList.add(n2, geomBatch2);
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.target, "target", null);
        super.write(jMEExporter);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.target = (TriMesh)inputCapsule.readSavable("target", null);
        super.read(jMEImporter);
    }

    @Override
    public void lockMeshes(Renderer renderer) {
        this.target.lockMeshes(renderer);
    }

    @Override
    public Vector3f randomVertex(Vector3f vector3f) {
        return this.target.randomVertex(vector3f);
    }
}

