/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.BoundingVolume;
import com.jme.renderer.Renderer;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Stack;

public abstract class SceneElement
implements Serializable,
Savable {
    public static final int NODE = 1;
    public static final int GEOMETRY = 2;
    public static final int TRIMESH = 4;
    public static final int SHARED_MESH = 8;
    public static final int SKY_BOX = 16;
    public static final int TERRAIN_BLOCK = 32;
    public static final int TERRAIN_PAGE = 64;
    public static final int COMPOSITE_MESH = 128;
    public static final int GEOMBATCH = 256;
    public static final int TRIANGLEBATCH = 512;
    public static final int SHAREDBATCH = 1024;
    public static final int QUADBATCH = 2048;
    public static final int CULL_INHERIT = 0;
    public static final int CULL_DYNAMIC = 1;
    public static final int CULL_ALWAYS = 2;
    public static final int CULL_NEVER = 3;
    public static final int LOCKED_NONE = 0;
    public static final int LOCKED_BOUNDS = 1;
    public static final int LOCKED_MESH_DATA = 2;
    public static final int LOCKED_TRANSFORMS = 4;
    public static final int LOCKED_SHADOWS = 8;
    public static final int LOCKED_BRANCH = 16;
    public static final int NM_INHERIT = 0;
    public static final int NM_USE_PROVIDED = 1;
    public static final int NM_GL_NORMALIZE_PROVIDED = 2;
    public static final int NM_GL_NORMALIZE_IF_SCALED = 3;
    public static final int NM_OFF = 4;
    protected int normalsMode = 0;
    protected int cullMode = 0;
    protected BoundingVolume worldBound;
    protected RenderState[] renderStateList;
    protected int renderQueueMode = 0;
    protected int zOrder = 0;
    protected int lockedMode = 0;
    protected int lightCombineMode = 4;
    protected int textureCombineMode = 4;
    protected String name;
    protected int frustrumIntersects = 1;
    protected boolean isCollidable = true;
    public transient float queueDistance = Float.NEGATIVE_INFINITY;
    private static final long serialVersionUID = 1L;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setIsCollidable(boolean bl) {
        this.isCollidable = bl;
    }

    public boolean isCollidable() {
        return this.isCollidable;
    }

    public BoundingVolume getWorldBound() {
        return this.worldBound;
    }

    public abstract int getType();

    public abstract void draw(Renderer var1);

    public void setCullMode(int n) {
        this.cullMode = n;
    }

    public int getLocalCullMode() {
        return this.cullMode;
    }

    public abstract int getCullMode();

    public abstract void updateGeometricState(float var1, boolean var2);

    public void lockBounds() {
        this.updateGeometricState(0.0f, true);
        this.lockedMode |= 1;
    }

    public void lockShadows() {
        this.lockedMode |= 8;
    }

    public void lockBranch() {
        this.lockedMode |= 0x10;
    }

    public void lockTransforms() {
        this.lockedMode |= 4;
    }

    public void lockMeshes(Renderer renderer) {
        this.updateRenderState();
        this.lockedMode |= 2;
    }

    public void lockMeshes() {
        this.lockMeshes(DisplaySystem.getDisplaySystem().getRenderer());
    }

    public void lock(Renderer renderer) {
        this.lockBounds();
        this.lockTransforms();
        this.lockMeshes(renderer);
        this.lockShadows();
    }

    public void lock() {
        this.lockBounds();
        this.lockTransforms();
        this.lockMeshes();
        this.lockShadows();
    }

    public void unlockBounds() {
        this.lockedMode &= 0xFFFFFFFE;
    }

    public void unlockShadows() {
        this.lockedMode &= 0xFFFFFFF7;
    }

    public void unlockBranch() {
        this.lockedMode &= 0xFFFFFFEF;
    }

    public void unlockTransforms() {
        this.lockedMode &= 0xFFFFFFFB;
    }

    public void unlockMeshes() {
        this.unlockMeshes(DisplaySystem.getDisplaySystem().getRenderer());
    }

    public void unlockMeshes(Renderer renderer) {
        this.lockedMode &= 0xFFFFFFFD;
    }

    public void unlock(Renderer renderer) {
        this.unlockBounds();
        this.unlockTransforms();
        this.unlockMeshes(renderer);
        this.unlockShadows();
        this.unlockBranch();
    }

    public void unlock() {
        this.unlockBounds();
        this.unlockTransforms();
        this.unlockMeshes();
        this.unlockShadows();
        this.unlockBranch();
    }

    public int getLocks() {
        return this.lockedMode;
    }

    public void setLocks(int n) {
        if ((this.lockedMode & 1) != 0) {
            this.lockBounds();
        }
        if ((this.lockedMode & 2) != 0) {
            this.lockMeshes();
        }
        if ((this.lockedMode & 8) != 0) {
            this.lockShadows();
        }
        if ((this.lockedMode & 4) != 0) {
            this.lockTransforms();
        }
    }

    public void setLocks(int n, Renderer renderer) {
        if ((this.lockedMode & 1) != 0) {
            this.lockBounds();
        }
        if ((this.lockedMode & 2) != 0) {
            this.lockMeshes(renderer);
        }
        if ((this.lockedMode & 8) != 0) {
            this.lockShadows();
        }
        if ((this.lockedMode & 4) != 0) {
            this.lockTransforms();
        }
    }

    public abstract void updateWorldBound();

    public void updateRenderState() {
        this.updateRenderState(null);
    }

    protected void updateRenderState(Stack[] stackArray) {
        int n;
        boolean bl;
        boolean bl2 = bl = stackArray == null;
        if (bl) {
            stackArray = new Stack[17];
            for (n = 0; n < stackArray.length; ++n) {
                stackArray[n] = new Stack();
            }
            this.propagateStatesFromRoot(stackArray);
        } else {
            for (n = 0; n < 17; ++n) {
                if (this.getRenderState(n) == null) continue;
                stackArray[n].push(this.getRenderState(n));
            }
        }
        this.applyRenderState(stackArray);
        if (!bl) {
            for (n = 0; n < 17; ++n) {
                if (this.getRenderState(n) == null) continue;
                stackArray[n].pop();
            }
        }
    }

    protected void applyRenderState(Stack[] stackArray) {
    }

    public void propagateStatesFromRoot(Stack[] stackArray) {
    }

    public void propagateBoundToRoot() {
    }

    public RenderState setRenderState(RenderState renderState) {
        if (renderState == null) {
            return null;
        }
        if (this.renderStateList == null) {
            this.renderStateList = new RenderState[17];
        }
        RenderState renderState2 = this.renderStateList[renderState.getType()];
        this.renderStateList[renderState.getType()] = renderState;
        return renderState2;
    }

    public RenderState getRenderState(int n) {
        return this.renderStateList != null ? this.renderStateList[n] : null;
    }

    public void clearRenderState(int n) {
        if (this.renderStateList != null) {
            this.renderStateList[n] = null;
        }
    }

    public void setRenderQueueMode(int n) {
        this.renderQueueMode = n;
    }

    public int getLocalRenderQueueMode() {
        return this.renderQueueMode;
    }

    public abstract int getRenderQueueMode();

    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public abstract int getNormalsMode();

    public int getLocalNormalsMode() {
        return this.normalsMode;
    }

    public void setNormalsMode(int n) {
        this.normalsMode = n;
    }

    public void setLightCombineMode(int n) {
        this.lightCombineMode = n;
    }

    public int getLocalLightCombineMode() {
        return this.lightCombineMode;
    }

    public abstract int getLightCombineMode();

    public void setTextureCombineMode(int n) {
        this.textureCombineMode = n;
    }

    public int getLocalTextureCombineMode() {
        return this.textureCombineMode;
    }

    public abstract int getTextureCombineMode();

    public int getLastFrustumIntersection() {
        return this.frustrumIntersects;
    }

    public void setLastFrustumIntersection(int n) {
        this.frustrumIntersects = n;
    }

    public String toString() {
        return this.name + " (" + this.getClass().getName() + ')';
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.name, "name", null);
        outputCapsule.write(this.isCollidable, "isCollidable", true);
        outputCapsule.write(this.cullMode, "cullMode", 0);
        outputCapsule.write(this.renderQueueMode, "renderQueueMode", 0);
        outputCapsule.write(this.zOrder, "zOrder", 0);
        outputCapsule.write(this.lightCombineMode, "lightCombineMode", 4);
        outputCapsule.write(this.textureCombineMode, "textureCombineMode", 4);
        outputCapsule.write(this.normalsMode, "normalsMode", 0);
        outputCapsule.write(this.renderStateList, "renderStateList", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.name = inputCapsule.readString("name", null);
        this.isCollidable = inputCapsule.readBoolean("isCollidable", true);
        this.cullMode = inputCapsule.readInt("cullMode", 0);
        this.renderQueueMode = inputCapsule.readInt("renderQueueMode", 0);
        this.zOrder = inputCapsule.readInt("zOrder", 0);
        this.lightCombineMode = inputCapsule.readInt("lightCombineMode", 4);
        this.textureCombineMode = inputCapsule.readInt("textureCombineMode", 4);
        this.normalsMode = inputCapsule.readInt("normalsMode", 0);
        Savable[] savableArray = inputCapsule.readSavableArray("renderStateList", null);
        if (savableArray == null) {
            this.renderStateList = null;
        } else {
            this.renderStateList = new RenderState[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.renderStateList[i] = (RenderState)savableArray[i];
            }
        }
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

