/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.BoundingVolume;
import com.jme.intersection.PickResults;
import com.jme.math.FastMath;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Spatial;
import com.jme.scene.VBOInfo;
import com.jme.scene.batch.GeomBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Stack;

public abstract class Geometry
extends Spatial
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    protected ArrayList<GeomBatch> batchList;

    public Geometry() {
        this.setupBatchList();
    }

    public Geometry(String string) {
        super(string);
        this.setupBatchList();
        this.reconstruct(null, null, null, null);
    }

    public Geometry(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        super(string);
        this.setupBatchList();
        this.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
    }

    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        GeomBatch geomBatch = new GeomBatch();
        geomBatch.setParentGeom(this);
        this.batchList.add(geomBatch);
    }

    public void setZOrder(int n) {
        super.setZOrder(n);
        int n2 = this.getBatchCount();
        while (--n2 >= 0) {
            this.getBatch(n2).setZOrder(n);
        }
    }

    public void addBatch(GeomBatch geomBatch) {
        geomBatch.setParentGeom(this);
        this.batchList.add(geomBatch);
    }

    public boolean removeBatch(GeomBatch geomBatch) {
        return this.batchList.remove(geomBatch);
    }

    public GeomBatch removeBatch(int n) {
        GeomBatch geomBatch = this.batchList.remove(n);
        geomBatch.setParentGeom(null);
        return geomBatch;
    }

    public GeomBatch getBatch(int n) {
        return this.batchList.get(n);
    }

    public void clearBatches() {
        this.batchList.clear();
    }

    public int getBatchCount() {
        return this.batchList.size();
    }

    public int getVertexCount() {
        int n = 0;
        for (int i = 0; i < this.getBatchCount(); ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            if (!geomBatch.isEnabled()) continue;
            n += geomBatch.getVertexCount();
        }
        return n;
    }

    public int getTriangleCount() {
        return 0;
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, 0);
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, int n) {
        if (floatBuffer == null) {
            this.getBatch(n).setVertexCount(0);
        } else {
            this.getBatch(n).setVertexCount(floatBuffer.limit() / 3);
        }
        this.getBatch(n).setVertexBuffer(floatBuffer);
        this.getBatch(n).setNormalBuffer(floatBuffer2);
        this.getBatch(n).setColorBuffer(floatBuffer3);
        if (this.getBatch(n).getTextureBuffers() == null) {
            this.getBatch(n).setTextureBuffers(new ArrayList<FloatBuffer>(1));
        }
        this.getBatch(n).clearTextureBuffers();
        this.getBatch(n).addTextureCoordinates(floatBuffer4);
        if (this.getBatch(n).getVBOInfo() != null) {
            this.getBatch(n).resizeTextureIds(1);
        }
    }

    public void setVBOInfo(VBOInfo vBOInfo) {
        this.setVBOInfo(0, vBOInfo);
    }

    public void setVBOInfo(int n, VBOInfo vBOInfo) {
        this.getBatch(n).setVBOInfo(vBOInfo);
    }

    public VBOInfo getVBOInfo(int n) {
        return this.getBatch(n).getVBOInfo();
    }

    public void setSolidColor(ColorRGBA colorRGBA) {
        for (int i = 0; i < this.getBatchCount(); ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            if (!geomBatch.isEnabled()) continue;
            geomBatch.setSolidColor(colorRGBA);
        }
    }

    public void setRandomColors() {
        for (int i = 0; i < this.getBatchCount(); ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            if (!geomBatch.isEnabled()) continue;
            geomBatch.setRandomColors();
        }
    }

    public FloatBuffer getVertexBuffer(int n) {
        return this.getBatch(n).getVertexBuffer();
    }

    public void setVertexBuffer(int n, FloatBuffer floatBuffer) {
        this.getBatch(n).setVertexBuffer(floatBuffer);
    }

    public FloatBuffer getNormalBuffer(int n) {
        return this.getBatch(n).getNormalBuffer();
    }

    public void setNormalBuffer(int n, FloatBuffer floatBuffer) {
        this.getBatch(n).setNormalBuffer(floatBuffer);
    }

    public FloatBuffer getColorBuffer(int n) {
        return this.getBatch(n).getColorBuffer();
    }

    public void setColorBuffer(int n, FloatBuffer floatBuffer) {
        this.getBatch(n).setColorBuffer(floatBuffer);
    }

    public void copyTextureCoords(int n, int n2, int n3) {
        this.copyTextureCoords(n, n2, n3, 1.0f);
    }

    public void copyTextureCoords(int n, int n2, int n3, float f) {
        this.getBatch(n).copyTextureCoordinates(n2, n3, f);
    }

    public FloatBuffer[] getTextureBuffers(int n) {
        return this.getBatch(n).getTextureBuffers().toArray(new FloatBuffer[this.getBatch(n).getTextureBuffers().size()]);
    }

    public FloatBuffer getTextureBuffer(int n, int n2) {
        return this.getBatch(n).getTextureBuffer(n2);
    }

    public void setTextureBuffer(int n, FloatBuffer floatBuffer) {
        this.setTextureBuffer(n, floatBuffer, 0);
    }

    public void setTextureBuffer(int n, FloatBuffer floatBuffer, int n2) {
        this.getBatch(n).setTextureBuffer(floatBuffer, n2);
    }

    public int getNumberOfUnits(int n) {
        if (this.getBatch(n).getTextureBuffers() == null) {
            return 0;
        }
        return this.getBatch(n).getTextureBuffers().size();
    }

    public int getType() {
        return 2;
    }

    public void clearBuffers() {
        this.reconstruct(null, null, null, null);
    }

    public void updateModelBound() {
        for (int i = 0; i < this.getBatchCount(); ++i) {
            GeomBatch geomBatch = this.batchList.get(i);
            if (geomBatch == null || !geomBatch.isEnabled()) continue;
            geomBatch.updateModelBound();
        }
        this.updateWorldBound();
    }

    public void setModelBound(BoundingVolume boundingVolume) {
        this.worldBound = null;
        if (this.batchList != null) {
            for (int i = 0; i < this.getBatchCount(); ++i) {
                GeomBatch geomBatch = this.batchList.get(i);
                if (geomBatch == null || !geomBatch.isEnabled()) continue;
                geomBatch.setModelBound(boundingVolume != null ? boundingVolume.clone(null) : null);
            }
        }
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        if (this.batchList != null) {
            for (int i = 0; i < this.getBatchCount(); ++i) {
                GeomBatch geomBatch = this.batchList.get(i);
                if (geomBatch == null || !geomBatch.isEnabled()) continue;
                geomBatch.updateGeometricState(f, false);
            }
        }
    }

    public void draw(Renderer renderer) {
    }

    public void updateWorldBound() {
        if ((this.lockedMode & 1) != 0) {
            return;
        }
        boolean bl = false;
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            if (geomBatch == null || !geomBatch.isEnabled()) continue;
            if (bl) {
                this.worldBound.mergeLocal(geomBatch.getWorldBound());
                continue;
            }
            if (geomBatch.getWorldBound() == null) continue;
            this.worldBound = geomBatch.getWorldBound().clone(this.worldBound);
            bl = true;
        }
    }

    protected void applyRenderState(Stack[] stackArray) {
        if (this.batchList != null) {
            int n = this.getBatchCount();
            for (int i = 0; i < n; ++i) {
                GeomBatch geomBatch = this.getBatch(i);
                if (geomBatch == null || !geomBatch.isEnabled()) continue;
                geomBatch.updateRenderState(stackArray);
            }
        }
    }

    public Vector3f randomVertex(Vector3f vector3f) {
        int n = (int)(FastMath.nextRandomFloat() * (float)this.getBatchCount());
        return this.getBatch(n).randomVertex(vector3f);
    }

    public void findPick(Ray ray, PickResults pickResults) {
        if (this.getWorldBound() != null && this.isCollidable && this.getWorldBound().intersects(ray)) {
            for (int i = 0; i < this.getBatchCount(); ++i) {
                GeomBatch geomBatch = this.getBatch(i);
                if (!geomBatch.isEnabled()) continue;
                geomBatch.findPick(ray, pickResults);
            }
        }
    }

    public void setDefaultColor(ColorRGBA colorRGBA) {
        for (int i = 0; i < this.getBatchCount(); ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            if (!geomBatch.isEnabled()) continue;
            geomBatch.setDefaultColor(colorRGBA);
        }
    }

    public FloatBuffer getWorldCoords(FloatBuffer floatBuffer) {
        return this.getWorldCoords(floatBuffer, 0);
    }

    public FloatBuffer getWorldCoords(FloatBuffer floatBuffer, int n) {
        return this.getBatch(n).getWorldCoords(floatBuffer);
    }

    public FloatBuffer getWorldNormals(FloatBuffer floatBuffer) {
        return this.getWorldNormals(floatBuffer, 0);
    }

    public FloatBuffer getWorldNormals(FloatBuffer floatBuffer, int n) {
        return this.getBatch(n).getWorldNormals(floatBuffer);
    }

    public void lockBounds() {
        super.lockBounds();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).lockBounds();
        }
    }

    public void lockShadows() {
        super.lockShadows();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).lockShadows();
        }
    }

    public void lockTransforms() {
        super.lockTransforms();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).lockTransforms();
        }
    }

    public void lockMeshes(Renderer renderer) {
        super.lockMeshes(renderer);
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).lockMeshes(renderer);
        }
    }

    public void unlockBounds() {
        super.unlockBounds();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).unlockBounds();
        }
    }

    public void unlockShadows() {
        super.unlockShadows();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).unlockShadows();
        }
    }

    public void unlockTransforms() {
        super.unlockTransforms();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).unlockTransforms();
        }
    }

    public void unlockMeshes(Renderer renderer) {
        super.unlockMeshes(renderer);
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).unlockMeshes(renderer);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            geomBatch.setParentGeom(this);
        }
    }

    public int getBatchIndex(GeomBatch geomBatch) {
        if (geomBatch == null) {
            return -1;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            GeomBatch geomBatch2 = this.getBatch(i);
            if (!geomBatch.equals(geomBatch2)) continue;
            return i;
        }
        return -1;
    }

    public void swapBatches(int n, int n2) {
        GeomBatch geomBatch = this.batchList.get(n2);
        GeomBatch geomBatch2 = this.batchList.remove(n);
        this.batchList.add(n, geomBatch);
        this.batchList.remove(n2);
        this.batchList.add(n2, geomBatch2);
        if (this.parent != null) {
            this.parent.batchChange(this, n, n2);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        this.batchList.trimToSize();
        outputCapsule.writeSavableArrayList(this.batchList, "batchList", new ArrayList(1));
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.batchList = inputCapsule.readSavableArrayList("batchList", new ArrayList(1));
        if (this.batchList != null) {
            this.batchList.trimToSize();
            int n = this.getBatchCount();
            for (int i = 0; i < n; ++i) {
                GeomBatch geomBatch = this.getBatch(i);
                geomBatch.setParentGeom(this);
            }
        }
    }

    public void setTangentBuffer(int n, FloatBuffer floatBuffer) {
        this.getBatch(n).setTangentBuffer(floatBuffer);
    }

    public FloatBuffer getTangentBuffer(int n) {
        return this.getBatch(n).getTangentBuffer();
    }

    public void setBinormalBuffer(int n, FloatBuffer floatBuffer) {
        this.getBatch(n).setBinormalBuffer(floatBuffer);
    }

    public FloatBuffer getBinormalBuffer(int n) {
        return this.getBatch(n).getBinormalBuffer();
    }
}

