/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.pass;

import com.jme.renderer.Renderer;
import com.jme.renderer.pass.Pass;
import java.util.ArrayList;

public class BasicPassManager {
    protected ArrayList<Pass> passes = new ArrayList();

    public void add(Pass pass) {
        this.passes.add(pass);
    }

    public void insert(Pass pass, int n) {
        this.passes.add(n, pass);
    }

    public boolean contains(Pass pass) {
        return this.passes.contains(pass);
    }

    public boolean remove(Pass pass) {
        return this.passes.remove(pass);
    }

    public Pass get(int n) {
        return this.passes.get(n);
    }

    public int passes() {
        return this.passes.size();
    }

    public void clearAll() {
        this.cleanUp();
        this.passes.clear();
    }

    public void cleanUp() {
        int n = this.passes.size();
        for (int i = 0; i < n; ++i) {
            Pass pass = this.passes.get(i);
            pass.cleanUp();
        }
    }

    public void renderPasses(Renderer renderer) {
        int n = this.passes.size();
        for (int i = 0; i < n; ++i) {
            Pass pass = this.passes.get(i);
            pass.renderPass(renderer);
        }
    }

    public void updatePasses(float f) {
        int n = this.passes.size();
        for (int i = 0; i < n; ++i) {
            Pass pass = this.passes.get(i);
            pass.updatePass(f);
        }
    }
}

