/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.lwjgl;

import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderContext;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.lwjgl.LWJGLCamera;
import com.jme.renderer.lwjgl.LWJGLRenderer;
import com.jme.scene.Spatial;
import com.jme.scene.state.lwjgl.LWJGLTextureState;
import com.jme.scene.state.lwjgl.records.TextureRecord;
import com.jme.scene.state.lwjgl.records.TextureStateRecord;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWJGLTextureRenderer
implements TextureRenderer {
    private static final Logger logger = Logger.getLogger(LWJGLTextureRenderer.class.getName());
    private LWJGLCamera camera;
    private ColorRGBA backgroundColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private int active;
    private int fboID;
    private int depthRBID;
    private int width;
    private int height;
    private boolean isSupported = true;
    private LWJGLRenderer parentRenderer;
    private Camera oldCamera;
    private int oldWidth;
    private int oldHeight;

    public LWJGLTextureRenderer(int n, int n2, LWJGLRenderer lWJGLRenderer) {
        this.isSupported = GLContext.getCapabilities().GL_EXT_framebuffer_object;
        if (!this.isSupported) {
            logger.warning("FBO not supported.");
            return;
        }
        logger.info("FBO support detected.");
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            int n3;
            if (!FastMath.isPowerOfTwo(n)) {
                n3 = 2;
                while ((n3 <<= 1) < n) {
                }
                n = n3;
            }
            if (!FastMath.isPowerOfTwo(n2)) {
                n3 = 2;
                while ((n3 <<= 1) < n2) {
                }
                n2 = n3;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)intBuffer);
        this.fboID = intBuffer.get(0);
        if (this.fboID <= 0) {
            logger.severe("Invalid FBO id returned! " + this.fboID);
            this.isSupported = false;
            return;
        }
        EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)intBuffer);
        this.depthRBID = intBuffer.get(0);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthRBID);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)n, (int)n2);
        this.width = n;
        this.height = n2;
        this.parentRenderer = lWJGLRenderer;
        this.initCamera();
    }

    @Override
    public boolean isSupported() {
        return this.isSupported;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = (LWJGLCamera)camera;
    }

    @Override
    public void setBackgroundColor(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            this.backgroundColor.a = 1.0f;
            this.backgroundColor.b = 1.0f;
            this.backgroundColor.g = 1.0f;
            this.backgroundColor.r = 1.0f;
        } else {
            this.backgroundColor = colorRGBA;
        }
    }

    @Override
    public ColorRGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setupTexture(Texture texture) {
        if (!this.isSupported) {
            return;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        if (texture.getTextureId() != 0) {
            intBuffer.put(texture.getTextureId());
            GL11.glDeleteTextures((IntBuffer)intBuffer);
            intBuffer.clear();
        }
        GL11.glGenTextures((IntBuffer)intBuffer);
        texture.setTextureId(intBuffer.get(0));
        TextureManager.registerForCleanup(texture.getTextureKey(), texture.getTextureId());
        LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
        int n = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n = 6407;
                break;
            }
            case 5: {
                n = 6406;
                break;
            }
            case 2: {
                n = 6402;
                break;
            }
            case 6: {
                n = 32841;
                break;
            }
            case 3: {
                n = 6409;
                break;
            }
            case 4: {
                n = 6410;
            }
        }
        int n2 = 32856;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n2 = 32849;
                break;
            }
            case 5: {
                n2 = 32828;
                break;
            }
            case 2: {
                n2 = 6402;
                break;
            }
            case 6: {
                n2 = 32843;
                break;
            }
            case 3: {
                n2 = 32832;
                break;
            }
            case 4: {
                n2 = 6410;
            }
        }
        GL11.glTexImage2D((int)3553, (int)0, (int)n2, (int)this.width, (int)this.height, (int)0, (int)n, (int)5121, (ByteBuffer)null);
        if (texture.getMipmap() != 0 && texture.getMipmap() != 2 && texture.getMipmap() != 1) {
            EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
        }
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        TextureRecord textureRecord = textureStateRecord.getTextureRecord(texture.getTextureId());
        LWJGLTextureState.applyFilter(texture, textureRecord, 0, textureStateRecord);
        LWJGLTextureState.applyWrap(texture, textureRecord, 0, textureStateRecord);
        logger.info("setup tex with id " + texture.getTextureId() + ": " + this.width + "," + this.height);
    }

    @Override
    public void render(Spatial spatial, Texture texture) {
        this.render(spatial, texture, true);
    }

    @Override
    public void render(Spatial spatial, Texture texture, boolean bl) {
        if (!this.isSupported) {
            return;
        }
        try {
            this.activate();
            LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
            if (texture.getRTTSource() == 2) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)texture.getTextureId(), (int)0);
                GL11.glDrawBuffer((int)0);
            } else {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.depthRBID);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)texture.getTextureId(), (int)0);
            }
            this.checkFBOComplete();
            this.switchCameraIn(bl);
            if (spatial.getParent() != null) {
                spatial.getParent().setLastFrustumIntersection(1);
            }
            this.doDraw(spatial);
            this.switchCameraOut();
            this.deactivate();
            if (texture.getMipmap() != 0 && texture.getMipmap() != 2 && texture.getMipmap() != 1) {
                LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture, boolean)", "Exception", exception);
        }
    }

    @Override
    public void render(ArrayList<? extends Spatial> arrayList, ArrayList<Texture> arrayList2) {
        this.render(arrayList, arrayList2, true);
    }

    @Override
    public void render(ArrayList<? extends Spatial> arrayList, ArrayList<Texture> arrayList2, boolean bl) {
        if (!this.isSupported) {
            return;
        }
        try {
            int n;
            this.activate();
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)0);
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 0;
            for (n = 0; n < arrayList2.size(); ++n) {
                Texture texture = arrayList2.get(n);
                if (texture.getRTTSource() == 2) {
                    if (bl2) continue;
                    EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)texture.getTextureId(), (int)0);
                    bl2 = true;
                    continue;
                }
                bl3 = true;
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + n2), (int)3553, (int)texture.getTextureId(), (int)0);
                ++n2;
            }
            if (!bl2) {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.depthRBID);
            }
            if (!bl3) {
                GL11.glDrawBuffer((int)0);
                GL11.glReadBuffer((int)0);
            }
            this.checkFBOComplete();
            this.switchCameraIn(bl);
            int n3 = arrayList.size();
            for (n = 0; n < n3; ++n) {
                Spatial spatial = arrayList.get(n);
                if (spatial.getParent() != null) {
                    spatial.getParent().setLastFrustumIntersection(1);
                }
                this.doDraw(spatial);
            }
            this.switchCameraOut();
            this.deactivate();
            n3 = arrayList2.size();
            for (n = 0; n < n3; ++n) {
                if (arrayList2.get(n).getMipmap() == 0 || arrayList2.get(n).getMipmap() == 2 || arrayList2.get(n).getMipmap() == 1) continue;
                LWJGLTextureState.doTextureBind(arrayList2.get(n).getTextureId(), 0);
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture)", "Exception", exception);
        }
    }

    private void checkFBOComplete() {
        int n = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        switch (n) {
            case 36053: {
                break;
            }
            case 36054: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
            }
            case 36055: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
            }
            case 36057: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
            }
            case 36059: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
            }
            case 36058: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
            }
            case 36060: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
            }
            case 36061: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_UNSUPPORTED_EXT exception");
            }
            default: {
                throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + n);
            }
        }
    }

    @Override
    public void copyToTexture(Texture texture, int n, int n2) {
        LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
        int n3 = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n3 = 6407;
                break;
            }
            case 5: {
                n3 = 6406;
                break;
            }
            case 2: {
                n3 = 6402;
                break;
            }
            case 6: {
                n3 = 32841;
                break;
            }
            case 3: {
                n3 = 6409;
                break;
            }
            case 4: {
                n3 = 6410;
            }
        }
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)n3, (int)0, (int)0, (int)n, (int)n2, (int)0);
    }

    public void switchCameraIn(boolean bl) {
        this.oldCamera = this.parentRenderer.getCamera();
        this.oldWidth = this.parentRenderer.getWidth();
        this.oldHeight = this.parentRenderer.getHeight();
        this.parentRenderer.setCamera(this.getCamera());
        this.parentRenderer.getQueue().swapBuckets();
        this.parentRenderer.reinit(this.width, this.height);
        if (bl) {
            this.parentRenderer.clearBuffers();
        }
        this.getCamera().update();
        this.getCamera().apply();
    }

    public void switchCameraOut() {
        this.parentRenderer.setCamera(this.oldCamera);
        this.parentRenderer.reinit(this.oldWidth, this.oldHeight);
        this.parentRenderer.getQueue().swapBuckets();
        this.oldCamera.update();
        this.oldCamera.apply();
    }

    private void doDraw(Spatial spatial) {
        spatial.onDraw(this.parentRenderer);
        this.parentRenderer.renderQueue();
    }

    public void activate() {
        if (!this.isSupported) {
            return;
        }
        if (this.active == 0) {
            GL11.glClearColor((float)this.backgroundColor.r, (float)this.backgroundColor.g, (float)this.backgroundColor.b, (float)this.backgroundColor.a);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.fboID);
        }
        ++this.active;
    }

    public void deactivate() {
        if (!this.isSupported) {
            return;
        }
        if (this.active == 1) {
            GL11.glClearColor((float)this.parentRenderer.getBackgroundColor().r, (float)this.parentRenderer.getBackgroundColor().g, (float)this.parentRenderer.getBackgroundColor().b, (float)this.parentRenderer.getBackgroundColor().a);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
        --this.active;
    }

    private void initCamera() {
        if (!this.isSupported) {
            return;
        }
        logger.info("Init RTT camera");
        this.camera = new LWJGLCamera(this.width, this.height, this, true);
        this.camera.setFrustum(1.0f, 1000.0f, -0.5f, 0.5f, 0.5f, -0.5f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.camera.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.camera.setDataOnly(false);
    }

    @Override
    public void cleanup() {
        if (!this.isSupported) {
            return;
        }
        if (this.fboID > 0) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
            intBuffer.put(this.fboID);
            EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)intBuffer);
        }
    }

    public LWJGLRenderer getParentRenderer() {
        return this.parentRenderer;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setMultipleTargets(boolean bl) {
    }
}

