/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Vector3f;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public class Triangle
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private Vector3f pointa;
    private Vector3f pointb;
    private Vector3f pointc;
    private Vector3f center;
    private Vector3f normal;
    private float projection;
    private int index;

    public Triangle() {
    }

    public Triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.pointa = new Vector3f(vector3f);
        this.pointb = new Vector3f(vector3f2);
        this.pointc = new Vector3f(vector3f3);
    }

    public Vector3f get(int n) {
        switch (n) {
            case 0: {
                return this.pointa;
            }
            case 1: {
                return this.pointb;
            }
            case 2: {
                return this.pointc;
            }
        }
        return null;
    }

    public void set(int n, Vector3f vector3f) {
        switch (n) {
            case 0: {
                this.pointa.set(vector3f);
                break;
            }
            case 1: {
                this.pointb.set(vector3f);
                break;
            }
            case 2: {
                this.pointc.set(vector3f);
            }
        }
    }

    public void calculateCenter() {
        if (this.center == null) {
            this.center = new Vector3f(this.pointa);
        } else {
            this.center.set(this.pointa);
        }
        this.center.addLocal(this.pointb).addLocal(this.pointc).multLocal(0.33333334f);
    }

    public void calculateNormal() {
        if (this.normal == null) {
            this.normal = new Vector3f(this.pointb);
        } else {
            this.normal.set(this.pointb);
        }
        this.normal.subtractLocal(this.pointa).crossLocal(this.pointc.x - this.pointa.x, this.pointc.y - this.pointa.y, this.pointc.z - this.pointa.z);
        this.normal.normalizeLocal();
    }

    public Vector3f getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    public void setCenter(Vector3f vector3f) {
        this.center = vector3f;
    }

    public Vector3f getNormal() {
        if (this.normal == null) {
            this.calculateNormal();
        }
        return this.normal;
    }

    public void setNormal(Vector3f vector3f) {
        this.normal = vector3f;
    }

    public float getProjection() {
        return this.projection;
    }

    public void setProjection(float f) {
        this.projection = f;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        jMEExporter.getCapsule(this).write(this.pointa, "pointa", Vector3f.ZERO);
        jMEExporter.getCapsule(this).write(this.pointb, "pointb", Vector3f.ZERO);
        jMEExporter.getCapsule(this).write(this.pointc, "pointc", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        this.pointa = (Vector3f)jMEImporter.getCapsule(this).readSavable("pointa", Vector3f.ZERO.clone());
        this.pointb = (Vector3f)jMEImporter.getCapsule(this).readSavable("pointb", Vector3f.ZERO.clone());
        this.pointc = (Vector3f)jMEImporter.getCapsule(this).readSavable("pointc", Vector3f.ZERO.clone());
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

