/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.intersection.PickData;
import com.jme.math.Ray;
import com.jme.scene.batch.GeomBatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public abstract class PickResults {
    private ArrayList<PickData> nodeList = new ArrayList();
    private boolean checkDistance;
    private DistanceComparator distanceCompare;
    private boolean modified = false;

    public void addPickData(PickData pickData) {
        this.nodeList.add(pickData);
        this.modified = true;
    }

    public int getNumber() {
        return this.nodeList.size();
    }

    public PickData getPickData(int n) {
        if (this.modified) {
            if (this.checkDistance) {
                Collections.sort(this.nodeList, this.distanceCompare);
            }
            this.modified = false;
        }
        return this.nodeList.get(n);
    }

    public void clear() {
        this.nodeList.clear();
    }

    public abstract void addPick(Ray var1, GeomBatch var2);

    public abstract void processPick();

    public boolean willCheckDistance() {
        return this.checkDistance;
    }

    public void setCheckDistance(boolean bl) {
        this.checkDistance = bl;
        if (bl) {
            this.distanceCompare = new DistanceComparator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistanceComparator
    implements Comparator<PickData> {
        private DistanceComparator() {
        }

        @Override
        public int compare(PickData pickData, PickData pickData2) {
            if (pickData.getDistance() <= pickData2.getDistance()) {
                return -1;
            }
            return 1;
        }
    }
}

