/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.lwjgl;

import com.jme.input.KeyInput;
import com.jme.input.KeyInputListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;

public class LWJGLKeyInput
extends KeyInput {
    private static final Logger logger = Logger.getLogger(LWJGLKeyInput.class.getName());

    protected LWJGLKeyInput() {
        try {
            Keyboard.create();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Could not create keyboard.", exception);
        }
    }

    public boolean isKeyDown(int n) {
        return Keyboard.isKeyDown((int)n);
    }

    public String getKeyName(int n) {
        return Keyboard.getKeyName((int)n);
    }

    public int getKeyIndex(String string) {
        return Keyboard.getKeyIndex((String)string);
    }

    public void update() {
        if (Display.isActive() && this.listeners != null && this.listeners.size() > 0) {
            while (Keyboard.next()) {
                char c = Keyboard.getEventCharacter();
                int n = Keyboard.getEventKey();
                boolean bl = Keyboard.getEventKeyState();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    KeyInputListener keyInputListener = (KeyInputListener)this.listeners.get(i);
                    keyInputListener.onKey(c, n, bl);
                }
            }
        } else {
            while (Keyboard.next()) {
            }
        }
    }

    public void destroy() {
        Keyboard.destroy();
    }
}

