/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.binding;

import com.jme.input.MouseInput;
import com.jme.input.controls.Binding;

public class MouseAxisBinding
implements Binding {
    private static final long serialVersionUID = 1L;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_W = 3;
    private int axis;
    private boolean reverse;

    public MouseAxisBinding(int n, boolean bl) {
        this.axis = n;
        this.reverse = bl;
    }

    public String getName() {
        if (this.reverse) {
            return "Mouse" + MouseAxisBinding.getAxisString(this.axis) + "(-)";
        }
        return "Mouse" + MouseAxisBinding.getAxisString(this.axis) + "(+)";
    }

    public float getValue() {
        float f = this.axis == 1 ? this.convert(MouseInput.get().getXDelta()) : (this.axis == 2 ? this.convert(MouseInput.get().getYDelta()) : this.convert(MouseInput.get().getWheelDelta()));
        return f;
    }

    private float convert(int n) {
        if (n < 0 && !this.reverse) {
            return 0.0f;
        }
        if (n > 0 && this.reverse) {
            return 0.0f;
        }
        return Math.abs((float)n * 0.1f);
    }

    public String toString() {
        return this.getName();
    }

    private static final String getAxisString(int n) {
        if (1 == n) {
            return "X";
        }
        if (2 == n) {
            return "Y";
        }
        if (3 == n) {
            return "W";
        }
        return "Unknown";
    }
}

