/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.binding;

import com.jme.input.controls.Binding;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;

public class JoystickButtonBinding
implements Binding {
    private static final long serialVersionUID = 1L;
    private transient Joystick joystick;
    private String name;
    private int button;

    public JoystickButtonBinding(Joystick joystick, int n) {
        this.name = joystick.getName();
        this.joystick = joystick;
        this.button = n;
    }

    public String getName() {
        return "JS:B" + this.button;
    }

    public float getValue() {
        if (this.joystick == null) {
            this.loadJoystick();
        }
        return this.joystick.isButtonPressed(this.button) ? 1.0f : 0.0f;
    }

    private void loadJoystick() {
        for (int i = 0; i < JoystickInput.get().getJoystickCount(); ++i) {
            if (!JoystickInput.get().getJoystick(i).getName().equals(this.name)) continue;
            this.joystick = JoystickInput.get().getJoystick(i);
        }
    }

    public String toString() {
        return this.joystick.getName() + ":Button" + this.button;
    }
}

