/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.binding;

import com.jme.input.controls.Binding;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;

public class JoystickAxisBinding
implements Binding {
    private static final long serialVersionUID = 1L;
    private transient Joystick joystick;
    private String name;
    private int axis;
    private boolean reverse;

    public JoystickAxisBinding(Joystick joystick, int n, boolean bl) {
        this.name = joystick.getName();
        this.joystick = joystick;
        this.axis = n;
        this.reverse = bl;
    }

    public String getName() {
        return "JS:X" + this.axis + (this.reverse ? "(-)" : "(+)");
    }

    public float getValue() {
        float f;
        if (this.joystick == null) {
            this.loadJoystick();
        }
        if ((f = this.joystick.getAxisValue(this.axis)) < 0.0f && !this.reverse) {
            return 0.0f;
        }
        if (f > 0.0f && this.reverse) {
            return 0.0f;
        }
        return Math.abs(f);
    }

    private void loadJoystick() {
        for (int i = 0; i < JoystickInput.get().getJoystickCount(); ++i) {
            if (!JoystickInput.get().getJoystick(i).getName().equals(this.name)) continue;
            this.joystick = JoystickInput.get().getJoystick(i);
        }
    }

    public String toString() {
        return this.joystick.getName() + ":Axis" + this.axis + (this.reverse ? "(-)" : "(+)");
    }
}

