/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.action;

import com.jme.input.Mouse;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.KeyNodeLookDownAction;
import com.jme.input.action.KeyNodeLookUpAction;
import com.jme.input.action.KeyNodeRotateLeftAction;
import com.jme.input.action.KeyNodeRotateRightAction;
import com.jme.input.action.MouseInputAction;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;

public class NodeMouseLook
extends MouseInputAction {
    private KeyNodeLookDownAction lookDown;
    private KeyNodeLookUpAction lookUp;
    private KeyNodeRotateLeftAction rotateLeft;
    private KeyNodeRotateRightAction rotateRight;
    private Vector3f lockAxis;
    private Spatial node;
    private static InputActionEvent event;

    public NodeMouseLook(Mouse mouse, Spatial spatial, float f) {
        this.mouse = mouse;
        this.speed = f;
        this.node = spatial;
        this.lookDown = new KeyNodeLookDownAction(this.node, f);
        this.lookUp = new KeyNodeLookUpAction(this.node, f);
        this.rotateLeft = new KeyNodeRotateLeftAction(this.node, f);
        this.rotateRight = new KeyNodeRotateRightAction(this.node, f);
        event = new InputActionEvent();
    }

    public void setLockAxis(Vector3f vector3f) {
        this.lockAxis = vector3f;
        this.rotateLeft.setLockAxis(vector3f);
        this.rotateRight.setLockAxis(vector3f);
    }

    public Vector3f getLockAxis() {
        return this.lockAxis;
    }

    public void setSpeed(float f) {
        super.setSpeed(f);
        this.lookDown.setSpeed(f);
        this.lookUp.setSpeed(f);
        this.rotateRight.setSpeed(f);
        this.rotateLeft.setSpeed(f);
    }

    public void performAction(InputActionEvent inputActionEvent) {
        float f = 0.01f * this.speed;
        if (this.mouse.getLocalTranslation().x > 0.0f) {
            event.setTime(f * this.mouse.getLocalTranslation().x);
            this.rotateRight.performAction(event);
        } else if (this.mouse.getLocalTranslation().x < 0.0f) {
            event.setTime(f * this.mouse.getLocalTranslation().x * -1.0f);
            this.rotateLeft.performAction(event);
        }
        if (this.mouse.getLocalTranslation().y > 0.0f) {
            event.setTime(f * this.mouse.getLocalTranslation().y);
            this.lookUp.performAction(event);
        } else if (this.mouse.getLocalTranslation().y < 0.0f) {
            event.setTime(f * this.mouse.getLocalTranslation().y * -1.0f);
            this.lookDown.performAction(event);
        }
    }
}

