/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.BaseHeadlessApp;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.state.LightState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SimpleHeadlessApp
extends BaseHeadlessApp {
    private static final Logger logger = Logger.getLogger(SimpleHeadlessApp.class.getName());
    protected Camera cam;
    protected Node rootNode;
    protected InputHandler input;
    protected Timer timer;
    protected float tpf;
    protected LightState lightState;
    long startTime = 0L;
    long fps = 0L;

    protected final void update(float f) {
        this.timer.update();
        this.tpf = this.timer.getTimePerFrame();
        this.simpleUpdate();
        this.rootNode.updateGeometricState(this.tpf, true);
    }

    protected final void render(float f) {
        this.display.getRenderer().clearStatistics();
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw(this.rootNode);
        this.simpleRender();
        if (this.startTime > System.currentTimeMillis()) {
            ++this.fps;
        } else {
            long l = 5000L + (this.startTime - System.currentTimeMillis());
            this.startTime = System.currentTimeMillis() + 5000L;
            logger.info(this.fps + " frames in " + (float)l / 1000.0f + " seconds = " + (float)this.fps / ((float)l / 1000.0f));
            this.fps = 0L;
        }
    }

    protected final void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem(this.properties.getRenderer());
            this.display.createHeadlessWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth());
            this.cam = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
        }
        catch (JmeException jmeException) {
            logger.log(Level.SEVERE, "Could not create displaySystem", jmeException);
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black.clone());
        if (this.cam != null) {
            this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
            Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
            Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
            Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
            this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
            this.cam.update();
            this.display.getRenderer().setCamera(this.cam);
        }
        this.timer = Timer.getTimer();
        this.display.setTitle("SimpleHeadlessApp");
        this.display.getRenderer().enableStatistics(true);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected final void initGame() {
        this.rootNode = new Node("rootNode");
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.rootNode.setRenderState(zBufferState);
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(100.0f, 100.0f, 100.0f));
        pointLight.setEnabled(true);
        this.lightState = this.display.getRenderer().createLightState();
        this.lightState.setEnabled(true);
        this.lightState.attach(pointLight);
        this.rootNode.setRenderState(this.lightState);
        this.simpleInitGame();
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
        this.startTime = System.currentTimeMillis() + 5000L;
    }

    protected abstract void simpleInitGame();

    protected void simpleUpdate() {
    }

    protected void simpleRender() {
    }

    protected void reinit() {
    }

    protected void cleanup() {
        logger.info("Cleaning up resources.");
        KeyInput.destroyIfInitalized();
        MouseInput.destroyIfInitalized();
        JoystickInput.destroyIfInitalized();
    }
}

