/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.BaseGame;
import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Text;
import com.jme.scene.state.LightState;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jme.util.geom.Debugger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseSimpleGame
extends BaseGame {
    private static final Logger logger = Logger.getLogger(BaseSimpleGame.class.getName());
    protected Camera cam;
    protected Node rootNode;
    protected InputHandler input;
    protected Timer timer;
    protected Node fpsNode;
    protected Text fps;
    protected int alphaBits = 0;
    protected int depthBits = 8;
    protected int stencilBits = 0;
    protected int samples = 0;
    protected float tpf;
    protected boolean showDepth = false;
    protected boolean showBounds = false;
    protected boolean showNormals = false;
    protected WireframeState wireState;
    protected LightState lightState;
    public static String fontLocation = "com/jme/app/defaultfont.tga";
    protected StringBuffer updateBuffer = new StringBuffer(30);
    protected StringBuffer tempBuffer = new StringBuffer();
    protected boolean pause;

    protected void update(float f) {
        this.timer.update();
        this.tpf = this.timer.getTimePerFrame();
        this.updateInput();
        GameTaskQueueManager.getManager().getQueue("update").execute();
        this.updateBuffer.setLength(0);
        this.updateBuffer.append("FPS: ").append((int)this.timer.getFrameRate()).append(" - ");
        this.updateBuffer.append(this.display.getRenderer().getStatistics(this.tempBuffer));
        this.fps.print(this.updateBuffer);
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_pause", false)) {
            boolean bl = this.pause = !this.pause;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("step", true)) {
            this.simpleUpdate();
            this.rootNode.updateGeometricState(this.tpf, true);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_wire", false)) {
            this.wireState.setEnabled(!this.wireState.isEnabled());
            this.rootNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_lights", false)) {
            this.lightState.setEnabled(!this.lightState.isEnabled());
            this.rootNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_bounds", false)) {
            boolean bl = this.showBounds = !this.showBounds;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_depth", false)) {
            boolean bl = this.showDepth = !this.showDepth;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_normals", false)) {
            boolean bl = this.showNormals = !this.showNormals;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("camera_out", false)) {
            logger.info("Camera at: " + this.display.getRenderer().getCamera().getLocation());
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("screen_shot", false)) {
            this.display.getRenderer().takeScreenShot("SimpleGameScreenShot");
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("parallel_projection", false)) {
            if (this.cam.isParallelProjection()) {
                this.cameraPerspective();
            } else {
                this.cameraParallel();
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("mem_report", false)) {
            long l = Runtime.getRuntime().totalMemory();
            long l2 = Runtime.getRuntime().freeMemory();
            long l3 = Runtime.getRuntime().maxMemory();
            logger.info("|*|*|  Memory Stats  |*|*|");
            logger.info("Total memory: " + (l >> 10) + " kb");
            logger.info("Free memory: " + (l2 >> 10) + " kb");
            logger.info("Max memory: " + (l3 >> 10) + " kb");
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit", false)) {
            this.finish();
        }
    }

    protected void updateInput() {
        this.input.update(this.tpf);
    }

    protected void render(float f) {
        Renderer renderer = this.display.getRenderer();
        renderer.clearStatistics();
        renderer.clearBuffers();
        GameTaskQueueManager.getManager().getQueue("render").execute();
    }

    protected void doDebug(Renderer renderer) {
        if (this.showBounds) {
            Debugger.drawBounds(this.rootNode, renderer, true);
        }
        if (this.showNormals) {
            Debugger.drawNormals(this.rootNode, renderer);
            Debugger.drawTangents(this.rootNode, renderer);
        }
    }

    protected void initSystem() throws JmeException {
        logger.info(this.getVersion());
        try {
            this.display = DisplaySystem.getDisplaySystem(this.properties.getRenderer());
            this.display.setMinDepthBits(this.depthBits);
            this.display.setMinStencilBits(this.stencilBits);
            this.display.setMinAlphaBits(this.alphaBits);
            this.display.setMinSamples(this.samples);
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            logger.info("Running on: " + this.display.getAdapter() + "\nDriver version: " + this.display.getDriverVersion() + "\n" + this.display.getDisplayVendor() + " - " + this.display.getDisplayRenderer() + " - " + this.display.getDisplayAPIVersion());
            this.cam = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
        }
        catch (JmeException jmeException) {
            logger.log(Level.SEVERE, "Could not create displaySystem", jmeException);
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black.clone());
        this.cameraPerspective();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.display.getRenderer().setCamera(this.cam);
        FirstPersonHandler firstPersonHandler = new FirstPersonHandler(this.cam, 50.0f, 1.0f);
        this.input = firstPersonHandler;
        this.timer = Timer.getTimer();
        String string = this.getClass().getName();
        if (string.lastIndexOf(46) > 0) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        this.display.setTitle(string);
        this.display.getRenderer().enableStatistics(true);
        KeyBindingManager.getKeyBindingManager().set("toggle_pause", 25);
        KeyBindingManager.getKeyBindingManager().set("step", 78);
        KeyBindingManager.getKeyBindingManager().set("toggle_wire", 20);
        KeyBindingManager.getKeyBindingManager().set("toggle_lights", 38);
        KeyBindingManager.getKeyBindingManager().set("toggle_bounds", 48);
        KeyBindingManager.getKeyBindingManager().set("toggle_normals", 49);
        KeyBindingManager.getKeyBindingManager().set("camera_out", 46);
        KeyBindingManager.getKeyBindingManager().set("screen_shot", 59);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
        KeyBindingManager.getKeyBindingManager().set("parallel_projection", 60);
        KeyBindingManager.getKeyBindingManager().set("toggle_depth", 61);
        KeyBindingManager.getKeyBindingManager().set("mem_report", 19);
    }

    protected void cameraPerspective() {
        this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        this.cam.setParallelProjection(false);
        this.cam.update();
    }

    protected void cameraParallel() {
        this.cam.setParallelProjection(true);
        float f = (float)this.display.getWidth() / (float)this.display.getHeight();
        this.cam.setFrustum(-100.0f, 1000.0f, -50.0f * f, 50.0f * f, -50.0f, 50.0f);
        this.cam.update();
    }

    protected void initGame() {
        this.rootNode = new Node("rootNode");
        this.wireState = this.display.getRenderer().createWireframeState();
        this.wireState.setEnabled(false);
        this.rootNode.setRenderState(this.wireState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.rootNode.setRenderState(zBufferState);
        this.fps = Text.createDefaultTextLabel("FPS label");
        this.fps.setCullMode(3);
        this.fps.setTextureCombineMode(5);
        this.fpsNode = new Node("FPS node");
        this.fpsNode.setRenderState(this.fps.getRenderState(0));
        this.fpsNode.setRenderState(this.fps.getRenderState(6));
        this.fpsNode.attachChild(this.fps);
        this.fpsNode.setCullMode(3);
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(0.75f, 0.75f, 0.75f, 0.75f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(100.0f, 100.0f, 100.0f));
        pointLight.setEnabled(true);
        this.lightState = this.display.getRenderer().createLightState();
        this.lightState.setEnabled(true);
        this.lightState.attach(pointLight);
        this.rootNode.setRenderState(this.lightState);
        this.simpleInitGame();
        this.timer.reset();
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
        this.fpsNode.updateGeometricState(0.0f, true);
        this.fpsNode.updateRenderState();
        this.timer.reset();
    }

    protected abstract void simpleInitGame();

    protected void simpleUpdate() {
    }

    protected void simpleRender() {
    }

    protected void reinit() {
    }

    protected void cleanup() {
        logger.info("Cleaning up resources.");
        TextureManager.doTextureCleanup();
        if (this.display != null && this.display.getRenderer() != null) {
            this.display.getRenderer().cleanup();
        }
        KeyInput.destroyIfInitalized();
        MouseInput.destroyIfInitalized();
        JoystickInput.destroyIfInitalized();
    }

    protected void quit() {
        super.quit();
        System.exit(0);
    }
}

