/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import com.jme.animation.SpatialTransformer;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.scene.lod.ClodMesh;
import com.jme.scene.lod.CollapseRecord;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.JointMesh;
import com.jmex.model.XMLparser.LoaderNode;
import com.jmex.model.XMLparser.XMLSharedNode;
import com.jmex.model.XMLparser.XMLloadable;
import com.jmex.model.animation.JointController;
import com.jmex.model.animation.KeyframeController;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.TerrainPage;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmeBinaryReader {
    private Stack<Object> objStack = new Stack();
    private Hashtable<String, Object> shares = new Hashtable();
    private HashMap<String, Object> attributes = new HashMap();
    private HashMap<String, Object> properties = new HashMap();
    private Hashtable<Object, Object> repeatShare = new Hashtable();
    private Node myScene;
    private Renderer renderer = DisplaySystem.getDisplaySystem().getRenderer();
    private DataInputStream myIn;
    private static final boolean DEBUG = false;

    public Node loadBinaryFormat(Node storeNode, InputStream binaryJme) throws IOException {
        this.clearValues();
        this.myScene = storeNode;
        this.myIn = new DataInputStream(binaryJme);
        this.readHeader();
        this.objStack.push(storeNode);
        byte flag = this.myIn.readByte();
        while (flag != 2) {
            if (flag == 0) {
                this.readBegining();
            } else if (flag == 1) {
                this.readEnd();
            } else {
                throw new IOException("Unknown flag:" + flag);
            }
            flag = this.myIn.readByte();
        }
        this.clearValues();
        return this.myScene;
    }

    private void clearValues() {
        this.repeatShare.clear();
        this.objStack.clear();
        this.shares.clear();
        this.attributes.clear();
        this.myIn = null;
    }

    public Node loadBinaryFormat(InputStream binaryJme) throws IOException {
        return this.loadBinaryFormat(new Node("XML loaded scene"), binaryJme);
    }

    private void readBegining() throws IOException {
        String tagName = this.myIn.readUTF().trim();
        this.readInObjects(this.attributes);
        if (!tagName.equals("scene")) {
            JointMesh jm;
            Object o;
            Texture t;
            if (tagName.equals("node")) {
                this.objStack.push(this.processSpatial((Spatial)new Node((String)this.attributes.get("name")), this.attributes));
            } else if (tagName.equals("terrainpage")) {
                this.objStack.push(this.processTerrainPage(new TerrainPage((String)this.attributes.get("name")), this.attributes));
            } else if (tagName.equals("repeatobject")) {
                this.objStack.push(this.repeatShare.get(this.attributes.get("ident")));
            } else if (tagName.equals("materialstate")) {
                this.objStack.push(this.buildMaterial(this.attributes));
            } else if (tagName.equals("alphastate")) {
                this.objStack.push(this.buildAlphaState(this.attributes));
            } else if (tagName.equals("texturestate")) {
                this.objStack.push(this.renderer.createTextureState());
            } else if (tagName.equals("texture")) {
                t = this.buildTexture(this.attributes);
                if (t != null) {
                    TextureState ts = (TextureState)this.objStack.pop();
                    Integer retrieveNumber = (Integer)this.attributes.get("texnum");
                    int textureNum = retrieveNumber == null ? 0 : retrieveNumber;
                    ts.setTexture(t, textureNum);
                    this.objStack.push(ts);
                }
            } else if (tagName.equals("clod")) {
                this.objStack.push(this.processSpatial((Spatial)new ClodMesh((String)this.attributes.get("name")), this.attributes));
            } else if (tagName.equals("obb")) {
                this.objStack.push(this.processOBB(new OrientedBoundingBox(), this.attributes));
            } else if (tagName.equals("boundsphere")) {
                this.objStack.push(this.processBSphere(new BoundingSphere(), this.attributes));
            } else if (tagName.equals("boundbox")) {
                this.objStack.push(this.processBBox(new BoundingBox(), this.attributes));
            } else if (tagName.equals("terrainblock")) {
                this.objStack.push(this.processTerrainBlock(new TerrainBlock((String)this.attributes.get("name")), this.attributes));
            } else if (tagName.equals("areaclod")) {
                this.objStack.push(this.processAreaClod(new AreaClodMesh((String)this.attributes.get("name")), this.attributes));
            } else if (tagName.equals("clodrecords")) {
                this.objStack.push(new CollapseRecord[((Integer)this.attributes.get("numrec")).intValue()]);
            } else if (tagName.equals("crecord")) {
                this.writeCollapseRecord(this.attributes);
            } else if (tagName.equals("mesh")) {
                t = new TriMesh((String)this.attributes.get("name"));
                t.getBatch(0).setIndexBuffer(BufferUtils.createIntBuffer((int)0));
                t.getBatch(0).setNormalBuffer(BufferUtils.createFloatBuffer((int)0));
                t.getBatch(0).setVertexBuffer(BufferUtils.createFloatBuffer((int)0));
                t.getBatch(0).setColorBuffer(null);
                t.getBatch(0).setTextureBuffer(null, 0);
                this.objStack.push(this.processSpatial((Spatial)t, this.attributes));
            } else if (tagName.startsWith("batch")) {
                if (!"batch0".equals(tagName)) {
                    o = this.objStack.pop();
                    if (o instanceof GeomBatch) {
                        o = this.objStack.pop();
                    }
                    Geometry geo = (Geometry)o;
                    TriangleBatch batch = null;
                    if (geo instanceof TriMesh) {
                        batch = new TriangleBatch();
                        batch.setIndexBuffer(BufferUtils.createIntBuffer((int)0));
                    } else {
                        batch = new GeomBatch();
                    }
                    batch.setNormalBuffer(BufferUtils.createFloatBuffer((int)0));
                    batch.setVertexBuffer(BufferUtils.createFloatBuffer((int)0));
                    batch.setColorBuffer(BufferUtils.createFloatBuffer((int)0));
                    batch.setTextureBuffer(BufferUtils.createFloatBuffer((int)0), 0);
                    geo.addBatch((GeomBatch)batch);
                    this.objStack.push(geo);
                    this.objStack.push(batch);
                }
            } else if (tagName.equals("vertex")) {
                o = this.objStack.pop();
                GeomBatch batch = null;
                if (o instanceof Geometry) {
                    Geometry geo = (Geometry)o;
                    batch = geo.getBatch(0);
                } else if (o instanceof GeomBatch) {
                    batch = (GeomBatch)o;
                }
                if (this.attributes.get("q3vert") != null) {
                    batch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.decodeShortCompress((short[])this.attributes.get("q3vert"))));
                } else {
                    batch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])((Vector3f[])this.attributes.get("data"))));
                }
                this.objStack.push(o);
            } else if (tagName.equals("normal")) {
                o = this.objStack.pop();
                GeomBatch batch = null;
                if (o instanceof Geometry) {
                    Geometry geo = (Geometry)o;
                    batch = geo.getBatch(0);
                } else if (o instanceof GeomBatch) {
                    batch = (GeomBatch)o;
                }
                if (this.attributes.get("q3norm") != null) {
                    batch.setNormalBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.decodeLatLong((byte[])this.attributes.get("q3norm"))));
                } else {
                    batch.setNormalBuffer(BufferUtils.createFloatBuffer((Vector3f[])((Vector3f[])this.attributes.get("data"))));
                }
                this.objStack.push(o);
            } else if (tagName.equals("texturecoords")) {
                o = this.objStack.pop();
                GeomBatch batch = null;
                if (o instanceof Geometry) {
                    Geometry geo = (Geometry)o;
                    batch = geo.getBatch(0);
                } else if (o instanceof GeomBatch) {
                    batch = (GeomBatch)o;
                }
                if (this.attributes.get("texindex") == null) {
                    batch.setTextureBuffer(BufferUtils.createFloatBuffer((Vector2f[])((Vector2f[])this.attributes.get("data"))), 0);
                } else {
                    batch.setTextureBuffer(BufferUtils.createFloatBuffer((Vector2f[])((Vector2f[])this.attributes.get("data"))), ((Integer)this.attributes.get("texindex")).intValue());
                }
                this.objStack.push(o);
            } else if (tagName.equals("color")) {
                o = this.objStack.pop();
                GeomBatch batch = null;
                if (o instanceof Geometry) {
                    Geometry geo = (Geometry)o;
                    batch = geo.getBatch(0);
                } else if (o instanceof GeomBatch) {
                    batch = (GeomBatch)o;
                }
                batch.setColorBuffer((FloatBuffer)this.attributes.get("data"));
                this.objStack.push(o);
            } else if (tagName.equals("defcolor")) {
                o = this.objStack.pop();
                Geometry geo = null;
                if (o instanceof Geometry) {
                    geo = (Geometry)o;
                } else if (o instanceof GeomBatch) {
                    geo = (Geometry)this.objStack.pop();
                    this.objStack.push(geo);
                }
                geo.setDefaultColor((ColorRGBA)this.attributes.get("data"));
                this.objStack.push(o);
            } else if (tagName.equals("index")) {
                o = this.objStack.pop();
                TriangleBatch batch = null;
                if (o instanceof TriMesh) {
                    TriMesh m = (TriMesh)o;
                    batch = m.getBatch(0);
                } else if (o instanceof TriangleBatch) {
                    batch = (TriangleBatch)o;
                }
                batch.setIndexBuffer(BufferUtils.createIntBuffer((int[])((int[])this.attributes.get("data"))));
                if (batch.getIndexBuffer() == null) {
                    batch.setIndexBuffer(BufferUtils.createIntBuffer((int)0));
                }
                this.objStack.push(o);
            } else if (tagName.equals("origvertex")) {
                jm = (JointMesh)this.objStack.pop();
                jm.originalVertex = (Vector3f[])this.attributes.get("data");
                this.objStack.push(jm);
            } else if (tagName.equals("orignormal")) {
                jm = (JointMesh)this.objStack.pop();
                jm.originalNormal = (Vector3f[])this.attributes.get("data");
                this.objStack.push(jm);
            } else if (tagName.equals("jointindex")) {
                jm = (JointMesh)this.objStack.pop();
                jm.jointIndex = (int[])this.attributes.get("data");
                this.objStack.push(jm);
            } else if (!tagName.equals("sharedtypes")) {
                Float oldTime;
                LightState parentLS;
                JointController jc;
                if (tagName.equals("primitive")) {
                    this.objStack.push(this.processPrimitive(this.attributes));
                } else if (tagName.equals("sharedrenderstate")) {
                    this.objStack.push((Object)new XMLSharedNode((String)this.attributes.get("ident")));
                } else if (tagName.equals("sharedtrimesh")) {
                    this.objStack.push((Object)new XMLSharedNode((String)this.attributes.get("ident")));
                } else if (tagName.equals("sharednode")) {
                    this.objStack.push((Object)new XMLSharedNode((String)this.attributes.get("ident")));
                } else if (tagName.equals("publicobject")) {
                    Object toAdd = this.shares.get(this.attributes.get("ident"));
                    this.objStack.push(toAdd);
                } else if (tagName.equals("xmlloadable")) {
                    try {
                        Class<?> c = Class.forName((String)this.attributes.get("class"));
                        if (!XMLloadable.class.isAssignableFrom(c)) {
                            throw new JmeException("Given XML class must implement XMLloadable");
                        }
                        XMLloadable x = (XMLloadable)c.newInstance();
                        Object o2 = x.loadFromXML((String)this.attributes.get("args"));
                        if (o2 instanceof Spatial) {
                            this.processSpatial((Spatial)o2, this.attributes);
                        }
                        this.objStack.push(o2);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JmeException("Unknown class type:" + this.attributes.get("class"));
                    }
                    catch (IllegalAccessException e) {
                        throw new JmeException("XMLloadable classes must have a default() constructor: " + this.attributes.get("class"));
                    }
                    catch (InstantiationException e) {
                        throw new JmeException("XMLloadable classes cannot be abstract: " + this.attributes.get("class"));
                    }
                } else if (tagName.equals("jointcontroller")) {
                    jc = new JointController(((Integer)this.attributes.get("numJoints")).intValue());
                    this.processController((Controller)jc, this.attributes);
                    jc.FPS = ((Float)this.attributes.get("fps")).floatValue();
                    this.objStack.push(jc);
                } else if (tagName.equals("keyframe")) {
                    Integer jointIndex = (Integer)this.objStack.pop();
                    JointController jc2 = (JointController)this.objStack.pop();
                    if (this.attributes.get("rot") != null) {
                        jc2.setRotation(jointIndex.intValue(), ((Float)this.attributes.get("time")).floatValue(), (Quaternion)this.attributes.get("rot"));
                    }
                    if (this.attributes.get("trans") != null) {
                        jc2.setTranslation(jointIndex.intValue(), ((Float)this.attributes.get("time")).floatValue(), (Vector3f)this.attributes.get("trans"));
                    }
                    this.objStack.push(jc2);
                    this.objStack.push(jointIndex);
                } else if (tagName.equals("joint")) {
                    jc = (JointController)this.objStack.pop();
                    jc.parentIndex[((Integer)this.attributes.get((Object)"index")).intValue()] = (Integer)this.attributes.get("parentindex");
                    jc.localRefMatrix[(Integer)this.attributes.get("index")].setRotation((Matrix3f)this.attributes.get("localrot"));
                    jc.localRefMatrix[(Integer)this.attributes.get("index")].setTranslation((Vector3f)this.attributes.get("localvec"));
                    this.objStack.push(jc);
                    this.objStack.push(this.attributes.get("index"));
                } else if (tagName.equals("jointmesh")) {
                    this.objStack.push(this.processSpatial((Spatial)new JointMesh((String)this.attributes.get("name")), this.attributes));
                } else if (tagName.equals("keyframecontroller")) {
                    KeyframeController kc = new KeyframeController();
                    kc.setActive(true);
                    TriMesh parentMesh = (TriMesh)this.objStack.pop();
                    kc.setMorphingMesh(parentMesh);
                    this.objStack.push(parentMesh);
                    this.objStack.push(kc);
                } else if (tagName.equals("keyframepointintime")) {
                    this.objStack.push(this.attributes.get("time"));
                    this.objStack.push(new TriMesh());
                } else if (tagName.equals("lightstate")) {
                    this.objStack.push(this.buildLightState(this.attributes));
                } else if (tagName.equals("spotlight")) {
                    parentLS = (LightState)this.objStack.pop();
                    parentLS.attach((Light)this.buildSpotLight(this.attributes));
                    this.objStack.push(parentLS);
                } else if (tagName.equals("pointlight")) {
                    parentLS = (LightState)this.objStack.pop();
                    parentLS.attach((Light)this.buildPointLight(this.attributes));
                    this.objStack.push(parentLS);
                } else if (tagName.equals("jmefile")) {
                    LoaderNode i;
                    if (this.attributes.get("file") != null) {
                        i = new LoaderNode("file " + (String)this.attributes.get("file"));
                        i.loadFromFilePath((String)this.attributes.get("type"), (String)this.attributes.get("file"), this.properties);
                        this.objStack.push((Object)i);
                    } else if (this.attributes.get("classloader") != null) {
                        i = new LoaderNode("classloader " + (String)this.attributes.get("classloader"));
                        i.loadFromClassLoader((String)this.attributes.get("type"), (String)this.attributes.get("classloader"), this.properties);
                        this.objStack.push((Object)i);
                    } else if (this.attributes.get("url") != null) {
                        i = new LoaderNode("classloader " + this.attributes.get("url"));
                        i.loadFromURLPath((String)this.attributes.get("type"), (URL)this.attributes.get("url"), this.properties);
                        this.objStack.push((Object)i);
                    }
                } else if (tagName.equals("spatialtransformer")) {
                    SpatialTransformer st = new SpatialTransformer(((Integer)this.attributes.get("numobjects")).intValue());
                    this.processController((Controller)st, this.attributes);
                    this.objStack.push(st);
                } else if (tagName.equals("stobj")) {
                    this.objStack.push(this.attributes.get("obnum"));
                    this.objStack.push(this.attributes.get("parnum"));
                    this.objStack.push((Object)new XMLSharedNode(null));
                } else if (tagName.equals("spatialpointtime")) {
                    this.objStack.push(this.attributes.get("time"));
                } else if (tagName.equals("sptscale")) {
                    oldTime = (Float)this.objStack.pop();
                    float time = oldTime.floatValue();
                    int[] scaleIndexes = (int[])this.attributes.get("index");
                    Vector3f[] scalevalues = (Vector3f[])this.attributes.get("scalevalues");
                    SpatialTransformer st = (SpatialTransformer)this.objStack.pop();
                    if (scalevalues != null) {
                        for (int i = 0; i < scaleIndexes.length; ++i) {
                            st.setScale(scaleIndexes[i], time, scalevalues[i]);
                        }
                    }
                    this.objStack.push(st);
                    this.objStack.push(oldTime);
                } else if (tagName.equals("sptrot")) {
                    oldTime = (Float)this.objStack.pop();
                    float time = oldTime.floatValue();
                    int[] rotIndexes = (int[])this.attributes.get("index");
                    Quaternion[] rotvalues = (Quaternion[])this.attributes.get("rotvalues");
                    SpatialTransformer st = (SpatialTransformer)this.objStack.pop();
                    if (rotvalues != null) {
                        for (int i = 0; i < rotIndexes.length; ++i) {
                            st.setRotation(rotIndexes[i], time, rotvalues[i]);
                        }
                    }
                    this.objStack.push(st);
                    this.objStack.push(oldTime);
                } else if (tagName.equals("spttrans")) {
                    oldTime = (Float)this.objStack.pop();
                    float time = oldTime.floatValue();
                    int[] transIndexes = (int[])this.attributes.get("index");
                    Vector3f[] transvalues = (Vector3f[])this.attributes.get("transvalues");
                    SpatialTransformer st = (SpatialTransformer)this.objStack.pop();
                    if (transvalues != null) {
                        for (int i = 0; i < transIndexes.length; ++i) {
                            st.setPosition(transIndexes[i], time, transvalues[i]);
                        }
                    }
                    this.objStack.push(st);
                    this.objStack.push(oldTime);
                } else if (tagName.equals("cullstate")) {
                    this.objStack.push(this.buildCullState(this.attributes));
                } else if (tagName.equals("wirestate")) {
                    this.objStack.push(this.buildWireState(this.attributes));
                } else {
                    throw new JmeException("Illegale Qualified name: '" + tagName + "'");
                }
            }
        }
        if (this.attributes.containsKey("sharedident")) {
            Object temp = this.objStack.pop();
            this.repeatShare.put(this.attributes.get("sharedident"), temp);
            this.objStack.push(temp);
        }
    }

    private void processController(Controller jc, HashMap attributes) {
        if (attributes.containsKey("speed")) {
            jc.setSpeed(((Float)attributes.get("speed")).floatValue());
        }
        if (attributes.containsKey("rptype")) {
            jc.setRepeatType(((Integer)attributes.get("rptype")).intValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readEnd() throws IOException {
        String tagName = this.myIn.readUTF();
        if (tagName.equals("scene")) {
            this.myScene = (Node)this.objStack.pop();
            return;
        } else if (tagName.equals("node") || tagName.equals("terrainpage")) {
            Node childNode = (Node)this.objStack.pop();
            Node parentNode = (Node)this.objStack.pop();
            parentNode.attachChild((Spatial)childNode);
            this.objStack.push(parentNode);
            return;
        } else if (tagName.equals("repeatobject")) {
            Object childObject = this.objStack.pop();
            if (childObject instanceof RenderState) {
                Spatial parentSpatial = (Spatial)this.objStack.pop();
                parentSpatial.setRenderState((RenderState)childObject);
                this.objStack.push(parentSpatial);
                return;
            } else if (childObject instanceof Controller) {
                Spatial parentSpatial = (Spatial)this.objStack.pop();
                parentSpatial.addController((Controller)childObject);
                this.objStack.push(parentSpatial);
                return;
            } else {
                if (!(childObject instanceof Spatial)) throw new IOException("Unknown child repeat object " + childObject.getClass());
                Node parentNode = (Node)this.objStack.pop();
                parentNode.attachChild((Spatial)childObject);
                this.objStack.push(parentNode);
            }
            return;
        } else if (tagName.equals("materialstate")) {
            MaterialState childMaterial = (MaterialState)this.objStack.pop();
            Object o = this.objStack.pop();
            if (o instanceof Spatial) {
                Spatial parentSpatial = (Spatial)o;
                parentSpatial.setRenderState((RenderState)childMaterial);
            } else if (o instanceof GeomBatch) {
                ((GeomBatch)o).setRenderState((RenderState)childMaterial);
            }
            this.objStack.push(o);
            return;
        } else if (tagName.equals("alphastate")) {
            AlphaState childAlphaState = (AlphaState)this.objStack.pop();
            Object o = this.objStack.pop();
            if (o instanceof Spatial) {
                Spatial parentSpatial = (Spatial)o;
                parentSpatial.setRenderState((RenderState)childAlphaState);
                if (childAlphaState.isBlendEnabled()) {
                    Spatial parent = parentSpatial;
                    parent.setRenderQueueMode(3);
                }
            } else if (o instanceof GeomBatch) {
                ((GeomBatch)o).setRenderState((RenderState)childAlphaState);
                if (childAlphaState.isBlendEnabled()) {
                    Spatial parent = (Spatial)this.objStack.pop();
                    parent.setRenderQueueMode(3);
                    this.objStack.push(parent);
                }
            }
            this.objStack.push(o);
            return;
        } else if (tagName.equals("texturestate")) {
            TextureState childMaterial = (TextureState)this.objStack.pop();
            Object o = this.objStack.pop();
            if (o instanceof Spatial) {
                Spatial parentSpatial = (Spatial)o;
                parentSpatial.setRenderState((RenderState)childMaterial);
            } else if (o instanceof GeomBatch) {
                ((GeomBatch)o).setRenderState((RenderState)childMaterial);
            }
            this.objStack.push(o);
            return;
        } else {
            if (tagName.equals("texture")) return;
            if (tagName.equals("cullstate")) {
                CullState childCull = (CullState)this.objStack.pop();
                Object o = this.objStack.pop();
                if (o instanceof Spatial) {
                    Spatial parentSpatial = (Spatial)o;
                    parentSpatial.setRenderState((RenderState)childCull);
                } else if (o instanceof GeomBatch) {
                    ((GeomBatch)o).setRenderState((RenderState)childCull);
                }
                this.objStack.push(o);
                return;
            } else {
                if (tagName.startsWith("batch")) return;
                if (tagName.equals("mesh") || tagName.equals("jointmesh") || tagName.equals("clod") || tagName.equals("areaclod") || tagName.equals("terrainblock")) {
                    Object o = this.objStack.pop();
                    Geometry childMesh = null;
                    if (o instanceof GeomBatch) {
                        childMesh = (Geometry)this.objStack.pop();
                    } else if (o instanceof Geometry) {
                        childMesh = (Geometry)o;
                    }
                    if (childMesh.getBatch(0).getModelBound() == null) {
                        if ("box".equals(this.properties.get("bound"))) {
                            childMesh.setModelBound((BoundingVolume)new BoundingBox());
                        } else if ("obb".equals(this.properties.get("bound"))) {
                            childMesh.setModelBound((BoundingVolume)new OrientedBoundingBox());
                        } else {
                            childMesh.setModelBound((BoundingVolume)new BoundingSphere());
                        }
                        childMesh.updateModelBound();
                    }
                    Node parentNode = (Node)this.objStack.pop();
                    parentNode.attachChild((Spatial)childMesh);
                    this.objStack.push(parentNode);
                    return;
                } else {
                    if (tagName.equals("vertex") || tagName.equals("normal") || tagName.equals("color") || tagName.equals("defcolor") || tagName.equals("texturecoords") || tagName.equals("index")) return;
                    if (tagName.equals("primitive")) {
                        Spatial childSpatial = (Spatial)this.objStack.pop();
                        Node parentNode = (Node)this.objStack.pop();
                        parentNode.attachChild(childSpatial);
                        this.objStack.push(parentNode);
                        return;
                    } else {
                        if (tagName.equals("pointlight") || tagName.equals("spotlight") || tagName.equals("sharedtypes") || tagName.equals("keyframe")) return;
                        if (tagName.equals("xmlloadable")) {
                            Object o = this.objStack.pop();
                            if (o instanceof RenderState) {
                                Spatial parentSpatial = (Spatial)this.objStack.pop();
                                parentSpatial.setRenderState((RenderState)o);
                                this.objStack.push(parentSpatial);
                                return;
                            } else if (o instanceof Controller) {
                                Spatial parentSpatial = (Spatial)this.objStack.pop();
                                parentSpatial.addController((Controller)o);
                                this.objStack.push(parentSpatial);
                                return;
                            } else {
                                if (!(o instanceof Spatial)) return;
                                Node parentNode = (Node)this.objStack.pop();
                                parentNode.attachChild((Spatial)o);
                                this.objStack.push(parentNode);
                            }
                            return;
                        } else if (tagName.equals("sharedrenderstate")) {
                            XMLSharedNode XMLShare = (XMLSharedNode)((Object)this.objStack.pop());
                            if (XMLShare.whatIReallyAm == null) return;
                            this.shares.put(XMLShare.myIdent, XMLShare.whatIReallyAm);
                            return;
                        } else if (tagName.equals("sharedtrimesh")) {
                            XMLSharedNode XMLShare = (XMLSharedNode)((Object)this.objStack.pop());
                            this.shares.put(XMLShare.myIdent, XMLShare.whatIReallyAm);
                            return;
                        } else if (tagName.equals("sharednode")) {
                            XMLSharedNode XMLShare = (XMLSharedNode)((Object)this.objStack.pop());
                            this.shares.put(XMLShare.myIdent, XMLShare.whatIReallyAm);
                            return;
                        } else if (tagName.equals("publicobject")) {
                            Object o = this.objStack.pop();
                            if (o instanceof RenderState) {
                                Spatial parentSpatial = (Spatial)this.objStack.pop();
                                parentSpatial.setRenderState((RenderState)o);
                                this.objStack.push(parentSpatial);
                                return;
                            } else if (o instanceof Controller) {
                                Spatial parentSpatial = (Spatial)this.objStack.pop();
                                parentSpatial.addController((Controller)o);
                                this.objStack.push(parentSpatial);
                                return;
                            } else {
                                if (!(o instanceof Spatial)) return;
                                Node parentNode = (Node)this.objStack.pop();
                                parentNode.attachChild((Spatial)o);
                                this.objStack.push(parentNode);
                            }
                            return;
                        } else if (tagName.equals("jointcontroller")) {
                            JointController jc = (JointController)this.objStack.pop();
                            Node parentNode = (Node)this.objStack.pop();
                            for (int i = 0; i < parentNode.getQuantity(); ++i) {
                                if (!(parentNode.getChild(i) instanceof JointMesh)) continue;
                                jc.addJointMesh((JointMesh)parentNode.getChild(i));
                            }
                            jc.processController();
                            if (jc.numJoints != 0) {
                                parentNode.addController((Controller)jc);
                            }
                            this.objStack.push(parentNode);
                            return;
                        } else if (tagName.equals("joint")) {
                            this.objStack.pop();
                            return;
                        } else if (tagName.equals("obb") || tagName.equals("boundsphere") || tagName.equals("boundbox")) {
                            BoundingVolume bv = (BoundingVolume)this.objStack.pop();
                            Object o = this.objStack.pop();
                            if (o instanceof Geometry) {
                                Geometry parentGeo = (Geometry)o;
                                parentGeo.setModelBound(bv);
                            }
                            this.objStack.push(o);
                            return;
                        } else {
                            if (tagName.equals("jointindex") || tagName.equals("origvertex") || tagName.equals("orignormal")) return;
                            if (tagName.equals("keyframecontroller")) {
                                KeyframeController kc = (KeyframeController)this.objStack.pop();
                                TriMesh parentMesh = (TriMesh)this.objStack.pop();
                                parentMesh.addController((Controller)kc);
                                this.objStack.push(parentMesh);
                                return;
                            } else if (tagName.equals("lightstate")) {
                                LightState ls = (LightState)this.objStack.pop();
                                Object o = this.objStack.pop();
                                if (o instanceof Spatial) {
                                    Spatial parentSpatial = (Spatial)o;
                                    parentSpatial.setRenderState((RenderState)ls);
                                } else if (o instanceof GeomBatch) {
                                    ((GeomBatch)o).setRenderState((RenderState)ls);
                                }
                                this.objStack.push(o);
                                return;
                            } else if (tagName.equals("keyframepointintime")) {
                                TriMesh parentMesh = (TriMesh)this.objStack.pop();
                                float time = ((Float)this.objStack.pop()).floatValue();
                                KeyframeController kc = (KeyframeController)this.objStack.pop();
                                kc.setKeyframe(time, parentMesh);
                                this.objStack.push(kc);
                                return;
                            } else if (tagName.equals("jmefile")) {
                                LoaderNode childLoaderNode = (LoaderNode)((Object)this.objStack.pop());
                                Node parentNode = (Node)this.objStack.pop();
                                parentNode.attachChild((Spatial)childLoaderNode);
                                this.objStack.push(parentNode);
                                return;
                            } else if (tagName.equals("spatialtransformer")) {
                                SpatialTransformer st = (SpatialTransformer)this.objStack.pop();
                                Spatial parentSpatial = (Spatial)this.objStack.pop();
                                st.interpolateMissing();
                                st.setActive(true);
                                parentSpatial.addController((Controller)st);
                                this.objStack.push(parentSpatial);
                                return;
                            } else if (tagName.equals("stobj")) {
                                XMLSharedNode xsn = (XMLSharedNode)((Object)this.objStack.pop());
                                int parNum = (Integer)this.objStack.pop();
                                int obNum = (Integer)this.objStack.pop();
                                SpatialTransformer parentST = (SpatialTransformer)this.objStack.pop();
                                parentST.setObject((Spatial)xsn.whatIReallyAm, obNum, parNum);
                                this.objStack.push(parentST);
                                return;
                            } else if (tagName.equals("spatialpointtime")) {
                                this.objStack.pop();
                                return;
                            } else if (tagName.equals("clodrecords")) {
                                CollapseRecord[] toPut = (CollapseRecord[])this.objStack.pop();
                                ClodMesh parentClod = (ClodMesh)this.objStack.pop();
                                parentClod.create(toPut);
                                this.objStack.push(parentClod);
                                return;
                            } else if (tagName.equals("wirestate")) {
                                WireframeState ws = (WireframeState)this.objStack.pop();
                                Object o = this.objStack.pop();
                                if (o instanceof Spatial) {
                                    Spatial parentSpatial = (Spatial)o;
                                    parentSpatial.setRenderState((RenderState)ws);
                                } else if (o instanceof GeomBatch) {
                                    ((GeomBatch)o).setRenderState((RenderState)ws);
                                }
                                this.objStack.push(o);
                                return;
                            } else {
                                if (tagName.equals("crecord") || tagName.equals("sptscale") || tagName.equals("sptrot") || tagName.equals("spttrans")) return;
                                throw new JmeException("Illegal Qualified name: " + tagName);
                            }
                        }
                    }
                }
            }
        }
    }

    private OrientedBoundingBox processOBB(OrientedBoundingBox obb, HashMap attributes) {
        obb.setCenter((Vector3f)attributes.get("center"));
        obb.setXAxis((Vector3f)attributes.get("xaxis"));
        obb.setYAxis((Vector3f)attributes.get("yaxis"));
        obb.setZAxis((Vector3f)attributes.get("zaxis"));
        obb.setExtent((Vector3f)attributes.get("extent"));
        return obb;
    }

    private BoundingSphere processBSphere(BoundingSphere v, HashMap attributes) {
        v.setCenter((Vector3f)attributes.get("center"));
        v.setRadius(((Float)attributes.get("radius")).floatValue());
        return v;
    }

    private BoundingBox processBBox(BoundingBox v, HashMap attributes) {
        v.setCenter((Vector3f)attributes.get("nowcent"));
        Vector3f ext = (Vector3f)attributes.get("nowext");
        v.xExtent = ext.x;
        v.yExtent = ext.y;
        v.zExtent = ext.z;
        return v;
    }

    private void writeCollapseRecord(HashMap attributes) {
        CollapseRecord temp = new CollapseRecord();
        temp.indices = (int[])attributes.get("indexary");
        temp.numbIndices = (Integer)attributes.get("numi");
        temp.numbTriangles = (Integer)attributes.get("numt");
        temp.numbVerts = (Integer)attributes.get("numv");
        temp.vertToKeep = (Integer)attributes.get("vkeep");
        temp.vertToThrow = (Integer)attributes.get("vthrow");
        CollapseRecord[] toPut = (CollapseRecord[])this.objStack.pop();
        toPut[((Integer)attributes.get((Object)"index")).intValue()] = temp;
        this.objStack.push(toPut);
    }

    private TerrainPage processTerrainPage(TerrainPage terrainPage, HashMap attributes) {
        this.processSpatial((Spatial)terrainPage, attributes);
        terrainPage.setOffset((Vector2f)attributes.get("offset"));
        terrainPage.setTotalSize(((Integer)attributes.get("totsize")).intValue());
        terrainPage.setSize(((Integer)attributes.get("size")).intValue());
        terrainPage.setStepScale((Vector3f)attributes.get("stepscale"));
        terrainPage.setOffsetAmount(((Float)attributes.get("offamnt")).floatValue());
        return terrainPage;
    }

    private TerrainBlock processTerrainBlock(TerrainBlock terrainBlock, HashMap attributes) {
        this.processAreaClod((AreaClodMesh)terrainBlock, attributes);
        terrainBlock.setSize(((Integer)attributes.get("tbsize")).intValue());
        terrainBlock.setTotalSize(((Integer)attributes.get("totsize")).intValue());
        terrainBlock.setStepScale((Vector3f)attributes.get("step"));
        terrainBlock.setUseClod(((Boolean)attributes.get("isclod")).booleanValue());
        terrainBlock.setOffset((Vector2f)attributes.get("offset"));
        terrainBlock.setOffsetAmount(((Float)attributes.get("offamnt")).floatValue());
        terrainBlock.setHeightMap((int[])attributes.get("hmap"));
        return terrainBlock;
    }

    private AreaClodMesh processAreaClod(AreaClodMesh areaClodMesh, HashMap attributes) {
        this.processSpatial((Spatial)areaClodMesh, attributes);
        areaClodMesh.setDistanceTolerance(((Float)attributes.get("disttol")).floatValue());
        areaClodMesh.setTrisPerPixel(((Float)attributes.get("trisppix")).floatValue());
        return areaClodMesh;
    }

    private Vector3f[] decodeShortCompress(short[] shorts) throws IOException {
        if (shorts.length % 3 != 0) {
            throw new IOException("Illeagle short[] length of " + shorts.length);
        }
        Vector3f[] toReturn = new Vector3f[shorts.length / 3];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = new Vector3f();
            toReturn[i].x = (float)shorts[i * 3 + 0] * 0.015625f;
            toReturn[i].y = (float)shorts[i * 3 + 1] * 0.015625f;
            toReturn[i].z = (float)shorts[i * 3 + 2] * 0.015625f;
        }
        return toReturn;
    }

    private Vector3f[] decodeLatLong(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length % 2 != 0) {
            throw new IOException("Illeagle bytes[] length of " + bytes.length);
        }
        Vector3f[] vecs = new Vector3f[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            vecs[i / 2] = new Vector3f();
            byte lng = bytes[i];
            byte lat = bytes[i + 1];
            float newlat = (float)Math.PI / 180 * (float)lat;
            float newlng = (float)Math.PI / 180 * (float)lng;
            vecs[i / 2].x = FastMath.cos((float)newlat) * FastMath.sin((float)newlng);
            vecs[i / 2].y = FastMath.sin((float)newlat) * FastMath.sin((float)newlng);
            vecs[i / 2].z = FastMath.cos((float)newlng);
        }
        return vecs;
    }

    private Object buildCullState(HashMap attributes) {
        CullState cs = this.renderer.createCullState();
        cs.setEnabled(true);
        String state = (String)attributes.get("cull");
        if ("none".equals(state)) {
            cs.setCullMode(0);
        } else if ("back".equals(state)) {
            cs.setCullMode(2);
        } else if ("front".equals(state)) {
            cs.setCullMode(1);
        }
        return cs;
    }

    private PointLight buildPointLight(HashMap attributes) {
        PointLight toReturn = new PointLight();
        this.putLightInfo((Light)toReturn, attributes);
        toReturn.setLocation((Vector3f)attributes.get("loc"));
        toReturn.setEnabled(true);
        return toReturn;
    }

    private SpotLight buildSpotLight(HashMap attributes) {
        SpotLight toReturn = new SpotLight();
        this.putLightInfo((Light)toReturn, attributes);
        toReturn.setLocation((Vector3f)attributes.get("loc"));
        toReturn.setAngle(((Float)attributes.get("fangle")).floatValue());
        toReturn.setDirection((Vector3f)attributes.get("dir"));
        toReturn.setExponent(((Float)attributes.get("fexponent")).floatValue());
        toReturn.setEnabled(true);
        return toReturn;
    }

    private WireframeState buildWireState(HashMap attributes) {
        WireframeState ws = this.renderer.createWireframeState();
        ws.setFace(((Integer)attributes.get("facetype")).intValue());
        ws.setLineWidth(((Float)attributes.get("width")).floatValue());
        ws.setEnabled(true);
        return ws;
    }

    private void putLightInfo(Light light, HashMap attributes) {
        light.setAmbient((ColorRGBA)attributes.get("ambient"));
        light.setConstant(((Float)attributes.get("fconstant")).floatValue());
        light.setDiffuse((ColorRGBA)attributes.get("diffuse"));
        light.setLinear(((Float)attributes.get("flinear")).floatValue());
        light.setQuadratic(((Float)attributes.get("fquadratic")).floatValue());
        light.setSpecular((ColorRGBA)attributes.get("specular"));
        light.setAttenuate(((Boolean)attributes.get("isattenuate")).booleanValue());
    }

    private LightState buildLightState(HashMap attributes) {
        Boolean sepspec;
        Boolean local;
        Boolean twoSided;
        LightState ls = this.renderer.createLightState();
        ColorRGBA globalAmbient = (ColorRGBA)attributes.get("ambient");
        if (globalAmbient != null) {
            ls.setGlobalAmbient(globalAmbient);
        }
        if ((twoSided = (Boolean)attributes.get("twosided")) != null) {
            ls.setTwoSidedLighting(twoSided.booleanValue());
        }
        if ((local = (Boolean)attributes.get("local")) != null) {
            ls.setLocalViewer(local.booleanValue());
        }
        if ((sepspec = (Boolean)attributes.get("sepspec")) != null) {
            ls.setSeparateSpecular(sepspec.booleanValue());
        }
        ls.setEnabled(true);
        return ls;
    }

    private Spatial processPrimitive(HashMap atts) {
        String parameters = (String)atts.get("params");
        String type = (String)atts.get("type");
        if (parameters == null) {
            throw new JmeException("Must specify parameters");
        }
        String[] parts = parameters.trim().split(" ");
        if (type.equalsIgnoreCase("box")) {
            if (parts.length != 7) {
                throw new JmeException("Box must have 7 parameters");
            }
        } else {
            throw new JmeException("Unknown primitive type: " + type);
        }
        Box box = new Box(parts[0], new Vector3f(Float.parseFloat(parts[1]), Float.parseFloat(parts[2]), Float.parseFloat(parts[3])), new Vector3f(Float.parseFloat(parts[4]), Float.parseFloat(parts[5]), Float.parseFloat(parts[6])));
        box.setModelBound((BoundingVolume)new BoundingSphere());
        box.updateModelBound();
        Box toReturn = box;
        return this.processSpatial((Spatial)toReturn, atts);
    }

    private Texture buildTexture(HashMap atts) {
        Texture p = null;
        int mipMap = 2;
        int filter = 1;
        int imageType = TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2;
        float aniso = 1.0f;
        boolean flip = true;
        if (this.properties.containsKey("tex_mm")) {
            mipMap = (Integer)this.properties.get("tex_mm");
        }
        if (this.properties.containsKey("tex_fm")) {
            filter = (Integer)this.properties.get("tex_fm");
        }
        if (this.properties.containsKey("tex_type")) {
            imageType = (Integer)this.properties.get("tex_type");
        }
        if (this.properties.containsKey("tex_aniso")) {
            aniso = ((Float)this.properties.get("tex_aniso")).floatValue();
        }
        if (this.properties.containsKey("tex_flip")) {
            flip = (Boolean)this.properties.get("tex_flip");
        }
        try {
            if (atts.get("URL") != null && !atts.get("URL").equals("null")) {
                p = TextureManager.loadTexture((URL)((URL)atts.get("URL")), (int)mipMap, (int)filter, (int)imageType, (float)aniso, (boolean)flip);
            } else if (atts.get("file") != null && !atts.get("file").equals("null")) {
                URL context = this.properties.containsKey("texurl") ? new URL((URL)this.properties.get("texurl"), (String)atts.get("file")) : (this.properties.containsKey("texclasspath") ? JmeBinaryReader.class.getClassLoader().getResource((String)this.properties.get("texclasspath") + (String)atts.get("file")) : (this.properties.containsKey("texdirfile") ? new File((String)this.properties.get("texdirfile") + File.separator + (String)atts.get("file")).toURL() : new File((String)atts.get("file")).toURI().toURL()));
                p = TextureManager.loadTexture((URL)context, (int)mipMap, (int)filter, (int)imageType, (float)aniso, (boolean)flip);
                if (p == null) {
                    return p;
                }
                p.setImageLocation("file:/" + atts.get("file"));
            }
            if (p == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Unable to load file: " + atts.get("file"));
            } else {
                if (atts.get("wrap") != null) {
                    p.setWrap(((Integer)atts.get("wrap")).intValue());
                }
                if (atts.get("scale") != null) {
                    p.setScale((Vector3f)atts.get("scale"));
                }
            }
        }
        catch (MalformedURLException e) {
            throw new JmeException("Bad file name: " + atts.get("file") + " (" + atts.get("URL") + ")");
        }
        return p;
    }

    private Spatial processSpatial(Spatial toAdd, HashMap atts) {
        if (atts.get("name") != null) {
            toAdd.setName((String)atts.get("name"));
        }
        if (atts.get("translation") != null) {
            toAdd.setLocalTranslation((Vector3f)atts.get("translation"));
        }
        if (atts.get("rotation") != null) {
            toAdd.setLocalRotation((Quaternion)atts.get("rotation"));
        }
        if (atts.get("scale") != null) {
            toAdd.setLocalScale((Vector3f)atts.get("scale"));
        }
        return toAdd;
    }

    private MaterialState buildMaterial(HashMap atts) {
        MaterialState m = this.renderer.createMaterialState();
        m.setAmbient((ColorRGBA)atts.get("ambient"));
        m.setDiffuse((ColorRGBA)atts.get("diffuse"));
        m.setEmissive((ColorRGBA)atts.get("emissive"));
        m.setShininess(((Float)atts.get("shiny")).floatValue());
        m.setSpecular((ColorRGBA)atts.get("specular"));
        Integer temp = (Integer)atts.get("color");
        if (temp != null) {
            m.setColorMaterial(temp.intValue());
        }
        if ((temp = (Integer)atts.get("face")) != null) {
            m.setMaterialFace(temp.intValue());
        }
        m.setEnabled(true);
        return m;
    }

    private AlphaState buildAlphaState(HashMap atts) {
        AlphaState a = this.renderer.createAlphaState();
        a.setSrcFunction(((Integer)atts.get("srcfunc")).intValue());
        a.setDstFunction(((Integer)atts.get("dstfunc")).intValue());
        a.setTestFunction(((Integer)atts.get("testfunc")).intValue());
        a.setReference(((Float)atts.get("reference")).floatValue());
        a.setBlendEnabled(((Boolean)atts.get("blend")).booleanValue());
        a.setTestEnabled(((Boolean)atts.get("test")).booleanValue());
        a.setEnabled(((Boolean)atts.get("enabled")).booleanValue());
        return a;
    }

    private void readInObjects(HashMap<String, Object> atribMap) throws IOException {
        atribMap.clear();
        int numFlags = this.myIn.readByte();
        block19: for (int i = 0; i < numFlags; ++i) {
            String name = this.myIn.readUTF();
            byte type = this.myIn.readByte();
            switch (type) {
                case 2: {
                    atribMap.put(name, this.getColorBuffer());
                    continue block19;
                }
                case 4: {
                    atribMap.put(name, this.getIntArray());
                    continue block19;
                }
                case 3: {
                    atribMap.put(name, this.myIn.readUTF());
                    continue block19;
                }
                case 1: {
                    atribMap.put(name, this.getVec2fArray());
                    continue block19;
                }
                case 0: {
                    atribMap.put(name, this.getVec3fArray());
                    continue block19;
                }
                case 5: {
                    atribMap.put(name, this.getVec3f());
                    continue block19;
                }
                case 15: {
                    atribMap.put(name, this.getVec2f());
                    continue block19;
                }
                case 6: {
                    atribMap.put(name, this.getQuat());
                    continue block19;
                }
                case 7: {
                    atribMap.put(name, new Float(this.myIn.readFloat()));
                    continue block19;
                }
                case 8: {
                    atribMap.put(name, this.getColor());
                    continue block19;
                }
                case 9: {
                    atribMap.put(name, new URL(this.myIn.readUTF()));
                    continue block19;
                }
                case 10: {
                    atribMap.put(name, new Integer(this.myIn.readInt()));
                    continue block19;
                }
                case 11: {
                    atribMap.put(name, new Boolean(this.myIn.readBoolean()));
                    continue block19;
                }
                case 12: {
                    atribMap.put(name, this.getQuatArray());
                    continue block19;
                }
                case 13: {
                    atribMap.put(name, this.getByteArray());
                    continue block19;
                }
                case 14: {
                    atribMap.put(name, this.getShortArray());
                    continue block19;
                }
                case 16: {
                    atribMap.put(name, this.getMat3());
                    continue block19;
                }
                default: {
                    throw new IOException("Unknown data type:" + type);
                }
            }
        }
    }

    private Matrix3f getMat3() throws IOException {
        Matrix3f m = new Matrix3f();
        m.m00 = this.myIn.readFloat();
        m.m01 = this.myIn.readFloat();
        m.m02 = this.myIn.readFloat();
        m.m10 = this.myIn.readFloat();
        m.m11 = this.myIn.readFloat();
        m.m12 = this.myIn.readFloat();
        m.m20 = this.myIn.readFloat();
        m.m21 = this.myIn.readFloat();
        m.m22 = this.myIn.readFloat();
        return m;
    }

    private short[] getShortArray() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.myIn.readShort();
        }
        return array;
    }

    private byte[] getByteArray() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.myIn.readByte();
        }
        return array;
    }

    private Quaternion[] getQuatArray() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        Quaternion[] array = new Quaternion[length];
        for (int i = 0; i < length; ++i) {
            array[i] = new Quaternion(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
            if (!Float.isNaN(array[i].x) || !Float.isNaN(array[i].y) || !Float.isNaN(array[i].z) || !Float.isNaN(array[i].w)) continue;
            array[i] = null;
        }
        return array;
    }

    private Quaternion getQuat() throws IOException {
        return new Quaternion(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private ColorRGBA getColor() throws IOException {
        return new ColorRGBA(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private Vector2f getVec2f() throws IOException {
        return new Vector2f(this.myIn.readFloat(), this.myIn.readFloat());
    }

    private Vector3f getVec3f() throws IOException {
        return new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private int[] getIntArray() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.myIn.readInt();
        }
        return array;
    }

    private Vector2f[] getVec2fArray() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        Vector2f[] array = new Vector2f[length];
        for (int i = 0; i < length; ++i) {
            array[i] = new Vector2f(this.myIn.readFloat(), this.myIn.readFloat());
            if (!Float.isNaN(array[i].x) || !Float.isNaN(array[i].y)) continue;
            array[i] = null;
        }
        return array;
    }

    private FloatBuffer getColorBuffer() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createColorBuffer((int)length);
        for (int i = 0; i < length; ++i) {
            buff.put(this.myIn.readFloat()).put(this.myIn.readFloat()).put(this.myIn.readFloat()).put(this.myIn.readFloat());
        }
        return buff;
    }

    private Vector3f[] getVec3fArray() throws IOException {
        int length = this.myIn.readInt();
        if (length == 0) {
            return null;
        }
        Vector3f[] array = new Vector3f[length];
        for (int i = 0; i < length; ++i) {
            array[i] = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
            if (!Float.isNaN(array[i].x) || !Float.isNaN(array[i].y) || !Float.isNaN(array[i].z)) continue;
            array[i] = null;
        }
        return array;
    }

    private void readHeader() throws IOException {
        if (1234567L != this.myIn.readLong()) {
            throw new IOException("Binary Header doesn't match.  Maybe wrong file?");
        }
    }

    public void setProperty(String key, Object property) {
        this.properties.put(key, property);
    }

    public void clearProperty(String key) {
        this.properties.remove(key);
    }
}

