/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d;

import com.jme.math.Vector3f;
import com.jmex.font3d.Glyph3DBatch;
import com.jmex.font3d.math.ClosedPolygon;
import com.jmex.font3d.math.PlanarEdge;
import com.jmex.font3d.math.PlanarVertex;
import com.jmex.font3d.math.TriangulationEdge;
import com.jmex.font3d.math.TriangulationVertex;
import com.jmex.font3d.math.Triangulator;
import java.awt.geom.Rectangle2D;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Glyph3D {
    private static final long serialVersionUID = -8126290675830115033L;
    Triangulator subdivision = new Triangulator();
    Vector<PlanarEdge> outline;
    Vector3f[] outline_normals;
    IntBuffer surface;
    private Rectangle2D bounds;
    private Glyph3DBatch glyphbatch;
    private char glyph_char;
    private int batchId = -1;

    public Glyph3D(char c) {
        this.glyph_char = c;
    }

    public void addPolygon(ClosedPolygon closedPolygon) {
        int n = this.subdivision.getVertices().size();
        for (Vector3f vector3f : closedPolygon.getPoints()) {
            Object Vertex = this.subdivision.addVertex(vector3f);
            if (((PlanarVertex)Vertex).getIndex() <= n) continue;
            this.subdivision.addEdge(((PlanarVertex)Vertex).getIndex(), ((PlanarVertex)Vertex).getIndex() - 1);
        }
        this.subdivision.addEdge(n, n + closedPolygon.getPoints().size() - 1);
    }

    public void triangulate() {
        this.outline = new Vector();
        for (TriangulationEdge planarEdge : this.subdivision.getEdges()) {
            if (!planarEdge.isRealEdge()) continue;
            this.outline.add(planarEdge);
        }
        this.outline_normals = new Vector3f[this.outline.size()];
        for (PlanarEdge planarEdge : this.outline) {
            TriangulationVertex triangulationVertex = (TriangulationVertex)planarEdge.getDestination();
            Vector3f vector3f = new Vector3f(triangulationVertex.getOutGoingEdge().getDestination().getPoint()).subtractLocal(triangulationVertex.getPoint()).normalizeLocal();
            vector3f.z = -vector3f.x;
            vector3f.x = vector3f.y;
            vector3f.y = vector3f.z;
            vector3f.z = 0.0f;
            Vector3f vector3f2 = new Vector3f(triangulationVertex.getPoint()).subtractLocal(triangulationVertex.getInGoingEdge().getOrigin().getPoint()).normalizeLocal();
            vector3f2.z = -vector3f2.x;
            vector3f2.x = vector3f2.y;
            vector3f2.y = vector3f2.z;
            vector3f2.z = 0.0f;
            vector3f.addLocal(vector3f2).normalizeLocal();
            this.outline_normals[triangulationVertex.getIndex()] = vector3f;
        }
        this.surface = this.subdivision.triangulate();
    }

    public boolean isEmpty() {
        return this.subdivision.getVertices().size() == 0;
    }

    public Vector<PlanarEdge> getOutline() {
        return this.outline;
    }

    public Vector3f[] getOutlineNormals() {
        return this.outline_normals;
    }

    public IntBuffer getSurface() {
        return this.surface;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public ArrayList<TriangulationVertex> getVertices() {
        return this.subdivision.getVertices();
    }

    public void generateBatch(boolean bl, boolean bl2, boolean bl3) {
        this.glyphbatch = new Glyph3DBatch(this, bl, bl2, bl3);
    }

    public Glyph3DBatch getBatch() {
        return this.glyphbatch;
    }

    public char getChar() {
        return this.glyph_char;
    }

    public void setBatchId(int n) {
        this.batchId = n;
    }

    public int getBatchId() {
        return this.batchId;
    }
}

