/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jmex.editors.swing.particles.ParticleEditPanel;
import com.jmex.editors.swing.widget.SphericalUnitVectorPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParticleEmissionPanel
extends ParticleEditPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox rotateWithEmitterBox;
    private SphericalUnitVectorPanel directionPanel = new SphericalUnitVectorPanel();
    private ValuePanel minAnglePanel = new ValuePanel("Min Degrees Off Dir.: ", "", 0.0f, 360.0f, 1.0f);
    private ValuePanel maxAnglePanel = new ValuePanel("Max Degrees Off Dir.: ", "", 0.0f, 360.0f, 1.0f);
    private ValuePanel velocityPanel = new ValuePanel("Initial Velocity: ", "", 0.0f, Float.MAX_VALUE, 0.001f);
    private ValuePanel spinPanel = new ValuePanel("Spin Speed: ", "", -3.4028235E38f, Float.MAX_VALUE, 0.1f);

    public ParticleEmissionPanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        this.rotateWithEmitterBox = new JCheckBox(new AbstractAction("Rotate With Emitter"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleEmissionPanel.this.getEdittedParticles().setRotateWithScene(ParticleEmissionPanel.this.rotateWithEmitterBox.isSelected());
            }
        });
        this.rotateWithEmitterBox.setFont(new Font("Arial", 1, 12));
        this.directionPanel.setBorder(this.createTitledBorder("DIRECTION"));
        this.directionPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ParticleEmissionPanel.this.getEdittedParticles() != null) {
                    ParticleEmissionPanel.this.getEdittedParticles().getEmissionDirection().set(ParticleEmissionPanel.this.directionPanel.getValue());
                    ParticleEmissionPanel.this.getEdittedParticles().updateRotationMatrix();
                }
            }
        });
        this.directionPanel.add((Component)this.rotateWithEmitterBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.minAnglePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleEmissionPanel.this.getEdittedParticles().setMinimumAngle(ParticleEmissionPanel.this.minAnglePanel.getFloatValue() * ((float)Math.PI / 180));
            }
        });
        this.maxAnglePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleEmissionPanel.this.getEdittedParticles().setMaximumAngle(ParticleEmissionPanel.this.maxAnglePanel.getFloatValue() * ((float)Math.PI / 180));
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder("ANGLE"));
        jPanel.add((Component)this.minAnglePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.maxAnglePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.velocityPanel.setBorder(this.createTitledBorder("VELOCITY"));
        this.velocityPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleEmissionPanel.this.getEdittedParticles().setInitialVelocity(ParticleEmissionPanel.this.velocityPanel.getFloatValue());
            }
        });
        this.spinPanel.setBorder(this.createTitledBorder("PARTICLE SPIN"));
        this.spinPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleEmissionPanel.this.getEdittedParticles().setParticleSpinSpeed(ParticleEmissionPanel.this.spinPanel.getFloatValue());
            }
        });
        this.add((Component)this.directionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.velocityPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.spinPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 10, 5), 0, 0));
    }

    public void updateWidgets() {
        this.rotateWithEmitterBox.setSelected(this.getEdittedParticles().isRotateWithScene());
        this.directionPanel.setValue(this.getEdittedParticles().getEmissionDirection());
        this.minAnglePanel.setValue(this.getEdittedParticles().getMinimumAngle() * 57.295776f);
        this.maxAnglePanel.setValue(this.getEdittedParticles().getMaximumAngle() * 57.295776f);
        this.velocityPanel.setValue(this.getEdittedParticles().getInitialVelocity());
        this.spinPanel.setValue(this.getEdittedParticles().getParticleSpinSpeed());
    }
}

