/*
 * Decompiled with CFR 0.152.
 */
package org.md5reader2.parser;

import com.jme.math.Vector3f;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.md5reader2.md5.MD5BoundingBox;
import org.md5reader2.parser.MD5Parser;

public class MD5AnimParser
extends MD5Parser {
    @Override
    protected void parseSections(StreamTokenizer st, int token) throws IOException {
        if (st.sval != null) {
            if (st.sval.equals("MD5Version")) {
                token = st.nextToken();
                this.animation.setMD5Version((int)st.nval);
            } else if (st.sval.equals("commandline")) {
                token = st.nextToken();
                this.animation.setCommandLine(st.sval);
            } else if (st.sval.equals("numFrames")) {
                token = st.nextToken();
                this.animation.setNumFrames((int)st.nval);
                this.animation.setBoundings(new MD5BoundingBox[(int)st.nval]);
            } else if (st.sval.equals("numJoints")) {
                token = st.nextToken();
                this.animation.setNumJoints((int)st.nval);
                this.animation.setJointName(new String[(int)st.nval]);
                this.animation.setJointParent(new int[(int)st.nval]);
                this.animation.setFlags(new int[(int)st.nval]);
                this.animation.setStartIndex(new int[(int)st.nval]);
            } else if (st.sval.equals("frameRate")) {
                token = st.nextToken();
                this.animation.setFrameRate((int)st.nval);
            } else if (st.sval.equals("numAnimatedComponents")) {
                token = st.nextToken();
                this.animation.setNumAnimatedComponents((int)st.nval);
            } else if (st.sval.equals("hierarchy")) {
                token = st.nextToken();
                this.parseHierarchy(st, token);
            } else if (st.sval.equals("bounds")) {
                token = st.nextToken();
                this.parseBoundings(st, token);
            } else if (st.sval.equals("baseframe")) {
                token = st.nextToken();
                this.parseBaseFrame(st, token);
            } else if (st.sval.equals("frame")) {
                token = st.nextToken();
                this.parseFrames(st, token);
            }
        }
    }

    private void parseHierarchy(StreamTokenizer st, int token) throws IOException {
        int jointIndex = 0;
        token = st.nextToken();
        while (st.ttype != 125) {
            switch (st.ttype) {
                case 34: {
                    this.animation.getJointName()[jointIndex] = st.sval;
                    break;
                }
                case -2: {
                    this.animation.getJointParent()[jointIndex] = (int)st.nval;
                    token = st.nextToken();
                    this.animation.getFlags()[jointIndex] = (int)st.nval;
                    token = st.nextToken();
                    this.animation.getStartIndex()[jointIndex] = (int)st.nval;
                    System.out.println("Joint " + jointIndex + " name: " + this.animation.getJointName()[jointIndex]);
                    System.out.println("\tParent of joint " + this.animation.getJointName()[jointIndex] + ": " + this.animation.getJointParent()[jointIndex]);
                    System.out.println("\tFlags of joint " + this.animation.getJointName()[jointIndex] + ": " + this.animation.getFlags()[jointIndex]);
                    System.out.println("\tStartIndex of joint " + this.animation.getJointName()[jointIndex] + ": " + this.animation.getStartIndex()[jointIndex]);
                    ++jointIndex;
                    break;
                }
                case 10: {
                    break;
                }
            }
            token = st.nextToken();
        }
    }

    private void parseBoundings(StreamTokenizer st, int token) throws IOException {
        int boundIndex = 0;
        int boundValue = 0;
        token = st.nextToken();
        while (st.ttype != 125) {
            switch (st.ttype) {
                case -2: {
                    if (boundValue == 0) {
                        this.animation.getBoundings()[boundIndex] = new MD5BoundingBox();
                        this.animation.getBoundings()[boundIndex].setMin(new Vector3f());
                        this.animation.getBoundings()[boundIndex].setMax(new Vector3f());
                        this.animation.getBoundings()[boundIndex].getMin().x = (float)st.nval;
                    } else if (boundValue == 1) {
                        this.animation.getBoundings()[boundIndex].getMin().y = (float)st.nval;
                    } else if (boundValue == 2) {
                        this.animation.getBoundings()[boundIndex].getMin().z = (float)st.nval;
                    } else if (boundValue == 3) {
                        this.animation.getBoundings()[boundIndex].getMax().x = (float)st.nval;
                    } else if (boundValue == 4) {
                        this.animation.getBoundings()[boundIndex].getMax().y = (float)st.nval;
                    } else if (boundValue == 5) {
                        this.animation.getBoundings()[boundIndex].getMax().z = (float)st.nval;
                        System.out.println("Bounding Box " + boundIndex + " Min: " + this.animation.getBoundings()[boundIndex].getMin().toString());
                        System.out.println("Bounding Box " + boundIndex + " Max: " + this.animation.getBoundings()[boundIndex].getMax().toString() + "\n");
                        ++boundIndex;
                    }
                    ++boundValue;
                    break;
                }
                case 10: {
                    boundValue = 0;
                    break;
                }
            }
            token = st.nextToken();
        }
    }

    private void parseBaseFrame(StreamTokenizer st, int token) throws IOException {
    }

    private void parseFrames(StreamTokenizer st, int token) throws IOException {
    }

    private boolean checkAnimation() {
        for (int i = 0; i < this.animation.getNumJoints(); ++i) {
            if (this.model.getJoints()[i].getName().equals(this.animation.getJointName()[i])) continue;
            return false;
        }
        return true;
    }
}

