/*
 * Decompiled with CFR 0.152.
 */
package ms3dreader;

import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import model.JointedMesh;
import model.ModelInfo;
import model.ModelUtils;
import model.ProxySkin;
import model.SimpleShader;
import model.SimpleSkin;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.Skeleton;
import model.animation.AnimationUtils;
import model.animation.SkeletalAnimation;
import model.file.ModelInfoReader;
import util.LittleEndianDataInputStream;

public class MS3DReader
implements ModelInfoReader {
    private DataInput in;

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public ModelInfo readModelInfo(InputStream oIn) throws IOException {
        this.in = new LittleEndianDataInputStream(oIn);
        if (!this.readString(10).equals("MS3D000000")) {
            throw new IOException("Not a Milkshape3d file");
        }
        int version = this.in.readInt();
        if (version != 4) {
            throw new IOException("Expected version 4, got " + version);
        }
        Vertex[] vertices = this.readVertices();
        Triangle[] triangles = this.readTriangles();
        SkeletalModel model = this.readGroups(vertices, triangles);
        this.readMaterials((ProxySkin)model.getDefaultSkin());
        SkeletalAnimation animation = this.readJoints(model);
        ModelInfo info = new ModelInfo(model);
        info.addAnimation(animation.getName(), animation);
        return info;
    }

    private Vertex[] readVertices() throws IOException {
        int numVertices = this.in.readUnsignedShort();
        Vertex[] vertices = new Vertex[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            this.in.skipBytes(1);
            vertices[i] = new Vertex(new Vector3f(this.in.readFloat(), this.in.readFloat(), this.in.readFloat()), this.in.readUnsignedByte());
            this.in.skipBytes(1);
        }
        return vertices;
    }

    private Triangle[] readTriangles() throws IOException {
        int numTriangles = this.in.readUnsignedShort();
        Triangle[] triangles = new Triangle[numTriangles];
        float[] s = new float[3];
        for (int i = 0; i < numTriangles; ++i) {
            int j;
            this.in.skipBytes(2);
            int[] indices = new int[3];
            Vector2f[] textures = new Vector2f[3];
            for (j = 0; j < 3; ++j) {
                indices[j] = this.in.readUnsignedShort();
            }
            this.in.skipBytes(36);
            for (j = 0; j < 3; ++j) {
                s[j] = this.in.readFloat();
            }
            for (j = 0; j < 3; ++j) {
                textures[j] = new Vector2f(s[j], 1.0f - this.in.readFloat());
            }
            triangles[i] = new Triangle(indices, textures);
            this.in.skipBytes(2);
        }
        return triangles;
    }

    private SkeletalModel readGroups(Vertex[] vertices, Triangle[] triangles) throws IOException {
        int numGroups = this.in.readUnsignedShort();
        ProxySkin skin = new ProxySkin(null);
        SkeletalModel model = new SkeletalModel("MS3d model", numGroups, skin);
        ArrayList<Vertex> groupVerts = new ArrayList<Vertex>();
        int[] vertMeshInd = new int[vertices.length];
        for (int i = 0; i < numGroups; ++i) {
            Vertex vertex;
            Arrays.fill(vertMeshInd, -1);
            groupVerts.clear();
            this.in.skipBytes(1);
            String name = this.readName(32);
            int numTris = this.in.readUnsignedShort();
            JointedMesh mesh = new JointedMesh(name, numTris, 0);
            model.getMeshes()[i] = mesh;
            int[] indices = mesh.getTriangleCornerArray();
            for (int j = 0; j < numTris; ++j) {
                Triangle tri = triangles[this.in.readUnsignedShort()];
                for (int k = 0; k < 3; ++k) {
                    int vertNum = tri.indices[k];
                    if (vertMeshInd[vertNum] < 0) {
                        vertex = vertices[vertNum].get();
                        groupVerts.add(vertex);
                        vertMeshInd[vertNum] = groupVerts.size() - 1;
                    } else {
                        vertex = (Vertex)groupVerts.get(vertMeshInd[vertNum]);
                    }
                    indices[j * 3 + k] = vertNum = vertMeshInd[vertNum];
                    if (vertex.texture == null) {
                        vertex.texture = tri.texture[k];
                        continue;
                    }
                    if (vertex.texture.equals((Object)tri.texture[k])) continue;
                    throw new IOException("Vertex with multiple texture coords");
                }
            }
            mesh.resetVertexCount(groupVerts.size());
            int[] bones = mesh.getVertexBone();
            Vector2f[] textures = mesh.getVertexTextureCoords(0);
            Vector3f[] offsets = mesh.getVertexOffset();
            for (int j = 0; j < groupVerts.size(); ++j) {
                vertex = (Vertex)groupVerts.get(j);
                offsets[j] = vertex.position;
                textures[j] = vertex.texture;
                bones[j] = vertex.bone;
            }
            mesh.updateTriangleCorners();
            mesh.updateTextureBuffer(0);
            int material = this.in.readUnsignedByte();
            if (material == 255) continue;
            skin.setNameMap(name, String.valueOf(material));
        }
        model.updateMeshNameMap();
        return model;
    }

    private void readMaterials(ProxySkin toChange) throws IOException {
        SimpleSkin skin = new SimpleSkin();
        toChange.setProxied(skin);
        int numMaterials = this.in.readUnsignedShort();
        for (int i = 0; i < numMaterials; ++i) {
            SimpleShader shader;
            String name = this.readName(32);
            toChange.repoint(String.valueOf(i), name);
            MaterialState material = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
            material.setAmbient(this.readColour());
            material.setDiffuse(this.readColour());
            material.setSpecular(this.readColour());
            material.setEmissive(this.readColour());
            material.setShininess(this.in.readFloat());
            material.setEnabled(true);
            this.in.skipBytes(1);
            String diffuseTex = this.readName(128);
            String alphaTex = this.readName(128);
            if (alphaTex.length() > 0) {
                throw new IOException("Alpha map not yet supported");
            }
            if (diffuseTex != null) {
                TextureState texture = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                texture.setTexture(TextureManager.loadTexture((String)diffuseTex, (int)6, (int)1));
                texture.setEnabled(true);
                shader = new SimpleShader(new RenderState[]{material, texture});
            } else {
                shader = new SimpleShader(new RenderState[]{material});
            }
            skin.setShader(name, shader);
        }
    }

    private SkeletalAnimation readJoints(SkeletalModel model) throws IOException {
        int i;
        int j;
        float fps = this.in.readFloat();
        float startTime = this.in.readFloat();
        int numFrames = this.in.readInt();
        int numJoints = this.in.readUnsignedShort();
        float[] angles = new float[3];
        Skeleton skeleton = new Skeleton(numJoints);
        model.setSkeleton(skeleton);
        String[] jointNames = skeleton.getJointNames();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> parents = new ArrayList<String>();
        SkeletalKeyFrame bind = new SkeletalKeyFrame(numJoints);
        skeleton.setBindFrame(bind);
        SkeletalAnimation animation = new SkeletalAnimation("animation", skeleton);
        animation.setBaseFrame(skeleton.getBindFrame());
        animation.getSuppliedPositions().set(0, numJoints);
        animation.getSuppliedRotations().set(0, numJoints);
        for (int i2 = 0; i2 < numJoints; ++i2) {
            SkeletalKeyFrame frame;
            float time;
            this.in.skipBytes(1);
            jointNames[i2] = this.readName(32);
            names.add(jointNames[i2]);
            parents.add(this.readName(32));
            for (int j2 = 0; j2 < 3; ++j2) {
                angles[j2] = this.in.readFloat();
            }
            bind.rotations[i2] = new Quaternion(angles);
            bind.positions[i2] = new Vector3f(this.in.readFloat(), this.in.readFloat(), this.in.readFloat());
            int numRotations = this.in.readUnsignedShort();
            int numTranslations = this.in.readUnsignedShort();
            for (j = 0; j < numRotations; ++j) {
                time = this.in.readFloat();
                for (int l = 0; l < 3; ++l) {
                    angles[l] = this.in.readFloat();
                }
                frame = this.getFrame(animation, time);
                frame.rotations[i2] = new Quaternion(angles);
            }
            for (j = 0; j < numTranslations; ++j) {
                time = this.in.readFloat();
                frame = this.getFrame(animation, time);
                frame.positions[i2] = new Vector3f(this.in.readFloat(), this.in.readFloat(), this.in.readFloat());
            }
        }
        int[] parent = skeleton.getParents();
        for (i = 0; i < numJoints; ++i) {
            parent[i] = names.indexOf(parents.get(i));
        }
        for (i = 0; i < model.getMeshes().length; ++i) {
            ModelUtils.convertToSkeletonSpace(skeleton, (JointedMesh)model.getMeshes()[i]);
        }
        AnimationUtils.fillIn(animation);
        for (i = 0; i < animation.size(); ++i) {
            SkeletalKeyFrame frame = animation.getSkeletal(i);
            for (j = 0; j < frame.positions.length; ++j) {
                bind.rotations[j].multLocal(frame.positions[j]);
            }
        }
        AnimationUtils.addBaseToOffset(animation);
        return animation;
    }

    private SkeletalKeyFrame getFrame(SkeletalAnimation animation, float time) {
        int pos = animation.findIndex(time, Integer.MAX_VALUE);
        if (pos > 0 && pos <= animation.size() && animation.getKeyFrame((int)(pos - 1)).time == time) {
            return animation.getSkeletal(pos - 1);
        }
        SkeletalKeyFrame frame = new SkeletalKeyFrame(animation.getSkeleton().getJointCount());
        frame.time = time;
        animation.addKeyFrame(frame);
        return frame;
    }

    private ColorRGBA readColour() throws IOException {
        return new ColorRGBA(this.in.readFloat(), this.in.readFloat(), this.in.readFloat(), this.in.readFloat());
    }

    private String readString(int length) throws IOException {
        byte[] data = new byte[length];
        this.in.readFully(data);
        return new String(data, "US-ASCII");
    }

    private String readName(int length) throws IOException {
        int end;
        byte[] data = new byte[length];
        this.in.readFully(data);
        for (end = 0; end < data.length && data[end] != 0; ++end) {
        }
        return new String(data, 0, end, "US-ASCII");
    }

    private static class Triangle {
        private int[] indices;
        private Vector2f[] texture;

        public Triangle(int[] indices, Vector2f[] texture) {
            this.indices = indices;
            this.texture = texture;
        }
    }

    private static class Vertex {
        private Vector3f position;
        private int bone;
        private boolean used = false;
        private Vector2f texture;

        public Vertex(Vector3f position, int bone) {
            this.position = position;
            this.bone = bone;
        }

        public Vertex get() {
            if (this.used) {
                return new Vertex(this.position, this.bone);
            }
            this.used = true;
            return this;
        }
    }
}

