/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Vector3f;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import model.KeyFrame;
import util.file.FileUtils;

public class Animation
implements Externalizable {
    protected KeyFrame baseFrame;
    protected ArrayList keyFrames = new ArrayList();
    protected String name;
    protected BitSet suppliedPositions = new BitSet();
    protected Vector3f translation = new Vector3f();

    public Animation() {
    }

    public Animation(String name) {
        this.name = name;
    }

    public void addKeyFrame(KeyFrame keyframe) {
        if (keyframe.isSkeletal() != this.isSkeletal()) {
            throw new IllegalArgumentException("skeletal/non skeletal mismatch");
        }
        int index = this.findIndex(keyframe.time, Integer.MAX_VALUE);
        this.keyFrames.add(index, keyframe);
    }

    public int findIndex(float time, int pos) {
        block7: {
            int length;
            block6: {
                if (this.keyFrames.isEmpty()) {
                    return 0;
                }
                length = this.keyFrames.size();
                if (pos >= length) {
                    pos = length - 1;
                } else if (pos < 0) {
                    pos = 0;
                }
                if (!(this.time(pos - 1) > time)) break block6;
                while (this.time(pos - 1) > time) {
                    --pos;
                }
                break block7;
            }
            if (!(this.time(pos) <= time)) break block7;
            while (pos < length && this.time(pos) <= time) {
                ++pos;
            }
        }
        return pos;
    }

    public KeyFrame first() {
        return (KeyFrame)this.keyFrames.get(0);
    }

    public KeyFrame getKeyFrame(int index) {
        return (KeyFrame)this.keyFrames.get(index);
    }

    public KeyFrame getBaseFrame() {
        return this.baseFrame;
    }

    public Vector3f getMovementTranslation() {
        return this.translation;
    }

    public String getName() {
        return this.name;
    }

    public KeyFrame getNearestKeyFrame(int index) {
        if (this.keyFrames.isEmpty()) {
            return null;
        }
        if (index < 0) {
            index = 0;
        } else if (index >= this.keyFrames.size()) {
            index = this.keyFrames.size() - 1;
        }
        return (KeyFrame)this.keyFrames.get(index);
    }

    public BitSet getSuppliedPositions() {
        return this.suppliedPositions;
    }

    public boolean isSkeletal() {
        return false;
    }

    public KeyFrame last() {
        return (KeyFrame)this.keyFrames.get(this.keyFrames.size() - 1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileUtils.checkVersionByte(in, 1, 1);
        this.name = in.readUTF();
        this.baseFrame = (KeyFrame)in.readObject();
        this.keyFrames = (ArrayList)in.readObject();
        this.translation = (Vector3f)in.readObject();
        this.suppliedPositions = (BitSet)in.readObject();
    }

    public void recalculateMovementTranslation(int vertex) {
        if (!this.suppliedPositions.get(0)) {
            this.translation.set(0.0f, 0.0f, 0.0f);
            return;
        }
        int pos = 0;
        for (int i = 0; i < vertex; ++i) {
            if (!this.suppliedPositions.get(i)) continue;
            ++pos;
        }
        this.translation.set(this.last().positions[pos]).subtractLocal(this.first().positions[pos]);
    }

    public void remove(int index) {
        this.keyFrames.remove(index);
    }

    public void setBaseFrame(KeyFrame baseFrame) {
        if (baseFrame.isSkeletal() != this.isSkeletal()) {
            throw new IllegalArgumentException("skeletal/non skeletal mismatch");
        }
        this.baseFrame = baseFrame;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int size() {
        return this.keyFrames.size();
    }

    public Animation subset(String name, int from, int to) {
        Animation copy = this.copy(name);
        copy.suppliedPositions = this.suppliedPositions;
        copy.translation = this.translation;
        copy.keyFrames.addAll(this.keyFrames.subList(from, to));
        copy.baseFrame = this.baseFrame;
        return copy;
    }

    public float time(int pos) {
        if (pos < 0) {
            return -3.4028235E38f;
        }
        if (pos >= this.keyFrames.size()) {
            return Float.MAX_VALUE;
        }
        return ((KeyFrame)this.keyFrames.get((int)pos)).time;
    }

    public void trimToSize() {
        this.keyFrames.trimToSize();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeUTF(this.name);
        out.writeObject(this.baseFrame);
        out.writeObject(this.keyFrames);
        out.writeObject(this.translation);
        out.writeObject(this.suppliedPositions);
    }

    protected Animation copy(String name) {
        return new Animation(name);
    }
}

