/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.math.Quaternion;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector3f;
import com.jme.scene.BillboardNode;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.NoSuchElementException;
import model.Mesh;
import model.Model;
import model.ModelInstance;
import model.ModelTriMesh;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.animation.AnimationController;
import model.animation.SkeletalAnimationController;

public class SkeletalModelInstance
extends ModelInstance {
    public static final int SKELETON_OFF = 0;
    public static final int SKELETON_OVERLAY = 1;
    public static final int SKELETON_ONLY = 2;
    private static TransformMatrix tempTransform = new TransformMatrix();
    private static Vector3f tempPosition = new Vector3f();
    private TransformMatrix[] jointTransform;
    public VisualSkeleton visualSkeleton;

    public SkeletalModelInstance(Model modelOb) {
        super(modelOb);
        if (this.jointTransform == null) {
            this.setupTransform();
        }
    }

    private void setupTransform() {
        this.jointTransform = new TransformMatrix[this.getModelSkeletal().getSkeleton().getJointCount()];
        for (int i = 0; i < this.jointTransform.length; ++i) {
            this.jointTransform[i] = new TransformMatrix();
        }
    }

    @Override
    public void loadBindFrame() {
        if (this.jointTransform == null) {
            this.setupTransform();
        }
        SkeletalKeyFrame bind = this.getModelSkeletal().getBindSkeletal();
        this.setRelativeTransforms(bind.positions, bind.rotations);
        this.skinMeshes(true);
    }

    public void addChild(ModelInstance instance, String parentBone) {
        int index = this.getModelSkeletal().getSkeleton().findJoint(parentBone);
        if (index < 0) {
            throw new NoSuchElementException("No such joint: " + parentBone);
        }
        this.addChild(instance, index);
    }

    public void addChild(ModelInstance instance, int parentBone) {
        if (instance.parent != null) {
            instance.parent.removeChild(instance);
        }
        this.attachChild((Spatial)instance);
        instance.parent = this;
        instance.parentBone = parentBone;
        instance.loadBindFrame();
    }

    public TransformMatrix[] getJointTransforms() {
        return this.jointTransform;
    }

    public void skinMeshes(boolean updateBounds) {
        if (this.visualSkeleton != null) {
            this.visualSkeleton.update(this);
            if (!this.visualSkeleton.meshesVisible) {
                return;
            }
        }
        Mesh[] meshDefs = this.getModel().getMeshes();
        for (int i = 0; i < this.meshes.length; ++i) {
            this.meshes[i].setModelBound((BoundingVolume)new OrientedBoundingBox());
            this.meshes[i].updateModelBound();
            this.meshes[i].updateGeometricState(0.0f, true);
            ModelTriMesh mesh = this.meshes[i];
            if (mesh.getShader() == null) continue;
            Mesh template = meshDefs[i];
            template.skinMesh(this.meshes[i], this.jointTransform, updateBounds);
            this.meshes[i].updateShader();
        }
    }

    public void removeChild(ModelInstance instance) {
        this.detachChild((Spatial)instance);
        instance.parent = null;
    }

    public SkeletalModel getModelSkeletal() {
        return (SkeletalModel)this.getModel();
    }

    public void setRelativeTransforms(Vector3f[] positions, Quaternion[] rotations) {
        int[] parents = this.getModelSkeletal().getSkeleton().getParents();
        TransformMatrix base = this.getTransformation();
        for (int i = 0; i < this.jointTransform.length; ++i) {
            tempTransform.set(rotations[i], positions[i]);
            if (parents[i] >= 0) {
                this.jointTransform[i].set(this.jointTransform[parents[i]]);
            } else {
                this.jointTransform[i].set(base);
            }
            this.jointTransform[i].multLocal(tempTransform, tempPosition);
        }
    }

    public int getSkeletonMode() {
        if (this.visualSkeleton == null) {
            return 0;
        }
        if (this.visualSkeleton.meshesVisible) {
            return 1;
        }
        return 2;
    }

    public void setSkeletonMode(int mode) {
        boolean newMesh;
        boolean curSkeleton = this.visualSkeleton != null;
        boolean curMesh = this.getSkeletonMode() != 2;
        boolean newSkeleton = mode == 2 || mode == 1;
        boolean bl = newMesh = mode != 2;
        if (curSkeleton != newSkeleton) {
            if (newSkeleton) {
                this.visualSkeleton = new VisualSkeleton(this);
                this.attachChild((Spatial)this.visualSkeleton);
            } else {
                this.detachChild((Spatial)this.visualSkeleton);
                this.visualSkeleton = null;
            }
        }
        if (curMesh != newMesh) {
            if (newMesh) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!(this.children.get(i) instanceof ModelTriMesh)) continue;
                    ((ModelTriMesh)((Object)this.children.get(i))).setShader(((ModelTriMesh)((Object)this.children.get(i))).getShader());
                }
            } else {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!(this.children.get(i) instanceof ModelTriMesh)) continue;
                }
            }
        }
        if (newSkeleton) {
            this.visualSkeleton.meshesVisible = newMesh;
        }
    }

    @Override
    public boolean isSkeletal() {
        return true;
    }

    @Override
    public AnimationController addAnimationController() {
        SkeletalAnimationController controller = new SkeletalAnimationController(this);
        this.addController(controller);
        return controller;
    }

    private static class VisualSkeleton
    extends Node {
        private Line skeletonLine;
        private Spatial[] textNodes;
        private boolean meshesVisible;

        private VisualSkeleton(SkeletalModelInstance instance) {
            super("visual skeleton");
            this.createSkeletonGeometry(instance);
            this.setLightCombineMode(0);
            TextureState ts = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            ts.setEnabled(true);
            ts.setTexture(TextureManager.loadTexture((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("/models/white.png"), (int)2, (int)1));
            this.setRenderState((RenderState)ts);
            AlphaState as = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
            as.setBlendEnabled(true);
            as.setSrcFunction(1);
            as.setDstFunction(3);
            this.setRenderState((RenderState)as);
            ZBufferState state = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
            state.setEnabled(false);
            this.setRenderState((RenderState)state);
            this.updateRenderState();
        }

        private boolean getXRay() {
            return true;
        }

        private void createSkeletonGeometry(SkeletalModelInstance instance) {
            this.skeletonLine = new Line("skeleton line");
            this.skeletonLine.setModelBound((BoundingVolume)new BoundingSphere());
            int[] parents = instance.getModelSkeletal().getSkeleton().getParents();
            int count = parents.length * 2;
            for (int i = 0; i < parents.length; ++i) {
                if (parents[i] >= 0) continue;
                count -= 2;
            }
            Vector3f[] vertices = new Vector3f[count];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = new Vector3f();
            }
            this.skeletonLine.setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])vertices));
            this.attachChild((Spatial)this.skeletonLine);
            String[] names = instance.getModelSkeletal().getSkeleton().getJointNames();
            this.textNodes = new Spatial[names.length];
            for (int i = 0; i < names.length; ++i) {
                BillboardNode node = new BillboardNode(names[i]);
                Text text = new Text(names[i], names[i]);
                text.setRenderQueueMode(0);
                node.attachChild((Spatial)text);
                text.setLocalScale(0.1f);
                this.textNodes[i] = node;
                this.attachChild((Spatial)node);
            }
            this.skeletonLine.setTextureCombineMode(0);
            this.update(instance);
        }

        private void update(SkeletalModelInstance instance) {
            int[] parents = instance.getModelSkeletal().getSkeleton().getParents();
            int pos = 0;
            Vector3f[] bones = BufferUtils.getVector3Array((FloatBuffer)this.skeletonLine.getVertexBuffer(0));
            for (int i = 0; i < parents.length; ++i) {
                if (parents[i] < 0) continue;
                instance.jointTransform[parents[i]].getTranslation(bones[pos++]);
                instance.jointTransform[i].getTranslation(bones[pos++]);
            }
            this.skeletonLine.updateModelBound();
            this.updateModelBound();
            this.updateGeometricState(0.0f, true);
            Vector3f temp = new Vector3f();
            for (int i = 0; i < this.textNodes.length; ++i) {
                instance.jointTransform[i].getTranslation(temp);
                this.textNodes[i].getLocalTranslation().set(temp);
            }
        }
    }
}

