/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.jme.math.TransformMatrix;
import com.jme.math.Vector2f;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import model.ModelTriMesh;
import util.file.FileUtils;

public abstract class Mesh
implements Externalizable {
    private String name;

    public Mesh(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getTextureCount();

    public abstract int[] getTriangleCornerArray();

    public abstract IntBuffer getTriangleCorners();

    public abstract int getVertexCount();

    public abstract FloatBuffer getVertexTextureBuffer(int var1);

    public abstract Vector2f[] getVertexTextureCoords(int var1);

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileUtils.checkVersionByte(in, 1, 1);
        this.name = in.readUTF();
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void skinMesh(ModelTriMesh var1, TransformMatrix[] var2, boolean var3);

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeUTF(this.name);
    }
}

