/*
 * Decompiled with CFR 0.152.
 */
package md5reader.defs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import md5reader.MD5AnimReader;
import md5reader.MD5MeshReader;
import md5reader.defs.D3Item;
import md5reader.defs.DefStore;
import model.Model;
import model.animation.Animation;

public class ModelDef
extends D3Item {
    private String parent;
    private String modelName;
    private Model realModel;
    private Map animations;
    private Map realAnimations = new HashMap();

    public ModelDef(DefStore store, String name, String parent, String modelName, Map animations) {
        super(store, name);
        this.parent = parent;
        this.modelName = modelName;
        this.animations = animations;
    }

    public String getModelName() {
        if (this.modelName != null) {
            return this.modelName;
        }
        ModelDef parent = this.getStore().getModelDef(this.parent);
        if (parent != null) {
            return parent.getModelName();
        }
        return null;
    }

    public Model getModel() throws IOException {
        if (this.realModel != null) {
            return this.realModel;
        }
        Model parentModel = null;
        ModelDef parent = this.getStore().getModelDef(this.parent);
        if (parent != null) {
            parentModel = parent.getModel();
        }
        if (this.modelName == null) {
            return parentModel;
        }
        if (!this.modelName.endsWith(".md5mesh")) {
            throw new IOException("No MD5 model, and .lwo cannot be loaded");
        }
        InputStream in = this.getStore().getInputStream(this.modelName);
        if (in == null) {
            throw new IOException("Model file not found");
        }
        MD5MeshReader reader = new MD5MeshReader();
        reader.setProperty("skin.classloader", this.getStore().makeClassLoader());
        this.realModel = reader.readModel(in);
        return this.realModel;
    }

    private Animation loadAnimation(String name) throws IOException {
        if (name == null) {
            return null;
        }
        InputStream in = this.getStore().getInputStream(name);
        if (in == null) {
            throw new FileNotFoundException("cannot find animation: " + name);
        }
        MD5AnimReader reader = new MD5AnimReader();
        return reader.readAnimation(in);
    }

    public Animation getAnimation(String name) throws IOException {
        if (this.realAnimations.containsKey(name)) {
            return (Animation)this.realAnimations.get(name);
        }
        if (this.animations.containsKey(name)) {
            Animation anim = this.loadAnimation((String)this.animations.get(name));
            this.realAnimations.put(name, anim);
            return anim;
        }
        ModelDef parent = this.getStore().getModelDef(this.parent);
        if (parent != null) {
            return parent.getAnimation(name);
        }
        return null;
    }

    public Set getAnimationNames() {
        return this.getAnimationNames(new HashSet());
    }

    public Set getAnimationNames(Set set) {
        ModelDef parent = this.getStore().getModelDef(this.parent);
        if (parent != null) {
            parent.getAnimationNames(set);
        }
        for (String key : this.animations.keySet()) {
            if (this.animations.get(key) != null) {
                set.add(key);
                continue;
            }
            set.remove(key);
        }
        return set;
    }
}

