/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.image.Texture;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Matrix3f;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import model.ModelTriMesh;
import model.Shader;

public class MD5DOT3BumpShader
extends Shader {
    private TextureState state = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
    public static float pos;

    public MD5DOT3BumpShader(Texture detail, Texture normalMap) {
    }

    @Override
    public void setup(ModelTriMesh mesh) {
        mesh.setRenderState((RenderState)this.state);
        mesh.setTextureBuffer(2, mesh.getTextureBuffer(0, 0));
        mesh.setLightCombineMode(0);
    }

    @Override
    public void updateMesh(ModelTriMesh mesh) {
        this.updateLightVectors(mesh);
    }

    @Override
    public boolean requiresNormals() {
        return false;
    }

    private void updateLightVectorsToNormals(ModelTriMesh mesh) {
        ColorRGBA[] colors = this.clearLightVectors(mesh);
        for (int i = 0; i < colors.length; ++i) {
            colors[i].r = 0.0f;
            colors[i].g = 0.0f;
            colors[i].b = 1.0f;
        }
    }

    private ColorRGBA[] clearLightVectors(ModelTriMesh mesh) {
        ColorRGBA[] lightVectors = BufferUtils.getColorArray((FloatBuffer)mesh.getColorBuffer(0));
        if (lightVectors == null) {
            lightVectors = new ColorRGBA[mesh.getVertexCount()];
            mesh.setColorBuffer(0, BufferUtils.createFloatBuffer((ColorRGBA[])lightVectors));
            for (int i = 0; i < lightVectors.length; ++i) {
                lightVectors[i] = new ColorRGBA();
            }
        } else {
            for (int i = 0; i < lightVectors.length; ++i) {
                lightVectors[i].set(ColorRGBA.black);
            }
        }
        return lightVectors;
    }

    private void updateLightVectors(ModelTriMesh mesh) {
        Vector3f lightVector;
        Light light = this.getLight(mesh);
        switch (light.getType()) {
            case 0: {
                lightVector = ((DirectionalLight)light).getDirection().negate();
                break;
            }
            case 1: 
            case 2: {
                lightVector = new Vector3f(((PointLight)light).getLocation());
                break;
            }
            default: {
                return;
            }
        }
        lightVector.subtractLocal(mesh.getWorldTranslation());
        mesh.getWorldRotation().multLocal(lightVector);
        lightVector.divideLocal(mesh.getWorldScale());
        Vector3f[] vertices = BufferUtils.getVector3Array((FloatBuffer)mesh.getVertexBuffer(0));
        Vector2f[] textures = BufferUtils.getVector2Array((FloatBuffer)mesh.getTextureBuffer(0, 3));
        int[] indices = BufferUtils.getIntArray((IntBuffer)mesh.getIndexBuffer(0));
        Vector2f t12 = new Vector2f();
        Vector2f t13 = new Vector2f();
        Vector3f v12 = new Vector3f();
        Vector3f v13 = new Vector3f();
        Vector3f t1 = new Vector3f();
        Vector3f b1 = new Vector3f();
        Vector3f t2 = new Vector3f();
        Vector3f b2 = new Vector3f();
        Vector3f n = new Vector3f();
        Vector3f texLightVector = new Vector3f();
        ColorRGBA[] lightVectors = this.clearLightVectors(mesh);
        for (int off = 0; off < indices.length; off += 3) {
            int index1 = indices[off];
            int index2 = indices[off + 1];
            int index3 = indices[off + 2];
            v12.set(vertices[index2]).subtractLocal(vertices[index1]);
            v13.set(vertices[index3]).subtractLocal(vertices[index1]);
            t12.set(textures[index2]).subtractLocal(textures[index1]);
            t13.set(textures[index3]).subtractLocal(textures[index1]);
            float det = 1.0f / (t12.x * t13.y - t13.x * t12.y);
            t1.set(v12).multLocal(t13.y);
            t2.set(v13).multLocal(t12.y);
            t1.subtractLocal(t2).multLocal(det);
            b1.set(v13).multLocal(t12.x);
            b2.set(v12).multLocal(t13.x);
            b1.subtractLocal(b2).multLocal(det);
            Vector3f b = v12.mult(-t13.x).add(v13.mult(t12.x)).mult(det);
            n.set(v12).crossLocal(v13);
            b1.normalizeLocal();
            t1.normalizeLocal();
            n.normalizeLocal();
            Matrix3f matrix = new Matrix3f(t1.x, b1.x, n.x, t1.y, b1.y, n.y, t1.z, b1.z, n.z);
            matrix.invertLocal();
            for (int i = 0; i < 3; ++i) {
                int index = indices[off + i];
                ColorRGBA color = lightVectors[index];
                texLightVector.set(lightVector);
                if (light.getType() != 0) {
                    texLightVector.subtractLocal(vertices[index]);
                }
                matrix.multLocal(texLightVector.normalizeLocal()).normalizeLocal();
                color.r += texLightVector.x;
                color.g += texLightVector.y;
                color.b += texLightVector.z;
            }
        }
        for (int i = 0; i < lightVectors.length; ++i) {
            ColorRGBA color = lightVectors[i];
            float x = color.r;
            float y = color.g;
            float z = color.b;
            float det = x * x + y * y + z * z;
            if (det != 0.0f) {
                det = (float)Math.sqrt(det) * 2.0f;
                color.r = 0.5f + x / det;
                color.g = 0.5f + y / det;
                color.b = 0.5f + z / det;
                continue;
            }
            color.r = 0.5f;
            color.g = 0.5f;
            color.b = 0.5f;
        }
    }

    private Light getLight(TriMesh mesh) {
        PointLight plight = new PointLight();
        plight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        plight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        plight.setLocation(new Vector3f((float)Math.sin(pos) * 100.0f, 10.0f, (float)Math.cos(pos) * 100.0f));
        return plight;
    }

    public void preRender(ModelTriMesh mesh) {
    }
}

