/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import md5reader.MD5Scanner;

public class AbstractD3Reader {
    public static final int EOF = 0;
    public static final int FLOAT = 1;
    public static final int INT = 2;
    public static final int TEXT = 3;
    public static final int OPENBRACKET = 4;
    public static final int CLOSEBRACKET = 5;
    public static final int OPENSEGMENT = 6;
    public static final int CLOSESEGMENT = 7;
    protected static final Quaternion BASE = new Quaternion(-0.5f, -0.5f, -0.5f, 0.5f);
    private static final String[] TYPE = new String[]{"EOF", "float", "int", "text", "open bracket", "close bracket", "open segment", "close segment"};
    private MD5Scanner scanner;

    public AbstractD3Reader() {
    }

    public AbstractD3Reader(Reader reader) {
        this.setReader(reader);
    }

    public AbstractD3Reader(InputStream in) throws IOException {
        this.setInputStream(in);
    }

    protected void setReader(Reader reader) {
        this.scanner = reader != null ? new MD5Scanner(reader) : null;
    }

    protected void setInputStream(InputStream in) throws IOException {
        this.scanner = in != null ? new MD5Scanner(new InputStreamReader(in, "US-ASCII")) : null;
    }

    protected int line() {
        return this.scanner.getLine() + 1;
    }

    protected String readStringStartOfLine() throws IOException {
        if (!this.skipStartOfLine(3, -1)) {
            return null;
        }
        return this.scanner.asString();
    }

    protected Vector3f readVector3fStartOfLine() throws IOException {
        if (!this.skipStartOfLine(4, -1)) {
            return null;
        }
        Vector3f vec = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
        this.skip(5);
        return vec;
    }

    protected float readFloatStartOfLine() throws IOException {
        if (!this.skipStartOfLine(1, 2)) {
            return Float.NaN;
        }
        return this.scanner.asFloat();
    }

    protected int readInt() throws IOException {
        this.skip(2);
        return this.scanner.asInt();
    }

    protected float readFloat() throws IOException {
        this.checkType(this.scanner.nextToken(), 1, 2);
        return this.scanner.asFloat();
    }

    protected String readString() throws IOException {
        this.checkType(this.scanner.nextToken(), 3);
        return this.scanner.asString();
    }

    protected int readPositiveInt() throws IOException {
        int value = this.readInt();
        if (value < 0) {
            throw new IOException("Expected positive int at line " + this.line());
        }
        return value;
    }

    protected void skipRestOfSection() throws IOException {
        int depth = 1;
        int type = this.scanner.nextToken();
        while (depth > 0) {
            if (type == 6) {
                ++depth;
            } else if (type == 7) {
                --depth;
            } else if (type == 0) {
                throw new EOFException("Unexpected EOF");
            }
            if (depth <= 0) continue;
            type = this.scanner.nextToken();
        }
    }

    protected void skipRestOfBlock() throws IOException {
        int depth = 1;
        int type = this.scanner.nextToken();
        while (depth > 0) {
            if (type == 4) {
                ++depth;
            } else if (type == 5) {
                --depth;
            } else if (type == 0) {
                throw new EOFException("Unexpected EOF");
            }
            if (depth <= 0) continue;
            type = this.scanner.nextToken();
        }
    }

    protected void skip(int type) throws IOException {
        this.checkType(this.scanner.nextToken(), type);
    }

    protected boolean skipStartOfLine(int type1, int type2) throws IOException {
        int read = this.scanner.nextToken();
        if (read == 7 || read == 0) {
            return false;
        }
        this.checkType(read, type1, type2);
        return true;
    }

    private void checkType(int found, int expected) throws IOException {
        if (found != expected) {
            throw new IOException("Expected type " + TYPE[expected] + " but found " + TYPE[found] + " at line " + this.line());
        }
    }

    private void checkType(int found, int expected1, int expected2) throws IOException {
        if (found != expected1 && found != expected2) {
            if (expected2 == -1) {
                this.checkType(found, expected1);
            } else {
                throw new IOException("Expected type " + TYPE[expected1] + " or " + TYPE[expected2] + " but found " + TYPE[found] + " at line " + this.line());
            }
        }
    }

    protected int read() throws IOException {
        return this.scanner.nextToken();
    }

    protected Vector3f readVector3f() throws IOException {
        this.skip(4);
        Vector3f vec = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
        this.skip(5);
        return vec;
    }

    protected Vector2f readVector2f() throws IOException {
        this.skip(4);
        Vector2f vec = new Vector2f(this.readFloat(), this.readFloat());
        this.skip(5);
        return vec;
    }

    protected Quaternion makeQuaternion(float x, float y, float z) {
        float term = 1.0f - x * x - y * y - z * z;
        float w = term < 0.0f ? 0.0f : (float)(-Math.sqrt(term));
        Quaternion q = new Quaternion(x, y, z, w);
        return q;
    }

    protected Quaternion readQuaternion() throws IOException {
        this.skip(4);
        Quaternion result = this.makeQuaternion(this.readFloat(), this.readFloat(), this.readFloat());
        this.skip(5);
        return result;
    }

    protected float asFloat() {
        return this.scanner.asFloat();
    }

    protected int asInt() {
        return this.scanner.asInt();
    }

    protected String asString() {
        return this.scanner.asString();
    }
}

