/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.net.URL;
import java.nio.FloatBuffer;

public class ProgressBar {
    private Node hudNode = new Node("hudNode");
    private Quad gauge;
    private Quad hudQuad = new Quad("hud", 34.0f, 10.0f);
    private int textureWidth;
    private int textureHeight;
    private int minimum = 0;
    private int maximum = 100;
    private int widthScale = 0;
    private int heightScale = 0;
    private int xpos = 0;
    private int ypos = 0;
    private final int width = 34;
    private final int height = 10;

    public ProgressBar(DisplaySystem displaySystem) {
        this.hudNode.getLocalTranslation().x = this.xpos;
        this.hudNode.getLocalTranslation().y = this.ypos;
        this.gauge = new Quad("gauge", 32.0f, 8.0f);
        this.gauge.setRenderQueueMode(4);
        LightState lightState = displaySystem.getRenderer().createLightState();
        lightState.setEnabled(false);
        this.hudNode.setRenderState((RenderState)lightState);
        this.hudNode.updateRenderState();
        this.hudNode.attachChild((Spatial)this.hudQuad);
        this.hudNode.attachChild((Spatial)this.gauge);
        TextureState textureState = displaySystem.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)this.getClass().getClassLoader().getResource("utils/hudtutorial3.png"), (int)2, (int)1, (float)0.0f, (boolean)true));
        this.textureWidth = textureState.getTexture().getImage().getWidth();
        this.textureHeight = textureState.getTexture().getImage().getHeight();
        textureState.setEnabled(true);
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer((int)4);
        floatBuffer.put(this.getUForPixel(0.0f)).put(this.getVForPixel(0.0f));
        floatBuffer.put(this.getUForPixel(0.0f)).put(this.getVForPixel(10.0f));
        floatBuffer.put(this.getUForPixel(34.0f)).put(this.getVForPixel(10.0f));
        floatBuffer.put(this.getUForPixel(34.0f)).put(this.getVForPixel(0.0f));
        this.hudQuad.setTextureBuffer(0, floatBuffer);
        this.hudNode.setRenderState((RenderState)textureState);
        AlphaState alphaState = displaySystem.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(false);
        alphaState.setEnabled(true);
        this.hudNode.setRenderState((RenderState)alphaState);
    }

    public int getWidth() {
        return 34 * this.widthScale;
    }

    public int getHeight() {
        return 10 * this.heightScale;
    }

    private float getUForPixel(float f) {
        return f / (float)this.textureWidth;
    }

    private float getVForPixel(float f) {
        return 1.0f - f / (float)this.textureHeight;
    }

    public Node getNode() {
        return this.hudNode;
    }

    public void setPosition(int n, int n2) {
        this.hudNode.getLocalTranslation().x = n;
        this.hudNode.getLocalTranslation().y = n2;
    }

    public void setGauge(int n) {
        float f = this.maximum - this.minimum;
        float f2 = n - this.minimum;
        float f3 = f2 / f;
        float f4 = 32.0f * f3;
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer((int)4);
        floatBuffer.put(this.getUForPixel(32.0f - f4)).put(this.getVForPixel(56.0f));
        floatBuffer.put(this.getUForPixel(32.0f - f4)).put(this.getVForPixel(64.0f));
        floatBuffer.put(this.getUForPixel(64.0f - f4)).put(this.getVForPixel(64.0f));
        floatBuffer.put(this.getUForPixel(64.0f - f4)).put(this.getVForPixel(56.0f));
        this.gauge.setTextureBuffer(0, floatBuffer);
    }

    public void setMinimum(int n) {
        this.minimum = n;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    public void setScale(int n, int n2) {
        this.widthScale = n;
        this.heightScale = n2;
        this.hudNode.setLocalScale(new Vector3f((float)this.widthScale, (float)this.heightScale, 1.0f));
    }

    private int getScaleWidth() {
        return this.widthScale;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }
}

