/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.SharedNode;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Dome;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.converters.MHObjToJme;
import com.jmex.model.converters.ObjToJme;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class JMUtils {
    public static TextureState loadTexture(File file, boolean bl) throws IOException {
        return JMUtils.loadTexture(ImageIO.read(file), bl);
    }

    public static TextureState loadTexture(Image image, boolean bl) throws IOException {
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((Image)image, (int)2, (int)2, (float)1.0f, (boolean)bl);
        textureState.setTexture(texture);
        return textureState;
    }

    public static int[][] loadCSV(Reader reader) {
        Object object = null;
        try {
            List list = IOUtils.readLines((Reader)reader);
            object = new int[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray = ((String)list.get(i)).split(",");
                object[i] = new int[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    object[i][j] = Integer.parseInt(stringArray[j]);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public static TextureState loadTexture(String string, boolean bl) throws IOException {
        URL uRL = JMUtils.class.getClassLoader().getResource(string);
        return JMUtils.loadTexture(ImageIO.read(uRL), bl);
    }

    public static Light createLight(Vector3f vector3f) {
        PointLight pointLight = new PointLight();
        pointLight.setLocation(vector3f);
        pointLight.setDiffuse(ColorRGBA.white);
        pointLight.setEnabled(true);
        return pointLight;
    }

    public static TextureState loadWrapTexture(File file, boolean bl) throws IOException {
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((Image)ImageIO.read(file), (int)2, (int)2, (float)1.0f, (boolean)bl);
        texture.setWrap(3);
        textureState.setTexture(texture);
        return textureState;
    }

    public static TextureState loadWrapTexture(String string, boolean bl) throws IOException {
        URL uRL = JMUtils.class.getClassLoader().getResource(string);
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((Image)ImageIO.read(uRL), (int)2, (int)2, (float)1.0f, (boolean)bl);
        texture.setWrap(3);
        textureState.setTexture(texture);
        return textureState;
    }

    public static void rotateX(Spatial spatial, float f) {
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(1.0f, 0.0f, 0.0f));
        spatial.setLocalRotation(quaternion);
    }

    public static void rotateY(Spatial spatial, float f) {
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(0.0f, 1.0f, 0.0f));
        spatial.setLocalRotation(quaternion);
    }

    public static Quaternion getRotate(float f, float f2, float f3) {
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles((float)Math.PI / 180 * f, (float)Math.PI / 180 * f2, (float)Math.PI / 180 * f3);
        return quaternion;
    }

    public static Quaternion getRotateY(float f) {
        f = JMUtils.toValidValue(f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(0.0f, 1.0f, 0.0f));
        return quaternion;
    }

    public static Quaternion getRotateX(float f) {
        f = JMUtils.toValidValue(f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(1.0f, 0.0f, 0.0f));
        return quaternion;
    }

    public static Quaternion getRotateZ(float f) {
        f = JMUtils.toValidValue(f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(0.0f, 0.0f, 1.0f));
        return quaternion;
    }

    public static void rotateZ(Spatial spatial, float f) {
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(0.0f, 0.0f, 1.0f));
        spatial.setLocalRotation(quaternion);
    }

    public static void setAlphaState(Spatial spatial) {
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        spatial.setRenderState((RenderState)alphaState);
    }

    public static void setEmissiveState(Spatial spatial, int n, int n2, int n3) {
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setEmissive(new ColorRGBA((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f));
        spatial.setRenderState((RenderState)materialState);
    }

    public static void setDiffuseState(Spatial spatial, int n, int n2, int n3) {
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setDiffuse(new ColorRGBA((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f));
        spatial.setRenderState((RenderState)materialState);
    }

    public static Node loadMHModel(String string) throws IOException {
        URL uRL = JMUtils.class.getClassLoader().getResource(string);
        MHObjToJme mHObjToJme = new MHObjToJme();
        mHObjToJme.setProperty("mtllib", uRL);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mHObjToJme.convert(uRL.openStream(), byteArrayOutputStream);
        return (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public static Node loadNodeModel(String string) throws IOException {
        URL uRL = JMUtils.class.getClassLoader().getResource(string);
        ObjToJme objToJme = new ObjToJme();
        objToJme.setProperty("mtllib", (Object)uRL);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        objToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
        return (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public static Vector3f createDirection(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        vector3f3.set(vector3f).subtractLocal(vector3f2).normalizeLocal();
        return vector3f3;
    }

    public static TriMesh loadTriMesh(String string) throws IOException {
        URL uRL = JMUtils.class.getClassLoader().getResource(string);
        ObjToJme objToJme = new ObjToJme();
        objToJme.setProperty("mtllib", (Object)uRL);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        objToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
        return (TriMesh)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public static Box createBox(String string) {
        Box box = new Box(string, new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        return box;
    }

    public static Dome createDome(String string) {
        return new Dome(string, 3, 30, 1.0f);
    }

    public static int angleInt(float f, float f2, float f3, float f4) {
        float f5 = JMUtils.angleRadius(f, f2, f3, f4);
        int n = (int)(f5 / ((float)Math.PI / 180));
        if (n < 0) {
            n += 360;
        }
        return n;
    }

    public static float angleRadius(float f, float f2, float f3, float f4) {
        float f5 = f - f3;
        float f6 = f2 - f4;
        double d = 0.0;
        if (f5 == 0.0f) {
            d = f6 == 0.0f ? 0.0 : (f6 > 0.0f ? 1.5707963705062866 : 4.71238899230957);
        } else {
            d = FastMath.atan((float)(f6 / Math.abs(f5)));
            if (f5 < 0.0f) {
                d = 3.1415927410125732 - d;
            } else if (f6 < 0.0f) {
                d = 6.2831854820251465 + d;
            }
        }
        return (float)d;
    }

    public static Vector3f getAngleAtY(float f, float f2) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        float f3 = f2 * FastMath.cos((float)((float)Math.PI / 180 * f));
        float f4 = f2 * FastMath.sin((float)((float)Math.PI / 180 * f));
        return new Vector3f(f4, 0.0f, f3);
    }

    public static float getLineAngle(float f, float f2, float f3, float f4) {
        float f5 = JMUtils.angleRadius(f4, f3, f2, f);
        float f6 = f5 / ((float)Math.PI / 180);
        if ((f6 %= 360.0f) < 0.0f) {
            f6 += 360.0f;
        }
        return f6;
    }

    public static Vector3f get2DAngleAt(float f, float f2) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        float f3 = f2 * FastMath.cos((float)((float)Math.PI / 180 * f));
        float f4 = f2 * FastMath.sin((float)((float)Math.PI / 180 * f));
        return new Vector3f(f3, 0.0f, f4);
    }

    public static void shuffle(int[] nArray) {
        Random random = new Random();
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n = random.nextInt(nArray.length - i);
            int n2 = nArray[i + n];
            nArray[i + n] = nArray[i];
            nArray[i] = n2;
        }
    }

    public static void shuffle(Object[] objectArray) {
        Random random = new Random();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = random.nextInt(objectArray.length - i);
            Object object = objectArray[i + n];
            objectArray[i + n] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public static Node getSharedNode(Node node, String string) {
        SharedNode sharedNode = new SharedNode(string, node);
        sharedNode.setName(string);
        for (int i = 0; i < sharedNode.getQuantity(); ++i) {
        }
        sharedNode.updateModelBound();
        return sharedNode;
    }

    public static Node getClodNodeFromParent(Node node, String string) {
        Node node2 = new Node(string);
        for (int i = 0; i < node.getQuantity(); ++i) {
            Spatial spatial = node.getChild(i);
            if (spatial instanceof Node) {
                node2.attachChild((Spatial)JMUtils.getClodNodeFromParent((Node)spatial, string));
                continue;
            }
            if (!(spatial instanceof TriMesh)) continue;
            AreaClodMesh areaClodMesh = new AreaClodMesh(spatial.getName(), (TriMesh)spatial, null);
            areaClodMesh.setModelBound((BoundingVolume)new BoundingBox());
            areaClodMesh.updateModelBound();
            areaClodMesh.setTrisPerPixel(0.5f);
            areaClodMesh.setRenderState(spatial.getRenderState(4));
            areaClodMesh.setRenderState(spatial.getRenderState(6));
            node2.attachChild((Spatial)areaClodMesh);
        }
        return node2;
    }

    public static Node createWall(int n, int n2, int n3) {
        return JMUtils.createWall(n, n2, n3, 40);
    }

    public static Node createWall(int n, int n2, int n3, int n4) {
        Node node = new Node("wall");
        int n5 = 10;
        Box box = new Box("wall1", new Vector3f((float)(-n5), 0.0f, (float)(-n4)), new Vector3f(0.0f, (float)n2, (float)n3));
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        node.attachChild((Spatial)box);
        Box box2 = new Box("wall2", new Vector3f((float)(-n4), 0.0f, (float)(-n5)), new Vector3f((float)n, (float)n2, 0.0f));
        box2.setModelBound((BoundingVolume)new BoundingBox());
        box2.updateModelBound();
        node.attachChild((Spatial)box2);
        Box box3 = new Box("wall3", new Vector3f((float)(n - n4), 0.0f, (float)(-n4)), new Vector3f((float)(n + n5), (float)n2, (float)n3));
        box3.setModelBound((BoundingVolume)new BoundingBox());
        box3.updateModelBound();
        node.attachChild((Spatial)box3);
        Box box4 = new Box("wall4", new Vector3f((float)(-n4), 0.0f, (float)(n3 - n4)), new Vector3f((float)n, (float)n2, (float)(n3 + n5)));
        box4.setModelBound((BoundingVolume)new BoundingBox());
        box4.updateModelBound();
        node.attachChild((Spatial)box4);
        return node;
    }

    public static SceneElement findCollision(List<SceneElement> list, BoundingVolume boundingVolume) {
        SceneElement sceneElement = null;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getWorldBound() == null || boundingVolume == list.get(i).getWorldBound() || !list.get(i).getWorldBound().intersects(boundingVolume)) continue;
            sceneElement = list.get(i);
            break;
        }
        return sceneElement;
    }

    public static SceneElement findCollision(List<SceneElement> list, Ray ray, float f) {
        SceneElement sceneElement = null;
        for (int i = 0; i < list.size(); ++i) {
            float f2;
            if (list.get(i).getWorldBound() == null || !list.get(i).getWorldBound().intersects(ray) || !((f2 = list.get(i).getWorldBound().distanceTo(ray.getOrigin())) < f)) continue;
            sceneElement = list.get(i);
            break;
        }
        return sceneElement;
    }

    public static SceneElement findCollision(List<SceneElement> list, Vector3f vector3f) {
        SceneElement sceneElement = null;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getWorldBound() == null || !list.get(i).getWorldBound().contains(vector3f)) continue;
            sceneElement = list.get(i);
            break;
        }
        return sceneElement;
    }

    public static float getAngleY(Quaternion quaternion) {
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        float f = quaternion.toAngleAxis(vector3f);
        float f2 = quaternion.toAngles((float[])null)[1] / ((float)Math.PI / 180);
        if (f2 < 0.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static float getAngleX(Quaternion quaternion) {
        Vector3f vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
        quaternion.toAngleAxis(vector3f);
        float f = quaternion.toAngles((float[])null)[0] / ((float)Math.PI / 180);
        if (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static Vector3f getDirection(Quaternion quaternion) {
        return quaternion.getRotationColumn(2);
    }

    public static int toInt(float f) {
        BigDecimal bigDecimal = new BigDecimal(f);
        float f2 = bigDecimal.setScale(1, 4).floatValue();
        return (int)f2;
    }

    public static float getAngleY(Spatial spatial) {
        Quaternion quaternion = new Quaternion(spatial.getLocalRotation());
        return JMUtils.getAngleY(quaternion);
    }

    public static int[] getIntAngles(Spatial spatial) {
        int[] nArray = new int[3];
        Quaternion quaternion = new Quaternion(spatial.getLocalRotation());
        Vector3f vector3f = new Vector3f(1.0f, 1.0f, 1.0f);
        quaternion.toAngleAxis(vector3f);
        for (int i = 0; i < nArray.length; ++i) {
            BigDecimal bigDecimal = new BigDecimal(quaternion.toAngles((float[])null)[i] / ((float)Math.PI / 180));
            float f = bigDecimal.setScale(1, 4).floatValue();
            if (f < 0.0f) {
                f += 360.0f;
            } else if (f > 360.0f) {
                f -= 360.0f;
            }
            nArray[i] = (int)f;
        }
        return nArray;
    }

    public static Quaternion getCameraRotation(Camera camera) {
        Quaternion quaternion = new Quaternion();
        Vector3f[] vector3fArray = new Vector3f[]{camera.getLeft(), camera.getUp(), camera.getDirection()};
        quaternion.fromAxes(vector3fArray);
        return quaternion;
    }

    public static float toValidValue(float f) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static LightState getLightState(Vector3f vector3f) {
        PointLight pointLight = new PointLight();
        pointLight.setLocation(vector3f);
        pointLight.setAmbient(ColorRGBA.white);
        pointLight.setEnabled(true);
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.attach((Light)pointLight);
        return lightState;
    }

    public static Vector3f toVector3f(String string) {
        String[] stringArray = string.split(" ");
        Vector3f vector3f = new Vector3f();
        if (stringArray.length == 3) {
            vector3f.x = Float.parseFloat(stringArray[0]);
            vector3f.y = Float.parseFloat(stringArray[1]);
            vector3f.z = Float.parseFloat(stringArray[2]);
        }
        return vector3f;
    }

    public static Quaternion toQuaternion(String string) {
        String[] stringArray = string.split(" ");
        Quaternion quaternion = new Quaternion();
        if (stringArray.length == 4) {
            quaternion.x = (float)Double.parseDouble(stringArray[0]);
            quaternion.y = (float)Double.parseDouble(stringArray[1]);
            quaternion.z = (float)Double.parseDouble(stringArray[2]);
            quaternion.w = (float)Double.parseDouble(stringArray[3]);
        }
        return quaternion;
    }

    public static Matrix3f toMatrix3f(String string) {
        String[] stringArray = string.split(" ");
        Matrix3f matrix3f = new Matrix3f();
        if (stringArray.length == 9) {
            float[] fArray = new float[9];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)Double.parseDouble(stringArray[i]);
            }
            matrix3f.set(fArray);
        }
        return matrix3f;
    }

    public static String toAngleString(Quaternion quaternion) {
        float[] fArray = quaternion.toAngles(null);
        int n = 0;
        while (n < 3) {
            int n2 = n++;
            fArray[n2] = fArray[n2] * 57.295776f;
        }
        return "angle:x=" + fArray[0] + " y=" + fArray[1] + " z=" + fArray[2];
    }

    public static String toAngleString(Vector3f vector3f, Vector3f vector3f2) {
        Quaternion quaternion = new Quaternion();
        Vector3f vector3f3 = vector3f.subtract(vector3f2);
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), vector3f3};
        quaternion.fromAxes(vector3fArray);
        return JMUtils.toAngleString(quaternion);
    }
}

