/*
 * Decompiled with CFR 0.152.
 */
package motiontools.studio;

import bone.BoneInfoDataHash;
import bone.BonePoseInfo;
import bone.BonePoseInfoData;
import bone.BonePoseInfoPanel;
import com.jme.animation.Bone;
import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.FirstPersonHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.MouseInput;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.CameraNode;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.util.GameTaskQueueManager;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.effects.glsl.BloomRenderPass;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.motiontools.Messages;
import md5reader.MD5MeshReader;
import model.KeyFrame;
import model.Model;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.SkeletalModelInstance;
import model.Skeleton;
import model.animation.Animation;
import model.animation.AnimationAnimator;
import model.animation.AnimationController;
import model.animation.SkeletalAnimation;
import motiontools.PoseBoneInfoDataHashContainer;
import motiontools.poseEditor.PoseEditorSwingWindow;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import utils.JMUtils;

public class Studio
extends SimplePassGame
implements PoseBoneInfoDataHashContainer {
    private static final int MAX_RANDOMLEVEL = 50;
    private static final Logger logger = Logger.getLogger(Studio.class.getName());
    private BonePoseInfoPanel boneInfoRootPanel;
    private JPanel boneInfoButtonList;
    private Node guiNode;
    private boolean boneOn;
    Node sceneRootNode;
    private JPanel infoCardLayoutPanel;
    private CardLayout infoCardLayout;
    private JCheckBox overwrite;
    private JTextField fileName;
    SkeletalModel skeltonModel;
    private AnimationController bodyAnimator;
    private SkeletalModelInstance bodyInstance;
    private Animation bodyAnimation;
    private AnimationAnimator animationAnimator;
    private SkeletalKeyFrame baseKeyFrame;
    private BonePoseInfoPanel boneInfoPanel;
    private JSlider randomLevel;
    private final int MAX_POSE_STEPS = 100;
    private JSlider poseStepsSlider;
    private int currentPoseSteps;
    private List lastOpenedData;
    private BloomRenderPass bloomRenderPass;
    private BoneInfoDataHash randomPoseDataHash;
    private BoneInfoDataHash animePoseDataHash;
    private Map<String, BonePoseInfo> boneInfoMap = new HashMap<String, BonePoseInfo>();
    private boolean enableShortcut = true;
    private Point lastClicked = new Point(0, 0);
    JFrame boneControlerFrame;
    PoseEditorSwingWindow settingFrame;
    private boolean modelLoaded;
    private boolean doAnimation;
    float angle = 0.0f;
    float add = 1.0f;
    private BoneInfoDataHash poseInfoDataHash = new BoneInfoDataHash(new HashMap());
    private boolean doShot = false;
    private JMEDesktop desktop;
    private float blenderTurn = -90.0f;
    private float cameraNodeAngleY = 0.0f;
    private float cameraNodeAngleX = 0.0f;
    private float cameraNodeAngleZ = 0.0f;
    private float cameraNodeAngleAdd = 5.0f;
    private Quaternion blender90turn = new Quaternion(new float[]{0.0f, -1.5707964f, 0.0f});
    private Quaternion cameraAngle = new Quaternion();
    private boolean visibleControls = true;
    private CameraNode cameraNode;
    private Quad backgroundGuad;

    public static void main(String[] stringArray) {
        Studio studio = new Studio();
        studio.setDialogBehaviour(2);
        studio.start();
    }

    public void openData(InputStream inputStream) {
        try {
            List list = IOUtils.readLines((InputStream)inputStream);
            this.openData(list);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static BoneInfoDataHash loadDataHash(File file) {
        try {
            String string;
            List list = IOUtils.readLines((InputStream)new FileInputStream(file));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals("#end_data"); ++i) {
                String[] stringArray;
                if (!string.startsWith("#") || string.indexOf("=") == -1 || (stringArray = string.substring(1).split("=")).length <= 1) continue;
                hashMap.put(stringArray[0], stringArray[1]);
                System.out.println("pud-data:" + stringArray[0] + "," + stringArray[1]);
            }
            return new BoneInfoDataHash(hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void openData(List list) {
        this.lastOpenedData = list;
        try {
            String[] stringArray;
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals("#end_data"); ++i) {
                if (!string.startsWith("#") || string.indexOf("=") == -1 || (stringArray = string.substring(1).split("=")).length <= 1) continue;
                hashMap.put(stringArray[0], stringArray[1]);
                System.out.println("pud-data:" + stringArray[0] + "," + stringArray[1]);
            }
            this.poseInfoDataHash = new BoneInfoDataHash(hashMap);
            String[] stringArray2 = this.getBoneKeyNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = this.findBonePoseInfo(stringArray2[i]);
                if (stringArray != null) {
                    JButton jButton;
                    stringArray.setAngleX(this.poseInfoDataHash.getRotX(stringArray2[i], (int)stringArray.getAngleX()));
                    stringArray.setAngleY(this.poseInfoDataHash.getRotY(stringArray2[i], (int)stringArray.getAngleY()));
                    stringArray.setAngleZ(this.poseInfoDataHash.getRotZ(stringArray2[i], (int)stringArray.getAngleZ()));
                    stringArray.setMinAngleX(this.poseInfoDataHash.getMinRotX(stringArray2[i], (int)stringArray.getMinAngleX()));
                    stringArray.setMinAngleY(this.poseInfoDataHash.getMinRotY(stringArray2[i], (int)stringArray.getMinAngleY()));
                    stringArray.setMinAngleZ(this.poseInfoDataHash.getMinRotZ(stringArray2[i], (int)stringArray.getMinAngleZ()));
                    stringArray.setMaxAngleX(this.poseInfoDataHash.getMaxRotX(stringArray2[i], (int)stringArray.getMaxAngleX()));
                    stringArray.setMaxAngleY(this.poseInfoDataHash.getMaxRotY(stringArray2[i], (int)stringArray.getMaxAngleY()));
                    stringArray.setMaxAngleZ(this.poseInfoDataHash.getMaxRotZ(stringArray2[i], (int)stringArray.getMaxAngleZ()));
                    stringArray.setLock(this.poseInfoDataHash.isLocked(stringArray2[i]));
                    String string2 = this.poseInfoDataHash.getLabelName(stringArray2[i]);
                    stringArray.setLabelName(string2);
                    if (string2 == null) {
                        string2 = stringArray2[i];
                    }
                    if ((jButton = this.findBoneInfoButton(stringArray2[i])) != null) {
                        jButton.setText(string2);
                    }
                    if (this.poseInfoDataHash.isDisabled(stringArray2[i])) {
                        BonePoseInfo bonePoseInfo;
                        if (jButton != null) {
                            jButton.setEnabled(false);
                        }
                        if ((bonePoseInfo = this.findBonePoseInfo(stringArray2[i])) != null) {
                            bonePoseInfo.setEnabled(false);
                        }
                    }
                    stringArray.setSyncTarget(this.findBonePoseInfo(this.poseInfoDataHash.getSyncTargetName(stringArray2[i])));
                    stringArray.setSyncMirrorX(this.poseInfoDataHash.getSyncMirrorX(stringArray2[i]));
                    stringArray.setSyncMirrorY(this.poseInfoDataHash.getSyncMirrorY(stringArray2[i]));
                    stringArray.setSyncMirrorZ(this.poseInfoDataHash.getSyncMirrorZ(stringArray2[i]));
                    continue;
                }
                logger.warning("no pose info:" + stringArray2[i]);
            }
            this.boneInfoButtonList.updateUI();
            this.boneInfoRootPanel.update();
            this.boneInfoPanel.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.boneInfoPanel.update();
        this.poseStepsSlider.setValue(0);
    }

    private JButton findBoneInfoButton(String string) {
        Component[] componentArray = this.boneInfoButtonList.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton) || !((JButton)componentArray[i]).getToolTipText().equals(string)) continue;
            return (JButton)componentArray[i];
        }
        return null;
    }

    public void openModel(File file) {
        try {
            SkeletalModel skeletalModel = (SkeletalModel)this.loadModel(file);
            logger.info("model loaded:" + skeletalModel);
            this.openModel(skeletalModel);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void openModel(URL uRL) {
        try {
            SkeletalModel skeletalModel = (SkeletalModel)this.loadModel(uRL);
            this.openModel(skeletalModel);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void openModel(SkeletalModel skeletalModel) {
        skeletalModel.getMeshes();
        this.skeltonModel = skeletalModel;
        try {
            this.baseKeyFrame = this.cloneSkeletalKeyFrame(this.skeltonModel.getBindSkeletal());
            this.bodyAnimation = this.createStillAnimation(this.skeltonModel.getSkeleton());
            String[] stringArray = this.getBoneKeyNames();
            this.boneInfoButtonList.removeAll();
            this.boneInfoMap.remove(this.boneInfoMap);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton;
                BonePoseInfoData bonePoseInfoData = null;
                if (i == 0) {
                    bonePoseInfoData = new BonePoseInfoData(true);
                    bonePoseInfoData.setKeyName(stringArray[i]);
                    this.boneInfoRootPanel.setTargetInfo(bonePoseInfoData);
                    this.boneInfoMap.put(bonePoseInfoData.getKeyName(), bonePoseInfoData);
                    jButton = new JButton(stringArray[i]);
                    jButton.setToolTipText(stringArray[i]);
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JButton jButton = (JButton)actionEvent.getSource();
                            BonePoseInfo bonePoseInfo = Studio.this.findBonePoseInfo(jButton.getToolTipText());
                            if (bonePoseInfo != null) {
                                Studio.this.infoCardLayout.first(Studio.this.infoCardLayoutPanel);
                            } else {
                                logger.warning("no info:" + jButton.getToolTipText());
                            }
                        }
                    });
                    jButton.setMargin(new Insets(3, 0, 3, 0));
                    this.boneInfoButtonList.add(jButton);
                    continue;
                }
                jButton = new JButton(stringArray[i]);
                jButton.setToolTipText(stringArray[i]);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JButton jButton = (JButton)actionEvent.getSource();
                        BonePoseInfo bonePoseInfo = Studio.this.findBonePoseInfo(jButton.getToolTipText());
                        if (bonePoseInfo != null) {
                            Studio.this.boneInfoPanel.setTargetInfo(bonePoseInfo);
                            Studio.this.infoCardLayout.last(Studio.this.infoCardLayoutPanel);
                        } else {
                            logger.warning("no info:" + jButton.getToolTipText());
                        }
                    }
                });
                jButton.setMargin(new Insets(3, 0, 3, 0));
                this.boneInfoButtonList.add(jButton);
                bonePoseInfoData = new BonePoseInfoData(false);
                bonePoseInfoData.setKeyName(stringArray[i]);
                this.boneInfoMap.put(bonePoseInfoData.getKeyName(), bonePoseInfoData);
                if (bl) continue;
                this.boneInfoPanel.setTargetInfo(bonePoseInfoData);
                bl = true;
            }
            if (this.bodyInstance != null) {
                this.rootNode.detachChild((Spatial)this.bodyInstance);
                this.bodyInstance = null;
            }
            this.bodyInstance = new SkeletalModelInstance((Model)this.skeltonModel);
            this.bodyInstance.updateGeometricState(0.0f, true);
            this.bodyInstance.setModelBound((BoundingVolume)new BoundingBox());
            this.settingFrame.setBodyBrightTarget((Spatial)this.bodyInstance);
            JMUtils.setEmissiveState((Spatial)this.bodyInstance, (int)this.settingFrame.getBodyBright(), (int)this.settingFrame.getBodyBright(), (int)this.settingFrame.getBodyBright());
            this.bodyAnimator = this.bodyInstance.addAnimationController();
            this.animationAnimator = this.bodyAnimator.addAnimation(this.bodyAnimation);
            this.animationAnimator.setInterpolationThreshold(0.0f);
            this.bodyAnimator.update(0.0f);
            this.bodyInstance.updateModelBound();
            this.rootNode.attachChild((Spatial)this.bodyInstance);
            this.rootNode.updateRenderState();
            if (this.lastOpenedData != null) {
                this.openData(this.lastOpenedData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableKeyboardInput(boolean bl) {
        logger.info("set key input:" + bl);
        ((FirstPersonHandler)this.input).getKeyboardLookHandler().setEnabled(bl);
        this.enableShortcut = bl;
    }

    public void createDesktop() {
        this.guiNode = new Node("gui");
        this.guiNode.setRenderQueueMode(4);
        int n = 460;
        this.desktop = new JMEDesktop("desktop", this.display.getWidth(), this.display.getHeight(), this.input);
        this.desktop.getJDesktop().setBackground(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.guiNode.attachChild((Spatial)this.desktop);
        this.desktop.getLocalTranslation().set((float)(this.desktop.getJDesktop().getSize().width / 2), (float)(n / 2), 0.0f);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Studio.this.desktop.getJDesktop().setBackground(new Color(0.0f, 0.0f, 1.0f, 0.0f));
                JSlider jSlider = new JSlider();
                jSlider.setSize(((Studio)Studio.this).desktop.getJDesktop().getSize().width, 16);
                jSlider.setMaximum(18000);
                Studio.this.desktop.getJDesktop().add(jSlider);
                JPanel jPanel = new JPanel();
                jPanel.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                jPanel.setLocation(0, 100);
                jPanel.setSize(320, 460);
                Studio.this.desktop.getJDesktop().add(jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel.add(jPanel2);
                JButton jButton = new JButton(Messages.getString("controler"));
                jButton.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (((Studio)Studio.this).lastClicked.x != mouseEvent.getX() || ((Studio)Studio.this).lastClicked.y != mouseEvent.getY() || Studio.this.boneControlerFrame == null) {
                            Studio.this.showBoneControlerWindow();
                        }
                        Studio.this.lastClicked = new Point(mouseEvent.getX(), mouseEvent.getY());
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                jButton.setToolTipText(Messages.getString("controler_tooltip"));
                jPanel2.add(jButton);
                JButton jButton2 = new JButton(Messages.getString("load_model"));
                jButton2.setToolTipText(Messages.getString("load_model_tooltip"));
                jPanel.add(jButton2);
                jButton2.addActionListener(new ErrorCatchingGLActionListener(){

                    @Override
                    public void doGLAction(ActionEvent actionEvent) {
                        Studio.this.openModel();
                        Studio.this.unfocusButton();
                    }
                });
                jPanel2.setLayout(new FlowLayout());
                JButton jButton3 = new JButton(Messages.getString("settings"));
                jButton3.setToolTipText(Messages.getString("settings_tooltip"));
                jButton3.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (((Studio)Studio.this).lastClicked.x != mouseEvent.getX() || ((Studio)Studio.this).lastClicked.y != mouseEvent.getY() || Studio.this.boneControlerFrame == null) {
                            Studio.this.showSettingWindow();
                        }
                        Studio.this.lastClicked = new Point(mouseEvent.getX(), mouseEvent.getY());
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                jPanel2.add(jButton3);
                JPanel jPanel3 = new JPanel();
                jPanel.add(jPanel3);
                JButton jButton4 = new JButton(Messages.getString("last"));
                jButton4.setToolTipText(Messages.getString("last_tooltip"));
                jButton4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Studio.this.defaultAll();
                    }
                });
                jPanel3.add(jButton4);
                JButton jButton5 = new JButton(Messages.getString("zero"));
                jButton5.setToolTipText(Messages.getString("zero_tooltip"));
                jButton5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Studio.this.zeroAll();
                    }
                });
                jPanel3.add(jButton5);
                JPanel jPanel4 = new JPanel();
                jPanel.add(jPanel4);
                Studio.this.randomLevel = new JSlider(){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(60, 10);
                    }
                };
                Studio.this.randomLevel.setToolTipText(Messages.getString("random_level_tooltip"));
                Studio.this.randomLevel.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JSlider jSlider = (JSlider)changeEvent.getSource();
                        jSlider.setToolTipText("" + jSlider.getValue());
                    }
                });
                Studio.this.randomLevel.setMaximum(50);
                Studio.this.randomLevel.setValue(25);
                jPanel4.add(Studio.this.randomLevel);
                JButton jButton6 = new JButton(Messages.getString("rand"));
                jButton6.setToolTipText(Messages.getString("rand_tooltip"));
                jButton6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Studio.this.randomAll();
                    }
                });
                jPanel4.add(jButton6);
                JPanel jPanel5 = new JPanel();
                jPanel.add(jPanel5);
                JButton jButton7 = new JButton(Messages.getString("as_random"));
                jButton7.setToolTipText(Messages.getString("as_random_tooltip"));
                jButton7.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Studio.this.randomPoseDataHash = Studio.this.toBoneInfoDataHash();
                    }
                });
                jPanel5.add(jButton7);
                JButton jButton8 = new JButton(Messages.getString("as_anime"));
                jButton7.setToolTipText(Messages.getString("as_anime_tooltip"));
                jButton8.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Studio.this.animePoseDataHash = Studio.this.toBoneInfoDataHash();
                        Studio.this.poseStepsSlider.setValue(0);
                    }
                });
                jPanel5.add(jButton8);
                JPanel jPanel6 = new JPanel();
                jPanel.add(jPanel6);
                Studio.this.poseStepsSlider = new JSlider(){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(120, 10);
                    }
                };
                Studio.this.poseStepsSlider.setToolTipText(Messages.getString("pose_step_tooltip"));
                Studio.this.poseStepsSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JSlider jSlider = (JSlider)changeEvent.getSource();
                        jSlider.setToolTipText("" + jSlider.getValue());
                        Studio.this.currentPoseSteps = jSlider.getValue();
                    }
                });
                Studio.this.poseStepsSlider.setMaximum(100);
                Studio.this.poseStepsSlider.setValue(0);
                jPanel6.add(Studio.this.poseStepsSlider);
                JButton jButton9 = new JButton(Messages.getString("as_current"));
                jButton9.setToolTipText(Messages.getString("as_current_tooltip"));
                jButton9.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String[] stringArray = Studio.this.getBoneKeyNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            BonePoseInfo bonePoseInfo;
                            Vector3f vector3f = Studio.this.getSteppedAngles(stringArray[i], Studio.this.currentPoseSteps);
                            if (vector3f == null || (bonePoseInfo = Studio.this.findBonePoseInfo(stringArray[i])) == null) continue;
                            bonePoseInfo.setAngleX(vector3f.x);
                            bonePoseInfo.setAngleY(vector3f.y);
                            bonePoseInfo.setAngleZ(vector3f.z);
                        }
                        Studio.this.boneInfoPanel.update();
                        Studio.this.boneInfoRootPanel.update();
                        Studio.this.poseStepsSlider.setValue(0);
                    }
                });
                jPanel6.add(jButton9);
                JCheckBox jCheckBox = new JCheckBox(Messages.getString("anime"));
                jCheckBox.setToolTipText(Messages.getString("anime_tooltip"));
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Studio.this.switchAnime(((JCheckBox)actionEvent.getSource()).isSelected());
                    }
                });
                jPanel6.add(jCheckBox);
                JPanel jPanel7 = new JPanel();
                jPanel.add(jPanel7);
                JButton jButton10 = new JButton(Messages.getString("image"));
                jCheckBox.setToolTipText(Messages.getString("image_tooltip"));
                jButton10.addActionListener(new ErrorCatchingGLActionListener(){

                    @Override
                    public void doGLAction(ActionEvent actionEvent) {
                        Studio.this.screenShot();
                    }
                });
                jPanel7.add(jButton10);
                Studio.this.createBoneContolerWindow();
                Studio.this.createSettingWindow();
                Studio.this.desktop.getJDesktop().updateUI();
                Studio.this.finishCreateDesktop();
            }
        });
        this.guiNode.setCullMode(3);
        this.guiNode.setLightCombineMode(0);
        this.guiNode.updateRenderState();
        this.guiNode.updateGeometricState(0.0f, true);
        MouseInput.get().setCursorVisible(true);
    }

    private void unfocusButton() {
    }

    private void createBoneContolerWindow() {
        this.boneControlerFrame = new JFrame();
        this.boneControlerFrame.setLayout(null);
        this.boneControlerFrame.setLocation(16, 16);
        this.boneControlerFrame.setSize(460, 640);
        this.boneControlerFrame.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setSize(440, 40);
        jPanel.setLocation(0, 0);
        this.boneControlerFrame.add(jPanel);
        this.fileName = new JTextField();
        this.fileName.setText("pose_data");
        this.fileName.setColumns(12);
        jPanel.add(this.fileName);
        JButton jButton = new JButton("save");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Studio.this.save(Studio.this.fileName.getText(), Studio.this.overwrite.isSelected());
            }
        });
        this.overwrite = new JCheckBox("ow");
        this.overwrite.setToolTipText("overwrite or not");
        jPanel.add(this.overwrite);
        JButton jButton2 = new JButton("load");
        jPanel.add(jButton2);
        jButton2.addActionListener(new ErrorCatchingGLActionListener(){

            @Override
            public void doGLAction(ActionEvent actionEvent) {
                Studio.this.openData();
                Studio.this.unfocusButton();
            }
        });
        this.boneInfoButtonList = new JPanel();
        this.boneInfoButtonList.setLayout(new GridLayout(0, 4));
        this.boneInfoButtonList.addMouseListener(new KeyInputControler());
        JScrollPane jScrollPane = new JScrollPane(this.boneInfoButtonList);
        jScrollPane.setLocation(0, 40);
        jScrollPane.setSize(440, 260);
        this.boneControlerFrame.add(jScrollPane);
        jScrollPane.setVisible(true);
        logger.info("desktop updated");
        logger.info("top-panel:" + this.boneControlerFrame.getSize());
        logger.info("desktop" + this.desktop.getJDesktop().getSize());
        this.infoCardLayoutPanel = new JPanel();
        this.infoCardLayoutPanel.setSize(440, 180);
        this.infoCardLayoutPanel.setLocation(0, 300);
        this.infoCardLayout = new CardLayout();
        this.infoCardLayoutPanel.setLayout(this.infoCardLayout);
        this.infoCardLayoutPanel.setVisible(true);
        this.boneInfoRootPanel = new BonePoseInfoPanel(true);
        this.infoCardLayoutPanel.add((Component)this.boneInfoRootPanel, "root");
        this.infoCardLayout.first(this.infoCardLayoutPanel);
        this.boneInfoPanel = new BonePoseInfoPanel(false);
        this.infoCardLayoutPanel.add((Component)this.boneInfoPanel, "children");
        this.boneControlerFrame.add(this.infoCardLayoutPanel);
    }

    private void showBoneControlerWindow() {
        if (this.boneControlerFrame != null) {
            this.boneControlerFrame.setVisible(true);
        } else {
            this.createBoneContolerWindow();
        }
    }

    public void loadSettings(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createSettingWindow() {
        this.settingFrame = new PoseEditorSwingWindow();
        this.settingFrame.setBackgroundTarget((Spatial)this.backgroundGuad);
        this.settingFrame.setBloomRenderPass(this.bloomRenderPass);
        this.settingFrame.setPoseBoneInfoDataHashContainer(this);
    }

    private void showSettingWindow() {
        if (this.settingFrame != null) {
            this.settingFrame.setVisible(true);
        } else {
            this.createSettingWindow();
            this.settingFrame.setVisible(true);
        }
    }

    private void finishCreateDesktop() {
        this.openModel(new File("datas/models/girl001/girl001.md5mesh"));
        this.openData(this.getClass().getResourceAsStream("/motiontools/hair_model_default_pose.txt"));
        this.modelLoaded = true;
    }

    public void openModel() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "load model");
        fileDialog.setDirectory("");
        fileDialog.setFile("*.md5mesh");
        fileDialog.setVisible(true);
        fileDialog.setLocation(0, 0);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            this.openModel(file);
        }
        frame.dispose();
    }

    public void openData() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "load pose");
        fileDialog.setFile("*.txt");
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            try {
                this.openData(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        frame.dispose();
    }

    private void switchAnime(boolean bl) {
        this.doAnimation = bl;
        if (this.doAnimation) {
            int n;
            SkeletalAnimation skeletalAnimation = new SkeletalAnimation();
            float f = 15.0f;
            int n2 = (int)(f * 3.0f);
            float f2 = 1.0f / f;
            skeletalAnimation.setBaseFrame((KeyFrame)this.cloneSkeletalKeyFrame(this.baseKeyFrame));
            String[] stringArray = this.skeltonModel.getSkeleton().getJointNames();
            logger.info("joint names=" + stringArray.length);
            skeletalAnimation.setSkeleton(this.skeltonModel.getSkeleton());
            if (!this.settingFrame.isStartAnimationFromAnimePose()) {
                Quaternion quaternion;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                BonePoseInfo bonePoseInfo;
                int n3;
                SkeletalKeyFrame skeletalKeyFrame;
                for (n = n2 - 1; n >= 0; --n) {
                    skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        bonePoseInfo = this.findBonePoseInfo(stringArray[n3]);
                        f8 = 0.0f;
                        f7 = 0.0f;
                        f6 = 0.0f;
                        if (this.animePoseDataHash != null) {
                            f8 = this.animePoseDataHash.getRotX(stringArray[n3], 0);
                            f7 = this.animePoseDataHash.getRotY(stringArray[n3], 0);
                            f6 = this.animePoseDataHash.getRotZ(stringArray[n3], 0);
                        }
                        f5 = bonePoseInfo.getAngleX() - f8;
                        f4 = bonePoseInfo.getAngleY() - f7;
                        f3 = bonePoseInfo.getAngleZ() - f6;
                        if (bonePoseInfo == null) continue;
                        quaternion = new Quaternion();
                        if (n != 0) {
                            quaternion.fromAngles(((float)n / (float)(n2 - 1) * f5 + f8) * ((float)Math.PI / 180), ((float)n / (float)(n2 - 1) * f4 + f7) * ((float)Math.PI / 180), ((float)n / (float)(n2 - 1) * f3 + f6) * ((float)Math.PI / 180));
                        } else {
                            quaternion.fromAngles(f8 * ((float)Math.PI / 180), f7 * ((float)Math.PI / 180), f6 * ((float)Math.PI / 180));
                        }
                        if (bonePoseInfo.isRoot()) {
                            quaternion.multLocal(this.cameraAngle);
                        }
                        skeletalKeyFrame.rotations[n3].set(quaternion.mult(this.baseKeyFrame.rotations[n3]));
                    }
                    skeletalKeyFrame.time = f2 * (float)(n2 - n);
                    skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                    skeletalAnimation.getSuppliedPositions().set(n2 + 1 + n, true);
                    skeletalAnimation.getSuppliedRotations().set(n2 + 1 + n, true);
                }
                for (n = 0; n <= n2; ++n) {
                    skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        bonePoseInfo = this.findBonePoseInfo(stringArray[n3]);
                        f8 = 0.0f;
                        f7 = 0.0f;
                        f6 = 0.0f;
                        if (this.animePoseDataHash != null) {
                            f8 = this.animePoseDataHash.getRotX(stringArray[n3], 0);
                            f7 = this.animePoseDataHash.getRotY(stringArray[n3], 0);
                            f6 = this.animePoseDataHash.getRotZ(stringArray[n3], 0);
                        }
                        f5 = bonePoseInfo.getAngleX() - f8;
                        f4 = bonePoseInfo.getAngleY() - f7;
                        f3 = bonePoseInfo.getAngleZ() - f6;
                        if (bonePoseInfo == null) continue;
                        quaternion = new Quaternion();
                        if (n != 0) {
                            quaternion.fromAngles(((float)n / (float)n2 * f5 + f8) * ((float)Math.PI / 180), ((float)n / (float)n2 * f4 + f7) * ((float)Math.PI / 180), ((float)n / (float)n2 * f3 + f6) * ((float)Math.PI / 180));
                        } else {
                            quaternion.fromAngles(f8 * ((float)Math.PI / 180), f7 * ((float)Math.PI / 180), f6 * ((float)Math.PI / 180));
                        }
                        if (bonePoseInfo.isRoot()) {
                            quaternion.multLocal(this.cameraAngle);
                        }
                        skeletalKeyFrame.rotations[n3].set(quaternion.mult(this.baseKeyFrame.rotations[n3]));
                    }
                    skeletalKeyFrame.time = f2 * (float)n + f2 * (float)(n2 + 1);
                    skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                    skeletalAnimation.getSuppliedPositions().set(n, true);
                    skeletalAnimation.getSuppliedRotations().set(n, true);
                }
            } else {
                Quaternion quaternion;
                float f9;
                float f10;
                float f11;
                float f12;
                float f13;
                float f14;
                BonePoseInfo bonePoseInfo;
                int n4;
                SkeletalKeyFrame skeletalKeyFrame;
                for (n = 0; n <= n2; ++n) {
                    skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        bonePoseInfo = this.findBonePoseInfo(stringArray[n4]);
                        f14 = 0.0f;
                        f13 = 0.0f;
                        f12 = 0.0f;
                        if (this.animePoseDataHash != null) {
                            f14 = this.animePoseDataHash.getRotX(stringArray[n4], 0);
                            f13 = this.animePoseDataHash.getRotY(stringArray[n4], 0);
                            f12 = this.animePoseDataHash.getRotZ(stringArray[n4], 0);
                        }
                        f11 = bonePoseInfo.getAngleX() - f14;
                        f10 = bonePoseInfo.getAngleY() - f13;
                        f9 = bonePoseInfo.getAngleZ() - f12;
                        if (bonePoseInfo == null) continue;
                        quaternion = new Quaternion();
                        if (n != 0) {
                            quaternion.fromAngles(((float)n / (float)n2 * f11 + f14) * ((float)Math.PI / 180), ((float)n / (float)n2 * f10 + f13) * ((float)Math.PI / 180), ((float)n / (float)n2 * f9 + f12) * ((float)Math.PI / 180));
                        } else {
                            quaternion.fromAngles(f14 * ((float)Math.PI / 180), f13 * ((float)Math.PI / 180), f12 * ((float)Math.PI / 180));
                        }
                        if (bonePoseInfo.isRoot()) {
                            quaternion.multLocal(this.cameraAngle);
                        }
                        skeletalKeyFrame.rotations[n4].set(quaternion.mult(this.baseKeyFrame.rotations[n4]));
                    }
                    skeletalKeyFrame.time = f2 * (float)n;
                    skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                    skeletalAnimation.getSuppliedPositions().set(n, true);
                    skeletalAnimation.getSuppliedRotations().set(n, true);
                }
                for (n = n2 - 1; n >= 0; --n) {
                    skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        bonePoseInfo = this.findBonePoseInfo(stringArray[n4]);
                        f14 = 0.0f;
                        f13 = 0.0f;
                        f12 = 0.0f;
                        if (this.animePoseDataHash != null) {
                            f14 = this.animePoseDataHash.getRotX(stringArray[n4], 0);
                            f13 = this.animePoseDataHash.getRotY(stringArray[n4], 0);
                            f12 = this.animePoseDataHash.getRotZ(stringArray[n4], 0);
                        }
                        f11 = bonePoseInfo.getAngleX() - f14;
                        f10 = bonePoseInfo.getAngleY() - f13;
                        f9 = bonePoseInfo.getAngleZ() - f12;
                        if (bonePoseInfo == null) continue;
                        quaternion = new Quaternion();
                        if (n != 0) {
                            quaternion.fromAngles(((float)n / (float)n2 * f11 + f14) * ((float)Math.PI / 180), ((float)n / (float)n2 * f10 + f13) * ((float)Math.PI / 180), ((float)n / (float)n2 * f9 + f12) * ((float)Math.PI / 180));
                        } else {
                            quaternion.fromAngles(f14 * ((float)Math.PI / 180), f13 * ((float)Math.PI / 180), f12 * ((float)Math.PI / 180));
                        }
                        if (bonePoseInfo.isRoot()) {
                            quaternion.multLocal(this.cameraAngle);
                        }
                        skeletalKeyFrame.rotations[n4].set(quaternion.mult(this.baseKeyFrame.rotations[n4]));
                    }
                    skeletalKeyFrame.time = f2 * (float)(n2 - n) + f2 * (float)(n2 + 1);
                    skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                    skeletalAnimation.getSuppliedPositions().set(n2 + 1 + n, true);
                    skeletalAnimation.getSuppliedRotations().set(n2 + 1 + n, true);
                }
            }
            this.bodyAnimator.removeAnimator(0);
            AnimationAnimator animationAnimator = this.bodyAnimator.addAnimation((Animation)skeletalAnimation);
            animationAnimator.fadeIn(0.01f);
            animationAnimator.setCycleType(1);
            this.animationAnimator = animationAnimator;
        }
    }

    private void defaultAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null) {
                bonePoseInfo.setAngleX(this.poseInfoDataHash.getRotX(stringArray[i], (int)bonePoseInfo.getAngleX()));
                bonePoseInfo.setAngleY(this.poseInfoDataHash.getRotY(stringArray[i], (int)bonePoseInfo.getAngleY()));
                bonePoseInfo.setAngleZ(this.poseInfoDataHash.getRotZ(stringArray[i], (int)bonePoseInfo.getAngleZ()));
                bonePoseInfo.setMinAngleX(this.poseInfoDataHash.getMinRotX(stringArray[i], (int)bonePoseInfo.getMinAngleX()));
                bonePoseInfo.setMinAngleY(this.poseInfoDataHash.getMinRotY(stringArray[i], (int)bonePoseInfo.getMinAngleY()));
                bonePoseInfo.setMinAngleZ(this.poseInfoDataHash.getMinRotZ(stringArray[i], (int)bonePoseInfo.getMinAngleZ()));
                bonePoseInfo.setMaxAngleX(this.poseInfoDataHash.getMaxRotX(stringArray[i], (int)bonePoseInfo.getMaxAngleX()));
                bonePoseInfo.setMaxAngleY(this.poseInfoDataHash.getMaxRotY(stringArray[i], (int)bonePoseInfo.getMaxAngleY()));
                bonePoseInfo.setMaxAngleZ(this.poseInfoDataHash.getMaxRotZ(stringArray[i], (int)bonePoseInfo.getMaxAngleZ()));
                continue;
            }
            logger.warning("no pose info:" + stringArray[i]);
        }
        this.boneInfoPanel.update();
        this.boneInfoRootPanel.update();
    }

    private void zeroAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null) {
                bonePoseInfo.setAngleX(0.0f);
                bonePoseInfo.setAngleY(0.0f);
                bonePoseInfo.setAngleZ(0.0f);
                continue;
            }
            logger.warning("no pose info:" + stringArray[i]);
        }
        this.boneInfoPanel.update();
        this.boneInfoRootPanel.update();
    }

    public void randomAll() {
        this.poseStepsSlider.setValue(0);
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            float f = 0.02f * (float)this.randomLevel.getValue();
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (this.randomPoseDataHash != null) {
                f2 = this.randomPoseDataHash.getRotX(stringArray[i], 0);
                f3 = this.randomPoseDataHash.getRotY(stringArray[i], 0);
                f4 = this.randomPoseDataHash.getRotZ(stringArray[i], 0);
            }
            if (bonePoseInfo.isLock()) continue;
            bonePoseInfo.random(f2, f3, f4, f);
        }
        this.boneInfoRootPanel.update();
        this.boneInfoPanel.update();
        if (this.doAnimation) {
            this.switchAnime(true);
        }
    }

    public void screenShot() {
        this.desktop.setCullMode(2);
        this.fpsNode.setCullMode(2);
        this.doShot = true;
    }

    public void save(String string, boolean bl) {
        String string2 = this.getExportData();
        File file = new File(this.settingFrame.getExportPath(), string + ".txt");
        if (!bl) {
            String string3 = FileNameUtils.getNotFoundFileName((File)file);
            logger.info("savedName:" + string3);
            file = new File(string3);
            this.fileName.setText(FileNameUtils.getRemovedExtensionName((String)file.getName()));
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void simpleInitGame() {
        Text text;
        System.out.println(this.cam.getLeft() + "," + this.cam.getUp());
        KeyBindingManager.getKeyBindingManager().set("num1", 79);
        KeyBindingManager.getKeyBindingManager().set("num3", 81);
        KeyBindingManager.getKeyBindingManager().set("num7", 71);
        KeyBindingManager.getKeyBindingManager().set("num0", 82);
        KeyBindingManager.getKeyBindingManager().set("num8", 72);
        KeyBindingManager.getKeyBindingManager().set("num2", 80);
        KeyBindingManager.getKeyBindingManager().set("num4", 75);
        KeyBindingManager.getKeyBindingManager().set("num6", 77);
        KeyBindingManager.getKeyBindingManager().set("control_visible", 88);
        KeyBindingManager.getKeyBindingManager().set("screenshot", 210);
        KeyBindingManager.getKeyBindingManager().set("random", 19);
        KeyBindingManager.getKeyBindingManager().set("out", 17);
        KeyBindingManager.getKeyBindingManager().set("in", 31);
        KeyBindingManager.getKeyBindingManager().set("up", 200);
        KeyBindingManager.getKeyBindingManager().set("down", 208);
        KeyBindingManager.getKeyBindingManager().set("right", 205);
        KeyBindingManager.getKeyBindingManager().set("left", 203);
        ((FirstPersonHandler)this.input).getMouseLookHandler().setEnabled(false);
        this.sceneRootNode = new Node("sceneRootNode");
        this.rootNode.attachChild((Spatial)this.sceneRootNode);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.attach(JMUtils.createLight(new Vector3f(0.0f, 7.0f, -25.0f)));
        lightState.attach(JMUtils.createLight(new Vector3f(0.0f, 7.0f, 25.0f)));
        this.lightState.detachAll();
        this.rootNode.setRenderState((RenderState)lightState);
        logger.info("" + this.cam.getDirection());
        KeyBindingManager.getKeyBindingManager().remove("toggle_pause");
        KeyBindingManager.getKeyBindingManager().remove("step");
        KeyBindingManager.getKeyBindingManager().remove("toggle_wire");
        KeyBindingManager.getKeyBindingManager().remove("toggle_lights");
        KeyBindingManager.getKeyBindingManager().remove("toggle_bounds");
        KeyBindingManager.getKeyBindingManager().remove("toggle_depth");
        KeyBindingManager.getKeyBindingManager().remove("toggle_normals");
        KeyBindingManager.getKeyBindingManager().remove("camera_out");
        KeyBindingManager.getKeyBindingManager().remove("screen_shot");
        KeyBindingManager.getKeyBindingManager().remove("parallel_projection");
        KeyBindingManager.getKeyBindingManager().remove("screen_shot");
        KeyBindingManager.getKeyBindingManager().remove("mem_report");
        KeyBindingManager.getKeyBindingManager().remove("screen_shot");
        this.cameraNode = new CameraNode("cameraNode", this.cam);
        this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
        this.cameraNode.setLocalRotation(new Quaternion());
        this.cameraNodeAngleX = 0.0f;
        this.cameraNodeAngleY = 0.0f;
        this.cameraNodeAngleZ = 0.0f;
        this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
        this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
        this.rootNode.attachChild((Spatial)this.cameraNode);
        this.backgroundGuad = new Quad("bg", 4.0f, 3.0f);
        this.backgroundGuad.setLocalScale(134.0f);
        this.backgroundGuad.setLocalRotation(JMUtils.getRotateY(180.0f));
        this.backgroundGuad.setLocalTranslation(0.0f, 0.0f, 400.0f);
        this.backgroundGuad.setCullMode(2);
        this.backgroundGuad.setLightCombineMode(0);
        this.backgroundGuad.setModelBound((BoundingVolume)new BoundingBox());
        JMUtils.setDiffuseState((Spatial)this.backgroundGuad, 255, 255, 255);
        this.cameraNode.attachChild((Spatial)this.backgroundGuad);
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.rootNode);
        this.pManager.add((Pass)renderPass);
        this.bloomRenderPass = new BloomRenderPass(this.cam, 4);
        this.bloomRenderPass.setBlurSize(0.02f);
        this.bloomRenderPass.setExposurePow(10.0f);
        this.bloomRenderPass.setExposureCutoff(0.0f);
        this.bloomRenderPass.setBlurIntensityMultiplier(0.6f);
        this.bloomRenderPass.setThrottle(0.015f);
        if (!this.bloomRenderPass.isSupported()) {
            text = new Text("Text", "GLSL Not supported on this computer.");
            text.setRenderQueueMode(4);
            text.setLightCombineMode(0);
            text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
            this.fpsNode.attachChild((Spatial)text);
        } else {
            this.bloomRenderPass.add((Spatial)this.rootNode);
            this.bloomRenderPass.setUseCurrentScene(true);
            this.pManager.add((Pass)this.bloomRenderPass);
        }
        text = new RenderPass();
        text.add((Spatial)this.fpsNode);
        text.add((Spatial)this.backgroundGuad);
        this.pManager.add((Pass)text);
        this.bloomRenderPass.setEnabled(false);
        ((FirstPersonHandler)this.input).getKeyboardLookHandler().setMoveSpeed(25.0f);
        this.createDesktop();
    }

    public String[] getBoneKeyNames() {
        return this.skeltonModel.getSkeleton().getJointNames();
    }

    public void printInfo(Spatial spatial) {
        block4: {
            block3: {
                if (!(spatial instanceof Node)) break block3;
                Node node = (Node)spatial;
                System.out.println("node:" + node.getName());
                for (int i = 0; i < node.getQuantity(); ++i) {
                    this.printInfo(node.getChild(i));
                }
                break block4;
            }
            if (!(spatial instanceof TriMesh)) break block4;
            TriMesh triMesh = (TriMesh)spatial;
            int n = triMesh.getBatchCount();
            System.out.println("triMesh:" + triMesh.getName());
            for (int i = 0; i < n; ++i) {
                System.out.println(triMesh.getVertexBuffer(i));
                if (triMesh.getVertexBuffer(i) != null) {
                    System.out.println(i + "=" + triMesh.getVertexBuffer(i).capacity() / 3);
                    continue;
                }
                logger.warning("have empty batch make crash" + triMesh.getName());
            }
        }
    }

    public void printBone(Bone bone) {
        System.out.println(bone.getName() + "," + bone.getLocalTranslation());
        for (int i = 0; i < bone.getQuantity(); ++i) {
            this.printBone((Bone)bone.getChild(i));
        }
    }

    protected void simpleUpdate() {
        if (this.enableShortcut) {
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("out", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, 0.0f, 1.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("in", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, 0.0f, -1.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("down", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, 1.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("up", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, -1.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("right", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(-1.0f, 0.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("left", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(1.0f, 0.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("bones", false)) {
                boolean bl = this.boneOn = !this.boneOn;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("num1_ctrl", false)) {
                System.out.println("num1_c");
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num0", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(5.0f, 0.0f, -19.0f));
                this.cameraNode.setLocalRotation(new Quaternion());
                this.cameraNodeAngleX = 0.0f;
                this.cameraNodeAngleY = 0.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num1", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
                this.cameraNodeAngleX = 0.0f;
                this.cameraNodeAngleY = 0.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num3", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
                this.cameraNode.setLocalRotation(new Quaternion());
                this.cameraNodeAngleX = 0.0f;
                this.cameraNodeAngleY = -90.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num7", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
                this.cameraNode.setLocalRotation(new Quaternion());
                this.cameraNodeAngleX = -90.0f;
                this.cameraNodeAngleY = 0.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
                Quaternion quaternion = new Quaternion();
                quaternion.fromAngles(this.cameraNodeAngleX * ((float)Math.PI / 180), 0.0f, 0.0f);
                quaternion.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num8", true)) {
                this.cameraNodeAngleX += this.cameraNodeAngleAdd;
                this.cameraNodeAngleX %= 360.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num2", true)) {
                this.cameraNodeAngleX -= this.cameraNodeAngleAdd;
                this.cameraNodeAngleX %= 360.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num4", true)) {
                this.cameraNodeAngleY -= this.cameraNodeAngleAdd;
                this.cameraNodeAngleY %= 360.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num6", true)) {
                this.cameraNodeAngleY += this.cameraNodeAngleAdd;
                this.cameraNodeAngleY %= 360.0f;
                this.cameraAngle = JMUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(JMUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("screenshot", false)) {
                this.screenShot();
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("random", false)) {
                this.randomAll();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("1", false)) {
                this.bloomRenderPass.setEnabled(!this.bloomRenderPass.isEnabled());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("2", false)) {
                this.bloomRenderPass.setBlurSize(this.bloomRenderPass.getBlurSize() - 0.001f);
                System.out.println("blurSize:" + this.bloomRenderPass.getBlurSize());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("3", false)) {
                this.bloomRenderPass.setBlurSize(this.bloomRenderPass.getBlurSize() + 0.001f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("4", false)) {
                this.bloomRenderPass.setExposurePow(this.bloomRenderPass.getExposurePow() - 1.0f);
                System.out.println("ExposurePow:" + this.bloomRenderPass.getExposurePow());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("5", false)) {
                this.bloomRenderPass.setExposurePow(this.bloomRenderPass.getExposurePow() + 1.0f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("6", false)) {
                this.bloomRenderPass.setExposureCutoff(this.bloomRenderPass.getExposureCutoff() - 0.1f);
                System.out.println("ExposureCutoff:" + this.bloomRenderPass.getExposureCutoff());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("7", false)) {
                this.bloomRenderPass.setExposureCutoff(this.bloomRenderPass.getExposureCutoff() + 0.1f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("8", false)) {
                this.bloomRenderPass.setBlurIntensityMultiplier(this.bloomRenderPass.getBlurIntensityMultiplier() - 0.1f);
                System.out.println("BlurIntensityMultiplier:" + this.bloomRenderPass.getBlurIntensityMultiplier());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("9", false)) {
                this.bloomRenderPass.setBlurIntensityMultiplier(this.bloomRenderPass.getBlurIntensityMultiplier() + 0.1f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("0", false)) {
                this.bloomRenderPass.resetParameters();
                this.bloomRenderPass.setUseCurrentScene(true);
                this.bloomRenderPass.setThrottle(0.02f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("`", false)) {
                this.bloomRenderPass.setUseCurrentScene(!this.bloomRenderPass.useCurrentScene());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("-", false)) {
                float f = this.bloomRenderPass.getThrottle() - 0.005f;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                logger.info("throttle: " + f);
                this.bloomRenderPass.setThrottle(f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("+", false)) {
                float f = this.bloomRenderPass.getThrottle() + 0.005f;
                System.out.println("getThrottle:" + this.bloomRenderPass.getThrottle());
                this.bloomRenderPass.setThrottle(f);
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("control_visible", false)) {
            boolean bl = this.visibleControls = !this.visibleControls;
            if (this.visibleControls) {
                this.desktop.setCullMode(3);
                this.fpsNode.setCullMode(3);
            } else {
                this.enableKeyboardInput(true);
                this.desktop.setCullMode(2);
                this.fpsNode.setCullMode(2);
            }
        }
        if (!this.doAnimation) {
            this.updateStillAnimation();
        }
    }

    public SkeletalKeyFrame cloneSkeletalKeyFrame(SkeletalKeyFrame skeletalKeyFrame) {
        int n;
        SkeletalKeyFrame skeletalKeyFrame2 = new SkeletalKeyFrame();
        skeletalKeyFrame2.positions = new Vector3f[skeletalKeyFrame.positions.length];
        skeletalKeyFrame2.rotations = new Quaternion[skeletalKeyFrame.rotations.length];
        for (n = 0; n < skeletalKeyFrame2.positions.length; ++n) {
            skeletalKeyFrame2.positions[n] = skeletalKeyFrame.positions[n].clone();
        }
        for (n = 0; n < skeletalKeyFrame2.rotations.length; ++n) {
            skeletalKeyFrame2.rotations[n] = new Quaternion(skeletalKeyFrame.rotations[n]);
        }
        return skeletalKeyFrame2;
    }

    private Vector3f getSteppedAngles(String string, int n) {
        BonePoseInfo bonePoseInfo = this.findBonePoseInfo(string);
        if (bonePoseInfo == null) {
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (n == 0) {
            f = bonePoseInfo.getAngleX();
            f2 = bonePoseInfo.getAngleY();
            f3 = bonePoseInfo.getAngleZ();
        } else if (n == 100) {
            if (this.animePoseDataHash == null) {
                f = 0.0f;
                f2 = 0.0f;
                f3 = 0.0f;
            } else {
                f = this.animePoseDataHash.getRotX(string, 0);
                f2 = this.animePoseDataHash.getRotY(string, 0);
                f3 = this.animePoseDataHash.getRotZ(string, 0);
            }
        } else {
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (this.animePoseDataHash != null) {
                f4 = this.animePoseDataHash.getRotX(string, 0);
                f5 = this.animePoseDataHash.getRotY(string, 0);
                f6 = this.animePoseDataHash.getRotZ(string, 0);
            }
            float f7 = bonePoseInfo.getAngleX() - f4;
            float f8 = bonePoseInfo.getAngleY() - f5;
            float f9 = bonePoseInfo.getAngleZ() - f6;
            f = (float)(100 - n) / 100.0f * f7 + f4;
            f2 = (float)(100 - n) / 100.0f * f8 + f5;
            f3 = (float)(100 - n) / 100.0f * f9 + f6;
        }
        return new Vector3f(f, f2, f3);
    }

    private SkeletalKeyFrame syncBoneAngles() {
        SkeletalKeyFrame skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
        String[] stringArray = this.skeltonModel.getSkeleton().getJointNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo == null) continue;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.currentPoseSteps == 0) {
                f = bonePoseInfo.getAngleX();
                f2 = bonePoseInfo.getAngleY();
                f3 = bonePoseInfo.getAngleZ();
            } else if (this.currentPoseSteps == 100) {
                if (this.animePoseDataHash == null) {
                    f = 0.0f;
                    f2 = 0.0f;
                    f3 = 0.0f;
                } else {
                    f = this.animePoseDataHash.getRotX(stringArray[i], 0);
                    f2 = this.animePoseDataHash.getRotY(stringArray[i], 0);
                    f3 = this.animePoseDataHash.getRotZ(stringArray[i], 0);
                }
            } else {
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (this.animePoseDataHash != null) {
                    f4 = this.animePoseDataHash.getRotX(stringArray[i], 0);
                    f5 = this.animePoseDataHash.getRotY(stringArray[i], 0);
                    f6 = this.animePoseDataHash.getRotZ(stringArray[i], 0);
                }
                float f7 = bonePoseInfo.getAngleX() - f4;
                float f8 = bonePoseInfo.getAngleY() - f5;
                float f9 = bonePoseInfo.getAngleZ() - f6;
                f = (float)(100 - this.currentPoseSteps) / 100.0f * f7 + f4;
                f2 = (float)(100 - this.currentPoseSteps) / 100.0f * f8 + f5;
                f3 = (float)(100 - this.currentPoseSteps) / 100.0f * f9 + f6;
            }
            Quaternion quaternion = new Quaternion();
            quaternion.fromAngles(f * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180), f3 * ((float)Math.PI / 180));
            if (!bonePoseInfo.isRoot()) {
                skeletalKeyFrame.rotations[i].set(quaternion.mult(this.baseKeyFrame.rotations[i]));
                continue;
            }
            quaternion.multLocal(this.cameraAngle);
            skeletalKeyFrame.rotations[i].set(quaternion.mult(this.baseKeyFrame.rotations[i]));
        }
        return skeletalKeyFrame;
    }

    private BonePoseInfo findBonePoseInfo(String string) {
        if (string == null) {
            return null;
        }
        return this.boneInfoMap.get(string);
    }

    public void updateStillAnimation() {
        if (!this.modelLoaded) {
            return;
        }
        SkeletalKeyFrame skeletalKeyFrame = this.syncBoneAngles();
        SkeletalAnimation skeletalAnimation = new SkeletalAnimation();
        skeletalAnimation.setBaseFrame((KeyFrame)skeletalKeyFrame);
        skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
        skeletalAnimation.setSkeleton(this.skeltonModel.getSkeleton());
        skeletalAnimation.getSuppliedPositions().set(0, true);
        skeletalAnimation.getSuppliedRotations().set(0, true);
        this.bodyAnimator.removeAnimator(0);
        AnimationAnimator animationAnimator = this.bodyAnimator.addAnimation((Animation)skeletalAnimation);
        animationAnimator.fadeIn(0.01f);
        animationAnimator.setCycleType(0);
        this.animationAnimator = animationAnimator;
    }

    public Bone findBone(String string) {
        return null;
    }

    protected void simpleRender() {
        this.display.getRenderer().draw((Spatial)this.guiNode);
        if (this.boneOn) {
            this.bodyInstance.setSkeletonMode(1);
        }
        if (this.doShot) {
            this.display.getRenderer().takeScreenShot(FileNameUtils.getRemovedExtensionName((String)FileNameUtils.getNotFoundFileName((File)new File(this.settingFrame.getExportPath(), "pose.png"))));
            this.doShot = false;
            if (this.visibleControls) {
                this.desktop.setCullMode(3);
            }
            this.fpsNode.setCullMode(3);
        }
    }

    public BoneInfoDataHash toBoneInfoDataHash() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo.isEnabled()) {
                Vector3f vector3f = this.getSteppedAngles(stringArray[i], this.currentPoseSteps);
                hashMap.put(BoneInfoDataHash.getRotKey(stringArray[i], "X"), "" + vector3f.x);
                hashMap.put(BoneInfoDataHash.getMinRotKey(stringArray[i], "X"), "" + bonePoseInfo.getMinAngleX());
                hashMap.put(BoneInfoDataHash.getMaxRotKey(stringArray[i], "X"), "" + bonePoseInfo.getMaxAngleX());
                hashMap.put(BoneInfoDataHash.getRotKey(stringArray[i], "Y"), "" + vector3f.y);
                hashMap.put(BoneInfoDataHash.getMinRotKey(stringArray[i], "Y"), "" + bonePoseInfo.getMinAngleY());
                hashMap.put(BoneInfoDataHash.getMaxRotKey(stringArray[i], "Y"), "" + bonePoseInfo.getMaxAngleY());
                hashMap.put(BoneInfoDataHash.getRotKey(stringArray[i], "Z"), "" + vector3f.z);
                hashMap.put(BoneInfoDataHash.getMinRotKey(stringArray[i], "Z"), "" + bonePoseInfo.getMinAngleZ());
                hashMap.put(BoneInfoDataHash.getMaxRotKey(stringArray[i], "Z"), "" + bonePoseInfo.getMaxAngleZ());
                String string = bonePoseInfo.getLabelName();
                if (string == null) {
                    string = bonePoseInfo.getKeyName();
                }
                hashMap.put(BoneInfoDataHash.getLabelKey(stringArray[i]), string);
                if (!bonePoseInfo.isLock()) continue;
                hashMap.put(BoneInfoDataHash.getLockKey(stringArray[i]), "1");
                continue;
            }
            hashMap.put(BoneInfoDataHash.getDisableKey(stringArray[i]), "1");
        }
        return new BoneInfoDataHash(hashMap);
    }

    public String getExportData() {
        System.out.println("exportdata");
        String string = "";
        try {
            String string2 = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/motiontools/blender_export.txt"));
            String string3 = "#version=0.1\r\n#akJ motion tools - RandomPoseEditor\r\n";
            String string4 = "";
            String[] stringArray = this.getBoneKeyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
                if (bonePoseInfo.isEnabled()) {
                    String string5;
                    string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getAngleX() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getMinAngleX() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getMaxAngleX() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getAngleY() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getMinAngleY() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getMaxAngleY() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getAngleZ() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getMinAngleZ() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getMaxAngleZ() + "\r\n";
                    if (bonePoseInfo.getSyncTarget() != null) {
                        string3 = string3 + "#" + BoneInfoDataHash.getSyncTargetKey(stringArray[i]) + "=" + bonePoseInfo.getSyncTarget().getKeyName() + "\r\n";
                        if (bonePoseInfo.getSyncMirrorX() != 1) {
                            string3 = string3 + "#" + BoneInfoDataHash.getSyncMirrorKey(stringArray[i], "X") + "=" + bonePoseInfo.getSyncMirrorX() + "\r\n";
                        }
                        if (bonePoseInfo.getSyncMirrorY() != 1) {
                            string3 = string3 + "#" + BoneInfoDataHash.getSyncMirrorKey(stringArray[i], "Y") + "=" + bonePoseInfo.getSyncMirrorY() + "\r\n";
                        }
                        if (bonePoseInfo.getSyncMirrorZ() != 1) {
                            string3 = string3 + "#" + BoneInfoDataHash.getSyncMirrorKey(stringArray[i], "Z") + "=" + bonePoseInfo.getSyncMirrorZ() + "\r\n";
                        }
                    }
                    if ((string5 = bonePoseInfo.getLabelName()) == null) {
                        string5 = bonePoseInfo.getKeyName();
                    }
                    string3 = string3 + "#" + BoneInfoDataHash.getLabelKey(stringArray[i]) + "=" + string5 + "\r\n";
                    if (bonePoseInfo.isLock()) {
                        string3 = string3 + "#" + BoneInfoDataHash.getLockKey(stringArray[i]) + "=" + "1" + "\r\n";
                    }
                    string4 = string4 + "bone=pose.bones['" + stringArray[i] + "']" + "\r\n";
                    Quaternion quaternion = bonePoseInfo.getRotation();
                    string4 = string4 + "bone.quat=Quaternion(" + quaternion.w + "," + quaternion.x + "," + quaternion.y + "," + quaternion.z + ")" + "\r\n";
                    string4 = string4 + "bone.insertKey(obj,newFrame,Pose.ROT)\r\n";
                    continue;
                }
                string3 = string3 + "#" + BoneInfoDataHash.getDisableKey(stringArray[i]) + "=1" + "\r\n";
            }
            string3 = string3 + "#end_data\r\n";
            string = string + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private Model loadModel(File file) throws IOException {
        MD5MeshReader mD5MeshReader = new MD5MeshReader();
        mD5MeshReader.setProperty("skin.classloader", (Object)new CustomLoader(file));
        return mD5MeshReader.readModel((InputStream)new FileInputStream(file));
    }

    private Model loadModel(URL uRL) throws IOException {
        MD5MeshReader mD5MeshReader = new MD5MeshReader();
        mD5MeshReader.setProperty("skin.classloader", (Object)new CustomLoader(null));
        if (uRL == null) {
            logger.warning("url is null.check resouces");
        }
        return mD5MeshReader.readModel(uRL.openStream());
    }

    private Animation createStillAnimation(Skeleton skeleton) {
        SkeletalAnimation skeletalAnimation = new SkeletalAnimation();
        SkeletalKeyFrame skeletalKeyFrame = skeleton.getBindFrame();
        SkeletalKeyFrame skeletalKeyFrame2 = new SkeletalKeyFrame();
        skeletalKeyFrame2.positions = (Vector3f[])skeletalKeyFrame.positions.clone();
        skeletalKeyFrame2.rotations = (Quaternion[])skeletalKeyFrame.rotations.clone();
        skeletalAnimation.setBaseFrame((KeyFrame)skeletalKeyFrame2);
        SkeletalKeyFrame skeletalKeyFrame3 = new SkeletalKeyFrame();
        skeletalKeyFrame3.positions = (Vector3f[])skeletalKeyFrame.positions.clone();
        skeletalKeyFrame3.rotations = (Quaternion[])skeletalKeyFrame.rotations.clone();
        skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame3);
        skeletalAnimation.setSkeleton(skeleton);
        skeletalAnimation.getSuppliedPositions().set(0, true);
        skeletalAnimation.getSuppliedRotations().set(0, true);
        return skeletalAnimation;
    }

    @Override
    public void setAnimePose(BoneInfoDataHash boneInfoDataHash) {
        this.animePoseDataHash = boneInfoDataHash;
    }

    @Override
    public void setRandomPose(BoneInfoDataHash boneInfoDataHash) {
        this.randomPoseDataHash = boneInfoDataHash;
    }

    public class CustomLoader
    extends ClassLoader {
        private String defaultResouce = "/textures/white.tga";
        private File md5file;

        public CustomLoader(File file) {
            this.md5file = file;
        }

        @Override
        public URL getResource(String string) {
            Serializable serializable;
            File file;
            System.out.println("resource:" + string);
            if (string.equals(".tga")) {
                logger.info("load default texture:" + this.defaultResouce);
                return this.getClass().getResource(this.defaultResouce);
            }
            if (string.endsWith(".tga.tga")) {
                string = string.substring(0, string.length() - 4);
            }
            if (string.endsWith(".png.png")) {
                string = string.substring(0, string.length() - 4);
            }
            if ((file = new File(string)).exists() && file.isFile()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            if (string.startsWith("//") && this.md5file != null) {
                serializable = new File(this.md5file.getParent(), string.substring(2));
                System.out.println("try blender same directory:" + ((File)serializable).getAbsolutePath());
                if (((File)serializable).exists() && ((File)serializable).isFile()) {
                    try {
                        return ((File)serializable).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            }
            if ((serializable = this.getClass().getResource("/" + string)) != null) {
                return serializable;
            }
            if (string.endsWith(".png") && !string.endsWith("_d.tga")) {
                logger.info("load default texture:" + this.defaultResouce);
                return this.getClass().getResource(this.defaultResouce);
            }
            return null;
        }
    }

    public static abstract class FileChoicer
    extends JPanel {
        private JTextField text;
        private Frame frame;
        private String nameFilter;
        private String dir;

        public FileChoicer(String string) {
            this.setLayout(new FlowLayout());
            this.add(new JLabel(string));
            this.text = new JTextField();
            this.text.setEditable(false);
            this.text.setColumns(12);
            this.add(this.text);
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(new ErrorCatchingGLActionListener(){

                @Override
                public void doGLAction(ActionEvent actionEvent) {
                    if (FileChoicer.this.frame == null) {
                        FileChoicer.this.frame = new Frame();
                    }
                    FileDialog fileDialog = new FileDialog(FileChoicer.this.frame);
                    if (FileChoicer.this.dir != null) {
                        fileDialog.setDirectory(FileChoicer.this.dir);
                    }
                    if (FileChoicer.this.nameFilter != null) {
                        fileDialog.setFile(FileChoicer.this.nameFilter);
                    }
                    fileDialog.setVisible(true);
                    if (fileDialog.getFile() != null) {
                        String string = fileDialog.getDirectory() + File.separatorChar + fileDialog.getFile();
                        FileChoicer.this.text.setText(string);
                        System.out.println(string);
                        FileChoicer.this.fileChanged(string);
                    }
                }
            });
            this.add(jButton);
            JButton jButton2 = new JButton("Reset");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FileChoicer.this.text.setText("");
                    FileChoicer.this.fileChanged("");
                }
            });
            this.add(jButton2);
        }

        protected abstract void fileChanged(String var1);

        public String getNameFilter() {
            return this.nameFilter;
        }

        public void setNameFilter(String string) {
            this.nameFilter = string;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String string) {
            this.dir = string;
        }
    }

    public class PoseAnimationInfo {
        private float current;
        private float start = 0.0f;
        private float end;
        private int direction = 1;
        private float addition;

        public float getCurrent() {
            return this.current;
        }

        public void setCurrent(float f) {
            this.current = f;
        }

        public float getStart() {
            return this.start;
        }

        public void setStart(float f) {
            this.start = f;
        }

        public float getEnd() {
            return this.end;
        }

        public void setEnd(float f) {
            this.end = f;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public float getAddition() {
            return this.addition;
        }

        public void setAddition(float f) {
            this.addition = f;
        }

        public void update() {
            this.current += this.addition * (float)this.direction;
            if (this.end > this.start) {
                if (this.current >= this.end || this.current <= this.start) {
                    this.direction *= -1;
                    if (this.current >= this.end) {
                        this.current = this.end;
                    } else if (this.current <= this.start) {
                        this.current = this.start;
                    }
                }
            } else {
                if (this.current <= this.end || this.current >= this.start) {
                    this.direction *= -1;
                }
                if (this.current <= this.end) {
                    this.current = this.end;
                } else if (this.current >= this.start) {
                    this.current = this.start;
                }
            }
        }
    }

    public static abstract class ErrorCatchingGLActionListener
    implements ActionListener {
        @Override
        public final void actionPerformed(final ActionEvent actionEvent) {
            Callable callable = new Callable(){

                public Object call() {
                    try {
                        ErrorCatchingGLActionListener.this.doGLAction(actionEvent);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Swing Action Error Caught!", exception);
                    }
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }

        public abstract void doGLAction(ActionEvent var1);
    }

    public class KeyInputControler
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Studio.this.enableKeyboardInput(false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Studio.this.enableKeyboardInput(true);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

