/*
 * Decompiled with CFR 0.152.
 */
package motiontools.poseEditor;

import com.jme.image.Texture;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.effects.glsl.BloomRenderPass;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import motiontools.MD5YogaMaster;
import motiontools.NumberValueChanger;
import motiontools.PoseBoneInfoDataHashContainer;
import org.apache.commons.lang.SystemUtils;
import utils.JMUtils;

public class PoseEditorSwingWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Spatial backgroundTarget;
    private Spatial bodyBrightTarget;
    private JTextField exportDir;
    private BloomRenderPass bloomRenderPass;
    public static final float bodyBrightDefault = 80.0f;
    public static final float blurSizeDefault = 0.02f;
    public static final float expowDefault = 10.0f;
    public static final float excutOffDefault = 0.0f;
    public static final float bimDefault = 0.6f;
    public static final float throttleDefault = 0.015f;
    private NumberValueChanger bodyBright;
    private NumberValueChanger throttle;
    private PoseBoneInfoDataHashContainer poseBoneInfoDataHashContainer;
    private NumberValueChanger bim;
    private NumberValueChanger excutOff;
    private NumberValueChanger expow;
    private NumberValueChanger blurSize;
    private JCheckBox bluarOnOff;
    private JCheckBox startAnimeFromAnime;
    private JCheckBox abaAnime;
    private MD5YogaMaster.FileChoicer animeFileChoicer;
    private MD5YogaMaster.FileChoicer randomFileChoicer;
    private JCheckBox backgroundOnOff;

    public String getExportPath() {
        return this.exportDir.getText();
    }

    public float getBodyBright() {
        return this.bodyBright.getValue();
    }

    public PoseEditorSwingWindow() {
        this.setLayout(new FlowLayout());
        this.setSize(400, 680);
        this.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.add(jPanel);
        MD5YogaMaster.FileChoicer fileChoicer = new MD5YogaMaster.FileChoicer("background"){

            @Override
            public void fileChanged(String string) {
                if (string.equals("")) {
                    if (PoseEditorSwingWindow.this.backgroundTarget != null) {
                        PoseEditorSwingWindow.this.backgroundTarget.clearRenderState(6);
                        PoseEditorSwingWindow.this.backgroundTarget.updateRenderState();
                        PoseEditorSwingWindow.this.backgroundOnOff.setSelected(false);
                        PoseEditorSwingWindow.this.backgroundTarget.setCullMode(2);
                    }
                } else {
                    try {
                        if (PoseEditorSwingWindow.this.backgroundTarget != null) {
                            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                            Texture texture = TextureManager.loadTexture((Image)ImageIO.read(new File(string)), (int)0, (int)0, (float)1.0f, (boolean)true);
                            textureState.setTexture(texture);
                            PoseEditorSwingWindow.this.backgroundTarget.setRenderState((RenderState)textureState);
                            PoseEditorSwingWindow.this.backgroundTarget.updateRenderState();
                            PoseEditorSwingWindow.this.backgroundOnOff.setSelected(true);
                            PoseEditorSwingWindow.this.backgroundTarget.setCullMode(3);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Images (*.png;*.jpg;*.gif)", "png", "jpg", "gif");
        fileChoicer.setFileFilter(fileNameExtensionFilter);
        jPanel.add(fileChoicer);
        this.backgroundOnOff = new JCheckBox("show Background");
        this.backgroundOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    PoseEditorSwingWindow.this.backgroundTarget.setCullMode(3);
                } else {
                    PoseEditorSwingWindow.this.backgroundTarget.setCullMode(2);
                }
            }
        });
        jPanel.add(this.backgroundOnOff);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton = new JButton("export");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.chooseEexportDir((Component)actionEvent.getSource());
                PoseEditorSwingWindow.this.animeFileChoicer.setDir(PoseEditorSwingWindow.this.exportDir.getText());
                PoseEditorSwingWindow.this.randomFileChoicer.setDir(PoseEditorSwingWindow.this.exportDir.getText());
            }
        });
        jPanel2.add(jButton);
        this.exportDir = new JTextField();
        this.exportDir.setColumns(16);
        this.exportDir.setEditable(false);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.exportDir.setText(FileNameUtils.getMyDocumentsPath());
        } else {
            this.exportDir.setText(System.getProperty("user.home"));
        }
        jPanel2.add(this.exportDir);
        jPanel.add(jPanel2);
        this.randomFileChoicer = new MD5YogaMaster.FileChoicer("randam"){

            @Override
            public void fileChanged(String string) {
                if (string.equals("")) {
                    PoseEditorSwingWindow.this.poseBoneInfoDataHashContainer.setRandomPose(null);
                } else {
                    PoseEditorSwingWindow.this.poseBoneInfoDataHashContainer.setRandomPose(MD5YogaMaster.loadDataHash(new File(string)));
                }
            }
        };
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter("Pose Data (*.txt)", "txt");
        this.randomFileChoicer.setFileFilter(fileNameExtensionFilter2);
        this.randomFileChoicer.setDir(this.exportDir.getText());
        jPanel.add(this.randomFileChoicer);
        this.animeFileChoicer = new MD5YogaMaster.FileChoicer("anime"){

            @Override
            public void fileChanged(String string) {
                if (string.equals("")) {
                    PoseEditorSwingWindow.this.poseBoneInfoDataHashContainer.setAnimePose(null);
                } else {
                    PoseEditorSwingWindow.this.poseBoneInfoDataHashContainer.setAnimePose(MD5YogaMaster.loadDataHash(new File(string)));
                }
            }
        };
        this.animeFileChoicer.setDir(this.exportDir.getText());
        this.randomFileChoicer.setFileFilter(fileNameExtensionFilter2);
        jPanel.add(this.animeFileChoicer);
        JPanel jPanel3 = new JPanel();
        jPanel.add(jPanel3);
        this.startAnimeFromAnime = new JCheckBox("start this anime");
        this.startAnimeFromAnime.setSelected(false);
        this.startAnimeFromAnime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel3.add(this.startAnimeFromAnime);
        this.abaAnime = new JCheckBox("A->B->A");
        this.abaAnime.setSelected(true);
        this.abaAnime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel3.add(this.abaAnime);
        this.bluarOnOff = new JCheckBox("Use Bluar");
        this.bluarOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jPanel.add(this.bluarOnOff);
        this.blurSize = new NumberValueChanger("BlurSize", 0.0f, 1.0f, 0.02f, 0.001f, 0.01f);
        this.blurSize.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSwingWindow.this.bloomRenderPass.setBlurSize(numberValueChanger.getValue());
            }
        });
        this.add(this.blurSize);
        this.expow = new NumberValueChanger("Expow", 0.0f, 100.0f, 10.0f, 1.0f, 5.0f);
        this.expow.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSwingWindow.this.bloomRenderPass.setExposurePow(numberValueChanger.getValue());
            }
        });
        this.add(this.expow);
        this.excutOff = new NumberValueChanger("ExCOff", -100.0f, 1.0f, 0.0f, 0.01f, 0.1f);
        this.excutOff.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSwingWindow.this.bloomRenderPass.setExposureCutoff(numberValueChanger.getValue());
            }
        });
        this.add(this.excutOff);
        this.bim = new NumberValueChanger("BIM", 0.0f, 100.0f, 0.6f, 0.1f, 1.0f);
        this.bim.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSwingWindow.this.bloomRenderPass.setBlurIntensityMultiplier(numberValueChanger.getValue());
            }
        });
        this.add(this.bim);
        this.throttle = new NumberValueChanger("throttle", 0.0f, 100.0f, 0.015f, 0.01f, 0.25f);
        this.throttle.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSwingWindow.this.bloomRenderPass.setThrottle(numberValueChanger.getValue());
            }
        });
        this.add(this.throttle);
        this.bodyBright = new NumberValueChanger("bodyBright", 0.0f, 255.0f, 80.0f, 1.0f, 5.0f);
        this.bodyBright.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                float f = numberValueChanger.getValue();
                JMUtils.setEmissiveState(PoseEditorSwingWindow.this.bodyBrightTarget, (int)f, (int)f, (int)f);
                PoseEditorSwingWindow.this.bodyBrightTarget.updateRenderState();
            }
        });
        this.add(this.bodyBright);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 4));
        this.add(jPanel4);
        JButton jButton2 = new JButton("default");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(0.6f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(false);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(false);
            }
        });
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton("natural");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(0.6f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton("real");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.bodyBright.setValue(0.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(false);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(false);
            }
        });
        jPanel4.add(jButton4);
        JButton jButton5 = new JButton("comic");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.bodyBright.setValue(255.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(false);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(false);
            }
        });
        jPanel4.add(jButton5);
        JButton jButton6 = new JButton("warm");
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSwingWindow.this.expow.setValue(30.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(0.8f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton6);
        JButton jButton7 = new JButton("light");
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(3.6f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(0.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton7);
        JButton jButton8 = new JButton("aura");
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSwingWindow.this.expow.setValue(50.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(7.0f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton8);
        JButton jButton9 = new JButton("fire");
        jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.15f);
                PoseEditorSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(4.0f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton9);
        JButton jButton10 = new JButton("fog");
        jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.42f);
                PoseEditorSwingWindow.this.expow.setValue(2.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSwingWindow.this.bim.setValue(3.4f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(0.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton10);
        JButton jButton11 = new JButton("fairly");
        jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSwingWindow.this.blurSize.setValue(0.03f);
                PoseEditorSwingWindow.this.expow.setValue(2.0f);
                PoseEditorSwingWindow.this.excutOff.setValue(-0.52f);
                PoseEditorSwingWindow.this.bim.setValue(1.0f);
                PoseEditorSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel4.add(jButton11);
    }

    public void loadSettings(InputStream inputStream) {
    }

    public void saveSettings(File file) {
    }

    public Spatial getBackgroundTarget() {
        return this.backgroundTarget;
    }

    public void setBackgroundTarget(Spatial spatial) {
        this.backgroundTarget = spatial;
    }

    private void chooseEexportDir(Component component) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.exportDir.getText());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setVisible(true);
        if (jFileChooser.showOpenDialog(component) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.exportDir.setText(file.getAbsolutePath());
        }
    }

    public boolean isABAAnimation() {
        return this.abaAnime.isSelected();
    }

    public boolean isStartAnimationFromAnimePose() {
        return this.startAnimeFromAnime.isSelected();
    }

    public void setStartAnimationFromAnimePose(boolean bl) {
        this.startAnimeFromAnime.setSelected(bl);
    }

    public Spatial getBodyBrightTarget() {
        return this.bodyBrightTarget;
    }

    public void setBodyBrightTarget(Spatial spatial) {
        this.bodyBrightTarget = spatial;
    }

    public BloomRenderPass getBloomRenderPass() {
        return this.bloomRenderPass;
    }

    public void setBloomRenderPass(BloomRenderPass bloomRenderPass) {
        this.bloomRenderPass = bloomRenderPass;
    }

    public PoseBoneInfoDataHashContainer getPoseBoneInfoDataHashContainer() {
        return this.poseBoneInfoDataHashContainer;
    }

    public void setPoseBoneInfoDataHashContainer(PoseBoneInfoDataHashContainer poseBoneInfoDataHashContainer) {
        this.poseBoneInfoDataHashContainer = poseBoneInfoDataHashContainer;
    }
}

