/*
 * Decompiled with CFR 0.152.
 */
package motiontools;

import bone.BlenderBoneLoader;
import bone.BoneData;
import com.jme.animation.Bone;
import com.jme.app.SimpleGame;
import com.jme.input.FirstPersonHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.MouseInput;
import com.jme.input.action.InputActionEvent;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.util.BoneDebugger;
import com.jmex.awt.swingui.JMEAction;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.model.XMLparser.JmeBinaryReader;
import com.jmex.model.XMLparser.XMLtoBinary;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import utils.JMUtils;

public class YogaMaster
extends SimpleGame {
    private static final Logger logger = Logger.getLogger(YogaMaster.class.getName());
    private Bone rootBone;
    private BoneData[] boneDatas;
    private Node guiNode;
    private boolean boneOn;
    Node sceneRootNode;
    private JCheckBox overwrite;
    private JTextField fileName;
    private JTextField exportDir;
    private Map<String, BonePoseInfo> bonePoseInfoMap = new HashMap<String, BonePoseInfo>();
    private boolean doAnimation;
    float angle = 0.0f;
    float add = 1.0f;
    private BoneInfoDataHash poseInfoDataHash = new BoneInfoDataHash(new HashMap());
    private Map<String, PoseAnimationInfo> poseMap;
    private Node modelNode;

    public static void main(String[] stringArray) {
        YogaMaster yogaMaster = new YogaMaster();
        yogaMaster.setDialogBehaviour(2);
        yogaMaster.start();
    }

    public void openData(InputStream inputStream) {
        try {
            List list = IOUtils.readLines((InputStream)inputStream);
            this.openData(list);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void openData(List list) {
        try {
            String[] stringArray;
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals("#end_data"); ++i) {
                if (!string.startsWith("#") || string.indexOf("=") == -1 || (stringArray = string.substring(1).split("=")).length <= 1) continue;
                hashMap.put(stringArray[0], stringArray[1]);
                System.out.println("pud-data:" + stringArray[0] + "," + stringArray[1]);
            }
            this.poseInfoDataHash = new BoneInfoDataHash(hashMap);
            String[] stringArray2 = this.getBoneKeyNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = this.findBonePoseInfo(stringArray2[i]);
                if (stringArray != null) {
                    stringArray.setAngleX(this.poseInfoDataHash.getRotX(stringArray2[i], stringArray.getAngleX()));
                    stringArray.setAngleY(this.poseInfoDataHash.getRotY(stringArray2[i], stringArray.getAngleY()));
                    stringArray.setAngleZ(this.poseInfoDataHash.getRotZ(stringArray2[i], stringArray.getAngleZ()));
                    stringArray.setMinAngleX(this.poseInfoDataHash.getMinRotX(stringArray2[i], stringArray.getMinAngleX()));
                    stringArray.setMinAngleY(this.poseInfoDataHash.getMinRotY(stringArray2[i], stringArray.getMinAngleY()));
                    stringArray.setMinAngleZ(this.poseInfoDataHash.getMinRotZ(stringArray2[i], stringArray.getMinAngleZ()));
                    stringArray.setMaxAngleX(this.poseInfoDataHash.getMaxRotX(stringArray2[i], stringArray.getMaxAngleX()));
                    stringArray.setMaxAngleY(this.poseInfoDataHash.getMaxRotY(stringArray2[i], stringArray.getMaxAngleY()));
                    stringArray.setMaxAngleZ(this.poseInfoDataHash.getMaxRotZ(stringArray2[i], stringArray.getMaxAngleZ()));
                    stringArray.setLocked(this.poseInfoDataHash.isLocked(stringArray2[i]));
                    stringArray.setLabelName(this.poseInfoDataHash.getLabelName(stringArray2[i]));
                    continue;
                }
                logger.warning("no pose info:" + stringArray2[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openModel(File file) {
        try {
            char c = File.separator.charAt(0);
            String string = file.getAbsolutePath().replace(c, '/');
            System.out.println(string);
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            URL uRL = new URL("file", "", string);
            this.openModel(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openModel(URL uRL) {
        Object object;
        InputStream inputStream;
        if (this.modelNode != null) {
            this.rootNode.detachChild((Spatial)this.modelNode);
        }
        XMLtoBinary xMLtoBinary = new XMLtoBinary();
        JmeBinaryReader jmeBinaryReader = new JmeBinaryReader();
        jmeBinaryReader.setProperty("bound", (Object)"box");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.modelNode = null;
        try {
            inputStream = uRL.openStream();
            object = BlenderBoneLoader.skeltonMeshToMesh(inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            xMLtoBinary.sendXMLtoBinary((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream);
            this.modelNode = jmeBinaryReader.loadBinaryFormat((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            logger.info("modelNode-scale:" + this.modelNode.getLocalScale());
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.printInfo((Spatial)this.modelNode);
        this.rootNode.attachChild((Spatial)this.modelNode);
        this.modelNode.setLocalRotation(new Quaternion());
        inputStream = (Node)this.modelNode.getChild(0);
        logger.info("default-scale:" + inputStream.getLocalScale());
        inputStream.setLocalScale(1.0f);
        inputStream.setLocalRotation(new Quaternion());
        try {
            object = uRL.openStream();
            this.boneDatas = BlenderBoneLoader.loadBone((InputStream)object);
            logger.info("boneData loaded:" + this.boneDatas.length);
            for (int i = 0; i < this.boneDatas.length; ++i) {
                BoneData boneData = this.boneDatas[i];
                this.rootNode.attachChild((Spatial)boneData.getBone());
                this.rootBone = boneData.getBone();
                try {
                    logger.info("bone-name:" + boneData.getName());
                    logger.info("" + inputStream.getChild(boneData.getName()));
                    Geometry geometry = (Geometry)inputStream.getChild(boneData.getName());
                    if (geometry != null) {
                        logger.info("geo:" + geometry.getLocalScale());
                        boneData.setSkin((Geometry)inputStream.getChild(boneData.getName()));
                        boneData.update();
                        continue;
                    }
                    logger.warning("null geo:" + boneData.getName());
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles(0.0f, (float)Math.PI, 0.0f);
        if (this.rootBone == null) {
            logger.warning("maybe you dont use skelton save mode or not set armature as parent");
        }
        this.rootBone.setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.rootBone.setLocalRotation(quaternion);
        logger.info("rootBone-loc:" + this.rootBone.getLocalTranslation());
        this.modelNode.updateRenderState();
    }

    public void enableKeyboardInput(boolean bl) {
        logger.info("set key input:" + bl);
        ((FirstPersonHandler)this.input).getKeyboardLookHandler().setEnabled(bl);
    }

    public void createDesktop() {
        this.guiNode = new Node("gui");
        this.guiNode.setRenderQueueMode(4);
        final JMEDesktop jMEDesktop = new JMEDesktop("desktop", 420, 750, this.input);
        jMEDesktop.getJDesktop().setBackground(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.guiNode.attachChild((Spatial)jMEDesktop);
        jMEDesktop.getLocalTranslation().set((float)(jMEDesktop.getJDesktop().getSize().width / 2), (float)(jMEDesktop.getJDesktop().getSize().height / 2 + 20), 0.0f);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jMEDesktop.getJDesktop().setBackground(new Color(0.0f, 0.0f, 1.0f, 0.0f));
                JPanel jPanel = new JPanel();
                jMEDesktop.getJDesktop().add(jPanel);
                JButton jButton = new JButton("model");
                jPanel.add(jButton);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.openModel();
                    }
                });
                jPanel.setLayout(new FlowLayout());
                JButton jButton2 = new JButton("browser");
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.chooseEexportDir(jMEDesktop.getJDesktop());
                    }
                });
                jPanel.add(jButton2);
                YogaMaster.this.exportDir = new JTextField();
                YogaMaster.this.exportDir.setColumns(16);
                if (SystemUtils.IS_OS_WINDOWS) {
                    YogaMaster.this.exportDir.setText(FileNameUtils.getMyDocumentsPath());
                } else {
                    YogaMaster.this.exportDir.setText(System.getProperty("user.home"));
                }
                jPanel.add(YogaMaster.this.exportDir);
                jPanel.setLocation(0, 0);
                jPanel.setSize(jMEDesktop.getJDesktop().getWidth(), 330);
                JCheckBox jCheckBox = new JCheckBox("show bone");
                jPanel.add(jCheckBox);
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.boneOn = ((JCheckBox)actionEvent.getSource()).isSelected();
                    }
                });
                jCheckBox.addActionListener((ActionListener)new JMEAction("my action", YogaMaster.this.input){

                    public void performAction(InputActionEvent inputActionEvent) {
                        logger.info("updated");
                        YogaMaster.this.guiNode.updateRenderState();
                    }
                });
                YogaMaster.this.fileName = new JTextField();
                YogaMaster.this.fileName.setText("pose_data");
                YogaMaster.this.fileName.setColumns(12);
                jPanel.add(YogaMaster.this.fileName);
                jPanel.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        YogaMaster.this.enableKeyboardInput(false);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        YogaMaster.this.enableKeyboardInput(true);
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                JButton jButton3 = new JButton("save");
                jPanel.add(jButton3);
                jButton3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.save(YogaMaster.this.fileName.getText(), YogaMaster.this.overwrite.isSelected());
                    }
                });
                YogaMaster.this.overwrite = new JCheckBox("ow");
                YogaMaster.this.overwrite.setToolTipText("overwrite or not");
                jPanel.add(YogaMaster.this.overwrite);
                JButton jButton4 = new JButton("load");
                jPanel.add(jButton4);
                jButton4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.openData();
                    }
                });
                JButton jButton5 = new JButton("R");
                jButton5.setToolTipText("random it");
                jButton5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.randomAll();
                    }
                });
                jPanel.add(jButton5);
                JButton jButton6 = new JButton("D");
                jButton6.setToolTipText("back to default readed data");
                jButton6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.defaultAll();
                    }
                });
                jPanel.add(jButton6);
                jPanel.add(jButton5);
                JButton jButton7 = new JButton("Z");
                jButton6.setToolTipText("set all value to zero");
                jButton7.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.zeroAll();
                    }
                });
                jPanel.add(jButton7);
                JCheckBox jCheckBox2 = new JCheckBox("Anime");
                jCheckBox2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        YogaMaster.this.switchAnime(((JCheckBox)actionEvent.getSource()).isSelected());
                    }
                });
                jPanel.add(jCheckBox2);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(0, 1));
                String[] stringArray = YogaMaster.this.getBoneKeyNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    BonePoseInfo bonePoseInfo;
                    if (i == 0) {
                        bonePoseInfo = new BonePoseInfo(true);
                        bonePoseInfo.setName(stringArray[i]);
                        jPanel.add(bonePoseInfo);
                        YogaMaster.this.bonePoseInfoMap.put(bonePoseInfo.getName(), bonePoseInfo);
                        continue;
                    }
                    bonePoseInfo = new BonePoseInfo(false);
                    bonePoseInfo.setName(stringArray[i]);
                    jPanel2.add(bonePoseInfo);
                    YogaMaster.this.bonePoseInfoMap.put(bonePoseInfo.getName(), bonePoseInfo);
                }
                JScrollPane jScrollPane = new JScrollPane(jPanel2);
                jMEDesktop.getJDesktop().add(jScrollPane);
                jScrollPane.setLocation(0, 330);
                jScrollPane.setSize(420, 400);
                jScrollPane.setVisible(true);
                jMEDesktop.getJDesktop().updateUI();
                logger.info("desktop updated");
                logger.info("top-panel:" + jPanel.getSize());
                logger.info("desktop" + jMEDesktop.getJDesktop().getSize());
                YogaMaster.this.openData(this.getClass().getResourceAsStream("/motiontools/default_pose.txt"));
            }
        });
        this.guiNode.setCullMode(3);
        this.guiNode.setLightCombineMode(0);
        this.guiNode.updateRenderState();
        this.guiNode.updateGeometricState(0.0f, true);
        MouseInput.get().setCursorVisible(true);
    }

    private void chooseEexportDir(Component component) {
        File file;
        JFileChooser jFileChooser = new JFileChooser("choose export");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setVisible(true);
        if (jFileChooser.showOpenDialog(component) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.exportDir.setText(file.getAbsolutePath());
        }
    }

    public void openModel() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "load model");
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            this.openModel(file);
        }
        frame.dispose();
    }

    public void openData() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "load pose");
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            try {
                this.openData(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        frame.dispose();
    }

    private void switchAnime(boolean bl) {
        this.doAnimation = bl;
    }

    private void defaultAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null) {
                bonePoseInfo.setAngleX(this.poseInfoDataHash.getRotX(stringArray[i], bonePoseInfo.getAngleX()));
                bonePoseInfo.setAngleY(this.poseInfoDataHash.getRotY(stringArray[i], bonePoseInfo.getAngleY()));
                bonePoseInfo.setAngleZ(this.poseInfoDataHash.getRotZ(stringArray[i], bonePoseInfo.getAngleZ()));
                bonePoseInfo.setMinAngleX(this.poseInfoDataHash.getMinRotX(stringArray[i], bonePoseInfo.getMinAngleX()));
                bonePoseInfo.setMinAngleY(this.poseInfoDataHash.getMinRotY(stringArray[i], bonePoseInfo.getMinAngleY()));
                bonePoseInfo.setMinAngleZ(this.poseInfoDataHash.getMinRotZ(stringArray[i], bonePoseInfo.getMinAngleZ()));
                bonePoseInfo.setMaxAngleX(this.poseInfoDataHash.getMaxRotX(stringArray[i], bonePoseInfo.getMaxAngleX()));
                bonePoseInfo.setMaxAngleY(this.poseInfoDataHash.getMaxRotY(stringArray[i], bonePoseInfo.getMaxAngleY()));
                bonePoseInfo.setMaxAngleZ(this.poseInfoDataHash.getMaxRotZ(stringArray[i], bonePoseInfo.getMaxAngleZ()));
                continue;
            }
            logger.warning("no pose info:" + stringArray[i]);
        }
    }

    private void zeroAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null) {
                bonePoseInfo.setAngleX(0);
                bonePoseInfo.setAngleY(0);
                bonePoseInfo.setAngleZ(0);
                continue;
            }
            logger.warning("no pose info:" + stringArray[i]);
        }
    }

    public void randomAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo.isLocked()) continue;
            bonePoseInfo.random();
        }
    }

    public void save(String string, boolean bl) {
        String string2 = this.getExportData();
        File file = new File(this.exportDir.getText(), string + ".txt");
        if (!bl) {
            String string3 = FileNameUtils.getNotFoundFileName((File)file);
            logger.info("savedName:" + string3);
            file = new File(string3);
            this.fileName.setText(FileNameUtils.getRemovedExtensionName((String)file.getName()));
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void simpleInitGame() {
        System.out.println(this.cam.getLeft() + "," + this.cam.getUp());
        KeyBindingManager.getKeyBindingManager().set("bones", 57);
        KeyBindingManager.getKeyBindingManager().set("num1", 79);
        KeyBindingManager.getKeyBindingManager().set("num3", 81);
        ((FirstPersonHandler)this.input).getMouseLookHandler().setEnabled(false);
        this.sceneRootNode = new Node("sceneRootNode");
        this.rootNode.attachChild((Spatial)this.sceneRootNode);
        this.openModel(((Object)((Object)this)).getClass().getResource("/motiontools/models/man1.xml"));
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.attach(JMUtils.createLight(new Vector3f(0.0f, 7.0f, -25.0f)));
        lightState.attach(JMUtils.createLight(new Vector3f(0.0f, 7.0f, 25.0f)));
        this.lightState.detachAll();
        this.rootNode.setRenderState((RenderState)lightState);
        this.createDesktop();
        this.cam.setLocation(new Vector3f(4.5f, 0.0f, -19.0f));
        this.cam.setDirection(new Vector3f(0.0f, 0.0f, 1.0f));
        this.cam.setLeft(new Vector3f(-1.0f, 0.0f, 0.0f));
        this.cam.update();
        logger.info("" + this.cam.getDirection());
    }

    public String[] getBoneKeyNames() {
        return new String[]{"joint0", "joint1", "joint2", "joint3", "joint5", "joint7", "joint11", "joint30", "joint4", "joint6", "joint10", "joint14", "joint57", "joint13", "joint9", "joint46", "joint12", "joint8"};
    }

    public void printInfo(Spatial spatial) {
        block4: {
            block3: {
                if (!(spatial instanceof Node)) break block3;
                Node node = (Node)spatial;
                System.out.println("node:" + node.getName());
                for (int i = 0; i < node.getQuantity(); ++i) {
                    this.printInfo(node.getChild(i));
                }
                break block4;
            }
            if (!(spatial instanceof TriMesh)) break block4;
            TriMesh triMesh = (TriMesh)spatial;
            int n = triMesh.getBatchCount();
            System.out.println("triMesh:" + triMesh.getName());
            for (int i = 0; i < n; ++i) {
                System.out.println(triMesh.getVertexBuffer(i));
                if (triMesh.getVertexBuffer(i) != null) {
                    System.out.println(i + "=" + triMesh.getVertexBuffer(i).capacity() / 3);
                    continue;
                }
                logger.warning("have empty batch make crash" + triMesh.getName());
            }
        }
    }

    public void printBone(Bone bone) {
        System.out.println(bone.getName() + "," + bone.getLocalTranslation());
        for (int i = 0; i < bone.getQuantity(); ++i) {
            this.printBone((Bone)bone.getChild(i));
        }
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("bones", false)) {
            boolean bl = this.boneOn = !this.boneOn;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("num1_ctrl", false)) {
            System.out.println("num1_c");
        } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num1", false)) {
            this.cam.setLocation(new Vector3f(0.0f, 0.0f, -19.0f));
            this.cam.setDirection(new Vector3f(0.0f, 0.0f, 1.0f));
            this.cam.setLeft(new Vector3f(-1.0f, 0.0f, 0.0f));
            System.out.println("num1");
        } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num3", false)) {
            System.out.println("num3");
        }
        if (this.doAnimation) {
            int n;
            String[] stringArray;
            int n2 = 150;
            if (this.poseMap == null) {
                this.poseMap = new HashMap<String, PoseAnimationInfo>();
                stringArray = this.getBoneKeyNames();
                for (n = 0; n < stringArray.length; ++n) {
                    this.poseMap.put(BoneInfoDataHash.getRotKey(stringArray[n], "X"), new PoseAnimationInfo());
                    this.poseMap.put(BoneInfoDataHash.getRotKey(stringArray[n], "Y"), new PoseAnimationInfo());
                    this.poseMap.put(BoneInfoDataHash.getRotKey(stringArray[n], "Z"), new PoseAnimationInfo());
                }
            }
            stringArray = this.getBoneKeyNames();
            for (n = 0; n < stringArray.length; ++n) {
                BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[n]);
                Bone bone = this.findBone(stringArray[n]);
                if (bonePoseInfo != null && bone != null) {
                    PoseAnimationInfo poseAnimationInfo = this.poseMap.get(BoneInfoDataHash.getRotKey(stringArray[n], "X"));
                    float f = bonePoseInfo.getAngleX();
                    poseAnimationInfo.setEnd(f);
                    poseAnimationInfo.setAddition(Math.abs(f) / (float)n2);
                    PoseAnimationInfo poseAnimationInfo2 = this.poseMap.get(BoneInfoDataHash.getRotKey(stringArray[n], "Y"));
                    float f2 = bonePoseInfo.getAngleY();
                    poseAnimationInfo2.setEnd(f2);
                    poseAnimationInfo2.setAddition(Math.abs(f2) / (float)n2);
                    PoseAnimationInfo poseAnimationInfo3 = this.poseMap.get(BoneInfoDataHash.getRotKey(stringArray[n], "Z"));
                    float f3 = bonePoseInfo.getAngleZ();
                    poseAnimationInfo3.setEnd(f3);
                    poseAnimationInfo3.setAddition(Math.abs(f3) / (float)n2);
                    Quaternion quaternion = new Quaternion();
                    quaternion.fromAngles(poseAnimationInfo.getCurrent() * ((float)Math.PI / 180), poseAnimationInfo2.getCurrent() * ((float)Math.PI / 180), poseAnimationInfo3.getCurrent() * ((float)Math.PI / 180));
                    bone.setLocalRotation(quaternion);
                    poseAnimationInfo.update();
                    poseAnimationInfo2.update();
                    poseAnimationInfo3.update();
                    continue;
                }
                if (bonePoseInfo == null) {
                    logger.info("info not found:" + stringArray[n]);
                }
                if (bone != null) continue;
                logger.info("bone not found:" + stringArray[n]);
            }
            this.updateBoneData();
        } else {
            String[] stringArray = this.getBoneKeyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.syncBoneAngle(stringArray[i]);
            }
            this.updateBoneData();
        }
    }

    private void syncBoneAngle(String string) {
        Bone bone = this.findBone(string);
        BonePoseInfo bonePoseInfo = this.findBonePoseInfo(string);
        if (bone == null || bonePoseInfo == null) {
            logger.warning("no bone or info:" + string);
            return;
        }
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles((float)bonePoseInfo.getAngleX() * ((float)Math.PI / 180), (float)bonePoseInfo.getAngleY() * ((float)Math.PI / 180), (float)bonePoseInfo.getAngleZ() * ((float)Math.PI / 180));
        bone.setLocalRotation(quaternion);
    }

    private BonePoseInfo findBonePoseInfo(String string) {
        return this.bonePoseInfoMap.get(string);
    }

    public void updateBoneData() {
        for (int i = 0; i < this.boneDatas.length; ++i) {
            this.boneDatas[i].update();
        }
    }

    public Bone findBone(String string) {
        return BoneData.findBone(this.rootBone, string);
    }

    protected void simpleRender() {
        this.display.getRenderer().draw((Spatial)this.guiNode);
        if (this.boneOn) {
            BoneDebugger.drawBones((Spatial)this.rootNode, (Renderer)this.display.getRenderer(), (boolean)true);
        }
    }

    public String getExportData() {
        System.out.println("exportdata");
        String string = "";
        try {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String[] stringArray = this.getBoneKeyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
                if (!bonePoseInfo.isEnabled()) continue;
                string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getAngleX() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getMinAngleX() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getMaxAngleX() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getAngleY() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getMinAngleY() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getMaxAngleY() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getAngleZ() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getMinAngleZ() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getMaxAngleZ() + "\r\n";
                string3 = string3 + "#" + BoneInfoDataHash.getLabelKey(stringArray[i]) + "=" + bonePoseInfo.getLabelName() + "\r\n";
                if (bonePoseInfo.isLocked()) {
                    string3 = string3 + "#" + BoneInfoDataHash.getLockKey(stringArray[i]) + "=" + "1" + "\r\n";
                }
                string4 = string4 + "bone=pose.bones['" + stringArray[i] + "']" + "\r\n";
                Quaternion quaternion = bonePoseInfo.getBlenderQuaternion();
                string4 = string4 + "bone.quat=Quaternion(" + quaternion.w + "," + quaternion.x + "," + quaternion.y + "," + quaternion.z + ")" + "\r\n";
                string4 = string4 + "bone.insertKey(obj,newFrame,Pose.ROT)\r\n";
            }
            string3 = string3 + "#end_data\r\n";
            string = string + string3;
            string = string + string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public class PoseAnimationInfo {
        private float current;
        private float start = 0.0f;
        private float end;
        private int direction = 1;
        private float addition;

        public float getCurrent() {
            return this.current;
        }

        public void setCurrent(float f) {
            this.current = f;
        }

        public float getStart() {
            return this.start;
        }

        public void setStart(float f) {
            this.start = f;
        }

        public float getEnd() {
            return this.end;
        }

        public void setEnd(float f) {
            this.end = f;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public float getAddition() {
            return this.addition;
        }

        public void setAddition(float f) {
            this.addition = f;
        }

        public void update() {
            this.current += this.addition * (float)this.direction;
            if (this.end > this.start) {
                if (this.current >= this.end || this.current <= this.start) {
                    this.direction *= -1;
                    if (this.current >= this.end) {
                        this.current = this.end;
                    } else if (this.current <= this.start) {
                        this.current = this.start;
                    }
                }
            } else {
                if (this.current <= this.end || this.current >= this.start) {
                    this.direction *= -1;
                }
                if (this.current <= this.end) {
                    this.current = this.end;
                } else if (this.current >= this.start) {
                    this.current = this.start;
                }
            }
        }
    }

    public class BonePoseInfo
    extends JPanel {
        private String keyName;
        private String labelName;
        JCheckBox lock;
        JLabel label;
        SliderControl controlX;
        SliderControl controlY;
        SliderControl controlZ;
        public boolean root;

        public String getLabelName() {
            if (this.labelName == null) {
                return this.keyName;
            }
            return this.labelName;
        }

        public void setLabelName(String string) {
            this.labelName = string;
            if (string == null) {
                this.label.setText(this.keyName);
            } else {
                this.label.setText(this.labelName);
            }
        }

        public boolean isLocked() {
            return this.lock.isSelected();
        }

        public void setLocked(boolean bl) {
            this.lock.setSelected(bl);
        }

        public Quaternion getBlenderQuaternion() {
            Quaternion quaternion = new Quaternion();
            float f = this.getAngleX();
            float f2 = this.getAngleY();
            float f3 = this.getAngleZ();
            if (this.isRoot()) {
                f = this.getAngleX();
                f2 = this.getAngleY();
                f3 = this.getAngleZ();
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (f3 != 0.0f) {
                    if (f3 <= 90.0f && f3 >= -90.0f) {
                        f4 = (float)((double)f3 * 16.553055 / 90.0);
                        f5 = (float)((double)f3 * 16.553055 / 90.0);
                    } else {
                        int n = 1;
                        if (f3 < 0.0f) {
                            n *= -1;
                        }
                        f4 = (float)((double)(f3 * (float)n) * 16.553055 / 90.0);
                        f5 = (float)((double)(90 * n) * 16.553055 / 90.0);
                        f5 -= (float)((double)(f3 - (float)(90 * n)) * 16.553055 / 90.0);
                    }
                }
            } else {
                float f7;
                Vector3f vector3f = YogaMaster.this.findBone("joint0").getBindMatrix().toTranslationVector();
                logger.info("root:" + vector3f);
                Bone bone = YogaMaster.this.findBone(this.keyName);
                Bone bone2 = (Bone)bone.getParent();
                Vector3f vector3f2 = bone.getBindMatrix().toTranslationVector().subtract(vector3f).subtract(bone2.getBindMatrix().toTranslationVector().subtract(vector3f));
                logger.info(this.keyName + ",diff=" + vector3f2);
                if (!(Math.abs(f3) >= Math.abs(f)) || Math.abs(f3) >= Math.abs(f2)) {
                    // empty if block
                }
                if (this.keyName.equals("joint1") || this.keyName.equals("joint2") || this.keyName.equals("joint3")) {
                    f *= -1.0f;
                    f3 *= -1.0f;
                }
                if (this.keyName.equals("joint4") || this.keyName.equals("joint5")) {
                    f7 = f3;
                    f3 = f2;
                    f2 = f;
                    f = f7;
                    if (this.keyName.equals("joint4")) {
                        f *= -1.0f;
                    }
                }
                if (this.keyName.equals("joint7") || this.keyName.equals("joint6") || this.keyName.equals("joint10") || this.keyName.equals("joint11")) {
                    f7 = f3;
                    f3 = f2;
                    f2 = f;
                    f = f7;
                    if (this.keyName.equals("joint6") || this.keyName.equals("joint10")) {
                        f2 *= -1.0f;
                    }
                }
            }
            if (f < 0.0f) {
                f += 360.0f;
            }
            if (f2 < 0.0f) {
                f2 += 360.0f;
            }
            if (f3 < 0.0f) {
                f3 += 360.0f;
            }
            quaternion.fromAngles(f * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180), f3 * ((float)Math.PI / 180));
            return quaternion;
        }

        public void setAngleX(int n) {
            this.controlX.setValue(n);
        }

        public int getAngleX() {
            return this.controlX.getValue();
        }

        public void setAngleY(int n) {
            this.controlY.setValue(n);
        }

        public int getAngleY() {
            return this.controlY.getValue();
        }

        public void setAngleZ(int n) {
            this.controlZ.setValue(n);
        }

        public int getAngleZ() {
            return this.controlZ.getValue();
        }

        public void setMinAngleX(int n) {
            this.controlX.setMin(n);
        }

        public int getMinAngleX() {
            return this.controlX.getMin();
        }

        public void setMinAngleY(int n) {
            this.controlY.setMin(n);
        }

        public int getMinAngleY() {
            return this.controlY.getMin();
        }

        public void setMinAngleZ(int n) {
            this.controlZ.setMin(n);
        }

        public int getMinAngleZ() {
            return this.controlZ.getMin();
        }

        public void setMaxAngleX(int n) {
            this.controlX.setMax(n);
        }

        public int getMaxAngleX() {
            return this.controlX.getMax();
        }

        public void setMaxAngleY(int n) {
            this.controlY.setMax(n);
        }

        public int getMaxAngleY() {
            return this.controlY.getMax();
        }

        public void setMaxAngleZ(int n) {
            this.controlZ.setMax(n);
        }

        public int getMaxAngleZ() {
            return this.controlZ.getMax();
        }

        public BonePoseInfo(boolean bl) {
            this.root = bl;
            this.label = new JLabel();
            this.lock = new JCheckBox("lock");
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, "North");
            jPanel.setLayout(new FlowLayout());
            if (!bl) {
                this.setBorder(new LineBorder(Color.black));
            }
            jPanel.add(this.lock);
            jPanel.add(this.label);
            JPanel jPanel2 = new JPanel();
            this.add((Component)jPanel2, "Center");
            jPanel2.setLayout(new GridLayout(3, 0));
            this.controlX = new SliderControl("X", bl);
            jPanel2.add(this.controlX);
            this.controlY = new SliderControl("Y", bl);
            jPanel2.add(this.controlY);
            this.controlZ = new SliderControl("Z", bl);
            jPanel2.add(this.controlZ);
        }

        @Override
        public String getName() {
            return this.keyName;
        }

        @Override
        public void setName(String string) {
            this.keyName = string;
            if (this.labelName == null) {
                this.label.setText(string);
            }
            this.label.setToolTipText(string);
        }

        public boolean isRoot() {
            return this.root;
        }

        public void setRoot(boolean bl) {
            this.root = bl;
        }

        public void random() {
            this.controlX.random();
            this.controlY.random();
            this.controlZ.random();
        }
    }

    public class SliderControl
    extends JPanel {
        JTextField minField;
        JTextField maxField;
        JButton randomButton;
        JButton zeroButton;
        JSlider slider;
        int min = -180;
        int max = 180;
        private boolean rootType;

        @Override
        public void setEnabled(boolean bl) {
            this.randomButton.setEnabled(bl);
            this.zeroButton.setEnabled(bl);
            this.minField.setEnabled(bl);
            this.maxField.setEnabled(bl);
            this.slider.setEnabled(bl);
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public SliderControl(String string, boolean bl) {
            this.rootType = bl;
            this.setLayout(new FlowLayout());
            this.slider = this.createSlider(string);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 4));
            this.randomButton = new JButton("R");
            this.randomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SliderControl.this.random();
                }
            });
            this.zeroButton = new JButton("0");
            this.zeroButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SliderControl.this.slider.setValue(0);
                }
            });
            this.minField = new JTextField("-180");
            this.minField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        SliderControl.this.min = Integer.parseInt(SliderControl.this.minField.getText().replaceAll(" ", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.maxField = new JTextField(" 180");
            this.maxField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        SliderControl.this.max = Integer.parseInt(SliderControl.this.maxField.getText().replaceAll(" ", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.add(this.slider);
            this.add(jPanel);
            jPanel.add(this.randomButton);
            jPanel.add(this.zeroButton);
            if (bl) {
                JButton jButton = new JButton("90");
                jPanel.add(jButton);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SliderControl.this.slider.setValue(90);
                    }
                });
                JButton jButton2 = new JButton("-90");
                jPanel.add(jButton2);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SliderControl.this.slider.setValue(-90);
                    }
                });
            } else {
                jPanel.add(this.minField);
                jPanel.add(this.maxField);
            }
        }

        public int getValue() {
            return this.slider.getValue();
        }

        public void setValue(int n) {
            this.slider.setValue(n);
        }

        public JSlider createSlider(String string) {
            JSlider jSlider = new JSlider();
            jSlider.setName(string);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    jSlider.setToolTipText(jSlider.getName() + "=" + jSlider.getValue());
                }
            });
            jSlider.setMinimum(-180);
            jSlider.setMaximum(180);
            jSlider.setValue(0);
            jSlider.setPaintLabels(true);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setLabelTable(jSlider.createStandardLabels(60));
            return jSlider;
        }

        public void setMin(int n) {
            this.min = n;
            this.minField.setText("" + n);
        }

        public void setMax(int n) {
            this.max = n;
            this.maxField.setText("" + n);
        }

        public void random() {
            int n = this.max - this.min;
            int n2 = (int)(Math.random() * (double)n) + this.min;
            this.slider.setValue(n2);
        }
    }

    public static class BoneInfoDataHash {
        public static final String X = "X";
        public static final String Y = "Y";
        public static final String Z = "Z";
        private Map<String, String> map;

        public boolean isLocked(String string) {
            String string2 = this.map.get(BoneInfoDataHash.getLockKey(string));
            return string2 != null && string2.equals("1");
        }

        public String getLabelName(String string) {
            String string2 = this.map.get(BoneInfoDataHash.getLabelKey(string));
            return string2;
        }

        public BoneInfoDataHash(Map map) {
            this.map = map;
        }

        public static String getLockKey(String string) {
            return string + "_lock";
        }

        public static String getLabelKey(String string) {
            return string + "_label";
        }

        public static String getMinRotKey(String string, String string2) {
            return string + "_rot" + string2 + "_min";
        }

        public static String getMaxRotKey(String string, String string2) {
            return string + "_rot" + string2 + "_max";
        }

        public static String getRotKey(String string, String string2) {
            return string + "_rot" + string2;
        }

        public int getRotX(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getRotKey(string, X)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getRotKey(string, X)));
            }
            System.out.println("getrotX=" + n2);
            return n2;
        }

        public int getRotY(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getRotKey(string, Y)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getRotKey(string, Y)));
            }
            return n2;
        }

        public int getRotZ(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getRotKey(string, Z)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getRotKey(string, Z)));
            }
            return n2;
        }

        public int getMinRotX(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getMinRotKey(string, X)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getMinRotKey(string, X)));
            }
            return n2;
        }

        public int getMinRotY(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getMinRotKey(string, Y)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getMinRotKey(string, Y)));
            }
            return n2;
        }

        public int getMinRotZ(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getMinRotKey(string, Z)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getMinRotKey(string, Z)));
            }
            return n2;
        }

        public int getMaxRotX(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getMaxRotKey(string, X)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getMaxRotKey(string, X)));
            }
            return n2;
        }

        public int getMaxRotY(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getMaxRotKey(string, Y)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getMaxRotKey(string, Y)));
            }
            return n2;
        }

        public int getMaxRotZ(String string, int n) {
            int n2 = n;
            if (this.map.get(BoneInfoDataHash.getMaxRotKey(string, Z)) != null) {
                n2 = Integer.parseInt(this.map.get(BoneInfoDataHash.getMaxRotKey(string, Z)));
            }
            return n2;
        }
    }
}

