/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jme.util.geom.GeometryTool;
import com.jmex.model.converters.ObjToJme;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

public class MHObjToJme
extends ObjToJme {
    private static final Logger logger = Logger.getLogger(MHObjToJme.class.getName());
    private BufferedReader inFile;
    private ArrayList<Vector3f> vertexList = new ArrayList();
    private ArrayList<Vector2f> textureList = new ArrayList();
    private ArrayList<Vector3f> normalList = new ArrayList();
    private ArrayList<Vector3f> genNormalList = new ArrayList();
    private MaterialGrouping curGroup;
    private String curObjectName = null;
    private MaterialGrouping defaultMaterialGroup;
    private HashMap<String, MaterialGrouping> materialNames = new HashMap();
    private HashMap<MaterialGrouping, ArraySet> materialSets = new HashMap();
    private Renderer renderer;
    private boolean generateMissingNormals = true;

    public static void main(String[] stringArray) {
        new DummyDisplaySystem();
        new MHObjToJme().attemptFileConvert(stringArray);
    }

    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        String string;
        this.renderer = DisplaySystem.getDisplaySystem().getRenderer();
        this.defaultMaterialGroup = new MaterialGrouping();
        this.vertexList.clear();
        this.textureList.clear();
        this.normalList.clear();
        this.genNormalList.clear();
        this.materialSets.clear();
        this.materialNames.clear();
        this.inFile = new BufferedReader(new InputStreamReader(inputStream));
        this.curGroup = this.defaultMaterialGroup;
        this.materialSets.put(this.defaultMaterialGroup, new ArraySet());
        while ((string = this.inFile.readLine()) != null) {
            this.processLine(string);
        }
        BinaryExporter.getInstance().save((Savable)this.buildStructure(), outputStream);
        this.nullAll();
    }

    private void nullAll() throws IOException {
        this.vertexList.clear();
        this.textureList.clear();
        this.normalList.clear();
        this.genNormalList.clear();
        this.curGroup = null;
        this.materialSets.clear();
        this.materialNames.clear();
        this.inFile.close();
        this.inFile = null;
        this.defaultMaterialGroup = null;
        this.renderer = null;
    }

    private Spatial buildStructure() {
        Node node = new Node("obj file");
        Object[] objectArray = this.materialSets.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            MaterialGrouping materialGrouping = (MaterialGrouping)objectArray[i];
            ArraySet arraySet = this.materialSets.get(materialGrouping);
            if (arraySet.indexes.size() < 3) continue;
            TriMesh triMesh = new TriMesh(arraySet.objName == null ? "temp" + i : arraySet.objName);
            Vector3f[] vector3fArray = new Vector3f[arraySet.sets.size()];
            Vector3f[] vector3fArray2 = new Vector3f[vector3fArray.length];
            Vector2f[] vector2fArray = new Vector2f[vector3fArray.length];
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            for (IndexSet indexSet : arraySet.sets) {
                vector3fArray[n] = this.vertexList.get(indexSet.vIndex);
                if (indexSet.nIndex >= 0) {
                    vector3fArray2[n] = this.normalList.get(indexSet.nIndex);
                    bl = true;
                } else if (indexSet.nIndex < -1) {
                    vector3fArray2[n] = this.genNormalList.get(-1 * indexSet.nIndex - 2);
                    bl = true;
                }
                if (indexSet.tIndex >= 0) {
                    vector2fArray[n] = this.textureList.get(indexSet.tIndex);
                    bl2 = true;
                }
                ++n;
            }
            Object object = new int[arraySet.indexes.size()];
            for (n = 0; n < arraySet.indexes.size(); ++n) {
                object[n] = (Integer)arraySet.indexes.get(n);
            }
            triMesh.reconstruct(BufferUtils.createFloatBuffer((Vector3f[])vector3fArray), bl ? BufferUtils.createFloatBuffer((Vector3f[])vector3fArray2) : null, null, bl2 ? BufferUtils.createFloatBuffer((Vector2f[])vector2fArray) : null, BufferUtils.createIntBuffer((int[])object));
            if (this.properties.get("sillycolors") != null) {
                triMesh.setRandomColors();
            }
            if (materialGrouping.ts != null) {
                triMesh.setRenderState((RenderState)materialGrouping.ts);
            }
            triMesh.setRenderState((RenderState)materialGrouping.m);
            if (materialGrouping.as != null) {
                triMesh.setRenderState((RenderState)materialGrouping.as);
                triMesh.setRenderQueueMode(3);
            }
            triMesh.setModelBound((BoundingVolume)new BoundingBox());
            triMesh.updateModelBound();
            GeometryTool.minimizeVerts((TriMesh)triMesh, (int)7);
            node.attachChild((Spatial)triMesh);
        }
        if (node.getQuantity() == 1) {
            return node.getChild(0);
        }
        return node;
    }

    private void processLine(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = string.split("\\s+");
        if ((stringArray = this.removeEmpty(stringArray)).length == 0) {
            return;
        }
        if (stringArray[0].charAt(0) == '#') {
            return;
        }
        if ("v".equals(stringArray[0])) {
            this.addVertextoList(stringArray);
            return;
        }
        if ("vt".equals(stringArray[0])) {
            this.addTextoList(stringArray);
            return;
        }
        if ("vn".equals(stringArray[0])) {
            this.addNormalToList(stringArray);
            return;
        }
        if ("g".equals(stringArray[0])) {
            if (stringArray.length >= 2 && this.materialNames.get(stringArray[1]) != null && this.materialNames.get(stringArray[1]) != null) {
                this.curGroup = this.materialNames.get(stringArray[1]);
            } else {
                this.setDefaultGroup();
            }
            return;
        }
        if ("f".equals(stringArray[0])) {
            this.addFaces(stringArray);
            return;
        }
        if ("mtllib".equals(stringArray[0])) {
            this.loadMaterials(stringArray);
            return;
        }
        if ("newmtl".equals(stringArray[0])) {
            this.addMaterial(stringArray);
            return;
        }
        if ("usemtl".equals(stringArray[0])) {
            if (this.materialNames.get(stringArray[1]) != null) {
                this.curGroup = this.materialNames.get(stringArray[1]);
                this.curGroup.name = stringArray[1];
            } else {
                this.setDefaultGroup();
            }
            return;
        }
        if ("Ka".equals(stringArray[0])) {
            this.curGroup.m.setAmbient(new ColorRGBA(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]), 1.0f));
            return;
        }
        if ("Kd".equals(stringArray[0])) {
            this.curGroup.m.setDiffuse(new ColorRGBA(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]), 1.0f));
            return;
        }
        if ("Ks".equals(stringArray[0])) {
            this.curGroup.m.setSpecular(new ColorRGBA(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]), 1.0f));
            return;
        }
        if ("Ns".equals(stringArray[0])) {
            float f = Float.parseFloat(stringArray[1]);
            if (f > 128.0f) {
                f = 128.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            this.curGroup.m.setShininess(f);
            return;
        }
        if ("d".equals(stringArray[0])) {
            float f = Float.parseFloat(stringArray[1]);
            this.curGroup.m.getAmbient().a *= f;
            this.curGroup.m.getDiffuse().a *= f;
            this.curGroup.m.getSpecular().a *= f;
            if (f < 1.0f) {
                this.curGroup.createAlphaState();
            }
            return;
        }
        if ("map_d".equals(stringArray[0])) {
            this.curGroup.createAlphaState();
            return;
        }
        if ("map_Kd".equals(stringArray[0]) || "map_Ka".equals(stringArray[0])) {
            URL uRL = (URL)this.properties.get("texdir");
            URL uRL2 = null;
            uRL2 = uRL != null ? new URL(uRL, string.trim().substring(7)) : new File(string.trim().substring(7)).toURI().toURL();
            TextureKey textureKey = new TextureKey(uRL2, true, TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2);
            Texture texture = new Texture();
            texture.setAnisoLevel(0.0f);
            texture.setMipmapState(2);
            texture.setFilter(1);
            texture.setTextureKey(textureKey);
            texture.setWrap(3);
            texture.setImageLocation(uRL2.toString());
            this.curGroup.ts = this.renderer.createTextureState();
            this.curGroup.ts.setTexture(texture);
            this.curGroup.ts.setEnabled(true);
            return;
        }
        if ("o".equals(stringArray[0])) {
            this.curObjectName = stringArray[1];
            logger.info("Object:" + this.curObjectName);
        }
    }

    private String[] removeEmpty(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            ++n;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            stringArray2[n2++] = stringArray[i].trim();
        }
        return stringArray2;
    }

    private void addMaterial(String[] stringArray) {
        MaterialGrouping materialGrouping = new MaterialGrouping();
        this.materialNames.put(stringArray[1], materialGrouping);
        this.materialSets.put(materialGrouping, new ArraySet());
        this.curGroup = materialGrouping;
    }

    private void loadMaterials(String[] stringArray) throws IOException {
        URL uRL = (URL)this.properties.get("mtllib");
        if (uRL == null) {
            return;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            this.processMaterialFile(new URL(uRL, stringArray[i]).openStream());
        }
    }

    private void processMaterialFile(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            this.processLine(string);
        }
    }

    private void addFaces(String[] stringArray) {
        ArraySet arraySet = this.materialSets.get(this.curGroup);
        if (arraySet.objName == null && this.curObjectName != null) {
            arraySet.objName = this.curObjectName;
        }
        if (arraySet.objName.equals("mesh.obj") && this.curGroup.name != null) {
            arraySet.objName = this.curGroup.name;
        }
        IndexSet indexSet = new IndexSet(stringArray[1]);
        int n = arraySet.findSet(indexSet);
        IndexSet indexSet2 = new IndexSet(stringArray[2]);
        int n2 = arraySet.findSet(indexSet2);
        for (int i = 3; i < stringArray.length; ++i) {
            IndexSet indexSet3 = new IndexSet();
            indexSet3.parseStringArray(stringArray[i]);
            int n3 = arraySet.findSet(indexSet3);
            arraySet.indexes.add(n);
            arraySet.indexes.add(n2);
            arraySet.indexes.add(n3);
            if (indexSet.nIndex == -1 || indexSet2.nIndex == -1 || indexSet3.nIndex == -1) {
                Vector3f vector3f = new Vector3f(this.vertexList.get(indexSet2.vIndex));
                Vector3f vector3f2 = new Vector3f(this.vertexList.get(indexSet3.vIndex));
                vector3f.subtractLocal(this.vertexList.get(indexSet.vIndex));
                vector3f2.subtractLocal(this.vertexList.get(indexSet.vIndex));
                vector3f.crossLocal(vector3f2);
                vector3f.normalizeLocal();
                this.genNormalList.add(vector3f);
                int n4 = -1 * (this.genNormalList.size() - 1) - 2;
                if (indexSet.nIndex == -1) {
                    indexSet.nIndex = n4;
                }
                if (indexSet2.nIndex == -1) {
                    indexSet2.nIndex = n4;
                }
                if (indexSet3.nIndex == -1) {
                    indexSet3.nIndex = n4;
                }
            }
            n2 = n3;
        }
    }

    private void setDefaultGroup() {
        this.curGroup = this.defaultMaterialGroup;
    }

    private void addNormalToList(String[] stringArray) {
        Vector3f vector3f = new Vector3f(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]));
        this.normalList.add(vector3f);
    }

    private void addTextoList(String[] stringArray) {
        float f = Float.parseFloat(stringArray[1]);
        float f2 = 0.0f;
        if (stringArray.length > 2) {
            f2 = Float.parseFloat(stringArray[2]);
        }
        this.textureList.add(new Vector2f(f, f2));
    }

    private void addVertextoList(String[] stringArray) {
        this.vertexList.add(new Vector3f(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])));
    }

    public boolean isGenerateMissingNormals() {
        return this.generateMissingNormals;
    }

    public void setGenerateMissingNormals(boolean bl) {
        this.generateMissingNormals = bl;
    }

    private class ArraySet {
        private String objName = null;
        private LinkedHashSet<IndexSet> sets = new LinkedHashSet();
        private HashMap<IndexSet, Integer> index = new HashMap();
        private ArrayList<Integer> indexes = new ArrayList();

        private ArraySet() {
        }

        public int findSet(IndexSet indexSet) {
            if (this.sets.contains(indexSet)) {
                return this.index.get(indexSet);
            }
            this.sets.add(indexSet);
            this.index.put(indexSet, this.sets.size() - 1);
            return this.sets.size() - 1;
        }
    }

    private class IndexSet {
        int vIndex;
        int nIndex;
        int tIndex;
        int index;

        public IndexSet() {
        }

        public IndexSet(String string) {
            this.parseStringArray(string);
        }

        public void parseStringArray(String string) {
            String[] stringArray = string.split("/");
            this.vIndex = Integer.parseInt(stringArray[0]);
            this.vIndex = this.vIndex < 0 ? (this.vIndex += MHObjToJme.this.vertexList.size()) : --this.vIndex;
            if (stringArray.length < 2 || stringArray[1] == null || stringArray[1].equals("")) {
                this.tIndex = -1;
            } else {
                this.tIndex = Integer.parseInt(stringArray[1]);
                this.tIndex = this.tIndex < 0 ? (this.tIndex += MHObjToJme.this.textureList.size()) : --this.tIndex;
            }
            if (stringArray.length != 3 || stringArray[2] == null || stringArray[2].equals("")) {
                this.nIndex = -1;
            } else {
                this.nIndex = Integer.parseInt(stringArray[2]);
                this.nIndex = this.nIndex < 0 ? (this.nIndex += MHObjToJme.this.normalList.size()) : --this.nIndex;
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexSet)) {
                return false;
            }
            IndexSet indexSet = (IndexSet)object;
            if (indexSet.nIndex != this.nIndex) {
                return false;
            }
            if (indexSet.tIndex != this.tIndex) {
                return false;
            }
            return indexSet.vIndex == this.vIndex;
        }

        public int hashCode() {
            int n = 37;
            n += 37 * n + this.vIndex;
            n += 37 * n + this.nIndex;
            n += 37 * n + this.tIndex;
            return n;
        }
    }

    private class MaterialGrouping {
        MaterialState m;
        TextureState ts;
        AlphaState as;
        String name;

        public MaterialGrouping() {
            this.m = MHObjToJme.this.renderer.createMaterialState();
            this.m.setAmbient(new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f));
            this.m.setDiffuse(new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f));
            this.m.setSpecular(ColorRGBA.white.clone());
            this.m.setEnabled(true);
        }

        public void createAlphaState() {
            if (this.as != null) {
                return;
            }
            this.as = MHObjToJme.this.renderer.createAlphaState();
            this.as.setBlendEnabled(true);
            this.as.setSrcFunction(4);
            this.as.setDstFunction(5);
            this.as.setTestEnabled(true);
            this.as.setTestFunction(4);
            this.as.setEnabled(true);
        }
    }
}

