/*
 * Decompiled with CFR 0.152.
 */
package bone;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;

public class Joint {
    private String name;
    private Joint parent;
    private Vector3f translation;
    private float angleX;
    private float angleY;
    private float angleZ;
    public Quaternion quaternion;

    public Joint(String string, Vector3f vector3f) {
        this.name = string;
        this.translation = vector3f;
    }

    public float[] getCurrentAngles() {
        return new float[]{this.angleX, this.angleY, this.angleZ};
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void reset() {
    }

    public Vector3f getLocation() {
        Vector3f vector3f = this.getDefaultAboluteTranslation();
        if (!this.isRoot()) {
            vector3f.subtractLocal(this.getParent().getDefaultAboluteTranslation());
        }
        return vector3f;
    }

    public Vector3f getDefaultAboluteTranslation() {
        Vector3f vector3f = this.getCurrentRotated();
        for (Joint joint = this.getParent(); joint != null; joint = joint.getParent()) {
            vector3f.addLocal(joint.getCurrentRotated());
        }
        return vector3f;
    }

    public Vector3f getCurrentRotated() {
        Vector3f vector3f = this.translation.clone();
        for (Joint joint = this.getParent(); joint != null && !joint.isRoot(); joint = joint.getParent()) {
            Quaternion quaternion = joint.getQuaternion();
            quaternion.mult(vector3f, vector3f);
        }
        return vector3f;
    }

    public Vector3f getCurrentMotionedAbsoluteTranslation() {
        Vector3f vector3f = new Vector3f();
        Joint joint = this.getParent();
        if (joint == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        vector3f.addLocal(joint.getCurrentMotionedAbsoluteTranslation());
        float[] fArray = this.getCurrentAbsoluteAngles();
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles(fArray);
        vector3f.addLocal(quaternion.mult(this.translation, null));
        return vector3f;
    }

    public static float[] normalize(float[] fArray) {
        float[] fArray2 = new float[3];
        for (int i = 0; i < fArray2.length; ++i) {
            float f = fArray[i];
            if (!((f %= 360.0f) < 0.0f)) continue;
            f += 360.0f;
        }
        return fArray2;
    }

    public static float toValuebleAngle(float f) {
        float f2 = f;
        if ((f2 %= 360.0f) > 180.0f) {
            f2 -= 360.0f;
        }
        return f2;
    }

    public float[] getCurrentAbsoluteAngles() {
        float[] fArray = this.getCurrentAngles();
        Joint joint = this.getParent();
        if (joint != null) {
            float[] fArray2 = this.getCurrentAbsoluteAngles();
            fArray[0] = fArray[0] + fArray2[0];
            fArray[1] = fArray[1] + fArray2[1];
            fArray[2] = fArray[2] + fArray2[2];
        }
        return fArray;
    }

    public Joint getParent() {
        return this.parent;
    }

    public void setParent(Joint joint) {
        this.parent = joint;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Quaternion getQuaternion() {
        return this.quaternion;
    }

    public void setQuaternion(Quaternion quaternion) {
        this.quaternion = quaternion;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3f vector3f) {
        this.translation = vector3f;
    }
}

