/*
 * Decompiled with CFR 0.152.
 */
package bone;

import bone.BonePoseInfo;
import com.jme.math.Quaternion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BonePoseInfoPanel
extends JPanel {
    public static final int ANGLE_X = 0;
    public static final int ANGLE_Y = 1;
    public static final int ANGLE_Z = 2;
    private String keyName;
    private String labelName;
    JCheckBox lock;
    JLabel label;
    private BonePoseInfo targetInfo;
    private BonePoseInfo syncTargetInfo;
    private int syncMirrorX;
    private int syncMirrorY;
    private int syncMirrorZ;
    private JButton syncButton;
    private JButton switchButton;
    AngleSliderControl controlX;
    AngleSliderControl controlY;
    AngleSliderControl controlZ;
    public boolean root;

    public BonePoseInfo getSyncTargetInfo() {
        return this.syncTargetInfo;
    }

    public void setSyncTargetInfo(BonePoseInfo bonePoseInfo) {
        this.syncTargetInfo = bonePoseInfo;
        if (bonePoseInfo != null) {
            this.syncButton.setEnabled(true);
            this.switchButton.setEnabled(true);
            String string = bonePoseInfo.getLabelName();
            if (string == null) {
                string = bonePoseInfo.getKeyName();
            }
            this.syncButton.setToolTipText(string);
            this.switchButton.setToolTipText(string);
        } else {
            this.syncButton.setEnabled(false);
            this.switchButton.setEnabled(false);
        }
    }

    public int getSyncMirrorX() {
        return this.syncMirrorX;
    }

    public void setSyncMirrorX(int n) {
        this.syncMirrorX = n;
    }

    public int getSyncMirrorY() {
        return this.syncMirrorY;
    }

    public void setSyncMirrorY(int n) {
        this.syncMirrorY = n;
    }

    public int getSyncMirrorZ() {
        return this.syncMirrorZ;
    }

    public void setSyncMirrorZ(int n) {
        this.syncMirrorZ = n;
    }

    public void update() {
        this.setTargetInfo(this.targetInfo);
    }

    public String getLabelName() {
        if (this.labelName == null) {
            return this.keyName;
        }
        return this.labelName;
    }

    public void setLabelName(String string) {
        this.labelName = string;
        if (string == null) {
            this.label.setText(this.keyName);
        } else {
            this.label.setText(this.labelName);
        }
    }

    public boolean isLocked() {
        return this.lock.isSelected();
    }

    public void setLocked(boolean bl) {
        this.lock.setSelected(bl);
    }

    public Quaternion getBlenderQuaternion() {
        Quaternion quaternion = new Quaternion();
        float f = this.getAngleX();
        float f2 = this.getAngleY();
        float f3 = this.getAngleZ();
        quaternion.fromAngles(f * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180), f3 * ((float)Math.PI / 180));
        if (this.isRoot()) {
            // empty if block
        }
        return quaternion;
    }

    public void setAngleX(int n) {
        this.controlX.setValue(n);
    }

    public int getAngleX() {
        return this.controlX.getValue();
    }

    public void setAngleY(int n) {
        this.controlY.setValue(n);
    }

    public int getAngleY() {
        return this.controlY.getValue();
    }

    public void setAngleZ(int n) {
        this.controlZ.setValue(n);
    }

    public int getAngleZ() {
        return this.controlZ.getValue();
    }

    public void setMinAngleX(int n) {
        this.controlX.setMin(n);
    }

    public int getMinAngleX() {
        return this.controlX.getMin();
    }

    public void setMinAngleY(int n) {
        this.controlY.setMin(n);
    }

    public int getMinAngleY() {
        return this.controlY.getMin();
    }

    public void setMinAngleZ(int n) {
        this.controlZ.setMin(n);
    }

    public int getMinAngleZ() {
        return this.controlZ.getMin();
    }

    public void setMaxAngleX(int n) {
        this.controlX.setMax(n);
    }

    public int getMaxAngleX() {
        return this.controlX.getMax();
    }

    public void setMaxAngleY(int n) {
        this.controlY.setMax(n);
    }

    public int getMaxAngleY() {
        return this.controlY.getMax();
    }

    public void setMaxAngleZ(int n) {
        this.controlZ.setMax(n);
    }

    public int getMaxAngleZ() {
        return this.controlZ.getMax();
    }

    public BonePoseInfoPanel(boolean bl) {
        this.root = bl;
        this.label = new JLabel();
        this.lock = new JCheckBox("lock");
        this.lock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BonePoseInfoPanel.this.targetInfo != null) {
                    BonePoseInfoPanel.this.targetInfo.setLock(BonePoseInfoPanel.this.lock.isSelected());
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.lock);
        jPanel.add(this.label);
        this.syncButton = new JButton("sync");
        this.syncButton.setEnabled(false);
        this.syncButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BonePoseInfoPanel.this.syncTargetInfo != null) {
                    int n = BonePoseInfoPanel.this.getAngleX() * BonePoseInfoPanel.this.syncMirrorX;
                    int n2 = BonePoseInfoPanel.this.getAngleY() * BonePoseInfoPanel.this.syncMirrorY;
                    int n3 = BonePoseInfoPanel.this.getAngleZ() * BonePoseInfoPanel.this.syncMirrorZ;
                    BonePoseInfoPanel.this.syncTargetInfo.setAngleX(n);
                    BonePoseInfoPanel.this.syncTargetInfo.setAngleY(n2);
                    BonePoseInfoPanel.this.syncTargetInfo.setAngleZ(n3);
                }
            }
        });
        jPanel.add(this.syncButton);
        this.switchButton = new JButton("switch");
        this.switchButton.setEnabled(false);
        this.switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BonePoseInfoPanel.this.syncTargetInfo != null) {
                    int n = BonePoseInfoPanel.this.getAngleX() * BonePoseInfoPanel.this.syncMirrorX;
                    int n2 = BonePoseInfoPanel.this.getAngleY() * BonePoseInfoPanel.this.syncMirrorY;
                    int n3 = BonePoseInfoPanel.this.getAngleZ() * BonePoseInfoPanel.this.syncMirrorZ;
                    int n4 = (int)BonePoseInfoPanel.this.syncTargetInfo.getAngleX() * BonePoseInfoPanel.this.syncMirrorX;
                    int n5 = (int)BonePoseInfoPanel.this.syncTargetInfo.getAngleY() * BonePoseInfoPanel.this.syncMirrorY;
                    int n6 = (int)BonePoseInfoPanel.this.syncTargetInfo.getAngleZ() * BonePoseInfoPanel.this.syncMirrorZ;
                    BonePoseInfoPanel.this.syncTargetInfo.setAngleX(n);
                    BonePoseInfoPanel.this.syncTargetInfo.setAngleY(n2);
                    BonePoseInfoPanel.this.syncTargetInfo.setAngleZ(n3);
                    BonePoseInfoPanel.this.setAngleX(n4);
                    BonePoseInfoPanel.this.setAngleY(n5);
                    BonePoseInfoPanel.this.setAngleZ(n6);
                }
            }
        });
        jPanel.add(this.switchButton);
        JPanel jPanel2 = new JPanel();
        this.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new GridLayout(3, 0));
        this.controlX = new AngleSliderControl("X", bl, 0);
        jPanel2.add(this.controlX);
        this.controlY = new AngleSliderControl("Y", bl, 1);
        jPanel2.add(this.controlY);
        this.controlZ = new AngleSliderControl("Z", bl, 2);
        jPanel2.add(this.controlZ);
    }

    @Override
    public String getName() {
        return this.keyName;
    }

    @Override
    public void setName(String string) {
        this.keyName = string;
        if (this.labelName == null) {
            this.label.setText(string);
        }
        this.label.setToolTipText(string);
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean bl) {
        this.root = bl;
    }

    public void random() {
        this.controlX.random();
        this.controlY.random();
        this.controlZ.random();
    }

    public BonePoseInfo getTargetInfo() {
        return this.targetInfo;
    }

    public void setTargetInfo(BonePoseInfo bonePoseInfo) {
        this.targetInfo = bonePoseInfo;
        if (bonePoseInfo != null) {
            this.keyName = bonePoseInfo.getKeyName();
            this.setLabelName(bonePoseInfo.getLabelName());
            this.setLocked(bonePoseInfo.isLock());
            this.setAngleX((int)bonePoseInfo.getAngleX());
            this.setAngleY((int)bonePoseInfo.getAngleY());
            this.setAngleZ((int)bonePoseInfo.getAngleZ());
            this.setMaxAngleX((int)bonePoseInfo.getMaxAngleX());
            this.setMaxAngleY((int)bonePoseInfo.getMaxAngleY());
            this.setMaxAngleZ((int)bonePoseInfo.getMaxAngleZ());
            this.setMinAngleX((int)bonePoseInfo.getMinAngleX());
            this.setMinAngleY((int)bonePoseInfo.getMinAngleY());
            this.setMinAngleZ((int)bonePoseInfo.getMinAngleZ());
            this.setSyncMirrorX(bonePoseInfo.getSyncMirrorX());
            this.setSyncMirrorY(bonePoseInfo.getSyncMirrorY());
            this.setSyncMirrorZ(bonePoseInfo.getSyncMirrorZ());
            this.setSyncTargetInfo(bonePoseInfo.getSyncTarget());
        } else {
            this.setLabelName("");
        }
    }

    public class AngleSliderControl
    extends JPanel {
        private int sliderType;
        JTextField minField;
        JTextField maxField;
        JButton randomButton;
        JButton zeroButton;
        JSlider slider;
        int min = -180;
        int max = 180;
        private boolean rootType;

        @Override
        public void setEnabled(boolean bl) {
            this.randomButton.setEnabled(bl);
            this.zeroButton.setEnabled(bl);
            this.minField.setEnabled(bl);
            this.maxField.setEnabled(bl);
            this.slider.setEnabled(bl);
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public AngleSliderControl(String string, boolean bl, int n) {
            this.sliderType = n;
            this.rootType = bl;
            this.setLayout(new FlowLayout());
            this.slider = this.createSlider(string);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 4));
            this.randomButton = new JButton("R");
            this.randomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AngleSliderControl.this.random();
                }
            });
            this.zeroButton = new JButton("0");
            this.zeroButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AngleSliderControl.this.slider.setValue(0);
                }
            });
            this.minField = new JTextField("-180");
            this.minField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        AngleSliderControl.this.min = Integer.parseInt(AngleSliderControl.this.minField.getText().replaceAll(" ", ""));
                        AngleSliderControl.this.updateMin(AngleSliderControl.this.min);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.maxField = new JTextField(" 180");
            this.maxField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        AngleSliderControl.this.max = Integer.parseInt(AngleSliderControl.this.maxField.getText().replaceAll(" ", ""));
                        AngleSliderControl.this.updateMax(AngleSliderControl.this.max);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.add(this.slider);
            this.add(jPanel);
            jPanel.add(this.randomButton);
            jPanel.add(this.zeroButton);
            if (bl) {
                System.out.println("rootType");
                JButton jButton = new JButton("90");
                jPanel.add(jButton);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AngleSliderControl.this.slider.setValue(90);
                    }
                });
                JButton jButton2 = new JButton("-90");
                jPanel.add(jButton2);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AngleSliderControl.this.slider.setValue(-90);
                    }
                });
            } else {
                jPanel.add(this.minField);
                jPanel.add(this.maxField);
            }
        }

        public int getValue() {
            return this.slider.getValue();
        }

        public void setValue(int n) {
            this.slider.setValue(n);
        }

        public JSlider createSlider(String string) {
            JSlider jSlider = new JSlider();
            jSlider.setName(string);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    jSlider.setToolTipText(jSlider.getName() + "=" + jSlider.getValue());
                    if (BonePoseInfoPanel.this.targetInfo != null) {
                        if (AngleSliderControl.this.sliderType == 0) {
                            BonePoseInfoPanel.this.targetInfo.setAngleX(jSlider.getValue());
                        } else if (AngleSliderControl.this.sliderType == 1) {
                            BonePoseInfoPanel.this.targetInfo.setAngleY(jSlider.getValue());
                        } else if (AngleSliderControl.this.sliderType == 2) {
                            BonePoseInfoPanel.this.targetInfo.setAngleZ(jSlider.getValue());
                        }
                    }
                }
            });
            jSlider.setMinimum(-180);
            jSlider.setMaximum(180);
            jSlider.setValue(0);
            jSlider.setPaintLabels(true);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setLabelTable(jSlider.createStandardLabels(60));
            return jSlider;
        }

        private void updateMin(int n) {
            if (BonePoseInfoPanel.this.targetInfo != null) {
                if (this.sliderType == 0) {
                    BonePoseInfoPanel.this.targetInfo.setMinAngleX(n);
                } else if (this.sliderType == 1) {
                    BonePoseInfoPanel.this.targetInfo.setMinAngleY(n);
                } else if (this.sliderType == 2) {
                    BonePoseInfoPanel.this.targetInfo.setMinAngleZ(n);
                }
            }
        }

        private void updateMax(int n) {
            if (BonePoseInfoPanel.this.targetInfo != null) {
                if (this.sliderType == 0) {
                    BonePoseInfoPanel.this.targetInfo.setMaxAngleX(n);
                } else if (this.sliderType == 1) {
                    BonePoseInfoPanel.this.targetInfo.setMaxAngleY(n);
                } else if (this.sliderType == 2) {
                    BonePoseInfoPanel.this.targetInfo.setMaxAngleZ(n);
                }
            }
        }

        public void setMin(int n) {
            this.min = n;
            this.minField.setText("" + n);
        }

        public void setMax(int n) {
            this.max = n;
            this.maxField.setText("" + n);
        }

        public void random() {
            int n = this.max - this.min;
            int n2 = (int)(Math.random() * (double)n) + this.min;
            this.slider.setValue(n2);
        }
    }
}

