/*
 * Decompiled with CFR 0.152.
 */
package bone;

import bone.VertexWeightInfo;
import com.jme.animation.Bone;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Geometry;
import com.jme.scene.batch.GeomBatch;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BoneData {
    private static final Logger logger = Logger.getLogger(BoneData.class.getName());
    private Bone rootBone;
    private Geometry skin;
    private List<VertexWeightInfo> vertexWeightInfoList = new ArrayList<VertexWeightInfo>();
    private String name;
    public boolean modified;

    public Bone getBone() {
        return this.rootBone;
    }

    public void setBone(Bone bone) {
        this.rootBone = bone;
    }

    public List<VertexWeightInfo> getVertexWeightInfoList() {
        return this.vertexWeightInfoList;
    }

    public void setVertexWeightInfoList(List<VertexWeightInfo> list) {
        this.vertexWeightInfoList = list;
    }

    public Geometry getSkin() {
        return this.skin;
    }

    public void setSkin(Geometry geometry) throws IOException {
        this.skin = geometry;
        if (geometry.getBatchCount() > 1) {
            throw new IOException("not supported more 1 batch");
        }
        GeomBatch geomBatch = geometry.getBatch(0);
        FloatBuffer floatBuffer = geomBatch.getVertexBuffer();
        if (geomBatch.getVertexCount() != this.vertexWeightInfoList.size()) {
            System.out.println(geomBatch.getVertexCount() + "," + this.vertexWeightInfoList.size());
            throw new RuntimeException("model vertex size is not same as vertexWeightInfoList:");
        }
        for (int i = 0; i < this.vertexWeightInfoList.size(); ++i) {
            VertexWeightInfo vertexWeightInfo = this.vertexWeightInfoList.get(i);
            Bone bone = this.rootBone;
            if (vertexWeightInfo.hasBoneName()) {
                bone = BoneData.findBone(this.rootBone, vertexWeightInfo.getBoneName());
            }
            Vector3f vector3f = this.getOffset(bone);
            Vector3f vector3f2 = new Vector3f(floatBuffer.get(i * 3), floatBuffer.get(i * 3 + 1), floatBuffer.get(i * 3 + 2));
            vertexWeightInfo.setTranslation(vector3f2.subtract(vector3f));
        }
    }

    public Bone findBone(String string) {
        return BoneData.findBone(this.rootBone, string);
    }

    public static Bone findBone(Bone bone, String string) {
        Bone bone2 = null;
        if (bone.getName().equals(string)) {
            return bone;
        }
        for (int i = 0; i < bone.getQuantity(); ++i) {
            Bone bone3 = BoneData.findBone((Bone)bone.getChild(i), string);
            if (bone3 == null || !bone3.getName().equals(string)) continue;
            bone2 = bone3;
            break;
        }
        return bone2;
    }

    public static boolean isRootBone(Bone bone) {
        return bone.getParent() == null || !(bone.getParent() instanceof Bone);
    }

    public Vector3f getOffset(Bone bone) {
        Vector3f vector3f = new Vector3f();
        if (BoneData.isRootBone(bone)) {
            return bone.getLocalTranslation();
        }
        Bone bone2 = bone;
        Bone bone3 = (Bone)bone2.getParent();
        while (bone2 != null) {
            Vector3f vector3f2 = this.boneTranslated(bone3, bone2.getLocalTranslation());
            vector3f.addLocal(vector3f2);
            if (BoneData.isRootBone(bone3)) {
                vector3f.addLocal(bone3.getLocalTranslation());
                break;
            }
            bone2 = bone3;
            bone3 = (Bone)bone3.getParent();
        }
        return vector3f;
    }

    public void update() {
        if (this.skin == null) {
            return;
        }
        GeomBatch geomBatch = this.skin.getBatch(0);
        FloatBuffer floatBuffer = geomBatch.getVertexBuffer();
        for (int i = 0; i < this.vertexWeightInfoList.size(); ++i) {
            VertexWeightInfo vertexWeightInfo = this.vertexWeightInfoList.get(i);
            Bone bone = this.rootBone;
            if (vertexWeightInfo.hasBoneName()) {
                bone = this.findBone(vertexWeightInfo.getBoneName());
            }
            Vector3f vector3f = this.boneTranslated(bone, vertexWeightInfo.getTranslation());
            Vector3f vector3f2 = this.getOffset(bone);
            vector3f.addLocal(vector3f2);
            floatBuffer.put(i * 3, vector3f.x);
            floatBuffer.put(i * 3 + 1, vector3f.y);
            floatBuffer.put(i * 3 + 2, vector3f.z);
        }
    }

    public Vector3f boneTranslated(Bone bone, Vector3f vector3f) {
        if (vector3f == null) {
            logger.warning("location is null:" + bone.getName());
            return null;
        }
        Quaternion quaternion = bone.getLocalRotation();
        Vector3f vector3f2 = quaternion.mult(vector3f);
        if (BoneData.isRootBone(bone)) {
            return vector3f2;
        }
        for (Bone bone2 = (Bone)bone.getParent(); bone2 != null; bone2 = (Bone)bone2.getParent()) {
            quaternion = bone2.getLocalRotation();
            quaternion.mult(vector3f2, vector3f2);
            if (BoneData.isRootBone(bone2)) break;
        }
        return vector3f2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

