/*
 * Decompiled with CFR 0.152.
 */
package bone;

import bone.BoneData;
import bone.Joint;
import bone.VertexWeightInfo;
import com.jme.animation.Bone;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.JMUtils;

public class BlenderBoneLoader {
    private static final Logger logger = Logger.getLogger(BoneData.class.getName());

    public static byte[] skeltonMeshToMesh(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Element[] elementArray;
            Object object;
            Object object2;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("jointcontroller");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeList.item(i).getParentNode().removeChild(nodeList.item(i));
            }
            NodeList nodeList2 = element.getElementsByTagName("node");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                int n;
                object2 = (Element)nodeList2.item(i);
                object = object2.getElementsByTagName("jointmesh");
                logger.info("list-size:" + object.getLength());
                elementArray = new Element[object.getLength()];
                for (n = 0; n < object.getLength(); ++n) {
                    elementArray[n] = (Element)object.item(n);
                }
                for (n = 0; n < elementArray.length; ++n) {
                    NodeList nodeList3 = elementArray[n].getChildNodes();
                    Element element2 = document.createElement("mesh");
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        if (nodeList3.item(j) instanceof Element) {
                            Element element3 = (Element)nodeList3.item(j);
                            if (element3.getNodeName().equals("jointindex") || element3.getNodeName().equals("origvertex") || element3.getNodeName().equals("orignormal")) continue;
                            element2.appendChild(element3.cloneNode(true));
                            continue;
                        }
                        element2.appendChild(nodeList3.item(j).cloneNode(true));
                    }
                    object2.replaceChild(element2, elementArray[n]);
                    element2.setAttribute("name", elementArray[n].getAttribute("name"));
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object2 = transformerFactory.newTransformer();
            object = new DOMSource();
            ((DOMSource)object).setNode(document);
            elementArray = new StreamResult();
            elementArray.setOutputStream(byteArrayOutputStream);
            ((Transformer)object2).transform((Source)object, (Result)elementArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static BoneData[] loadBone(InputStream inputStream) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            VertexWeightInfo vertexWeightInfo;
            String[] stringArray;
            Object object;
            Object object2;
            Object object3;
            int n;
            Element element;
            int n2;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element2 = document.getDocumentElement();
            Element element3 = (Element)document.getElementsByTagName("node").item(0);
            Vector3f vector3f = JMUtils.toVector3f(element3.getAttribute("scale"));
            Vector3f vector3f2 = JMUtils.toVector3f(element3.getAttribute("translation"));
            Quaternion quaternion = JMUtils.toQuaternion(element3.getAttribute("rotation"));
            NodeList nodeList = element2.getElementsByTagName("joint");
            String[] stringArray2 = new String[nodeList.getLength()];
            String[] stringArray3 = null;
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            HashMap<Object, String[]> hashMap2 = new HashMap<Object, String[]>();
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element = (Element)nodeList.item(n2);
                n = Integer.parseInt(element.getAttribute("index"));
                object3 = element.getAttribute("name");
                stringArray2[n] = object3;
                object2 = JMUtils.toVector3f(element.getAttribute("localvec"));
                object = JMUtils.toQuaternion(element.getAttribute("quat"));
                stringArray = new Joint((String)object3, (Vector3f)object2);
                stringArray.quaternion = object;
                hashMap.put("" + n, stringArray);
            }
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element = (Element)nodeList.item(n2);
                n = Integer.parseInt(element.getAttribute("index"));
                object3 = element.getAttribute("name");
                stringArray2[n] = object3;
                object2 = element.getAttribute("parentindex");
                System.out.println((String)object3 + "," + element.getAttribute("localvec"));
                object = (Joint)hashMap.get("" + n);
                ((Joint)object).setParent((Joint)hashMap.get("" + (String)object2));
                stringArray = new Bone((String)object3);
                hashMap2.put(object3, stringArray);
            }
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                Vector3f vector3f3;
                element = (Element)nodeList.item(n2);
                n = Integer.parseInt(element.getAttribute("index"));
                object3 = element.getAttribute("name");
                stringArray2[n] = object3;
                object2 = JMUtils.createBox((String)object3);
                JMUtils.setEmissiveState((Spatial)object2, 0, 255, 0);
                object2.setCullMode(3);
                object = (Joint)hashMap.get("" + n);
                object2.setLocalScale(0.1f);
                object2.setLocalTranslation(((Joint)object).getDefaultAboluteTranslation().clone());
                object2.updateRenderState();
                stringArray = (Bone)hashMap2.get(object3);
                Vector3f vector3f4 = ((Joint)object).getLocation();
                Quaternion quaternion2 = new Quaternion();
                quaternion2.fromAngles(-0.2890265f, (float)Math.PI, 0.0f);
                System.out.println("15f q=" + quaternion2 + "");
                System.out.println("rotation:" + quaternion);
                quaternion2.mult(vector3f4, vector3f4);
                vector3f4.divideLocal(vector3f);
                vertexWeightInfo = new Matrix4f();
                vertexWeightInfo.setTranslation(vector3f4);
                Quaternion quaternion3 = JMUtils.toQuaternion(element.getAttribute("quat"));
                vertexWeightInfo.setRotationQuaternion(quaternion3);
                stringArray.setBindMatrix((Matrix4f)vertexWeightInfo);
                stringArray.setLocalTranslation(vector3f4);
                if (((Joint)object).isRoot()) {
                    vector3f3 = quaternion3.mult(((Joint)object).getLocation());
                    System.out.println("real translate:" + vector3f3 + " q=" + new Quaternion(0.0f, 0.99101025f, 0.1337858f, 0.0f).mult(((Joint)object).getLocation()));
                    System.out.println("real translate:" + vector3f3 + " q=" + new Quaternion(0.0f, 0.7071068f, 0.7071068f, 0.0f).mult(((Joint)object).getLocation()));
                    System.out.println("translated:" + vector3f2);
                    System.out.println("translated:" + vector3f2);
                    stringArray3 = stringArray;
                    stringArray3.setLocalTranslation(quaternion.mult(((Joint)object).getLocation()));
                    Joint joint = (Joint)hashMap.get("1");
                    Bone bone = (Bone)hashMap2.get(joint.getName());
                    Vector3f vector3f5 = ((Joint)object).getLocation().subtract(joint.getLocation());
                    System.out.println("joint0:" + ((Joint)object).getLocation());
                    System.out.println("joint1:" + joint.getLocation());
                    System.out.println("angle:" + JMUtils.toAngleString(((Joint)object).getLocation(), joint.getLocation()));
                    System.out.println("bone0:" + stringArray.getLocalTranslation());
                    System.out.println("bone1:" + bone.getLocalTranslation());
                    System.out.println("angle:" + JMUtils.toAngleString(stringArray.getLocalTranslation(), bone.getLocalTranslation()));
                    System.out.println("rotation:" + JMUtils.toAngleString(quaternion));
                    continue;
                }
                vector3f3 = (Bone)hashMap2.get(((Joint)object).getParent().getName());
                vector3f3.attachChild((Spatial)stringArray);
            }
            nodeList = element2.getElementsByTagName("jointmesh");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element = (Element)nodeList.item(n2);
                String string = element.getAttribute("name");
                System.out.println("joint-mesh-name:" + string + "," + element);
                object3 = new BoneData();
                ((BoneData)object3).setName(string);
                arrayList.add(object3);
                ((BoneData)object3).setBone((Bone)stringArray3);
                object2 = element.getElementsByTagName("jointindex");
                object = (Element)object2.item(0);
                stringArray = object.getAttribute("data").split(" ");
                if (stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].length() <= 0) continue;
                        int n3 = Integer.parseInt(stringArray[i]);
                        vertexWeightInfo = new VertexWeightInfo();
                        if (n3 != -1) {
                            vertexWeightInfo.setBoneName(stringArray2[n3]);
                        }
                        ((BoneData)object3).getVertexWeightInfoList().add(vertexWeightInfo);
                    }
                    continue;
                }
                System.out.println("empty ignore it:" + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.toArray(new BoneData[arrayList.size()]);
    }
}

