/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.math.FastMath;
import com.jme.math.Line;
import com.jme.math.Matrix3f;
import com.jme.math.Rectangle;
import com.jme.math.Ring;
import com.jme.math.TransformMatrix;
import com.jme.math.Triangle;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleController;
import com.jmex.effects.particles.ParticleInfluence;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParticleGeometry
extends Geometry {
    protected static final long serialVersionUID = 2L;
    public static final int ET_POINT = 0;
    public static final int ET_LINE = 1;
    public static final int ET_RECTANGLE = 2;
    public static final int ET_GEOMBATCH = 3;
    public static final int ET_RING = 4;
    public static final int PT_QUAD = 0;
    public static final int PT_TRIANGLE = 1;
    public static final int PT_POINT = 2;
    public static final int PT_LINE = 3;
    public static final int PT_GEOMBATCH = 4;
    protected static final float DEFAULT_END_SIZE = 4.0f;
    protected static final float DEFAULT_START_SIZE = 20.0f;
    protected static final float DEFAULT_MAX_ANGLE = 0.7853982f;
    protected static final float DEFAULT_MAX_LIFE = 3000.0f;
    protected static final float DEFAULT_MIN_LIFE = 2000.0f;
    protected static final ColorRGBA DEFAULT_START_COLOR = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    protected static final ColorRGBA DEFAULT_END_COLOR = new ColorRGBA(1.0f, 1.0f, 0.0f, 0.0f);
    protected int particleType;
    protected int emitType = 0;
    protected Line psLine;
    protected Rectangle psRect;
    protected GeomBatch psBatch;
    protected Ring psRing;
    protected boolean cameraFacing = true;
    protected boolean velocityAligned = false;
    protected float startSize;
    protected float endSize;
    protected ColorRGBA startColor;
    protected ColorRGBA endColor;
    protected float initialVelocity;
    protected float minimumLifeTime;
    protected float maximumLifeTime;
    protected float minimumAngle;
    protected float maximumAngle;
    protected float particleSpinSpeed;
    protected Vector3f emissionDirection;
    protected TransformMatrix emitterTransform = new TransformMatrix();
    protected Vector3f worldEmit = new Vector3f();
    protected int numParticles;
    protected boolean rotateWithScene = false;
    protected Matrix3f rotMatrix;
    protected float particleOrientation;
    protected FloatBuffer geometryCoordinates;
    protected FloatBuffer appearanceColors;
    protected Vector3f upXemit;
    protected Vector3f absUpVector;
    protected Vector3f abUpMinUp;
    protected Vector3f upVector;
    protected Vector3f leftVector;
    protected Vector3f invScale;
    protected Particle[] particles;
    protected int releaseRate;
    protected Vector3f originOffset;
    protected Vector3f originCenter;
    protected static Vector2f workVect2 = new Vector2f();
    protected static Vector3f workVect3 = new Vector3f();
    protected ParticleController controller;
    protected Vector3f oldEmit = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
    protected float[][] matData = new float[3][3];

    public ParticleGeometry() {
    }

    public ParticleGeometry(String string, int n) {
        this(string, n, 0);
    }

    public ParticleGeometry(String string, int n, int n2) {
        super(string);
        this.numParticles = n;
        this.particleType = n2;
        this.emissionDirection = new Vector3f(0.0f, 1.0f, 0.0f);
        this.minimumLifeTime = 2000.0f;
        this.maximumLifeTime = 3000.0f;
        this.maximumAngle = 0.7853982f;
        this.startSize = 20.0f;
        this.endSize = 4.0f;
        this.startColor = DEFAULT_START_COLOR.clone();
        this.endColor = DEFAULT_END_COLOR.clone();
        this.upVector = Vector3f.UNIT_Y.clone();
        this.leftVector = new Vector3f(-1.0f, 0.0f, 0.0f);
        this.originCenter = new Vector3f();
        this.originOffset = new Vector3f();
        this.particleSpinSpeed = 0.0f;
        this.releaseRate = n;
        this.upXemit = new Vector3f();
        this.absUpVector = new Vector3f();
        this.abUpMinUp = new Vector3f();
        this.initialVelocity = 1.0f;
        this.rotMatrix = new Matrix3f();
        this.initializeParticles(n);
        this.getBatch(0).setCastsShadows(false);
    }

    protected abstract void initializeParticles(int var1);

    public static int getVertsForParticleType(int n) {
        switch (n) {
            case 1: 
            case 4: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 4;
    }

    public void forceRespawn() {
        int n = this.particles.length;
        while (--n >= 0) {
            this.particles[n].recreateParticle(0.0f);
            this.particles[n].setStatus(1);
            this.particles[n].updateAndCheck(1.0f);
            this.particles[n].setStatus(2);
        }
        if (this.controller != null) {
            this.controller.setActive(true);
        }
    }

    public void updateRotationMatrix() {
        if (this.oldEmit.equals((Object)this.worldEmit)) {
            return;
        }
        float f = this.upVector.dot(this.worldEmit);
        if ((double)FastMath.abs((float)f) > 0.9999999999999998) {
            this.absUpVector.x = this.upVector.x <= 0.0f ? -this.upVector.x : this.upVector.x;
            this.absUpVector.y = this.upVector.y <= 0.0f ? -this.upVector.y : this.upVector.y;
            float f2 = this.absUpVector.z = this.upVector.z <= 0.0f ? -this.upVector.z : this.upVector.z;
            if (this.absUpVector.x < this.absUpVector.y) {
                if (this.absUpVector.x < this.absUpVector.z) {
                    this.absUpVector.x = 1.0f;
                    this.absUpVector.z = 0.0f;
                    this.absUpVector.y = 0.0f;
                } else {
                    this.absUpVector.z = 1.0f;
                    this.absUpVector.y = 0.0f;
                    this.absUpVector.x = 0.0f;
                }
            } else if (this.absUpVector.y < this.absUpVector.z) {
                this.absUpVector.y = 1.0f;
                this.absUpVector.z = 0.0f;
                this.absUpVector.x = 0.0f;
            } else {
                this.absUpVector.z = 1.0f;
                this.absUpVector.y = 0.0f;
                this.absUpVector.x = 0.0f;
            }
            this.absUpVector.subtract(this.upVector, this.abUpMinUp);
            this.absUpVector.subtract(this.worldEmit, this.upXemit);
            float f3 = 2.0f / this.abUpMinUp.dot(this.abUpMinUp);
            float f4 = 2.0f / this.upXemit.dot(this.upXemit);
            float f5 = f3 * f4 * this.abUpMinUp.dot(this.upXemit);
            float[] fArray = new float[]{this.abUpMinUp.x, this.abUpMinUp.y, this.abUpMinUp.z};
            float[] fArray2 = new float[]{this.upXemit.x, this.upXemit.y, this.upXemit.z};
            int n = 0;
            while (n < 3) {
                for (int i = 0; i < 3; ++i) {
                    this.matData[n][i] = -f3 * fArray[n] * fArray[i] - f4 * fArray2[n] * fArray2[i] + f5 * fArray2[n] * fArray[i];
                }
                float[] fArray3 = this.matData[n];
                int n2 = n++;
                fArray3[n2] = fArray3[n2] + 1.0f;
            }
        } else {
            this.upVector.cross(this.worldEmit, this.upXemit);
            float f6 = 1.0f / (1.0f + f);
            float f7 = f6 * this.upXemit.x;
            float f8 = f6 * this.upXemit.z;
            float f9 = f7 * this.upXemit.y;
            float f10 = f7 * this.upXemit.z;
            float f11 = f8 * this.upXemit.y;
            this.matData[0][0] = f + f7 * this.upXemit.x;
            this.matData[0][1] = f9 - this.upXemit.z;
            this.matData[0][2] = f10 + this.upXemit.y;
            this.matData[1][0] = f9 + this.upXemit.z;
            this.matData[1][1] = f + f6 * this.upXemit.y * this.upXemit.y;
            this.matData[1][2] = f11 - this.upXemit.x;
            this.matData[2][0] = f10 - this.upXemit.y;
            this.matData[2][1] = f11 + this.upXemit.x;
            this.matData[2][2] = f + f8 * this.upXemit.z;
        }
        this.rotMatrix.set(this.matData);
        this.oldEmit.set(this.worldEmit);
    }

    public ParticleController getParticleController() {
        return this.controller;
    }

    public void addController(Controller controller) {
        super.addController(controller);
        if (controller instanceof ParticleController) {
            this.controller = (ParticleController)controller;
        }
    }

    public Vector3f getEmissionDirection() {
        return this.emissionDirection;
    }

    public void setEmissionDirection(Vector3f vector3f) {
        this.emissionDirection = vector3f;
    }

    public float getEndSize() {
        return this.endSize;
    }

    public void setEndSize(float f) {
        this.endSize = f >= 0.0f ? f : 0.0f;
    }

    public float getStartSize() {
        return this.startSize;
    }

    public void setStartSize(float f) {
        this.startSize = f >= 0.0f ? f : 0.0f;
    }

    public void setStartColor(ColorRGBA colorRGBA) {
        this.startColor = colorRGBA;
    }

    public ColorRGBA getStartColor() {
        return this.startColor;
    }

    public void setEndColor(ColorRGBA colorRGBA) {
        this.endColor = colorRGBA;
    }

    public ColorRGBA getEndColor() {
        return this.endColor;
    }

    public void setParticleSpinSpeed(float f) {
        this.particleSpinSpeed = f;
    }

    public float getParticleSpinSpeed() {
        return this.particleSpinSpeed;
    }

    public Vector3f getInvScale() {
        return this.invScale;
    }

    public void setInvScale(Vector3f vector3f) {
        this.invScale = vector3f;
    }

    public void updateInvScale() {
        this.invScale.set(this.worldScale);
        this.invScale.set(1.0f / this.invScale.x, 1.0f / this.invScale.y, 1.0f / this.invScale.z);
    }

    public void addInfluence(ParticleInfluence particleInfluence) {
        this.controller.addInfluence(particleInfluence);
    }

    public boolean removeInfluence(ParticleInfluence particleInfluence) {
        return this.controller.removeInfluence(particleInfluence);
    }

    public ArrayList<ParticleInfluence> getInfluences() {
        return this.controller.getInfluences();
    }

    public void clearInfluences() {
        this.controller.clearInfluences();
    }

    public void setParticleMass(float f) {
        float f2 = 0.0f;
        f2 = f == 0.0f ? Float.POSITIVE_INFINITY : (f == Float.POSITIVE_INFINITY ? 0.0f : (f == Float.POSITIVE_INFINITY ? 0.0f : 1.0f / f));
        int n = this.particles.length;
        while (--n >= 0) {
            this.particles[n].setMasses(f, f2);
        }
    }

    public void setMinimumAngle(float f) {
        this.minimumAngle = f >= 0.0f ? f : 0.0f;
    }

    public float getMinimumAngle() {
        return this.minimumAngle;
    }

    public void setMaximumAngle(float f) {
        this.maximumAngle = f >= 0.0f ? f : 0.0f;
    }

    public float getMaximumAngle() {
        return this.maximumAngle;
    }

    public void setMinimumLifeTime(float f) {
        this.minimumLifeTime = f >= 0.0f ? f : 1.0f;
    }

    public float getMinimumLifeTime() {
        return this.minimumLifeTime;
    }

    public void setMaximumLifeTime(float f) {
        this.maximumLifeTime = f >= 0.0f ? f : 1.0f;
    }

    public float getMaximumLifeTime() {
        return this.maximumLifeTime;
    }

    public Matrix3f getRotMatrix() {
        return this.rotMatrix;
    }

    public void setRotMatrix(Matrix3f matrix3f) {
        this.rotMatrix = matrix3f;
    }

    public TransformMatrix getEmitterTransform() {
        return this.emitterTransform;
    }

    public void setEmitterTransform(TransformMatrix transformMatrix) {
        this.emitterTransform = transformMatrix;
    }

    public float getParticleOrientation() {
        return this.particleOrientation;
    }

    public void setParticleOrientation(float f) {
        this.particleOrientation = f;
    }

    public void setInitialVelocity(float f) {
        this.initialVelocity = f;
    }

    public float getInitialVelocity() {
        return this.initialVelocity;
    }

    public void setOriginOffset(Vector3f vector3f) {
        this.originOffset.set(vector3f);
    }

    public Vector3f getOriginOffset() {
        return this.originOffset;
    }

    public Vector3f getWorldEmit() {
        return this.worldEmit;
    }

    public void setWorldEmit(Vector3f vector3f) {
        this.worldEmit = vector3f;
    }

    public int getReleaseRate() {
        return this.releaseRate;
    }

    public void setReleaseRate(int n) {
        int n2 = this.releaseRate;
        this.releaseRate = n;
        if (this.controller != null && !this.controller.isActive() && this.controller.isControlFlow() && n2 == 0) {
            this.controller.setActive(true);
        }
    }

    public int getEmitType() {
        return this.emitType;
    }

    public void setEmitType(int n) {
        this.emitType = n;
    }

    public int getParticleType() {
        return this.particleType;
    }

    public void setParticleType(int n) {
        this.particleType = n;
    }

    public void setGeometry(Line line) {
        this.psLine = line;
        this.emitType = 1;
    }

    public void setGeometry(Rectangle rectangle) {
        this.psRect = rectangle;
        this.emitType = 2;
    }

    public void setGeometry(Ring ring) {
        this.psRing = ring;
        this.emitType = 4;
    }

    public void setGeomBatch(GeomBatch geomBatch) {
        this.psBatch = geomBatch;
        this.emitType = 3;
    }

    public void setGeometry(Geometry geometry) {
        this.psBatch = geometry.getBatch(0);
        this.emitType = 3;
    }

    public void setGeometry(Geometry geometry, int n) {
        this.psBatch = geometry.getBatch(n);
        this.emitType = 3;
    }

    public Line getLine() {
        return this.psLine;
    }

    public Rectangle getRectangle() {
        return this.psRect;
    }

    public Ring getRing() {
        return this.psRing;
    }

    public GeomBatch getGeomBatch() {
        return this.psBatch;
    }

    public void initAllParticlesLocation() {
        int n = this.particles.length;
        while (--n >= 0) {
            this.initParticleLocation(n);
            this.particles[n].updateVerts(null);
        }
    }

    public void initParticleLocation(int n) {
        Particle particle = this.particles[n];
        if (this.particleType == 4) {
            int n2;
            Vector3f[] vector3fArray = new Vector3f[3];
            ((TriangleBatch)this.psBatch).getTriangle(n, vector3fArray);
            Triangle triangle = particle.getTriangleModel();
            if (triangle == null) {
                triangle = new Triangle(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
            } else {
                for (n2 = 0; n2 < 3; ++n2) {
                    triangle.set(n2, vector3fArray[n2]);
                }
            }
            triangle.calculateCenter();
            triangle.calculateNormal();
            for (n2 = 0; n2 < 3; ++n2) {
                vector3fArray[n2].subtract(triangle.getCenter(), vector3fArray[n2]);
                triangle.set(n2, vector3fArray[n2]);
            }
            particle.setTriangleModel(triangle);
            this.psBatch.getParentGeom().localToWorld(triangle.getCenter(), particle.getPosition());
            particle.getPosition().multLocal(this.getInvScale());
        } else if (this.getEmitType() == 3) {
            if (this.getGeomBatch() != null && this.getGeomBatch() instanceof TriangleBatch) {
                ((TriangleBatch)this.getGeomBatch()).randomPointOnTriangles(particle.getPosition(), workVect3);
            } else if (this.getGeomBatch() != null) {
                this.getGeomBatch().randomVertex(particle.getPosition());
            }
            particle.getPosition().multLocal(this.getInvScale());
        } else {
            switch (this.getEmitType()) {
                case 1: {
                    particle.getPosition().set(this.getLine().random());
                    break;
                }
                case 2: {
                    particle.getPosition().set(this.getRectangle().random());
                    break;
                }
                case 4: {
                    particle.getPosition().set(this.getRing().random());
                    break;
                }
                default: {
                    particle.getPosition().set(this.originOffset);
                }
            }
            this.emitterTransform.multPoint(particle.getPosition());
        }
    }

    public boolean isCameraFacing() {
        return this.cameraFacing;
    }

    public void setCameraFacing(boolean bl) {
        this.cameraFacing = bl;
    }

    public boolean isVelocityAligned() {
        return this.velocityAligned;
    }

    public void setVelocityAligned(boolean bl) {
        this.velocityAligned = bl;
    }

    public Particle getParticle(int n) {
        return this.particles[n];
    }

    public boolean isActive() {
        return this.controller.isActive();
    }

    public void setSpeed(float f) {
        this.controller.setSpeed(f);
    }

    public void setRepeatType(int n) {
        this.controller.setRepeatType(n);
    }

    public void setControlFlow(boolean bl) {
        this.controller.setControlFlow(bl);
    }

    public Vector3f getOriginCenter() {
        return this.originCenter;
    }

    public Vector3f getUpVector() {
        return this.upVector;
    }

    public void setUpVector(Vector3f vector3f) {
        this.upVector = vector3f;
    }

    public Vector3f getLeftVector() {
        return this.leftVector;
    }

    public void setLeftVector(Vector3f vector3f) {
        this.leftVector = vector3f;
    }

    public boolean isRotateWithScene() {
        return this.rotateWithScene;
    }

    public void setRotateWithScene(boolean bl) {
        this.rotateWithScene = bl;
    }

    public void resetParticleVelocity(int n) {
        this.getRandomVelocity(this.particles[n].getVelocity());
    }

    public float getRandomAngle() {
        return this.getMinimumAngle() + FastMath.nextRandomFloat() * (this.getMaximumAngle() - this.getMinimumAngle());
    }

    public float getRandomLifeSpan() {
        return this.getMinimumLifeTime() + (this.getMaximumLifeTime() - this.getMinimumLifeTime()) * FastMath.nextRandomFloat();
    }

    protected Vector3f getRandomVelocity(Vector3f vector3f) {
        float f = (float)Math.PI * 2 * FastMath.nextRandomFloat();
        float f2 = this.getRandomAngle();
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.x = FastMath.cos((float)f) * FastMath.sin((float)f2);
        vector3f.y = FastMath.cos((float)f2);
        vector3f.z = FastMath.sin((float)f) * FastMath.sin((float)f2);
        this.rotateVectorSpeed(vector3f);
        vector3f.multLocal(this.getInitialVelocity());
        return vector3f;
    }

    protected void rotateVectorSpeed(Vector3f vector3f) {
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f.x = -1.0f * (this.rotMatrix.m00 * f + this.rotMatrix.m10 * f2 + this.rotMatrix.m20 * f3);
        vector3f.y = this.getRotMatrix().m01 * f + this.rotMatrix.m11 * f2 + this.rotMatrix.m21 * f3;
        vector3f.z = -1.0f * (this.rotMatrix.m02 * f + this.rotMatrix.m12 * f2 + this.rotMatrix.m22 * f3);
    }

    public void warmUp(int n) {
        if (this.controller != null) {
            this.controller.warmUp(n);
        }
    }

    public int getNumParticles() {
        return this.numParticles;
    }

    public void setNumParticles(int n) {
        this.numParticles = n;
    }

    public float getReleaseVariance() {
        if (this.controller != null) {
            return this.controller.getReleaseVariance();
        }
        return 0.0f;
    }

    public void setReleaseVariance(float f) {
        if (this.controller != null) {
            this.controller.setReleaseVariance(f);
        }
    }

    public void recreate(int n) {
        this.numParticles = n;
        this.initializeParticles(this.numParticles);
    }

    public void updateWorldBound() {
    }

    public void updateWorldBoundManually() {
        super.updateWorldBound();
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        if (this.isRotateWithScene()) {
            if (this.emitType == 3 && this.getGeomBatch() != null) {
                this.getGeomBatch().getParentGeom().getWorldRotation().mult(this.emissionDirection, this.worldEmit);
            } else {
                this.worldRotation.mult(this.emissionDirection, this.worldEmit);
            }
        } else {
            this.worldEmit.set(this.emissionDirection);
        }
        this.emitterTransform.set(this.worldRotation, this.worldTranslation.divideLocal(this.worldScale));
        this.originCenter.set(this.worldTranslation).addLocal(this.originOffset);
        this.getWorldTranslation().set(0.0f, 0.0f, 0.0f);
        this.getWorldRotation().set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write(this.emitType, "emitType", 0);
        outputCapsule.write(this.particleType, "particleType", 0);
        outputCapsule.write((Savable)this.psLine, "psLine", null);
        outputCapsule.write((Savable)this.psRect, "psRect", null);
        outputCapsule.write((Savable)this.psRing, "psRing", null);
        outputCapsule.write((Savable)this.psBatch, "psBatch", null);
        outputCapsule.write(this.startSize, "startSize", 20.0f);
        outputCapsule.write(this.endSize, "endSize", 4.0f);
        outputCapsule.write((Savable)this.startColor, "startColor", (Savable)DEFAULT_START_COLOR);
        outputCapsule.write((Savable)this.endColor, "endColor", (Savable)DEFAULT_END_COLOR);
        outputCapsule.write(this.initialVelocity, "initialVelocity", 1.0f);
        outputCapsule.write(this.minimumLifeTime, "minimumLifeTime", 2000.0f);
        outputCapsule.write(this.maximumLifeTime, "maximumLifeTime", 3000.0f);
        outputCapsule.write(this.minimumAngle, "minimumAngle", 0.0f);
        outputCapsule.write(this.maximumAngle, "maximumAngle", 0.7853982f);
        outputCapsule.write(this.particleSpinSpeed, "particleSpinSpeed", 0.0f);
        outputCapsule.write((Savable)this.emissionDirection, "emissionDirection", (Savable)Vector3f.UNIT_Y);
        outputCapsule.write((Savable)this.worldEmit, "worldEmit", (Savable)Vector3f.ZERO);
        outputCapsule.write((Savable)this.upVector, "upVector", (Savable)Vector3f.UNIT_Y);
        outputCapsule.write((Savable)this.leftVector, "leftVector", (Savable)new Vector3f(-1.0f, 0.0f, 0.0f));
        outputCapsule.write(this.numParticles, "numParticles", 0);
        outputCapsule.write(this.particleOrientation, "particleOrientation", 0.0f);
        outputCapsule.write(this.rotateWithScene, "rotateWithScene", false);
        outputCapsule.write(this.geometryCoordinates, "geometryCoordinates", null);
        outputCapsule.write(this.appearanceColors, "appearanceColors", null);
        outputCapsule.write(this.releaseRate, "releaseRate", this.numParticles);
        outputCapsule.write((Savable)this.originCenter, "originCenter", (Savable)Vector3f.ZERO);
        outputCapsule.write((Savable)this.originOffset, "originOffset", (Savable)Vector3f.ZERO);
        outputCapsule.write((Savable)this.controller, "controller", null);
        outputCapsule.write(this.cameraFacing, "cameraFacing", true);
        outputCapsule.write(this.velocityAligned, "velocityAligned", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.emitType = inputCapsule.readInt("emitType", 0);
        this.particleType = inputCapsule.readInt("particleType", 0);
        this.psLine = (Line)inputCapsule.readSavable("psLine", null);
        this.psRect = (Rectangle)inputCapsule.readSavable("psRect", null);
        this.psRing = (Ring)inputCapsule.readSavable("psRing", null);
        this.psBatch = (GeomBatch)inputCapsule.readSavable("psBatch", null);
        this.startSize = inputCapsule.readFloat("startSize", 20.0f);
        this.endSize = inputCapsule.readFloat("endSize", 4.0f);
        this.startColor = (ColorRGBA)inputCapsule.readSavable("startColor", (Savable)DEFAULT_START_COLOR.clone());
        this.endColor = (ColorRGBA)inputCapsule.readSavable("endColor", (Savable)DEFAULT_END_COLOR.clone());
        this.initialVelocity = inputCapsule.readFloat("initialVelocity", 1.0f);
        this.minimumLifeTime = inputCapsule.readFloat("minimumLifeTime", 2000.0f);
        this.maximumLifeTime = inputCapsule.readFloat("maximumLifeTime", 3000.0f);
        this.minimumAngle = inputCapsule.readFloat("minimumAngle", 0.0f);
        this.maximumAngle = inputCapsule.readFloat("maximumAngle", 0.7853982f);
        this.particleSpinSpeed = inputCapsule.readFloat("particleSpinSpeed", 0.0f);
        this.emissionDirection = (Vector3f)inputCapsule.readSavable("emissionDirection", (Savable)Vector3f.UNIT_Y.clone());
        this.worldEmit = (Vector3f)inputCapsule.readSavable("worldEmit", (Savable)Vector3f.ZERO.clone());
        this.upVector = (Vector3f)inputCapsule.readSavable("upVector", (Savable)Vector3f.UNIT_Y.clone());
        this.leftVector = (Vector3f)inputCapsule.readSavable("leftVector", (Savable)new Vector3f(-1.0f, 0.0f, 0.0f));
        this.numParticles = inputCapsule.readInt("numParticles", 0);
        this.rotateWithScene = inputCapsule.readBoolean("rotateWithScene", false);
        this.geometryCoordinates = inputCapsule.readFloatBuffer("geometryCoordinates", null);
        this.appearanceColors = inputCapsule.readFloatBuffer("appearanceColors", null);
        this.releaseRate = inputCapsule.readInt("releaseRate", this.numParticles);
        this.particleOrientation = inputCapsule.readFloat("particleOrientation", 0.0f);
        this.originCenter = (Vector3f)inputCapsule.readSavable("originCenter", (Savable)new Vector3f());
        this.originOffset = (Vector3f)inputCapsule.readSavable("originOffset", (Savable)new Vector3f());
        this.controller = (ParticleController)inputCapsule.readSavable("controller", null);
        this.cameraFacing = inputCapsule.readBoolean("cameraFacing", true);
        this.velocityAligned = inputCapsule.readBoolean("velocityAligned", false);
        this.invScale = new Vector3f();
        this.upXemit = new Vector3f();
        this.absUpVector = new Vector3f();
        this.abUpMinUp = new Vector3f();
        this.rotMatrix = new Matrix3f();
        this.initializeParticles(this.numParticles);
    }
}

